/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkConformanceVersion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int SUBMINOR;
    public static final int PATCH;

    public VkConformanceVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkConformanceVersion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte major() {
        return VkConformanceVersion.nmajor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte minor() {
        return VkConformanceVersion.nminor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte subminor() {
        return VkConformanceVersion.nsubminor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte patch() {
        return VkConformanceVersion.npatch(this.address());
    }

    public VkConformanceVersion major(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersion.nmajor(this.address(), value);
        return this;
    }

    public VkConformanceVersion minor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersion.nminor(this.address(), value);
        return this;
    }

    public VkConformanceVersion subminor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersion.nsubminor(this.address(), value);
        return this;
    }

    public VkConformanceVersion patch(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersion.npatch(this.address(), value);
        return this;
    }

    public VkConformanceVersion set(byte major, byte minor, byte subminor, byte patch) {
        this.major(major);
        this.minor(minor);
        this.subminor(subminor);
        this.patch(patch);
        return this;
    }

    public VkConformanceVersion set(VkConformanceVersion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkConformanceVersion malloc() {
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkConformanceVersion calloc() {
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkConformanceVersion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkConformanceVersion create(long address) {
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)address);
    }

    @Nullable
    public static VkConformanceVersion createSafe(long address) {
        return address == 0L ? null : (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkConformanceVersion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkConformanceVersion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkConformanceVersion mallocStack() {
        return VkConformanceVersion.mallocStack(MemoryStack.stackGet());
    }

    public static VkConformanceVersion callocStack() {
        return VkConformanceVersion.callocStack(MemoryStack.stackGet());
    }

    public static VkConformanceVersion mallocStack(MemoryStack stack) {
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkConformanceVersion callocStack(MemoryStack stack) {
        return (VkConformanceVersion)VkConformanceVersion.wrap(VkConformanceVersion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkConformanceVersion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkConformanceVersion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static byte nmajor(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAJOR);
    }

    public static byte nminor(long struct) {
        return UNSAFE.getByte(null, struct + (long)MINOR);
    }

    public static byte nsubminor(long struct) {
        return UNSAFE.getByte(null, struct + (long)SUBMINOR);
    }

    public static byte npatch(long struct) {
        return UNSAFE.getByte(null, struct + (long)PATCH);
    }

    public static void nmajor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAJOR, value);
    }

    public static void nminor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MINOR, value);
    }

    public static void nsubminor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SUBMINOR, value);
    }

    public static void npatch(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PATCH, value);
    }

    static {
        Struct.Layout layout = VkConformanceVersion.__struct((Struct.Member[])new Struct.Member[]{VkConformanceVersion.__member((int)1), VkConformanceVersion.__member((int)1), VkConformanceVersion.__member((int)1), VkConformanceVersion.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAJOR = layout.offsetof(0);
        MINOR = layout.offsetof(1);
        SUBMINOR = layout.offsetof(2);
        PATCH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkConformanceVersion, Buffer>
    implements NativeResource {
        private static final VkConformanceVersion ELEMENT_FACTORY = VkConformanceVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkConformanceVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte major() {
            return VkConformanceVersion.nmajor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte minor() {
            return VkConformanceVersion.nminor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte subminor() {
            return VkConformanceVersion.nsubminor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte patch() {
            return VkConformanceVersion.npatch(this.address());
        }

        public Buffer major(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersion.nmajor(this.address(), value);
            return this;
        }

        public Buffer minor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersion.nminor(this.address(), value);
            return this;
        }

        public Buffer subminor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersion.nsubminor(this.address(), value);
            return this;
        }

        public Buffer patch(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersion.npatch(this.address(), value);
            return this;
        }
    }
}

