//
// h501.h
//
// Code automatically generated by asnparse.
//

#if ! H323_DISABLE_H501

#ifndef __H501_H
#define __H501_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif

#include <ptclib/asner.h>

#include "h235.h"
#include "h225.h"


//
// MessageBody
//

class H501_ServiceRequest;
class H501_ServiceConfirmation;
class H501_ServiceRejection;
class H501_ServiceRelease;
class H501_DescriptorRequest;
class H501_DescriptorConfirmation;
class H501_DescriptorRejection;
class H501_DescriptorIDRequest;
class H501_DescriptorIDConfirmation;
class H501_DescriptorIDRejection;
class H501_DescriptorUpdate;
class H501_DescriptorUpdateAck;
class H501_AccessRequest;
class H501_AccessConfirmation;
class H501_AccessRejection;
class H501_RequestInProgress;
class H501_NonStandardRequest;
class H501_NonStandardConfirmation;
class H501_NonStandardRejection;
class H501_UnknownMessageResponse;
class H501_UsageRequest;
class H501_UsageConfirmation;
class H501_UsageIndication;
class H501_UsageIndicationConfirmation;
class H501_UsageIndicationRejection;
class H501_UsageRejection;
class H501_ValidationRequest;
class H501_ValidationConfirmation;
class H501_ValidationRejection;
class H501_AuthenticationRequest;
class H501_AuthenticationConfirmation;
class H501_AuthenticationRejection;

class H501_MessageBody : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_MessageBody, PASN_Choice);
#endif
  public:
    H501_MessageBody(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_serviceRequest,
      e_serviceConfirmation,
      e_serviceRejection,
      e_serviceRelease,
      e_descriptorRequest,
      e_descriptorConfirmation,
      e_descriptorRejection,
      e_descriptorIDRequest,
      e_descriptorIDConfirmation,
      e_descriptorIDRejection,
      e_descriptorUpdate,
      e_descriptorUpdateAck,
      e_accessRequest,
      e_accessConfirmation,
      e_accessRejection,
      e_requestInProgress,
      e_nonStandardRequest,
      e_nonStandardConfirmation,
      e_nonStandardRejection,
      e_unknownMessageResponse,
      e_usageRequest,
      e_usageConfirmation,
      e_usageIndication,
      e_usageIndicationConfirmation,
      e_usageIndicationRejection,
      e_usageRejection,
      e_validationRequest,
      e_validationConfirmation,
      e_validationRejection,
      e_authenticationRequest,
      e_authenticationConfirmation,
      e_authenticationRejection
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ServiceRequest &() const;
#else
    operator H501_ServiceRequest &();
    operator const H501_ServiceRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ServiceConfirmation &() const;
#else
    operator H501_ServiceConfirmation &();
    operator const H501_ServiceConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ServiceRejection &() const;
#else
    operator H501_ServiceRejection &();
    operator const H501_ServiceRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ServiceRelease &() const;
#else
    operator H501_ServiceRelease &();
    operator const H501_ServiceRelease &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorRequest &() const;
#else
    operator H501_DescriptorRequest &();
    operator const H501_DescriptorRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorConfirmation &() const;
#else
    operator H501_DescriptorConfirmation &();
    operator const H501_DescriptorConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorRejection &() const;
#else
    operator H501_DescriptorRejection &();
    operator const H501_DescriptorRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorIDRequest &() const;
#else
    operator H501_DescriptorIDRequest &();
    operator const H501_DescriptorIDRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorIDConfirmation &() const;
#else
    operator H501_DescriptorIDConfirmation &();
    operator const H501_DescriptorIDConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorIDRejection &() const;
#else
    operator H501_DescriptorIDRejection &();
    operator const H501_DescriptorIDRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorUpdate &() const;
#else
    operator H501_DescriptorUpdate &();
    operator const H501_DescriptorUpdate &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_DescriptorUpdateAck &() const;
#else
    operator H501_DescriptorUpdateAck &();
    operator const H501_DescriptorUpdateAck &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AccessRequest &() const;
#else
    operator H501_AccessRequest &();
    operator const H501_AccessRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AccessConfirmation &() const;
#else
    operator H501_AccessConfirmation &();
    operator const H501_AccessConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AccessRejection &() const;
#else
    operator H501_AccessRejection &();
    operator const H501_AccessRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_RequestInProgress &() const;
#else
    operator H501_RequestInProgress &();
    operator const H501_RequestInProgress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_NonStandardRequest &() const;
#else
    operator H501_NonStandardRequest &();
    operator const H501_NonStandardRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_NonStandardConfirmation &() const;
#else
    operator H501_NonStandardConfirmation &();
    operator const H501_NonStandardConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_NonStandardRejection &() const;
#else
    operator H501_NonStandardRejection &();
    operator const H501_NonStandardRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UnknownMessageResponse &() const;
#else
    operator H501_UnknownMessageResponse &();
    operator const H501_UnknownMessageResponse &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageRequest &() const;
#else
    operator H501_UsageRequest &();
    operator const H501_UsageRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageConfirmation &() const;
#else
    operator H501_UsageConfirmation &();
    operator const H501_UsageConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageIndication &() const;
#else
    operator H501_UsageIndication &();
    operator const H501_UsageIndication &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageIndicationConfirmation &() const;
#else
    operator H501_UsageIndicationConfirmation &();
    operator const H501_UsageIndicationConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageIndicationRejection &() const;
#else
    operator H501_UsageIndicationRejection &();
    operator const H501_UsageIndicationRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_UsageRejection &() const;
#else
    operator H501_UsageRejection &();
    operator const H501_UsageRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ValidationRequest &() const;
#else
    operator H501_ValidationRequest &();
    operator const H501_ValidationRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ValidationConfirmation &() const;
#else
    operator H501_ValidationConfirmation &();
    operator const H501_ValidationConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_ValidationRejection &() const;
#else
    operator H501_ValidationRejection &();
    operator const H501_ValidationRejection &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AuthenticationRequest &() const;
#else
    operator H501_AuthenticationRequest &();
    operator const H501_AuthenticationRequest &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AuthenticationConfirmation &() const;
#else
    operator H501_AuthenticationConfirmation &();
    operator const H501_AuthenticationConfirmation &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_AuthenticationRejection &() const;
#else
    operator H501_AuthenticationRejection &();
    operator const H501_AuthenticationRejection &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ServiceRejectionReason
//

class H501_ServiceRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceRejectionReason, PASN_Choice);
#endif
  public:
    H501_ServiceRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_serviceUnavailable,
      e_serviceRedirected,
      e_security,
      e_continue,
      e_undefined,
      e_unknownServiceID,
      e_cannotSupportUsageSpec,
      e_neededFeature,
      e_genericDataReason,
      e_usageUnavailable,
      e_unknownUsageSendTo
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ServiceReleaseReason
//

class H501_ServiceReleaseReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceReleaseReason, PASN_Choice);
#endif
  public:
    H501_ServiceReleaseReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_outOfService,
      e_maintenance,
      e_terminated,
      e_expired
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// DescriptorRejectionReason
//

class H501_DescriptorRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorRejectionReason, PASN_Choice);
#endif
  public:
    H501_DescriptorRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_packetSizeExceeded,
      e_illegalID,
      e_security,
      e_hopCountExceeded,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// DescriptorIDRequest
//

class H501_DescriptorIDRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorIDRequest, PASN_Sequence);
#endif
  public:
    H501_DescriptorIDRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// DescriptorIDRejectionReason
//

class H501_DescriptorIDRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorIDRejectionReason, PASN_Choice);
#endif
  public:
    H501_DescriptorIDRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_noDescriptors,
      e_security,
      e_hopCountExceeded,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// DescriptorUpdateAck
//

class H501_DescriptorUpdateAck : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorUpdateAck, PASN_Sequence);
#endif
  public:
    H501_DescriptorUpdateAck(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// AccessRejectionReason
//

class H501_AccessRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AccessRejectionReason, PASN_Choice);
#endif
  public:
    H501_AccessRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_noMatch,
      e_packetSizeExceeded,
      e_security,
      e_hopCountExceeded,
      e_needCallInformation,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_destinationUnavailable,
      e_aliasesInconsistent,
      e_resourceUnavailable,
      e_incompleteAddress,
      e_unknownServiceID,
      e_usageUnavailable,
      e_cannotSupportUsageSpec,
      e_unknownUsageSendTo
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UsageConfirmation
//

class H501_UsageConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageConfirmation, PASN_Sequence);
#endif
  public:
    H501_UsageConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// UsageField
//

class H501_UsageField : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageField, PASN_Sequence);
#endif
  public:
    H501_UsageField(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_ObjectId m_id;
    PASN_OctetString m_value;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageRejectReason
//

class H501_UsageRejectReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageRejectReason, PASN_Choice);
#endif
  public:
    H501_UsageRejectReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_invalidCall,
      e_unavailable,
      e_security,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UsageIndicationConfirmation
//

class H501_UsageIndicationConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageIndicationConfirmation, PASN_Sequence);
#endif
  public:
    H501_UsageIndicationConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// UsageIndicationRejectionReason
//

class H501_UsageIndicationRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageIndicationRejectionReason, PASN_Choice);
#endif
  public:
    H501_UsageIndicationRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_unknownCall,
      e_incomplete,
      e_security,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ValidationRejectionReason
//

class H501_ValidationRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ValidationRejectionReason, PASN_Choice);
#endif
  public:
    H501_ValidationRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_tokenNotValid,
      e_security,
      e_hopCountExceeded,
      e_missingSourceInfo,
      e_missingDestInfo,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// NonStandardRequest
//

class H501_NonStandardRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_NonStandardRequest, PASN_Sequence);
#endif
  public:
    H501_NonStandardRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// NonStandardConfirmation
//

class H501_NonStandardConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_NonStandardConfirmation, PASN_Sequence);
#endif
  public:
    H501_NonStandardConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// NonStandardRejectionReason
//

class H501_NonStandardRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_NonStandardRejectionReason, PASN_Choice);
#endif
  public:
    H501_NonStandardRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notSupported,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UnknownMessageReason
//

class H501_UnknownMessageReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UnknownMessageReason, PASN_Choice);
#endif
  public:
    H501_UnknownMessageReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_notUnderstood,
      e_undefined
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ApplicationMessage
//

class H501_ApplicationMessage : public PASN_OctetString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ApplicationMessage, PASN_OctetString);
#endif
  public:
    H501_ApplicationMessage(unsigned tag = UniversalOctetString, TagClass tagClass = UniversalTagClass);

    H501_ApplicationMessage(const char * v);
    H501_ApplicationMessage(const PString & v);
    H501_ApplicationMessage(const PBYTEArray & v);

    H501_ApplicationMessage & operator=(const char * v);
    H501_ApplicationMessage & operator=(const PString & v);
    H501_ApplicationMessage & operator=(const PBYTEArray & v);
    PObject * Clone() const;
};


//
// AuthenticationConfirmation
//

class H501_AuthenticationConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AuthenticationConfirmation, PASN_Sequence);
#endif
  public:
    H501_AuthenticationConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);


    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    PObject * Clone() const;
};


//
// AuthenticationRejectionReason
//

class H501_AuthenticationRejectionReason : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AuthenticationRejectionReason, PASN_Choice);
#endif
  public:
    H501_AuthenticationRejectionReason(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_security,
      e_hopCountExceeded,
      e_noServiceRelationship,
      e_undefined,
      e_neededFeature,
      e_genericDataReason,
      e_unknownServiceID,
      e_securityWrongSyncTime,
      e_securityReplay,
      e_securityWrongGeneralID,
      e_securityWrongSendersID,
      e_securityIntegrityFailed,
      e_securityWrongOID
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// Pattern
//

class H225_AliasAddress;
class H501_Pattern_range;

class H501_Pattern : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_Pattern, PASN_Choice);
#endif
  public:
    H501_Pattern(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_specific,
      e_wildcard,
      e_range
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_AliasAddress &() const;
#else
    operator H225_AliasAddress &();
    operator const H225_AliasAddress &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_Pattern_range &() const;
#else
    operator H501_Pattern_range &();
    operator const H501_Pattern_range &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// AccessToken
//

class H235_ClearToken;
class H225_CryptoH323Token;
class H225_GenericData;

class H501_AccessToken : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AccessToken, PASN_Choice);
#endif
  public:
    H501_AccessToken(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_token,
      e_cryptoToken,
      e_genericData
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H235_ClearToken &() const;
#else
    operator H235_ClearToken &();
    operator const H235_ClearToken &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_CryptoH323Token &() const;
#else
    operator H225_CryptoH323Token &();
    operator const H225_CryptoH323Token &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GenericData &() const;
#else
    operator H225_GenericData &();
    operator const H225_GenericData &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// CallInformation
//

class H501_CallInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_CallInformation, PASN_Sequence);
#endif
  public:
    H501_CallInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_circuitID
    };

    H225_CallIdentifier m_callIdentifier;
    H225_ConferenceIdentifier m_conferenceID;
    H225_CircuitInfo m_circuitID;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageCallStatus
//

class H501_UsageCallStatus : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageCallStatus, PASN_Choice);
#endif
  public:
    H501_UsageCallStatus(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_preConnect,
      e_callInProgress,
      e_callEnded,
      e_registrationLost
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// Role
//

class H225_NonStandardParameter;

class H501_Role : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_Role, PASN_Choice);
#endif
  public:
    H501_Role(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_originator,
      e_destination,
      e_nonStandardData
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_NonStandardParameter &() const;
#else
    operator H225_NonStandardParameter &();
    operator const H225_NonStandardParameter &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// TimeZone
//

class H501_TimeZone : public PASN_Integer
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_TimeZone, PASN_Integer);
#endif
  public:
    H501_TimeZone(unsigned tag = UniversalInteger, TagClass tagClass = UniversalTagClass);

    H501_TimeZone & operator=(int v);
    H501_TimeZone & operator=(unsigned v);
    PObject * Clone() const;
};


//
// TerminationCause
//

class H501_TerminationCause : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_TerminationCause, PASN_Sequence);
#endif
  public:
    H501_TerminationCause(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_causeIE,
      e_nonStandardData
    };

    H225_ReleaseCompleteReason m_releaseCompleteReason;
    PASN_Integer m_causeIE;
    H225_NonStandardParameter m_nonStandardData;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ProtocolVersion
//

class H501_ProtocolVersion : public PASN_ObjectId
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ProtocolVersion, PASN_ObjectId);
#endif
  public:
    H501_ProtocolVersion(unsigned tag = UniversalObjectId, TagClass tagClass = UniversalTagClass);

    PObject * Clone() const;
};


//
// ElementIdentifier
//

class H501_ElementIdentifier : public PASN_BMPString
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ElementIdentifier, PASN_BMPString);
#endif
  public:
    H501_ElementIdentifier(unsigned tag = UniversalBMPString, TagClass tagClass = UniversalTagClass);

    H501_ElementIdentifier & operator=(const char * v);
    H501_ElementIdentifier & operator=(const PString & v);
    H501_ElementIdentifier & operator=(const PWCharArray & v);
    H501_ElementIdentifier & operator=(const PASN_BMPString & v);
    PObject * Clone() const;
};


//
// GlobalTimeStamp
//

class H501_GlobalTimeStamp : public PASN_IA5String
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_GlobalTimeStamp, PASN_IA5String);
#endif
  public:
    H501_GlobalTimeStamp(unsigned tag = UniversalIA5String, TagClass tagClass = UniversalTagClass);

    H501_GlobalTimeStamp & operator=(const char * v);
    H501_GlobalTimeStamp & operator=(const PString & v);
    PObject * Clone() const;
};


//
// ArrayOf_TransportAddress
//

class H225_TransportAddress;

class H501_ArrayOf_TransportAddress : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_TransportAddress, PASN_Array);
#endif
  public:
    H501_ArrayOf_TransportAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_TransportAddress & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ClearToken
//

class H235_ClearToken;

class H501_ArrayOf_ClearToken : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_ClearToken, PASN_Array);
#endif
  public:
    H501_ArrayOf_ClearToken(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H235_ClearToken & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_CryptoH323Token
//

class H225_CryptoH323Token;

class H501_ArrayOf_CryptoH323Token : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_CryptoH323Token, PASN_Array);
#endif
  public:
    H501_ArrayOf_CryptoH323Token(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_CryptoH323Token & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_NonStandardParameter
//

class H225_NonStandardParameter;

class H501_ArrayOf_NonStandardParameter : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_NonStandardParameter, PASN_Array);
#endif
  public:
    H501_ArrayOf_NonStandardParameter(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_NonStandardParameter & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_GenericData
//

class H225_GenericData;

class H501_ArrayOf_GenericData : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_GenericData, PASN_Array);
#endif
  public:
    H501_ArrayOf_GenericData(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_GenericData & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_SecurityMode
//

class H501_SecurityMode;

class H501_ArrayOf_SecurityMode : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_SecurityMode, PASN_Array);
#endif
  public:
    H501_ArrayOf_SecurityMode(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_SecurityMode & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_PASN_ObjectId
//

class H501_ArrayOf_PASN_ObjectId : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_PASN_ObjectId, PASN_Array);
#endif
  public:
    H501_ArrayOf_PASN_ObjectId(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    PASN_ObjectId & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_GloballyUniqueID
//

class H225_GloballyUniqueID;

class H501_ArrayOf_GloballyUniqueID : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_GloballyUniqueID, PASN_Array);
#endif
  public:
    H501_ArrayOf_GloballyUniqueID(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_GloballyUniqueID & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_Descriptor
//

class H501_Descriptor;

class H501_ArrayOf_Descriptor : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_Descriptor, PASN_Array);
#endif
  public:
    H501_ArrayOf_Descriptor(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_Descriptor & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_DescriptorInfo
//

class H501_DescriptorInfo;

class H501_ArrayOf_DescriptorInfo : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_DescriptorInfo, PASN_Array);
#endif
  public:
    H501_ArrayOf_DescriptorInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_DescriptorInfo & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_UpdateInformation
//

class H501_UpdateInformation;

class H501_ArrayOf_UpdateInformation : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_UpdateInformation, PASN_Array);
#endif
  public:
    H501_ArrayOf_UpdateInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_UpdateInformation & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// UpdateInformation_descriptorInfo
//

class H225_GloballyUniqueID;
class H501_Descriptor;

class H501_UpdateInformation_descriptorInfo : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UpdateInformation_descriptorInfo, PASN_Choice);
#endif
  public:
    H501_UpdateInformation_descriptorInfo(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_descriptorID,
      e_descriptor
    };

#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H225_GloballyUniqueID &() const;
#else
    operator H225_GloballyUniqueID &();
    operator const H225_GloballyUniqueID &() const;
#endif
#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
    operator H501_Descriptor &() const;
#else
    operator H501_Descriptor &();
    operator const H501_Descriptor &() const;
#endif

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// UpdateInformation_updateType
//

class H501_UpdateInformation_updateType : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UpdateInformation_updateType, PASN_Choice);
#endif
  public:
    H501_UpdateInformation_updateType(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_added,
      e_deleted,
      e_changed
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_SupportedProtocols
//

class H225_SupportedProtocols;

class H501_ArrayOf_SupportedProtocols : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_SupportedProtocols, PASN_Array);
#endif
  public:
    H501_ArrayOf_SupportedProtocols(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_SupportedProtocols & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AddressTemplate
//

class H501_AddressTemplate;

class H501_ArrayOf_AddressTemplate : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_AddressTemplate, PASN_Array);
#endif
  public:
    H501_ArrayOf_AddressTemplate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_AddressTemplate & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ServiceControlSession
//

class H225_ServiceControlSession;

class H501_ArrayOf_ServiceControlSession : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_ServiceControlSession, PASN_Array);
#endif
  public:
    H501_ArrayOf_ServiceControlSession(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_ServiceControlSession & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_AccessToken
//

class H501_AccessToken;

class H501_ArrayOf_AccessToken : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_AccessToken, PASN_Array);
#endif
  public:
    H501_ArrayOf_AccessToken(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_AccessToken & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_UsageField
//

class H501_UsageField;

class H501_ArrayOf_UsageField : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_UsageField, PASN_Array);
#endif
  public:
    H501_ArrayOf_UsageField(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_UsageField & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_Pattern
//

class H501_Pattern;

class H501_ArrayOf_Pattern : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_Pattern, PASN_Array);
#endif
  public:
    H501_ArrayOf_Pattern(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_Pattern & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_RouteInformation
//

class H501_RouteInformation;

class H501_ArrayOf_RouteInformation : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_RouteInformation, PASN_Array);
#endif
  public:
    H501_ArrayOf_RouteInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_RouteInformation & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// Pattern_range
//

class H501_Pattern_range : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_Pattern_range, PASN_Sequence);
#endif
  public:
    H501_Pattern_range(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_PartyNumber m_startOfRange;
    H225_PartyNumber m_endOfRange;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RouteInformation_messageType
//

class H501_RouteInformation_messageType : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_RouteInformation_messageType, PASN_Choice);
#endif
  public:
    H501_RouteInformation_messageType(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_sendAccessRequest,
      e_sendSetup,
      e_nonExistent
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_PriceInfoSpec
//

class H501_PriceInfoSpec;

class H501_ArrayOf_PriceInfoSpec : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_PriceInfoSpec, PASN_Array);
#endif
  public:
    H501_ArrayOf_PriceInfoSpec(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_PriceInfoSpec & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_ContactInformation
//

class H501_ContactInformation;

class H501_ArrayOf_ContactInformation : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_ContactInformation, PASN_Array);
#endif
  public:
    H501_ArrayOf_ContactInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_ContactInformation & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_CircuitIdentifier
//

class H225_CircuitIdentifier;

class H501_ArrayOf_CircuitIdentifier : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_CircuitIdentifier, PASN_Array);
#endif
  public:
    H501_ArrayOf_CircuitIdentifier(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_CircuitIdentifier & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// ArrayOf_PriceElement
//

class H501_PriceElement;

class H501_ArrayOf_PriceElement : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_PriceElement, PASN_Array);
#endif
  public:
    H501_ArrayOf_PriceElement(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_PriceElement & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// PriceElement_units
//

class H501_PriceElement_units : public PASN_Choice
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_PriceElement_units, PASN_Choice);
#endif
  public:
    H501_PriceElement_units(unsigned tag = 0, TagClass tagClass = UniversalTagClass);

    enum Choices {
      e_seconds,
      e_packets,
      e_bytes,
      e_initial,
      e_minimum,
      e_maximum
    };

    PBoolean CreateObject();
    PObject * Clone() const;
};


//
// ArrayOf_AlternatePE
//

class H501_AlternatePE;

class H501_ArrayOf_AlternatePE : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_AlternatePE, PASN_Array);
#endif
  public:
    H501_ArrayOf_AlternatePE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H501_AlternatePE & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// UsageSpecification_when
//

class H501_UsageSpecification_when : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageSpecification_when, PASN_Sequence);
#endif
  public:
    H501_UsageSpecification_when(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_never,
      e_start,
      e_end,
      e_period,
      e_failures
    };

    PASN_Null m_never;
    PASN_Null m_start;
    PASN_Null m_end;
    PASN_Integer m_period;
    PASN_Null m_failures;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ArrayOf_AliasAddress
//

class H225_AliasAddress;

class H501_ArrayOf_AliasAddress : public PASN_Array
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ArrayOf_AliasAddress, PASN_Array);
#endif
  public:
    H501_ArrayOf_AliasAddress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Object * CreateObject() const;
    H225_AliasAddress & operator[](PINDEX i) const;
    PObject * Clone() const;
};


//
// MessageCommonInfo
//

class H501_MessageCommonInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_MessageCommonInfo, PASN_Sequence);
#endif
  public:
    H501_MessageCommonInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_replyAddress,
      e_integrityCheckValue,
      e_tokens,
      e_cryptoTokens,
      e_nonStandard,
      e_serviceID,
      e_genericData,
      e_featureSet,
      e_version
    };

    PASN_Integer m_sequenceNumber;
    H501_ProtocolVersion m_annexGversion;
    PASN_Integer m_hopCount;
    H501_ArrayOf_TransportAddress m_replyAddress;
    H225_ICV m_integrityCheckValue;
    H501_ArrayOf_ClearToken m_tokens;
    H501_ArrayOf_CryptoH323Token m_cryptoTokens;
    H501_ArrayOf_NonStandardParameter m_nonStandard;
    H225_GloballyUniqueID m_serviceID;
    H501_ArrayOf_GenericData m_genericData;
    H225_FeatureSet m_featureSet;
    H501_ProtocolVersion m_version;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// SecurityMode
//

class H501_SecurityMode : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_SecurityMode, PASN_Sequence);
#endif
  public:
    H501_SecurityMode(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_authentication,
      e_integrity,
      e_algorithmOIDs
    };

    H235_AuthenticationMechanism m_authentication;
    H225_IntegrityMechanism m_integrity;
    H501_ArrayOf_PASN_ObjectId m_algorithmOIDs;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorRequest
//

class H501_DescriptorRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorRequest, PASN_Sequence);
#endif
  public:
    H501_DescriptorRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ArrayOf_GloballyUniqueID m_descriptorID;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorConfirmation
//

class H501_DescriptorConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorConfirmation, PASN_Sequence);
#endif
  public:
    H501_DescriptorConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ArrayOf_Descriptor m_descriptor;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorRejection
//

class H501_DescriptorRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorRejection, PASN_Sequence);
#endif
  public:
    H501_DescriptorRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_descriptorID
    };

    H501_DescriptorRejectionReason m_reason;
    H225_GloballyUniqueID m_descriptorID;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorIDConfirmation
//

class H501_DescriptorIDConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorIDConfirmation, PASN_Sequence);
#endif
  public:
    H501_DescriptorIDConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ArrayOf_DescriptorInfo m_descriptorInfo;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorIDRejection
//

class H501_DescriptorIDRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorIDRejection, PASN_Sequence);
#endif
  public:
    H501_DescriptorIDRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_DescriptorIDRejectionReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorUpdate
//

class H501_DescriptorUpdate : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorUpdate, PASN_Sequence);
#endif
  public:
    H501_DescriptorUpdate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_AliasAddress m_sender;
    H501_ArrayOf_UpdateInformation m_updateInfo;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UpdateInformation
//

class H501_UpdateInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UpdateInformation, PASN_Sequence);
#endif
  public:
    H501_UpdateInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_UpdateInformation_descriptorInfo m_descriptorInfo;
    H501_UpdateInformation_updateType m_updateType;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AccessConfirmation
//

class H501_AccessConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AccessConfirmation, PASN_Sequence);
#endif
  public:
    H501_AccessConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_supportedProtocols,
      e_serviceControl
    };

    H501_ArrayOf_AddressTemplate m_templates;
    PASN_Boolean m_partialResponse;
    H501_ArrayOf_SupportedProtocols m_supportedProtocols;
    H501_ArrayOf_ServiceControlSession m_serviceControl;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AccessRejection
//

class H501_AccessRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AccessRejection, PASN_Sequence);
#endif
  public:
    H501_AccessRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_serviceControl
    };

    H501_AccessRejectionReason m_reason;
    H501_ArrayOf_ServiceControlSession m_serviceControl;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageRejection
//

class H501_UsageRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageRejection, PASN_Sequence);
#endif
  public:
    H501_UsageRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_UsageRejectReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageIndicationRejection
//

class H501_UsageIndicationRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageIndicationRejection, PASN_Sequence);
#endif
  public:
    H501_UsageIndicationRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_UsageIndicationRejectionReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ValidationRejection
//

class H501_ValidationRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ValidationRejection, PASN_Sequence);
#endif
  public:
    H501_ValidationRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ValidationRejectionReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RequestInProgress
//

class H501_RequestInProgress : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_RequestInProgress, PASN_Sequence);
#endif
  public:
    H501_RequestInProgress(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_serviceControl
    };

    PASN_Integer m_delay;
    H501_ArrayOf_ServiceControlSession m_serviceControl;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// NonStandardRejection
//

class H501_NonStandardRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_NonStandardRejection, PASN_Sequence);
#endif
  public:
    H501_NonStandardRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_NonStandardRejectionReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UnknownMessageResponse
//

class H501_UnknownMessageResponse : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UnknownMessageResponse, PASN_Sequence);
#endif
  public:
    H501_UnknownMessageResponse(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_OctetString m_unknownMessage;
    H501_UnknownMessageReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AuthenticationRequest
//

class H501_AuthenticationRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AuthenticationRequest, PASN_Sequence);
#endif
  public:
    H501_AuthenticationRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ApplicationMessage m_applicationMessage;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AuthenticationRejection
//

class H501_AuthenticationRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AuthenticationRejection, PASN_Sequence);
#endif
  public:
    H501_AuthenticationRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_AuthenticationRejectionReason m_reason;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AddressTemplate
//

class H501_AddressTemplate : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AddressTemplate, PASN_Sequence);
#endif
  public:
    H501_AddressTemplate(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_supportedProtocols,
      e_featureSet
    };

    H501_ArrayOf_Pattern m_pattern;
    H501_ArrayOf_RouteInformation m_routeInfo;
    PASN_Integer m_timeToLive;
    H501_ArrayOf_SupportedProtocols m_supportedProtocols;
    H225_FeatureSet m_featureSet;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ContactInformation
//

class H501_ContactInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ContactInformation, PASN_Sequence);
#endif
  public:
    H501_ContactInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_transportQoS,
      e_security,
      e_accessTokens,
      e_multipleCalls,
      e_featureSet,
      e_circuitID,
      e_supportedCircuits
    };

    H225_AliasAddress m_transportAddress;
    PASN_Integer m_priority;
    H225_TransportQOS m_transportQoS;
    H501_ArrayOf_SecurityMode m_security;
    H501_ArrayOf_AccessToken m_accessTokens;
    PASN_Boolean m_multipleCalls;
    H225_FeatureSet m_featureSet;
    H225_CircuitInfo m_circuitID;
    H501_ArrayOf_CircuitIdentifier m_supportedCircuits;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PriceInfoSpec
//

class H501_PriceInfoSpec : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_PriceInfoSpec, PASN_Sequence);
#endif
  public:
    H501_PriceInfoSpec(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_validFrom,
      e_validUntil,
      e_hoursFrom,
      e_hoursUntil,
      e_priceElement,
      e_priceFormula
    };

    PASN_IA5String m_currency;
    PASN_Integer m_currencyScale;
    H501_GlobalTimeStamp m_validFrom;
    H501_GlobalTimeStamp m_validUntil;
    PASN_IA5String m_hoursFrom;
    PASN_IA5String m_hoursUntil;
    H501_ArrayOf_PriceElement m_priceElement;
    PASN_IA5String m_priceFormula;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PriceElement
//

class H501_PriceElement : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_PriceElement, PASN_Sequence);
#endif
  public:
    H501_PriceElement(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    PASN_Integer m_amount;
    PASN_Integer m_quantum;
    H501_PriceElement_units m_units;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// DescriptorInfo
//

class H501_DescriptorInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_DescriptorInfo, PASN_Sequence);
#endif
  public:
    H501_DescriptorInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H225_GloballyUniqueID m_descriptorID;
    H501_GlobalTimeStamp m_lastChanged;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AlternatePEInfo
//

class H501_AlternatePEInfo : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AlternatePEInfo, PASN_Sequence);
#endif
  public:
    H501_AlternatePEInfo(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_ArrayOf_AlternatePE m_alternatePE;
    PASN_Boolean m_alternateIsPermanent;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AlternatePE
//

class H501_AlternatePE : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AlternatePE, PASN_Sequence);
#endif
  public:
    H501_AlternatePE(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_elementIdentifier
    };

    H225_AliasAddress m_contactAddress;
    PASN_Integer m_priority;
    H501_ElementIdentifier m_elementIdentifier;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UserInformation
//

class H501_UserInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UserInformation, PASN_Sequence);
#endif
  public:
    H501_UserInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_userAuthenticator
    };

    H225_AliasAddress m_userIdentifier;
    H501_ArrayOf_CryptoH323Token m_userAuthenticator;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageSpecification
//

class H501_UsageSpecification : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageSpecification, PASN_Sequence);
#endif
  public:
    H501_UsageSpecification(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_sendToPEAddress
    };

    H501_ElementIdentifier m_sendTo;
    H501_UsageSpecification_when m_when;
    H501_ArrayOf_PASN_ObjectId m_required;
    H501_ArrayOf_PASN_ObjectId m_preferred;
    H225_AliasAddress m_sendToPEAddress;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// PartyInformation
//

class H501_PartyInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_PartyInformation, PASN_Sequence);
#endif
  public:
    H501_PartyInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_domainIdentifier,
      e_transportAddress,
      e_endpointType,
      e_userInfo,
      e_timeZone
    };

    H501_ArrayOf_AliasAddress m_logicalAddresses;
    H225_AliasAddress m_domainIdentifier;
    H225_AliasAddress m_transportAddress;
    H225_EndpointType m_endpointType;
    H501_UserInformation m_userInfo;
    H501_TimeZone m_timeZone;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Message
//

class H501_Message : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_Message, PASN_Sequence);
#endif
  public:
    H501_Message(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_MessageBody m_body;
    H501_MessageCommonInfo m_common;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceRequest
//

class H501_ServiceRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceRequest, PASN_Sequence);
#endif
  public:
    H501_ServiceRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_elementIdentifier,
      e_domainIdentifier,
      e_securityMode,
      e_timeToLive,
      e_usageSpec
    };

    H501_ElementIdentifier m_elementIdentifier;
    H225_AliasAddress m_domainIdentifier;
    H501_ArrayOf_SecurityMode m_securityMode;
    PASN_Integer m_timeToLive;
    H501_UsageSpecification m_usageSpec;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceConfirmation
//

class H501_ServiceConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceConfirmation, PASN_Sequence);
#endif
  public:
    H501_ServiceConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alternates,
      e_securityMode,
      e_timeToLive,
      e_usageSpec
    };

    H501_ElementIdentifier m_elementIdentifier;
    H225_AliasAddress m_domainIdentifier;
    H501_AlternatePEInfo m_alternates;
    H501_SecurityMode m_securityMode;
    PASN_Integer m_timeToLive;
    H501_UsageSpecification m_usageSpec;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceRejection
//

class H501_ServiceRejection : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceRejection, PASN_Sequence);
#endif
  public:
    H501_ServiceRejection(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alternates
    };

    H501_ServiceRejectionReason m_reason;
    H501_AlternatePEInfo m_alternates;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ServiceRelease
//

class H501_ServiceRelease : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ServiceRelease, PASN_Sequence);
#endif
  public:
    H501_ServiceRelease(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_alternates
    };

    H501_ServiceReleaseReason m_reason;
    H501_AlternatePEInfo m_alternates;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// AccessRequest
//

class H501_AccessRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_AccessRequest, PASN_Sequence);
#endif
  public:
    H501_AccessRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_sourceInfo,
      e_callInfo,
      e_usageSpec,
      e_desiredProtocols
    };

    H501_PartyInformation m_destinationInfo;
    H501_PartyInformation m_sourceInfo;
    H501_CallInformation m_callInfo;
    H501_UsageSpecification m_usageSpec;
    H501_ArrayOf_SupportedProtocols m_desiredProtocols;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageRequest
//

class H501_UsageRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageRequest, PASN_Sequence);
#endif
  public:
    H501_UsageRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    H501_CallInformation m_callInfo;
    H501_UsageSpecification m_usageSpec;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// UsageIndication
//

class H501_UsageIndication : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_UsageIndication, PASN_Sequence);
#endif
  public:
    H501_UsageIndication(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_accessTokens,
      e_srcInfo,
      e_startTime,
      e_endTime,
      e_terminationCause
    };

    H501_CallInformation m_callInfo;
    H501_ArrayOf_AccessToken m_accessTokens;
    H501_Role m_senderRole;
    H501_UsageCallStatus m_usageCallStatus;
    H501_PartyInformation m_srcInfo;
    H501_PartyInformation m_destAddress;
    H235_TimeStamp m_startTime;
    H235_TimeStamp m_endTime;
    H501_TerminationCause m_terminationCause;
    H501_ArrayOf_UsageField m_usageFields;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ValidationRequest
//

class H501_ValidationRequest : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ValidationRequest, PASN_Sequence);
#endif
  public:
    H501_ValidationRequest(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_accessToken,
      e_destinationInfo,
      e_sourceInfo,
      e_usageSpec
    };

    H501_ArrayOf_AccessToken m_accessToken;
    H501_PartyInformation m_destinationInfo;
    H501_PartyInformation m_sourceInfo;
    H501_CallInformation m_callInfo;
    H501_UsageSpecification m_usageSpec;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// ValidationConfirmation
//

class H501_ValidationConfirmation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_ValidationConfirmation, PASN_Sequence);
#endif
  public:
    H501_ValidationConfirmation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_destinationInfo,
      e_usageSpec
    };

    H501_PartyInformation m_destinationInfo;
    H501_UsageSpecification m_usageSpec;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// RouteInformation
//

class H501_RouteInformation : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_RouteInformation, PASN_Sequence);
#endif
  public:
    H501_RouteInformation(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_usageSpec,
      e_priceInfo,
      e_type,
      e_featureSet,
      e_circuitID,
      e_supportedCircuits
    };

    H501_RouteInformation_messageType m_messageType;
    PASN_Boolean m_callSpecific;
    H501_UsageSpecification m_usageSpec;
    H501_ArrayOf_PriceInfoSpec m_priceInfo;
    H501_ArrayOf_ContactInformation m_contacts;
    H225_EndpointType m_type;
    H225_FeatureSet m_featureSet;
    H225_CircuitInfo m_circuitID;
    H501_ArrayOf_CircuitIdentifier m_supportedCircuits;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


//
// Descriptor
//

class H501_Descriptor : public PASN_Sequence
{
#ifndef PASN_LEANANDMEAN
    PCLASSINFO(H501_Descriptor, PASN_Sequence);
#endif
  public:
    H501_Descriptor(unsigned tag = UniversalSequence, TagClass tagClass = UniversalTagClass);

    enum OptionalFields {
      e_gatekeeperID
    };

    H501_DescriptorInfo m_descriptorInfo;
    H501_ArrayOf_AddressTemplate m_templates;
    H225_GatekeeperIdentifier m_gatekeeperID;

    PINDEX GetDataLength() const;
    PBoolean Decode(PASN_Stream & strm);
    void Encode(PASN_Stream & strm) const;
#ifndef PASN_NOPRINTON
    void PrintOn(ostream & strm) const;
#endif
    Comparison Compare(const PObject & obj) const;
    PObject * Clone() const;
};


#endif // __H501_H

#endif // if ! H323_DISABLE_H501


// End of h501.h
