(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define scheme/base-ports#input-port-open?
    (lambda (_port411_)
      (if (not (input-port? _port411_))
          (error '"Bad argument; expected input port" _port411_)
          (if (macro-closed? (macro-port-roptions _port411_))
              '#f
              (if (macro-device-port? _port411_)
                  (scheme/base-ports#rdevice-open?
                   (macro-condvar-name
                    (macro-device-port-rdevice-condvar _port411_)))
                  (if (macro-raw-device-port? _port411_)
                      (scheme/base-ports#rdevice-open?
                       (macro-condvar-name
                        (macro-raw-device-port-rdevice-condvar _port411_)))
                      '#t))))))
  (define scheme/base-ports#output-port-open?
    (lambda (_port409_)
      (if (not (output-port? _port409_))
          (error '"Bad argument; expected input port" _port409_)
          (if (macro-closed? (macro-port-woptions _port409_))
              '#f
              (if (macro-device-port? _port409_)
                  (scheme/base-ports#wdevice-open?
                   (macro-condvar-name
                    (macro-device-port-wdevice-condvar _port409_)))
                  (if (macro-raw-device-port? _port409_)
                      (scheme/base-ports#wdevice-open?
                       (macro-condvar-name
                        (macro-raw-device-port-wdevice-condvar _port409_)))
                      '#t))))))
  (namespace ("scheme/base-ports#" rdevice-open? wdevice-open?))
  (c-declare
   "#ifndef ___STAGE_OPEN\n#define ___STAGE_OPEN 0\n#endif\n#ifndef ___FFI_HAVE_DEVICE\n#define ___FFI_HAVE_DEVICE\ntypedef struct ___device_struct\n  {\n    void *vtbl;\n    int refcount;                  /* device structure is released when zero */\n    void *group;                   /* device group this device belongs to */\n    struct ___device_struct *prev; /* bidirectional list pointer to previous */\n    struct ___device_struct *next; /* bidirectional list pointer to next */\n    int direction;                 /* ___DIRECTION_RD and/or ___DIRECTION_WR */\n    int close_direction;           /* ___DIRECTION_RD and/or ___DIRECTION_WR */\n    int read_stage;                /* ___STAGE_OPEN ... ___STAGE_CLOSED */\n    int write_stage;               /* ___STAGE_OPEN ... ___STAGE_CLOSED */\n  } ___device;\n#endif\n\nstatic ___SCMOBJ ___rdevice_openp(___SCMOBJ dev)\n{\n ___device *d = ___CAST(___device*,___FIELD(dev,___FOREIGN_PTR));\n if (d->read_stage != ___STAGE_OPEN)\n {\n  return ___FAL;\n }\n else\n {\n  return ___TRU;\n }\n}\n\nstatic ___SCMOBJ ___wdevice_openp(___SCMOBJ dev)\n{\n ___device *d = ___CAST(___device*,___FIELD(dev,___FOREIGN_PTR));\n if (d->write_stage != ___STAGE_OPEN)\n {\n  return ___FAL;\n }\n else\n {\n  return ___TRU;\n }\n}")
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (##symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-c-lambda
   rdevice-open?
   (scheme-object)
   scheme-object
   "___rdevice_openp")
  (define-c-lambda
   wdevice-open?
   (scheme-object)
   scheme-object
   "___wdevice_openp")
  (define scheme/base-ports#port-buffered-chars?
    (lambda (_port404_)
      (let ((_$e406_ (let ((__tmp4012 (macro-character-port-rlo _port404_))
                           (__tmp4011 (macro-character-port-rhi _port404_)))
                       (declare (not safe))
                       (##fx< __tmp4012 __tmp4011))))
        (if _$e406_ _$e406_ (macro-character-port-peek-eof? _port404_)))))
  (define scheme/base-ports#check-byte-port/lock!
    (lambda (_port401_ _proc402_)
      (if (macro-byte-port? _port401_)
          '#!void
          (error '"Illegal argument; expected byte-port" _port401_))
      (macro-port-mutex-lock! _port401_)
      (if (scheme/base-ports#port-buffered-chars? _port401_)
          (begin
            (macro-port-mutex-unlock! _port401_)
            (let ()
              (declare (not safe))
              (##raise-nonempty-input-port-character-buffer-exception
               _port401_
               _proc402_
               _port401_)))
          '#!void)))
  (define scheme/base-ports#peek-u8
    (lambda (_port389_)
      (scheme/base-ports#check-byte-port/lock!
       _port389_
       scheme/base-ports#peek-u8)
      (let _lp391_ ()
        (let ((_byte-rlo394_ (macro-byte-port-rlo _port389_))
              (_byte-rhi395_ (macro-byte-port-rhi _port389_)))
          (if (let () (declare (not safe)) (##fx< _byte-rlo394_ _byte-rhi395_))
              (let ((_byte397_
                     (u8vector-ref
                      (macro-byte-port-rbuf _port389_)
                      _byte-rlo394_)))
                (macro-port-mutex-unlock! _port389_)
                _byte397_)
              (let ((_res399_
                     ((macro-byte-port-rbuf-fill _port389_) _port389_ '1 '#t)))
                (if (eq? _res399_ ##err-code-EAGAIN)
                    (begin (macro-port-mutex-unlock! _port389_) (eof-object))
                    (if (fixnum? _res399_)
                        (begin
                          (macro-port-mutex-unlock! _port389_)
                          (let ()
                            (declare (not safe))
                            (##raise-os-io-exception
                             _port389_
                             '#f
                             _res399_
                             scheme/base-ports#peek-u8
                             _port389_)))
                        (if _res399_
                            (_lp391_)
                            (begin
                              (macro-port-mutex-unlock! _port389_)
                              (eof-object))))))))))))
