(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/fcntl#fcntl__0
    (lambda (_raw430_ _cmd431_)
      (let* ((_fd433_ (if (std/os/fd#fd? _raw430_)
                          (std/os/fd#fd-e _raw430_)
                          _raw430_))
             (_r435_ (std/os/fcntl#_fcntl0 _fd433_ _cmd431_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r435_)))
            _r435_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r435_))
             std/os/fcntl#fcntl
             _raw430_
             _cmd431_)))))
  (define std/os/fcntl#fcntl__1
    (lambda (_raw438_ _cmd439_ _arg440_)
      (let* ((_fd442_ (if (std/os/fd#fd? _raw438_)
                          (std/os/fd#fd-e _raw438_)
                          _raw438_))
             (_r444_ (std/os/fcntl#_fcntl1 _fd442_ _cmd439_ _arg440_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r444_)))
            _r444_
            (std/os/error#raise-os-error
             (let () (declare (not safe)) (##fx- _r444_))
             std/os/fcntl#fcntl
             _raw438_
             _cmd439_
             _arg440_)))))
  (define std/os/fcntl#fcntl
    (lambda _g4046_
      (let ((_g4045_ (let () (declare (not safe)) (##length _g4046_))))
        (cond ((let () (declare (not safe)) (##fx= _g4045_ 2))
               (apply std/os/fcntl#fcntl__0 _g4046_))
              ((let () (declare (not safe)) (##fx= _g4045_ 3))
               (apply std/os/fcntl#fcntl__1 _g4046_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/fcntl#fcntl
                _g4046_))))))
  (define std/os/fcntl#fd-getfl
    (lambda (_raw428_) (std/os/fcntl#fcntl__0 _raw428_ std/os/fcntl#F_GETFL)))
  (define std/os/fcntl#fd-setfl
    (lambda (_raw420_ _xflags421_)
      (let* ((_flags423_ (std/os/fcntl#fcntl__0 _raw420_ std/os/fcntl#F_GETFL))
             (_flags425_
              (let () (declare (not safe)) (##fxior _flags423_ _xflags421_))))
        (std/os/fcntl#fcntl__1 _raw420_ std/os/fcntl#F_SETFL _flags425_))))
  (define std/os/fcntl#fd-setfl!
    (lambda (_raw417_ _flags418_)
      (std/os/fcntl#fcntl__1 _raw417_ std/os/fcntl#F_SETFL _flags418_)))
  (define std/os/fcntl#fd-getfd
    (lambda (_raw415_) (std/os/fcntl#fcntl__0 _raw415_ std/os/fcntl#F_GETFD)))
  (define std/os/fcntl#fd-setfd
    (lambda (_raw407_ _xflags408_)
      (let* ((_flags410_ (std/os/fcntl#fcntl__0 _raw407_ std/os/fcntl#F_GETFD))
             (_flags412_
              (let () (declare (not safe)) (##fxior _flags410_ _xflags408_))))
        (std/os/fcntl#fcntl__1 _raw407_ std/os/fcntl#F_SETFD _flags412_))))
  (define std/os/fcntl#fd-setfd!
    (lambda (_raw404_ _flags405_)
      (std/os/fcntl#fcntl__1 _raw404_ std/os/fcntl#F_SETFD _flags405_)))
  (define std/os/fcntl#fd-set-nonblock
    (lambda (_raw402_)
      (std/os/fcntl#fd-setfl _raw402_ std/os/fcntl#O_NONBLOCK)))
  (define std/os/fcntl#fd-set-closeonexec
    (lambda (_raw400_)
      (std/os/fcntl#fd-setfd _raw400_ std/os/fcntl#FD_CLOEXEC)))
  (define std/os/fcntl#fd-set-nonblock/closeonexec
    (lambda (_raw398_)
      (std/os/fcntl#fd-setfl _raw398_ std/os/fcntl#O_NONBLOCK)
      (std/os/fcntl#fd-setfd _raw398_ std/os/fcntl#FD_CLOEXEC)))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/os/fcntl#"
    _fcntl1
    _fcntl0
    O_TMPFILE
    O_NOFOLLOW
    O_NOATIME
    O_DSYNC
    O_DIRECT
    O_CLOEXEC
    O_WRONLY
    O_RDWR
    O_RDONLY
    O_ACCMODE
    O_SYNC
    O_NONBLOCK
    O_APPEND
    O_TRUNC
    O_NOCTTY
    O_EXCL
    O_CREAT
    FD_CLOEXEC
    F_SETFL
    F_GETFL
    F_SETFD
    F_GETFD
    F_DUPFD))
  (c-declare "#include <unistd.h>")
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <sys/stat.h>")
  (c-declare "#include <fcntl.h>")
  (namespace ("std/os/fcntl#" __fcntl0 __fcntl1))
  (define-const F_DUPFD)
  (define-const F_GETFD)
  (define-const F_SETFD)
  (define-const F_GETFL)
  (define-const F_SETFL)
  (define-const FD_CLOEXEC)
  (define-const O_CREAT)
  (define-const O_EXCL)
  (define-const O_NOCTTY)
  (define-const O_TRUNC)
  (define-const O_APPEND)
  (define-const O_NONBLOCK)
  (define-const O_SYNC)
  (define-const O_ACCMODE)
  (define-const O_RDONLY)
  (define-const O_RDWR)
  (define-const O_WRONLY)
  (define-const* O_CLOEXEC)
  (define-const* O_DIRECT)
  (define-const* O_DSYNC)
  (define-const* O_EXCL)
  (define-const* O_NOATIME)
  (define-const* O_NOCTTY)
  (define-const* O_NOFOLLOW)
  (define-const* O_TMPFILE)
  (define-c-lambda __fcntl0 (int int) int "fcntl")
  (define-c-lambda __fcntl1 (int int int) int "fcntl")
  (define-with-errno _fcntl0 __fcntl0 (fd cmd))
  (define-with-errno _fcntl1 __fcntl1 (fd cmd arg))
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
