(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/net/socket/api#ssocket-connect__%
    (lambda (_addr1098_ _timeo1099_)
      (let* ((_sa1101_ (std/os/socket#socket-address _addr1098_))
             (_sock1103_
              (std/os/socket#socket__0
               (std/os/_socket#sockaddr_family _sa1101_)
               std/os/_socket#SOCK_STREAM))
             (_rcon1113_
              (with-exception-catcher
               (lambda (_g11041106_)
                 (if '#t
                     (let ((_e1109_ _g11041106_))
                       (close-port _sock1103_)
                       (raise _e1109_))
                     (raise _g11041106_)))
               (lambda () (std/os/socket#socket-connect _sock1103_ _sa1101_))))
             (_ssock1115_ (std/net/socket/api#make-ssocket _sock1103_)))
        (let* ((_ssock11171126_ _ssock1115_)
               (_E11191130_
                (lambda () (error '"No clause matching" _ssock11171126_)))
               (_K11201141_
                (lambda (_close1133_ _wait-out1134_)
                  (if _rcon1113_
                      '#!void
                      (if (_wait-out1134_
                           _ssock1115_
                           (std/net/socket/base#abs-timeout _timeo1099_))
                          '#!void
                          (begin
                            (_close1133_ _ssock1115_ 'inout '#f)
                            (std/error#raise-timeout
                             'ssocket-connect
                             '"connection timeout"
                             _addr1098_))))
                  (let ((_errno1139_
                         (let ((_$e1136_ _rcon1113_))
                           (if _$e1136_
                               _$e1136_
                               (std/os/socket#socket-getsockopt
                                _sock1103_
                                std/os/_socket#SOL_SOCKET
                                std/os/_socket#SO_ERROR)))))
                    (if (##fxzero? _errno1139_)
                        _ssock1115_
                        (begin
                          (_close1133_ _ssock1115_ 'inout '#f)
                          (std/os/error#raise-os-error
                           _errno1139_
                           std/net/socket/api#ssocket-connect
                           _addr1098_
                           _timeo1099_)))))))
          (if (##structure-direct-instance-of?
               _ssock11171126_
               'std/net/socket/base#!socket::t)
              (let* ((_e11211144_ (##vector-ref _ssock11171126_ '1))
                     (_e11221147_ (##vector-ref _ssock11171126_ '2))
                     (_e11231150_ (##vector-ref _ssock11171126_ '3))
                     (_wait-out1153_ _e11231150_)
                     (_e11241155_ (##vector-ref _ssock11171126_ '4))
                     (_close1158_ _e11241155_))
                (_K11201141_ _close1158_ _wait-out1153_))
              (_E11191130_))))))
  (define std/net/socket/api#ssocket-connect__0
    (lambda (_addr1163_)
      (let ((_timeo1165_ '#f))
        (std/net/socket/api#ssocket-connect__% _addr1163_ _timeo1165_))))
  (define std/net/socket/api#ssocket-connect
    (lambda _g6229_
      (let ((_g6228_ (##length _g6229_)))
        (cond ((##fx= _g6228_ 1)
               (apply std/net/socket/api#ssocket-connect__0 _g6229_))
              ((##fx= _g6228_ 2)
               (apply std/net/socket/api#ssocket-connect__% _g6229_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-connect
                _g6229_))))))
  (define std/net/socket/api#ssocket-listen__%
    (lambda (_addr1058_ _backlog1059_ _opts1060_)
      (let* ((_sa1062_ (std/os/socket#socket-address _addr1058_))
             (_sock1064_
              (std/os/socket#server-socket__0
               (std/os/_socket#sockaddr_family _sa1062_)
               std/os/_socket#SOCK_STREAM)))
        (with-exception-catcher
         (lambda (_g10661068_)
           (if '#t
               (let ((_e1071_ _g10661068_))
                 (close-port _sock1064_)
                 (raise _e1071_))
               (raise _g10661068_)))
         (lambda ()
           (for-each
            (lambda (_g10741076_)
              (std/os/socket#socket-setsockopt
               _sock1064_
               std/os/_socket#SOL_SOCKET
               _g10741076_
               '1))
            _opts1060_)
           (std/os/socket#socket-bind _sock1064_ _sa1062_)
           (std/os/socket#socket-listen__% _sock1064_ _backlog1059_)
           (std/net/socket/api#make-ssocket _sock1064_))))))
  (define std/net/socket/api#ssocket-listen__0
    (lambda (_addr1082_)
      (let* ((_backlog1084_ '10)
             (_opts1086_ std/net/socket/api#default-listen-sockopts))
        (std/net/socket/api#ssocket-listen__%
         _addr1082_
         _backlog1084_
         _opts1086_))))
  (define std/net/socket/api#ssocket-listen__1
    (lambda (_addr1088_ _backlog1089_)
      (let ((_opts1091_ std/net/socket/api#default-listen-sockopts))
        (std/net/socket/api#ssocket-listen__%
         _addr1088_
         _backlog1089_
         _opts1091_))))
  (define std/net/socket/api#ssocket-listen
    (lambda _g6231_
      (let ((_g6230_ (##length _g6231_)))
        (cond ((##fx= _g6230_ 1)
               (apply std/net/socket/api#ssocket-listen__0 _g6231_))
              ((##fx= _g6230_ 2)
               (apply std/net/socket/api#ssocket-listen__1 _g6231_))
              ((##fx= _g6230_ 3)
               (apply std/net/socket/api#ssocket-listen__% _g6231_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-listen
                _g6231_))))))
  (define std/net/socket/api#ssocket-accept__%
    (lambda (_ssock1004_ _sa1005_ _timeo1006_)
      (let* ((_ssock10071013_ _ssock1004_)
             (_E10091017_
              (lambda () (error '"No clause matching" _ssock10071013_)))
             (_K10101031_
              (lambda (_sock1020_)
                (let ((_timeo1022_
                       (std/net/socket/base#abs-timeout _timeo1006_)))
                  (let _lp1024_ ()
                    (let ((_wait-in1027_
                           (##direct-structure-ref
                            _ssock1004_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in1027_
                          (let ((_cli1029_
                                 (std/os/socket#socket-accept__%
                                  _sock1020_
                                  _sa1005_)))
                            (if _cli1029_
                                (std/net/socket/api#make-ssocket _cli1029_)
                                (if (_wait-in1027_ _ssock1004_ _timeo1022_)
                                    (_lp1024_)
                                    (std/error#raise-timeout
                                     'ssocket-accept
                                     '"accept timeout"
                                     _ssock1004_))))
                          (std/error#raise-io-error
                           'ssocket-accept
                           '"Socket is not open for input"
                           _ssock1004_))))))))
        (if (##structure-direct-instance-of?
             _ssock10071013_
             'std/net/socket/base#!socket::t)
            (let* ((_e10111034_ (##vector-ref _ssock10071013_ '1))
                   (_sock1037_ _e10111034_))
              (_K10101031_ _sock1037_))
            (_E10091017_)))))
  (define std/net/socket/api#ssocket-accept__0
    (lambda (_ssock1042_)
      (let* ((_sa1044_ '#f) (_timeo1046_ '#f))
        (std/net/socket/api#ssocket-accept__%
         _ssock1042_
         _sa1044_
         _timeo1046_))))
  (define std/net/socket/api#ssocket-accept__1
    (lambda (_ssock1048_ _sa1049_)
      (let ((_timeo1051_ '#f))
        (std/net/socket/api#ssocket-accept__%
         _ssock1048_
         _sa1049_
         _timeo1051_))))
  (define std/net/socket/api#ssocket-accept
    (lambda _g6233_
      (let ((_g6232_ (##length _g6233_)))
        (cond ((##fx= _g6232_ 1)
               (apply std/net/socket/api#ssocket-accept__0 _g6233_))
              ((##fx= _g6232_ 2)
               (apply std/net/socket/api#ssocket-accept__1 _g6233_))
              ((##fx= _g6232_ 3)
               (apply std/net/socket/api#ssocket-accept__% _g6233_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-accept
                _g6233_))))))
  (define std/net/socket/api#ssocket-send__%
    (lambda (_ssock930_ _buf931_ _start932_ _end933_ _timeo934_)
      (let* ((_ssock935941_ _ssock930_)
             (_E937945_
              (lambda () (error '"No clause matching" _ssock935941_)))
             (_K938962_
              (lambda (_sock948_)
                (let ((_timeo950_
                       (std/net/socket/base#abs-timeout _timeo934_)))
                  (let _lp952_ ()
                    (let ((_wait-out955_
                           (##direct-structure-ref
                            _ssock930_
                            '3
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-out955_
                          (let* ((_r957_ (std/os/socket#socket-send__2
                                          _sock948_
                                          _buf931_
                                          _start932_
                                          _end933_))
                                 (_$e959_ _r957_))
                            (if _$e959_
                                _$e959_
                                (if (_wait-out955_ _ssock930_ _timeo950_)
                                    (_lp952_)
                                    (std/error#raise-timeout
                                     'ssocket-send
                                     '"send timeout"
                                     _ssock930_))))
                          (std/error#raise-io-error
                           'ssocket-send
                           '"Socket is not open for output"
                           _ssock930_))))))))
        (if (##structure-direct-instance-of?
             _ssock935941_
             'std/net/socket/base#!socket::t)
            (let* ((_e939965_ (##vector-ref _ssock935941_ '1))
                   (_sock968_ _e939965_))
              (_K938962_ _sock968_))
            (_E937945_)))))
  (define std/net/socket/api#ssocket-send__0
    (lambda (_ssock973_ _buf974_)
      (let* ((_start976_ '0)
             (_end978_ (u8vector-length _buf974_))
             (_timeo980_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock973_
         _buf974_
         _start976_
         _end978_
         _timeo980_))))
  (define std/net/socket/api#ssocket-send__1
    (lambda (_ssock982_ _buf983_ _start984_)
      (let* ((_end986_ (u8vector-length _buf983_)) (_timeo988_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock982_
         _buf983_
         _start984_
         _end986_
         _timeo988_))))
  (define std/net/socket/api#ssocket-send__2
    (lambda (_ssock990_ _buf991_ _start992_ _end993_)
      (let ((_timeo995_ '#f))
        (std/net/socket/api#ssocket-send__%
         _ssock990_
         _buf991_
         _start992_
         _end993_
         _timeo995_))))
  (define std/net/socket/api#ssocket-send
    (lambda _g6235_
      (let ((_g6234_ (##length _g6235_)))
        (cond ((##fx= _g6234_ 2)
               (apply std/net/socket/api#ssocket-send__0 _g6235_))
              ((##fx= _g6234_ 3)
               (apply std/net/socket/api#ssocket-send__1 _g6235_))
              ((##fx= _g6234_ 4)
               (apply std/net/socket/api#ssocket-send__2 _g6235_))
              ((##fx= _g6234_ 5)
               (apply std/net/socket/api#ssocket-send__% _g6235_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-send
                _g6235_))))))
  (define std/net/socket/api#ssocket-send-all__%
    (lambda (_ssock857_ _buf858_ _start859_ _end860_ _timeo861_)
      (let* ((_ssock862868_ _ssock857_)
             (_E864872_
              (lambda () (error '"No clause matching" _ssock862868_)))
             (_K865888_
              (lambda (_sock875_)
                (let ((_timeo877_
                       (std/net/socket/base#abs-timeout _timeo861_)))
                  (let _lp879_ ((_count881_ '0) (_start882_ _start859_))
                    (let ((_wait-out884_
                           (##direct-structure-ref
                            _ssock857_
                            '3
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-out884_
                          (if (##fx< _start882_ _end860_)
                              (let ((_r886_ (std/os/socket#socket-send__2
                                             _sock875_
                                             _buf858_
                                             _start882_
                                             _end860_)))
                                (if _r886_
                                    (_lp879_ (##fx+ _count881_ _r886_)
                                             (##fx+ _start882_ _r886_))
                                    (if (_wait-out884_ _ssock857_ _timeo877_)
                                        (_lp879_ _count881_ _start882_)
                                        (std/error#raise-timeout
                                         'ssocket-send-all
                                         '"send timeout"
                                         _ssock857_))))
                              _count881_)
                          (std/error#raise-io-error
                           'ssocket-send-all
                           '"Socket is not open for output"
                           _ssock857_))))))))
        (if (##structure-direct-instance-of?
             _ssock862868_
             'std/net/socket/base#!socket::t)
            (let* ((_e866891_ (##vector-ref _ssock862868_ '1))
                   (_sock894_ _e866891_))
              (_K865888_ _sock894_))
            (_E864872_)))))
  (define std/net/socket/api#ssocket-send-all__0
    (lambda (_ssock899_ _buf900_)
      (let* ((_start902_ '0)
             (_end904_ (u8vector-length _buf900_))
             (_timeo906_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock899_
         _buf900_
         _start902_
         _end904_
         _timeo906_))))
  (define std/net/socket/api#ssocket-send-all__1
    (lambda (_ssock908_ _buf909_ _start910_)
      (let* ((_end912_ (u8vector-length _buf909_)) (_timeo914_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock908_
         _buf909_
         _start910_
         _end912_
         _timeo914_))))
  (define std/net/socket/api#ssocket-send-all__2
    (lambda (_ssock916_ _buf917_ _start918_ _end919_)
      (let ((_timeo921_ '#f))
        (std/net/socket/api#ssocket-send-all__%
         _ssock916_
         _buf917_
         _start918_
         _end919_
         _timeo921_))))
  (define std/net/socket/api#ssocket-send-all
    (lambda _g6237_
      (let ((_g6236_ (##length _g6237_)))
        (cond ((##fx= _g6236_ 2)
               (apply std/net/socket/api#ssocket-send-all__0 _g6237_))
              ((##fx= _g6236_ 3)
               (apply std/net/socket/api#ssocket-send-all__1 _g6237_))
              ((##fx= _g6236_ 4)
               (apply std/net/socket/api#ssocket-send-all__2 _g6237_))
              ((##fx= _g6236_ 5)
               (apply std/net/socket/api#ssocket-send-all__% _g6237_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-send-all
                _g6237_))))))
  (define std/net/socket/api#ssocket-recv__%
    (lambda (_ssock783_ _buf784_ _start785_ _end786_ _timeo787_)
      (let* ((_ssock788794_ _ssock783_)
             (_E790798_
              (lambda () (error '"No clause matching" _ssock788794_)))
             (_K791815_
              (lambda (_sock801_)
                (let ((_timeo803_
                       (std/net/socket/base#abs-timeout _timeo787_)))
                  (let _lp805_ ()
                    (let ((_wait-in808_
                           (##direct-structure-ref
                            _ssock783_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in808_
                          (let* ((_r810_ (std/os/socket#socket-recv__2
                                          _sock801_
                                          _buf784_
                                          _start785_
                                          _end786_))
                                 (_$e812_ _r810_))
                            (if _$e812_
                                _$e812_
                                (if (_wait-in808_ _ssock783_ _timeo803_)
                                    (_lp805_)
                                    (std/error#raise-timeout
                                     'ssocket-recv
                                     '"receive timeout"
                                     _ssock783_))))
                          (std/error#raise-io-error
                           'ssocket-recv
                           '"Socket is not open for input"
                           _ssock783_))))))))
        (if (##structure-direct-instance-of?
             _ssock788794_
             'std/net/socket/base#!socket::t)
            (let* ((_e792818_ (##vector-ref _ssock788794_ '1))
                   (_sock821_ _e792818_))
              (_K791815_ _sock821_))
            (_E790798_)))))
  (define std/net/socket/api#ssocket-recv__0
    (lambda (_ssock826_ _buf827_)
      (let* ((_start829_ '0)
             (_end831_ (u8vector-length _buf827_))
             (_timeo833_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock826_
         _buf827_
         _start829_
         _end831_
         _timeo833_))))
  (define std/net/socket/api#ssocket-recv__1
    (lambda (_ssock835_ _buf836_ _start837_)
      (let* ((_end839_ (u8vector-length _buf836_)) (_timeo841_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock835_
         _buf836_
         _start837_
         _end839_
         _timeo841_))))
  (define std/net/socket/api#ssocket-recv__2
    (lambda (_ssock843_ _buf844_ _start845_ _end846_)
      (let ((_timeo848_ '#f))
        (std/net/socket/api#ssocket-recv__%
         _ssock843_
         _buf844_
         _start845_
         _end846_
         _timeo848_))))
  (define std/net/socket/api#ssocket-recv
    (lambda _g6239_
      (let ((_g6238_ (##length _g6239_)))
        (cond ((##fx= _g6238_ 2)
               (apply std/net/socket/api#ssocket-recv__0 _g6239_))
              ((##fx= _g6238_ 3)
               (apply std/net/socket/api#ssocket-recv__1 _g6239_))
              ((##fx= _g6238_ 4)
               (apply std/net/socket/api#ssocket-recv__2 _g6239_))
              ((##fx= _g6238_ 5)
               (apply std/net/socket/api#ssocket-recv__% _g6239_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-recv
                _g6239_))))))
  (define std/net/socket/api#ssocket-recv-all__%
    (lambda (_ssock710_ _buf711_ _start712_ _end713_ _timeo714_)
      (let* ((_ssock715721_ _ssock710_)
             (_E717725_
              (lambda () (error '"No clause matching" _ssock715721_)))
             (_K718741_
              (lambda (_sock728_)
                (let ((_timeo730_
                       (std/net/socket/base#abs-timeout _timeo714_)))
                  (let _lp732_ ((_count734_ '0) (_start735_ _start712_))
                    (let ((_wait-in737_
                           (##direct-structure-ref
                            _ssock710_
                            '2
                            std/net/socket/base#!socket::t
                            '#f)))
                      (if _wait-in737_
                          (if (##fx>= _start735_ _end713_)
                              _count734_
                              (let ((_r739_ (std/os/socket#socket-recv__2
                                             _sock728_
                                             _buf711_
                                             _start735_
                                             _end713_)))
                                (if (not _r739_)
                                    (if (_wait-in737_ _ssock710_ _timeo730_)
                                        (_lp732_ _count734_ _start735_)
                                        (std/error#raise-timeout
                                         'ssocket-recv-all
                                         '"receive timeout"
                                         _ssock710_))
                                    (if (##fxzero? _r739_)
                                        _count734_
                                        (_lp732_ (##fx+ _count734_ _r739_)
                                                 (##fx+ _start735_ _r739_))))))
                          (std/error#raise-io-error
                           'ssocket-recv-all
                           '"Socket is not open for input"
                           _ssock710_))))))))
        (if (##structure-direct-instance-of?
             _ssock715721_
             'std/net/socket/base#!socket::t)
            (let* ((_e719744_ (##vector-ref _ssock715721_ '1))
                   (_sock747_ _e719744_))
              (_K718741_ _sock747_))
            (_E717725_)))))
  (define std/net/socket/api#ssocket-recv-all__0
    (lambda (_ssock752_ _buf753_)
      (let* ((_start755_ '0)
             (_end757_ (u8vector-length _buf753_))
             (_timeo759_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock752_
         _buf753_
         _start755_
         _end757_
         _timeo759_))))
  (define std/net/socket/api#ssocket-recv-all__1
    (lambda (_ssock761_ _buf762_ _start763_)
      (let* ((_end765_ (u8vector-length _buf762_)) (_timeo767_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock761_
         _buf762_
         _start763_
         _end765_
         _timeo767_))))
  (define std/net/socket/api#ssocket-recv-all__2
    (lambda (_ssock769_ _buf770_ _start771_ _end772_)
      (let ((_timeo774_ '#f))
        (std/net/socket/api#ssocket-recv-all__%
         _ssock769_
         _buf770_
         _start771_
         _end772_
         _timeo774_))))
  (define std/net/socket/api#ssocket-recv-all
    (lambda _g6241_
      (let ((_g6240_ (##length _g6241_)))
        (cond ((##fx= _g6240_ 2)
               (apply std/net/socket/api#ssocket-recv-all__0 _g6241_))
              ((##fx= _g6240_ 3)
               (apply std/net/socket/api#ssocket-recv-all__1 _g6241_))
              ((##fx= _g6240_ 4)
               (apply std/net/socket/api#ssocket-recv-all__2 _g6241_))
              ((##fx= _g6240_ 5)
               (apply std/net/socket/api#ssocket-recv-all__% _g6241_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-recv-all
                _g6241_))))))
  (define std/net/socket/api#ssocket-socket
    (lambda (_ssock707_)
      (##direct-structure-ref
       _ssock707_
       '1
       std/net/socket/base#!socket::t
       '#f)))
  (define std/net/socket/api#ssocket-close
    (lambda (_ssock705_)
      ((##direct-structure-ref
        _ssock705_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock705_
       'inout
       '#f)))
  (define std/net/socket/api#ssocket-close-input__%
    (lambda (_ssock692_ _shutdown693_)
      ((##direct-structure-ref
        _ssock692_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock692_
       'in
       (if _shutdown693_ std/os/_socket#SHUT_RD '#f))))
  (define std/net/socket/api#ssocket-close-input__0
    (lambda (_ssock698_)
      (let ((_shutdown700_ '#f))
        (std/net/socket/api#ssocket-close-input__% _ssock698_ _shutdown700_))))
  (define std/net/socket/api#ssocket-close-input
    (lambda _g6243_
      (let ((_g6242_ (##length _g6243_)))
        (cond ((##fx= _g6242_ 1)
               (apply std/net/socket/api#ssocket-close-input__0 _g6243_))
              ((##fx= _g6242_ 2)
               (apply std/net/socket/api#ssocket-close-input__% _g6243_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-close-input
                _g6243_))))))
  (define std/net/socket/api#ssocket-close-output__%
    (lambda (_ssock678_ _shutdown679_)
      ((##direct-structure-ref
        _ssock678_
        '4
        std/net/socket/base#!socket::t
        '#f)
       _ssock678_
       'out
       (if _shutdown679_ std/os/_socket#SHUT_WR '#f))))
  (define std/net/socket/api#ssocket-close-output__0
    (lambda (_ssock684_)
      (let ((_shutdown686_ '#f))
        (std/net/socket/api#ssocket-close-output__%
         _ssock684_
         _shutdown686_))))
  (define std/net/socket/api#ssocket-close-output
    (lambda _g6245_
      (let ((_g6244_ (##length _g6245_)))
        (cond ((##fx= _g6244_ 1)
               (apply std/net/socket/api#ssocket-close-output__0 _g6245_))
              ((##fx= _g6244_ 2)
               (apply std/net/socket/api#ssocket-close-output__% _g6245_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socket/api#ssocket-close-output
                _g6245_))))))
  (define std/net/socket/api#!socket::destroy std/net/socket/api#ssocket-close)
  (bind-method!
   std/net/socket/base#!socket::t
   'destroy
   std/net/socket/api#!socket::destroy
   '#f)
  (define std/net/socket/api#default-listen-sockopts
    (cons std/os/_socket#SO_REUSEADDR '()))
  (define std/net/socket/api#make-ssocket
    (lambda (_sock543_)
      (let ((_$e545_ (std/net/socket/base#current-socket-server)))
        (if _$e545_
            ((lambda (_srv548_)
               (let ((_token550_ (##structure std/actor/proto#!token::t))
                     (_dest552_ _srv548_))
                 (std/actor/message#send-message__%
                  _dest552_
                  (##structure
                   std/actor/proto#!call::t
                   (##structure
                    std/net/socket/base#socket-server.add::t
                    _sock543_)
                   _token550_)
                  '#f
                  '#t)
                 (std/actor/proto#!!call-recv _token550_ _dest552_)))
             _$e545_)
            (std/net/socket/basic-socket#basic-socket _sock543_))))))
