(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/dh#with-null-check
    (lambda (_makef416_)
      (let ((_$e418_ (_makef416_)))
        (if _$e418_ _$e418_ (error '"error allocating key; NULL POINTER")))))
  (define std/crypto/dh#DH-get-1024-160
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_1024_160)))
  (define std/crypto/dh#DH-get-2048-224
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_2048_224)))
  (define std/crypto/dh#DH-get-2048-256
    (lambda ()
      (std/crypto/dh#with-null-check std/crypto/libcrypto#DH_get_2048_256)))
  (define std/crypto/dh#DH-generate-key
    (lambda (_dh408_)
      (let ((_res410_ (std/crypto/libcrypto#DH_generate_key _dh408_)))
        (if (let () (declare (not safe)) (##fxzero? _res410_))
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/dh#DH-compute-key
    (lambda (_dh398_ _bn399_)
      (let* ((_len401_ (std/crypto/libcrypto#DH_size _dh398_))
             (_secret403_ (make-u8vector _len401_))
             (_count405_
              (std/crypto/libcrypto#DH_compute_key
               _secret403_
               _bn399_
               _dh398_)))
        (if (let () (declare (not safe)) (##fx< _count405_ _len401_))
            (u8vector-shrink! _secret403_ _count405_)
            '#!void)
        _secret403_))))
