(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/43#nonneg-int?
    (lambda (_x2358_) (if (integer? _x2358_) (not (negative? _x2358_)) '#f)))
  (define std/srfi/43#between?
    (lambda (_x2354_ _y2355_ _z2356_)
      (if (< _x2354_ _y2355_) (<= _y2355_ _z2356_) '#f)))
  (define std/srfi/43#unspecified-value (lambda () (if '#f '#f '#!void)))
  (define std/srfi/43#vectors-ref
    (lambda (_vectors2348_ _i2349_)
      (map (lambda (_v2351_) (vector-ref _v2351_ _i2349_)) _vectors2348_)))
  (define std/srfi/43#check-type
    (lambda (_pred?2344_ _value2345_ _callee2346_)
      (if (_pred?2344_ _value2345_)
          _value2345_
          (std/srfi/43#check-type
           _pred?2344_
           (error '"erroneous value"
                  (list _pred?2344_ _value2345_)
                  (cons 'while (cons 'calling (cons _callee2346_ '()))))
           _callee2346_))))
  (define std/srfi/43#check-index
    (lambda (_vec2338_ _index2339_ _callee2340_)
      (let ((_index2342_
             (std/srfi/43#check-type integer? _index2339_ _callee2340_)))
        (if (< _index2342_ '0)
            (std/srfi/43#check-index
             _vec2338_
             (error '"vector index too low"
                    _index2342_
                    (cons 'into (cons 'vector (cons _vec2338_ '())))
                    (cons 'while (cons 'calling (cons _callee2340_ '()))))
             _callee2340_)
            (if (>= _index2342_ (vector-length _vec2338_))
                (std/srfi/43#check-index
                 _vec2338_
                 (error '"vector index too high"
                        _index2342_
                        (cons 'into (cons 'vector (cons _vec2338_ '())))
                        (cons 'while (cons 'calling (cons _callee2340_ '()))))
                 _callee2340_)
                _index2342_)))))
  (define std/srfi/43#check-indices
    (lambda (_vec2322_
             _start2323_
             _start-name2324_
             _end2325_
             _end-name2326_
             _callee2327_)
      (let ((_lose2331_
             (lambda _things2329_
               (apply error
                      '"vector range out of bounds"
                      (append _things2329_
                              (cons 'vector (cons 'was (cons _vec2322_ '())))
                              (cons _start-name2324_
                                    (cons 'was (cons _start2323_ '())))
                              (cons _end-name2326_
                                    (cons 'was (cons _end2325_ '())))
                              (cons 'while
                                    (cons 'calling
                                          (cons _callee2327_ '())))))))
            (_start2332_
             (std/srfi/43#check-type integer? _start2323_ _callee2327_))
            (_end2333_
             (std/srfi/43#check-type integer? _end2325_ _callee2327_)))
        (if (> _start2332_ _end2333_)
            (let ((_g6131_ (_lose2331_
                            (cons _end-name2326_
                                  (cons '< (cons _start-name2324_ '()))))))
              (begin
                (let ((_g6132_ (let ()
                                 (declare (not safe))
                                 (if (##values? _g6131_)
                                     (##vector-length _g6131_)
                                     1))))
                  (if (not (let () (declare (not safe)) (##fx= _g6132_ 2)))
                      (error "Context expects 2 values" _g6132_)))
                (let ((_new-start2335_
                       (let () (declare (not safe)) (##vector-ref _g6131_ 0)))
                      (_new-end2336_
                       (let () (declare (not safe)) (##vector-ref _g6131_ 1))))
                  (std/srfi/43#check-indices
                   _vec2322_
                   _new-start2335_
                   _start-name2324_
                   _new-end2336_
                   _end-name2326_
                   _callee2327_))))
            (if (< _start2332_ '0)
                (std/srfi/43#check-indices
                 _vec2322_
                 (_lose2331_ (cons _start-name2324_ (cons '< (cons '0 '()))))
                 _start-name2324_
                 _end2333_
                 _end-name2326_
                 _callee2327_)
                (if (>= _start2332_ (vector-length _vec2322_))
                    (std/srfi/43#check-indices
                     _vec2322_
                     (_lose2331_
                      (cons _start-name2324_ (cons '> (cons 'len '())))
                      (cons 'len
                            (cons 'was (cons (vector-length _vec2322_) '()))))
                     _start-name2324_
                     _end2333_
                     _end-name2326_
                     _callee2327_)
                    (if (> _end2333_ (vector-length _vec2322_))
                        (std/srfi/43#check-indices
                         _vec2322_
                         _start2332_
                         _start-name2324_
                         (_lose2331_
                          (cons _end-name2326_ (cons '> (cons 'len '())))
                          (cons 'len
                                (cons 'was
                                      (cons (vector-length _vec2322_) '()))))
                         _end-name2326_
                         _callee2327_)
                        (values _start2332_ _end2333_))))))))
  (define std/srfi/43#vector-parse-start+end
    (lambda (_vec2314_ _args2315_ _start-name2316_ _end-name2317_ _callee2318_)
      (let ((_len2320_ (vector-length _vec2314_)))
        (if (null? _args2315_)
            (values '0 _len2320_)
            (if (null? (cdr _args2315_))
                (std/srfi/43#check-indices
                 _vec2314_
                 (car _args2315_)
                 _start-name2316_
                 _len2320_
                 _end-name2317_
                 _callee2318_)
                (if (null? (cddr _args2315_))
                    (std/srfi/43#check-indices
                     _vec2314_
                     (car _args2315_)
                     _start-name2316_
                     (cadr _args2315_)
                     _end-name2317_
                     _callee2318_)
                    (error '"too many arguments"
                           (cons 'extra
                                 (cons 'args
                                       (cons 'were
                                             (cons (cddr _args2315_) '()))))
                           (cons 'while
                                 (cons 'calling
                                       (cons _callee2318_ '()))))))))))
  (define std/srfi/43#%smallest-length
    (letrec ((_loop2308_
              (lambda (_vector-list2310_ _length2311_ _callee2312_)
                (if (null? _vector-list2310_)
                    _length2311_
                    (_loop2308_
                     (cdr _vector-list2310_)
                     (min (vector-length
                           (std/srfi/43#check-type
                            vector?
                            (car _vector-list2310_)
                            _callee2312_))
                          _length2311_)
                     _callee2312_)))))
      _loop2308_))
  (define std/srfi/43#%vector-copy!
    (letrec ((_loop/l->r2287_
              (lambda (_target2290_ _source2291_ _send2292_ _i2293_ _j2294_)
                (if (< _i2293_ _send2292_)
                    (begin
                      (vector-set!
                       _target2290_
                       _j2294_
                       (vector-ref _source2291_ _i2293_))
                      (_loop/l->r2287_
                       _target2290_
                       _source2291_
                       _send2292_
                       (+ _i2293_ '1)
                       (+ _j2294_ '1)))
                    '#!void)))
             (_loop/r->l2288_
              (lambda (_target2296_ _source2297_ _sstart2298_ _i2299_ _j2300_)
                (if (>= _i2299_ _sstart2298_)
                    (begin
                      (vector-set!
                       _target2296_
                       _j2300_
                       (vector-ref _source2297_ _i2299_))
                      (_loop/r->l2288_
                       _target2296_
                       _source2297_
                       _sstart2298_
                       (- _i2299_ '1)
                       (- _j2300_ '1)))
                    '#!void))))
      (lambda (_target2302_ _tstart2303_ _source2304_ _sstart2305_ _send2306_)
        (if (> _sstart2305_ _tstart2303_)
            (_loop/l->r2287_
             _target2302_
             _source2304_
             _send2306_
             _sstart2305_
             _tstart2303_)
            (_loop/r->l2288_
             _target2302_
             _source2304_
             _sstart2305_
             (- _send2306_ '1)
             (+ '-1 _tstart2303_ _send2306_ (- _sstart2305_)))))))
  (define std/srfi/43#%vector-reverse-copy!
    (letrec ((_loop2273_
              (lambda (_target2275_ _source2276_ _sstart2277_ _i2278_ _j2279_)
                (if (>= _i2278_ _sstart2277_)
                    (begin
                      (vector-set!
                       _target2275_
                       _j2279_
                       (vector-ref _source2276_ _i2278_))
                      (_loop2273_
                       _target2275_
                       _source2276_
                       _sstart2277_
                       (- _i2278_ '1)
                       (+ _j2279_ '1)))
                    '#!void))))
      (lambda (_target2281_ _tstart2282_ _source2283_ _sstart2284_ _send2285_)
        (_loop2273_
         _target2281_
         _source2283_
         _sstart2284_
         (- _send2285_ '1)
         _tstart2282_))))
  (define std/srfi/43#%vector-reverse!
    (letrec ((_loop2261_
              (lambda (_vec2263_ _i2264_ _j2265_)
                (if (<= _i2264_ _j2265_)
                    (let ((_v2267_ (vector-ref _vec2263_ _i2264_)))
                      (vector-set!
                       _vec2263_
                       _i2264_
                       (vector-ref _vec2263_ _j2265_))
                      (vector-set! _vec2263_ _j2265_ _v2267_)
                      (_loop2261_ _vec2263_ (+ _i2264_ '1) (- _j2265_ '1)))
                    '#!void))))
      (lambda (_vec2269_ _start2270_ _end2271_)
        (_loop2261_ _vec2269_ _start2270_ (- _end2271_ '1)))))
  (define std/srfi/43#%vector-fold1
    (letrec ((_loop2248_
              (lambda (_kons2250_ _knil2251_ _len2252_ _vec2253_ _i2254_)
                (if (= _i2254_ _len2252_)
                    _knil2251_
                    (_loop2248_
                     _kons2250_
                     (_kons2250_
                      _i2254_
                      _knil2251_
                      (vector-ref _vec2253_ _i2254_))
                     _len2252_
                     _vec2253_
                     (+ _i2254_ '1))))))
      (lambda (_kons2256_ _knil2257_ _len2258_ _vec2259_)
        (_loop2248_ _kons2256_ _knil2257_ _len2258_ _vec2259_ '0))))
  (define std/srfi/43#%vector-fold2+
    (letrec ((_loop2235_
              (lambda (_kons2237_ _knil2238_ _len2239_ _vectors2240_ _i2241_)
                (if (= _i2241_ _len2239_)
                    _knil2238_
                    (_loop2235_
                     _kons2237_
                     (apply _kons2237_
                            _i2241_
                            _knil2238_
                            (std/srfi/43#vectors-ref _vectors2240_ _i2241_))
                     _len2239_
                     _vectors2240_
                     (+ _i2241_ '1))))))
      (lambda (_kons2243_ _knil2244_ _len2245_ _vectors2246_)
        (_loop2235_ _kons2243_ _knil2244_ _len2245_ _vectors2246_ '0))))
  (define std/srfi/43#%vector-map1!
    (letrec ((_loop2221_
              (lambda (_f2223_ _target2224_ _vec2225_ _i2226_)
                (if (zero? _i2226_)
                    _target2224_
                    (let ((_j2228_ (- _i2226_ '1)))
                      (vector-set!
                       _target2224_
                       _j2228_
                       (_f2223_ _j2228_ (vector-ref _vec2225_ _j2228_)))
                      (_loop2221_ _f2223_ _target2224_ _vec2225_ _j2228_))))))
      (lambda (_f2230_ _target2231_ _vec2232_ _len2233_)
        (_loop2221_ _f2230_ _target2231_ _vec2232_ _len2233_))))
  (define std/srfi/43#%vector-map2+!
    (letrec ((_loop2207_
              (lambda (_f2209_ _target2210_ _vectors2211_ _i2212_)
                (if (zero? _i2212_)
                    _target2210_
                    (let ((_j2214_ (- _i2212_ '1)))
                      (vector-set!
                       _target2210_
                       _j2214_
                       (apply _f2209_
                              _j2214_
                              (std/srfi/43#vectors-ref _vectors2211_ _j2214_)))
                      (_loop2207_
                       _f2209_
                       _target2210_
                       _vectors2211_
                       _j2214_))))))
      (lambda (_f2216_ _target2217_ _vectors2218_ _len2219_)
        (_loop2207_ _f2216_ _target2217_ _vectors2218_ _len2219_))))
  (define std/srfi/43#vector-unfold
    (letrec ((_tabulate!2171_
              (lambda (_f2175_ _vec2176_ _i2177_ _len2178_)
                (if (< _i2177_ _len2178_)
                    (begin
                      (vector-set! _vec2176_ _i2177_ (_f2175_ _i2177_))
                      (_tabulate!2171_
                       _f2175_
                       _vec2176_
                       (+ _i2177_ '1)
                       _len2178_))
                    '#!void)))
             (_unfold1!2172_
              (lambda (_f2180_ _vec2181_ _i2182_ _len2183_ _seed2184_)
                (if (< _i2182_ _len2183_)
                    (let ((_g6133_ (_f2180_ _i2182_ _seed2184_)))
                      (begin
                        (let ((_g6134_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6133_)
                                             (##vector-length _g6133_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx= _g6134_ 2)))
                              (error "Context expects 2 values" _g6134_)))
                        (let ((_elt2186_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6133_ 0)))
                              (_new-seed2187_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6133_ 1))))
                          (begin
                            (vector-set! _vec2181_ _i2182_ _elt2186_)
                            (_unfold1!2172_
                             _f2180_
                             _vec2181_
                             (+ _i2182_ '1)
                             _len2183_
                             _new-seed2187_)))))
                    '#!void)))
             (_unfold2+!2173_
              (lambda (_f2189_ _vec2190_ _i2191_ _len2192_ _seeds2193_)
                (if (< _i2191_ _len2192_)
                    (let ((_g6135_ (apply _f2189_ _i2191_ _seeds2193_)))
                      (begin
                        (let ((_g6136_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6135_)
                                             (##vector-length _g6135_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx>= _g6136_ 1)))
                              (error "Context expects at least 1 values"
                                     _g6136_)))
                        (let ((_elt2195_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6135_)
                                     (##vector-ref _g6135_ 0)
                                     _g6135_)))
                              (_new-seeds2196_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6135_)
                                     (##cdr (##vector->list _g6135_))
                                     '()))))
                          (begin
                            (vector-set! _vec2190_ _i2191_ _elt2195_)
                            (_unfold2+!2173_
                             _f2189_
                             _vec2190_
                             (+ _i2191_ '1)
                             _len2192_
                             _new-seeds2196_)))))
                    '#!void))))
      (lambda (_f2198_ _len2199_ . _initial-seeds2200_)
        (let ((_f2202_ (std/srfi/43#check-type
                        procedure?
                        _f2198_
                        std/srfi/43#vector-unfold))
              (_len2203_
               (std/srfi/43#check-type
                std/srfi/43#nonneg-int?
                _len2199_
                std/srfi/43#vector-unfold)))
          (let ((_vec2205_ (make-vector _len2203_)))
            (if (null? _initial-seeds2200_)
                (_tabulate!2171_ _f2202_ _vec2205_ '0 _len2203_)
                (if (null? (cdr _initial-seeds2200_))
                    (_unfold1!2172_
                     _f2202_
                     _vec2205_
                     '0
                     _len2203_
                     (car _initial-seeds2200_))
                    (_unfold2+!2173_
                     _f2202_
                     _vec2205_
                     '0
                     _len2203_
                     _initial-seeds2200_)))
            _vec2205_)))))
  (define std/srfi/43#vector-unfold-right
    (letrec ((_tabulate!2137_
              (lambda (_f2141_ _vec2142_ _i2143_)
                (if (>= _i2143_ '0)
                    (begin
                      (vector-set! _vec2142_ _i2143_ (_f2141_ _i2143_))
                      (_tabulate!2137_ _f2141_ _vec2142_ (- _i2143_ '1)))
                    '#!void)))
             (_unfold1!2138_
              (lambda (_f2145_ _vec2146_ _i2147_ _seed2148_)
                (if (>= _i2147_ '0)
                    (let ((_g6137_ (_f2145_ _i2147_ _seed2148_)))
                      (begin
                        (let ((_g6138_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6137_)
                                             (##vector-length _g6137_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx= _g6138_ 2)))
                              (error "Context expects 2 values" _g6138_)))
                        (let ((_elt2150_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6137_ 0)))
                              (_new-seed2151_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g6137_ 1))))
                          (begin
                            (vector-set! _vec2146_ _i2147_ _elt2150_)
                            (_unfold1!2138_
                             _f2145_
                             _vec2146_
                             (- _i2147_ '1)
                             _new-seed2151_)))))
                    '#!void)))
             (_unfold2+!2139_
              (lambda (_f2153_ _vec2154_ _i2155_ _seeds2156_)
                (if (>= _i2155_ '0)
                    (let ((_g6139_ (apply _f2153_ _i2155_ _seeds2156_)))
                      (begin
                        (let ((_g6140_ (let ()
                                         (declare (not safe))
                                         (if (##values? _g6139_)
                                             (##vector-length _g6139_)
                                             1))))
                          (if (not (let ()
                                     (declare (not safe))
                                     (##fx>= _g6140_ 1)))
                              (error "Context expects at least 1 values"
                                     _g6140_)))
                        (let ((_elt2158_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6139_)
                                     (##vector-ref _g6139_ 0)
                                     _g6139_)))
                              (_new-seeds2159_
                               (let ()
                                 (declare (not safe))
                                 (if (##values? _g6139_)
                                     (##cdr (##vector->list _g6139_))
                                     '()))))
                          (begin
                            (vector-set! _vec2154_ _i2155_ _elt2158_)
                            (_unfold2+!2139_
                             _f2153_
                             _vec2154_
                             (- _i2155_ '1)
                             _new-seeds2159_)))))
                    '#!void))))
      (lambda (_f2161_ _len2162_ . _initial-seeds2163_)
        (let ((_f2165_ (std/srfi/43#check-type
                        procedure?
                        _f2161_
                        std/srfi/43#vector-unfold-right))
              (_len2166_
               (std/srfi/43#check-type
                std/srfi/43#nonneg-int?
                _len2162_
                std/srfi/43#vector-unfold-right)))
          (let ((_vec2168_ (make-vector _len2166_)) (_i2169_ (- _len2166_ '1)))
            (if (null? _initial-seeds2163_)
                (_tabulate!2137_ _f2165_ _vec2168_ _i2169_)
                (if (null? (cdr _initial-seeds2163_))
                    (_unfold1!2138_
                     _f2165_
                     _vec2168_
                     _i2169_
                     (car _initial-seeds2163_))
                    (_unfold2+!2139_
                     _f2165_
                     _vec2168_
                     _i2169_
                     _initial-seeds2163_)))
            _vec2168_)))))
  (define std/srfi/43#vector-copy
    (lambda (_vec2126_ . _args2127_)
      (let* ((_vec2129_
              (std/srfi/43#check-type
               vector?
               _vec2126_
               std/srfi/43#vector-copy))
             (_g6141_ (std/srfi/43#vector-copy:parse-args
                       _vec2129_
                       _args2127_)))
        (begin
          (let ((_g6142_ (let ()
                           (declare (not safe))
                           (if (##values? _g6141_)
                               (##vector-length _g6141_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6142_ 3)))
                (error "Context expects 3 values" _g6142_)))
          (let ((_start2131_
                 (let () (declare (not safe)) (##vector-ref _g6141_ 0)))
                (_end2132_
                 (let () (declare (not safe)) (##vector-ref _g6141_ 1)))
                (_fill2133_
                 (let () (declare (not safe)) (##vector-ref _g6141_ 2))))
            (let ((_new-vector2135_
                   (make-vector (- _end2132_ _start2131_) _fill2133_)))
              (std/srfi/43#%vector-copy!
               _new-vector2135_
               '0
               _vec2129_
               _start2131_
               (if (> _end2132_ (vector-length _vec2129_))
                   (vector-length _vec2129_)
                   _end2132_))
              _new-vector2135_))))))
  (define std/srfi/43#vector-copy:parse-args
    (lambda (_vec2111_ _args2112_)
      (letrec ((_parse-args2114_
                (lambda (_start2118_ _end2119_ _n2120_ _fill2121_)
                  (let ((_start2123_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start2118_
                          std/srfi/43#vector-copy))
                        (_end2124_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end2119_
                          std/srfi/43#vector-copy)))
                    (if (and (<= '0 _start2123_ _end2124_)
                             (<= _start2123_ _n2120_))
                        (values _start2123_ _end2124_ _fill2121_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/43#vector-copy '())))
                               (cons 'start (cons 'was (cons _start2123_ '())))
                               (cons 'end (cons 'was (cons _end2124_ '())))
                               (cons 'vector
                                     (cons 'was (cons _vec2111_ '())))))))))
        (let ((_n2116_ (vector-length _vec2111_)))
          (if (null? _args2112_)
              (_parse-args2114_
               '0
               _n2116_
               _n2116_
               (std/srfi/43#unspecified-value))
              (if (null? (cdr _args2112_))
                  (_parse-args2114_
                   (car _args2112_)
                   _n2116_
                   _n2116_
                   (std/srfi/43#unspecified-value))
                  (if (null? (cddr _args2112_))
                      (_parse-args2114_
                       (car _args2112_)
                       (cadr _args2112_)
                       _n2116_
                       (std/srfi/43#unspecified-value))
                      (if (null? (cdddr _args2112_))
                          (_parse-args2114_
                           (car _args2112_)
                           (cadr _args2112_)
                           _n2116_
                           (caddr _args2112_))
                          (error '"too many arguments"
                                 std/srfi/43#vector-copy
                                 (cdddr _args2112_))))))))))
  (define std/srfi/43#vector-reverse-copy
    (lambda (_vec2101_ . _maybe-start+end2102_)
      (let* ((_vec2104_
              (std/srfi/43#check-type
               vector?
               _vec2101_
               std/srfi/43#vector-reverse-copy))
             (_g6143_ (std/srfi/43#vector-parse-start+end
                       _vec2104_
                       _maybe-start+end2102_
                       'start
                       'end
                       std/srfi/43#vector-reverse-copy)))
        (begin
          (let ((_g6144_ (let ()
                           (declare (not safe))
                           (if (##values? _g6143_)
                               (##vector-length _g6143_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6144_ 2)))
                (error "Context expects 2 values" _g6144_)))
          (let ((_start2106_
                 (let () (declare (not safe)) (##vector-ref _g6143_ 0)))
                (_end2107_
                 (let () (declare (not safe)) (##vector-ref _g6143_ 1))))
            (let ((_new2109_ (make-vector (- _end2107_ _start2106_))))
              (std/srfi/43#%vector-reverse-copy!
               _new2109_
               '0
               _vec2104_
               _start2106_
               _end2107_)
              _new2109_))))))
  (define std/srfi/43#vector-append
    (lambda _vectors2099_
      (std/srfi/43#vector-concatenate:aux
       _vectors2099_
       std/srfi/43#vector-append)))
  (define std/srfi/43#vector-concatenate
    (lambda (_vector-list2097_)
      (std/srfi/43#vector-concatenate:aux
       _vector-list2097_
       std/srfi/43#vector-concatenate)))
  (define std/srfi/43#vector-concatenate:aux
    (letrec ((_compute-length2067_
              (lambda (_vectors2070_ _len2071_ _callee2072_)
                (if (null? _vectors2070_)
                    _len2071_
                    (let ((_vec2074_
                           (std/srfi/43#check-type
                            vector?
                            (car _vectors2070_)
                            _callee2072_)))
                      (_compute-length2067_
                       (cdr _vectors2070_)
                       (+ (vector-length _vec2074_) _len2071_)
                       _callee2072_)))))
             (_concatenate!2068_
              (lambda (_vectors2076_ _target2077_ _to2078_)
                (if (null? _vectors2076_)
                    _target2077_
                    (let* ((_vec12080_ (car _vectors2076_))
                           (_len2082_ (vector-length _vec12080_)))
                      (std/srfi/43#%vector-copy!
                       _target2077_
                       _to2078_
                       _vec12080_
                       '0
                       _len2082_)
                      (_concatenate!2068_
                       (cdr _vectors2076_)
                       _target2077_
                       (+ _to2078_ _len2082_)))))))
      (lambda (_vectors2085_ _callee2086_)
        (if (null? _vectors2085_)
            (make-vector '0)
            (if (null? (cdr _vectors2085_))
                (let* ((_vec2088_
                        (std/srfi/43#check-type
                         vector?
                         (car _vectors2085_)
                         _callee2086_))
                       (_len2090_ (vector-length _vec2088_))
                       (_new2092_ (make-vector _len2090_)))
                  (std/srfi/43#%vector-copy!
                   _new2092_
                   '0
                   _vec2088_
                   '0
                   _len2090_)
                  _new2092_)
                (let ((_new-vector2095_
                       (make-vector
                        (_compute-length2067_ _vectors2085_ '0 _callee2086_))))
                  (_concatenate!2068_ _vectors2085_ _new-vector2095_ '0)
                  _new-vector2095_))))))
  (define std/srfi/43#vector-empty?
    (lambda (_vec2063_)
      (let ((_vec2065_
             (std/srfi/43#check-type
              vector?
              _vec2063_
              std/srfi/43#vector-empty?)))
        (zero? (vector-length _vec2065_)))))
  (define std/srfi/43#vector=
    (lambda (_elt=?2048_ . _vectors2049_)
      (let ((_elt=?2051_
             (std/srfi/43#check-type
              procedure?
              _elt=?2048_
              std/srfi/43#vector=)))
        (if (null? _vectors2049_)
            '#t
            (if (null? (cdr _vectors2049_))
                (begin
                  (std/srfi/43#check-type
                   vector?
                   (car _vectors2049_)
                   std/srfi/43#vector=)
                  '#t)
                (let _loop2053_ ((_vecs2055_ _vectors2049_))
                  (let ((_vec12057_
                         (std/srfi/43#check-type
                          vector?
                          (car _vecs2055_)
                          std/srfi/43#vector=))
                        (_vec2+2058_ (cdr _vecs2055_)))
                    (let ((_$e2060_ (null? _vec2+2058_)))
                      (if _$e2060_
                          _$e2060_
                          (if (std/srfi/43#binary-vector=
                               _elt=?2051_
                               _vec12057_
                               (car _vec2+2058_))
                              (_loop2053_ _vec2+2058_)
                              '#f))))))))))
  (define std/srfi/43#binary-vector=
    (lambda (_elt=?2023_ _vector-a2024_ _vector-b2025_)
      (let ((_$e2027_ (eq? _vector-a2024_ _vector-b2025_)))
        (if _$e2027_
            _$e2027_
            (let ((_length-a2030_ (vector-length _vector-a2024_))
                  (_length-b2031_ (vector-length _vector-b2025_)))
              (letrec ((_loop2033_
                        (lambda (_i2036_)
                          (let ((_$e2038_ (= _i2036_ _length-a2030_)))
                            (if _$e2038_
                                _$e2038_
                                (if (< _i2036_ _length-b2031_)
                                    (_test2034_
                                     (vector-ref _vector-a2024_ _i2036_)
                                     (vector-ref _vector-b2025_ _i2036_)
                                     _i2036_)
                                    '#f)))))
                       (_test2034_
                        (lambda (_elt-a2041_ _elt-b2042_ _i2043_)
                          (if (or (eq? _elt-a2041_ _elt-b2042_)
                                  (_elt=?2023_ _elt-a2041_ _elt-b2042_))
                              (_loop2033_ (+ _i2043_ '1))
                              '#f))))
                (if (= _length-a2030_ _length-b2031_)
                    (_loop2033_ '0)
                    '#f)))))))
  (define std/srfi/43#vector-fold
    (lambda (_kons2015_ _knil2016_ _vec2017_ . _vectors2018_)
      (let ((_kons2020_
             (std/srfi/43#check-type
              procedure?
              _kons2015_
              std/srfi/43#vector-fold))
            (_vec2021_
             (std/srfi/43#check-type
              vector?
              _vec2017_
              std/srfi/43#vector-fold)))
        (if (null? _vectors2018_)
            (std/srfi/43#%vector-fold1
             _kons2020_
             _knil2016_
             (vector-length _vec2021_)
             _vec2021_)
            (std/srfi/43#%vector-fold2+
             _kons2020_
             _knil2016_
             (std/srfi/43#%smallest-length
              _vectors2018_
              (vector-length _vec2021_)
              std/srfi/43#vector-fold)
             (cons _vec2021_ _vectors2018_))))))
  (define std/srfi/43#vector-fold-right
    (letrec ((_loop11994_
              (lambda (_kons1997_ _knil1998_ _vec1999_ _i2000_)
                (if (negative? _i2000_)
                    _knil1998_
                    (_loop11994_
                     _kons1997_
                     (_kons1997_
                      _i2000_
                      _knil1998_
                      (vector-ref _vec1999_ _i2000_))
                     _vec1999_
                     (- _i2000_ '1)))))
             (_loop2+1995_
              (lambda (_kons2002_ _knil2003_ _vectors2004_ _i2005_)
                (if (negative? _i2005_)
                    _knil2003_
                    (_loop2+1995_
                     _kons2002_
                     (apply _kons2002_
                            _i2005_
                            _knil2003_
                            (std/srfi/43#vectors-ref _vectors2004_ _i2005_))
                     _vectors2004_
                     (- _i2005_ '1))))))
      (lambda (_kons2007_ _knil2008_ _vec2009_ . _vectors2010_)
        (let ((_kons2012_
               (std/srfi/43#check-type
                procedure?
                _kons2007_
                std/srfi/43#vector-fold-right))
              (_vec2013_
               (std/srfi/43#check-type
                vector?
                _vec2009_
                std/srfi/43#vector-fold-right)))
          (if (null? _vectors2010_)
              (_loop11994_
               _kons2012_
               _knil2008_
               _vec2013_
               (- (vector-length _vec2013_) '1))
              (_loop2+1995_
               _kons2012_
               _knil2008_
               (cons _vec2013_ _vectors2010_)
               (- (std/srfi/43#%smallest-length
                   _vectors2010_
                   (vector-length _vec2013_)
                   std/srfi/43#vector-fold-right)
                  '1)))))))
  (define std/srfi/43#vector-map
    (lambda (_f1983_ _vec1984_ . _vectors1985_)
      (let ((_f1987_ (std/srfi/43#check-type
                      procedure?
                      _f1983_
                      std/srfi/43#vector-map))
            (_vec1988_
             (std/srfi/43#check-type
              vector?
              _vec1984_
              std/srfi/43#vector-map)))
        (if (null? _vectors1985_)
            (let ((_len1990_ (vector-length _vec1988_)))
              (std/srfi/43#%vector-map1!
               _f1987_
               (make-vector _len1990_)
               _vec1988_
               _len1990_))
            (let ((_len1992_
                   (std/srfi/43#%smallest-length
                    _vectors1985_
                    (vector-length _vec1988_)
                    std/srfi/43#vector-map)))
              (std/srfi/43#%vector-map2+!
               _f1987_
               (make-vector _len1992_)
               (cons _vec1988_ _vectors1985_)
               _len1992_))))))
  (define std/srfi/43#vector-map!
    (lambda (_f1976_ _vec1977_ . _vectors1978_)
      (let ((_f1980_ (std/srfi/43#check-type
                      procedure?
                      _f1976_
                      std/srfi/43#vector-map!))
            (_vec1981_
             (std/srfi/43#check-type
              vector?
              _vec1977_
              std/srfi/43#vector-map!)))
        (if (null? _vectors1978_)
            (std/srfi/43#%vector-map1!
             _f1980_
             _vec1981_
             _vec1981_
             (vector-length _vec1981_))
            (std/srfi/43#%vector-map2+!
             _f1980_
             _vec1981_
             (cons _vec1981_ _vectors1978_)
             (std/srfi/43#%smallest-length
              _vectors1978_
              (vector-length _vec1981_)
              std/srfi/43#vector-map!)))
        (std/srfi/43#unspecified-value))))
  (define std/srfi/43#vector-for-each
    (letrec ((_for-each11956_
              (lambda (_f1959_ _vec1960_ _i1961_ _len1962_)
                (if (< _i1961_ _len1962_)
                    (begin
                      (_f1959_ _i1961_ (vector-ref _vec1960_ _i1961_))
                      (_for-each11956_
                       _f1959_
                       _vec1960_
                       (+ _i1961_ '1)
                       _len1962_))
                    '#!void)))
             (_for-each2+1957_
              (lambda (_f1964_ _vecs1965_ _i1966_ _len1967_)
                (if (< _i1966_ _len1967_)
                    (begin
                      (apply _f1964_
                             _i1966_
                             (std/srfi/43#vectors-ref _vecs1965_ _i1966_))
                      (_for-each2+1957_
                       _f1964_
                       _vecs1965_
                       (+ _i1966_ '1)
                       _len1967_))
                    '#!void))))
      (lambda (_f1969_ _vec1970_ . _vectors1971_)
        (let ((_f1973_ (std/srfi/43#check-type
                        procedure?
                        _f1969_
                        std/srfi/43#vector-for-each))
              (_vec1974_
               (std/srfi/43#check-type
                vector?
                _vec1970_
                std/srfi/43#vector-for-each)))
          (if (null? _vectors1971_)
              (_for-each11956_ _f1973_ _vec1974_ '0 (vector-length _vec1974_))
              (_for-each2+1957_
               _f1973_
               (cons _vec1974_ _vectors1971_)
               '0
               (std/srfi/43#%smallest-length
                _vectors1971_
                (vector-length _vec1974_)
                std/srfi/43#vector-for-each)))))))
  (define std/srfi/43#vector-count
    (lambda (_pred?1941_ _vec1942_ . _vectors1943_)
      (let ((_pred?1945_
             (std/srfi/43#check-type
              procedure?
              _pred?1941_
              std/srfi/43#vector-count))
            (_vec1946_
             (std/srfi/43#check-type
              vector?
              _vec1942_
              std/srfi/43#vector-count)))
        (if (null? _vectors1943_)
            (std/srfi/43#%vector-fold1
             (lambda (_index1948_ _count1949_ _elt1950_)
               (if (_pred?1945_ _index1948_ _elt1950_)
                   (+ _count1949_ '1)
                   _count1949_))
             '0
             (vector-length _vec1946_)
             _vec1946_)
            (std/srfi/43#%vector-fold2+
             (lambda (_index1952_ _count1953_ . _elts1954_)
               (if (apply _pred?1945_ _index1952_ _elts1954_)
                   (+ _count1953_ '1)
                   _count1953_))
             '0
             (std/srfi/43#%smallest-length
              _vectors1943_
              (vector-length _vec1946_)
              std/srfi/43#vector-count)
             (cons _vec1946_ _vectors1943_))))))
  (define std/srfi/43#vector-index
    (lambda (_pred?1937_ _vec1938_ . _vectors1939_)
      (std/srfi/43#vector-index/skip
       _pred?1937_
       _vec1938_
       _vectors1939_
       std/srfi/43#vector-index)))
  (define std/srfi/43#vector-skip
    (lambda (_pred?1931_ _vec1932_ . _vectors1933_)
      (std/srfi/43#vector-index/skip
       (lambda _elts1935_ (not (apply _pred?1931_ _elts1935_)))
       _vec1932_
       _vectors1933_
       std/srfi/43#vector-skip)))
  (define std/srfi/43#vector-index/skip
    (letrec ((_loop11910_
              (lambda (_pred?1913_ _vec1914_ _len1915_ _i1916_)
                (if (= _i1916_ _len1915_)
                    '#f
                    (if (_pred?1913_ (vector-ref _vec1914_ _i1916_))
                        _i1916_
                        (_loop11910_
                         _pred?1913_
                         _vec1914_
                         _len1915_
                         (+ _i1916_ '1))))))
             (_loop2+1911_
              (lambda (_pred?1918_ _vectors1919_ _len1920_ _i1921_)
                (if (= _i1921_ _len1920_)
                    '#f
                    (if (apply _pred?1918_
                               (std/srfi/43#vectors-ref _vectors1919_ _i1921_))
                        _i1921_
                        (_loop2+1911_
                         _pred?1918_
                         _vectors1919_
                         _len1920_
                         (+ _i1921_ '1)))))))
      (lambda (_pred?1923_ _vec1924_ _vectors1925_ _callee1926_)
        (let ((_pred?1928_
               (std/srfi/43#check-type procedure? _pred?1923_ _callee1926_))
              (_vec1929_
               (std/srfi/43#check-type vector? _vec1924_ _callee1926_)))
          (if (null? _vectors1925_)
              (_loop11910_ _pred?1928_ _vec1929_ (vector-length _vec1929_) '0)
              (_loop2+1911_
               _pred?1928_
               (cons _vec1929_ _vectors1925_)
               (std/srfi/43#%smallest-length
                _vectors1925_
                (vector-length _vec1929_)
                _callee1926_)
               '0))))))
  (define std/srfi/43#vector-index-right
    (lambda (_pred?1906_ _vec1907_ . _vectors1908_)
      (std/srfi/43#vector-index/skip-right
       _pred?1906_
       _vec1907_
       _vectors1908_
       std/srfi/43#vector-index-right)))
  (define std/srfi/43#vector-skip-right
    (lambda (_pred?1900_ _vec1901_ . _vectors1902_)
      (std/srfi/43#vector-index/skip-right
       (lambda _elts1904_ (not (apply _pred?1900_ _elts1904_)))
       _vec1901_
       _vectors1902_
       std/srfi/43#vector-index-right)))
  (define std/srfi/43#vector-index/skip-right
    (letrec ((_loop11881_
              (lambda (_pred?1884_ _vec1885_ _i1886_)
                (if (negative? _i1886_)
                    '#f
                    (if (_pred?1884_ (vector-ref _vec1885_ _i1886_))
                        _i1886_
                        (_loop11881_ _pred?1884_ _vec1885_ (- _i1886_ '1))))))
             (_loop2+1882_
              (lambda (_pred?1888_ _vectors1889_ _i1890_)
                (if (negative? _i1890_)
                    '#f
                    (if (apply _pred?1888_
                               (std/srfi/43#vectors-ref _vectors1889_ _i1890_))
                        _i1890_
                        (_loop2+1882_
                         _pred?1888_
                         _vectors1889_
                         (- _i1890_ '1)))))))
      (lambda (_pred?1892_ _vec1893_ _vectors1894_ _callee1895_)
        (let ((_pred?1897_
               (std/srfi/43#check-type procedure? _pred?1892_ _callee1895_))
              (_vec1898_
               (std/srfi/43#check-type vector? _vec1893_ _callee1895_)))
          (if (null? _vectors1894_)
              (_loop11881_
               _pred?1897_
               _vec1898_
               (- (vector-length _vec1898_) '1))
              (_loop2+1882_
               _pred?1897_
               (cons _vec1898_ _vectors1894_)
               (- (std/srfi/43#%smallest-length
                   _vectors1894_
                   (vector-length _vec1898_)
                   _callee1895_)
                  '1)))))))
  (define std/srfi/43#vector-binary-search
    (lambda (_vec1856_ _value1857_ _cmp1858_ . _maybe-start+end1859_)
      (let* ((_cmp1861_
              (std/srfi/43#check-type
               procedure?
               _cmp1858_
               std/srfi/43#vector-binary-search))
             (_vec1863_
              (std/srfi/43#check-type
               vector?
               _vec1856_
               std/srfi/43#vector-binary-search))
             (_g6145_ (std/srfi/43#vector-parse-start+end
                       _vec1863_
                       _maybe-start+end1859_
                       'start
                       'end
                       std/srfi/43#vector-binary-search)))
        (begin
          (let ((_g6146_ (let ()
                           (declare (not safe))
                           (if (##values? _g6145_)
                               (##vector-length _g6145_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6146_ 2)))
                (error "Context expects 2 values" _g6146_)))
          (let ((_start1865_
                 (let () (declare (not safe)) (##vector-ref _g6145_ 0)))
                (_end1866_
                 (let () (declare (not safe)) (##vector-ref _g6145_ 1))))
            (let _loop1868_ ((_start1870_ _start1865_)
                             (_end1871_ _end1866_)
                             (_j1872_ '#f))
              (let ((_i1874_ (quotient (+ _start1870_ _end1871_) '2)))
                (if (or (= _start1870_ _end1871_)
                        (and _j1872_ (= _i1874_ _j1872_)))
                    '#f
                    (let ((_comparison1879_
                           (std/srfi/43#check-type
                            integer?
                            (_cmp1861_
                             (vector-ref _vec1863_ _i1874_)
                             _value1857_)
                            (cons _cmp1861_
                                  (cons 'for
                                        (cons std/srfi/43#vector-binary-search
                                              '()))))))
                      (if (zero? _comparison1879_)
                          _i1874_
                          (if (positive? _comparison1879_)
                              (_loop1868_ _start1870_ _i1874_ _i1874_)
                              (_loop1868_ _i1874_ _end1871_ _i1874_))))))))))))
  (define std/srfi/43#vector-any
    (letrec ((_loop11824_
              (lambda (_pred?1827_ _vec1828_ _i1829_ _len1830_ _len-11831_)
                (if (not (= _i1829_ _len1830_))
                    (if (= _i1829_ _len-11831_)
                        (_pred?1827_ (vector-ref _vec1828_ _i1829_))
                        (let ((_$e1833_
                               (_pred?1827_ (vector-ref _vec1828_ _i1829_))))
                          (if _$e1833_
                              _$e1833_
                              (_loop11824_
                               _pred?1827_
                               _vec1828_
                               (+ _i1829_ '1)
                               _len1830_
                               _len-11831_))))
                    '#f)))
             (_loop2+1825_
              (lambda (_pred?1836_ _vectors1837_ _i1838_ _len1839_ _len-11840_)
                (if (not (= _i1838_ _len1839_))
                    (if (= _i1838_ _len-11840_)
                        (apply _pred?1836_
                               (std/srfi/43#vectors-ref _vectors1837_ _i1838_))
                        (let ((_$e1842_
                               (apply _pred?1836_
                                      (std/srfi/43#vectors-ref
                                       _vectors1837_
                                       _i1838_))))
                          (if _$e1842_
                              _$e1842_
                              (_loop2+1825_
                               _pred?1836_
                               _vectors1837_
                               (+ _i1838_ '1)
                               _len1839_
                               _len-11840_))))
                    '#f))))
      (lambda (_pred?1845_ _vec1846_ . _vectors1847_)
        (let ((_pred?1849_
               (std/srfi/43#check-type
                procedure?
                _pred?1845_
                std/srfi/43#vector-any))
              (_vec1850_
               (std/srfi/43#check-type
                vector?
                _vec1846_
                std/srfi/43#vector-any)))
          (if (null? _vectors1847_)
              (let ((_len1852_ (vector-length _vec1850_)))
                (_loop11824_
                 _pred?1849_
                 _vec1850_
                 '0
                 _len1852_
                 (- _len1852_ '1)))
              (let ((_len1854_
                     (std/srfi/43#%smallest-length
                      _vectors1847_
                      (vector-length _vec1850_)
                      std/srfi/43#vector-any)))
                (_loop2+1825_
                 _pred?1849_
                 (cons _vec1850_ _vectors1847_)
                 '0
                 _len1854_
                 (- _len1854_ '1))))))))
  (define std/srfi/43#vector-every
    (letrec ((_loop11792_
              (lambda (_pred?1795_ _vec1796_ _i1797_ _len1798_ _len-11799_)
                (let ((_$e1801_ (= _i1797_ _len1798_)))
                  (if _$e1801_
                      _$e1801_
                      (if (= _i1797_ _len-11799_)
                          (_pred?1795_ (vector-ref _vec1796_ _i1797_))
                          (if (_pred?1795_ (vector-ref _vec1796_ _i1797_))
                              (_loop11792_
                               _pred?1795_
                               _vec1796_
                               (+ _i1797_ '1)
                               _len1798_
                               _len-11799_)
                              '#f))))))
             (_loop2+1793_
              (lambda (_pred?1804_ _vectors1805_ _i1806_ _len1807_ _len-11808_)
                (let ((_$e1810_ (= _i1806_ _len1807_)))
                  (if _$e1810_
                      _$e1810_
                      (if (= _i1806_ _len-11808_)
                          (apply _pred?1804_
                                 (std/srfi/43#vectors-ref
                                  _vectors1805_
                                  _i1806_))
                          (if (apply _pred?1804_
                                     (std/srfi/43#vectors-ref
                                      _vectors1805_
                                      _i1806_))
                              (_loop2+1793_
                               _pred?1804_
                               _vectors1805_
                               (+ _i1806_ '1)
                               _len1807_
                               _len-11808_)
                              '#f)))))))
      (lambda (_pred?1813_ _vec1814_ . _vectors1815_)
        (let ((_pred?1817_
               (std/srfi/43#check-type
                procedure?
                _pred?1813_
                std/srfi/43#vector-every))
              (_vec1818_
               (std/srfi/43#check-type
                vector?
                _vec1814_
                std/srfi/43#vector-every)))
          (if (null? _vectors1815_)
              (let ((_len1820_ (vector-length _vec1818_)))
                (_loop11792_
                 _pred?1817_
                 _vec1818_
                 '0
                 _len1820_
                 (- _len1820_ '1)))
              (let ((_len1822_
                     (std/srfi/43#%smallest-length
                      _vectors1815_
                      (vector-length _vec1818_)
                      std/srfi/43#vector-every)))
                (_loop2+1793_
                 _pred?1817_
                 (cons _vec1818_ _vectors1815_)
                 '0
                 _len1822_
                 (- _len1822_ '1))))))))
  (define std/srfi/43#vector-swap!
    (lambda (_vec1781_ _i1782_ _j1783_)
      (let ((_vec1785_
             (std/srfi/43#check-type
              vector?
              _vec1781_
              std/srfi/43#vector-swap!)))
        (let ((_i1787_ (std/srfi/43#check-index
                        _vec1785_
                        _i1782_
                        std/srfi/43#vector-swap!))
              (_j1788_ (std/srfi/43#check-index
                        _vec1785_
                        _j1783_
                        std/srfi/43#vector-swap!)))
          (let ((_x1790_ (vector-ref _vec1785_ _i1787_)))
            (vector-set! _vec1785_ _i1787_ (vector-ref _vec1785_ _j1788_))
            (vector-set! _vec1785_ _j1788_ _x1790_))))))
  (define std/srfi/43#%%vector-fill!
    (let ((_%vector-fill!1765_ vector-fill!))
      (lambda (_vec1767_ _value1768_ . _maybe-start+end1769_)
        (if (null? _maybe-start+end1769_)
            (_%vector-fill!1765_ _vec1767_ _value1768_)
            (let* ((_vec1771_
                    (std/srfi/43#check-type vector? _vec1767_ vector-fill!))
                   (_g6147_ (std/srfi/43#vector-parse-start+end
                             _vec1771_
                             _maybe-start+end1769_
                             'start
                             'end
                             vector-fill!)))
              (begin
                (let ((_g6148_ (let ()
                                 (declare (not safe))
                                 (if (##values? _g6147_)
                                     (##vector-length _g6147_)
                                     1))))
                  (if (not (let () (declare (not safe)) (##fx= _g6148_ 2)))
                      (error "Context expects 2 values" _g6148_)))
                (let ((_start1773_
                       (let () (declare (not safe)) (##vector-ref _g6147_ 0)))
                      (_end1774_
                       (let () (declare (not safe)) (##vector-ref _g6147_ 1))))
                  (let _$loop1776_ ((_i1779_ _start1773_))
                    (if (= _i1779_ _end1774_)
                        '#!void
                        (begin
                          (vector-set! _vec1771_ _i1779_ _value1768_)
                          (_$loop1776_ (+ _i1779_ '1))))))))))))
  (define std/srfi/43#vector-copy!
    (lambda (_target1748_ _tstart1749_ _source1750_ . _maybe-sstart+send1751_)
      (letrec ((_doit!1753_
                (lambda (_sstart1757_ _send1758_ _source-length1759_)
                  (let ((_tstart1761_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _tstart1749_
                          std/srfi/43#vector-copy!))
                        (_sstart1762_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _sstart1757_
                          std/srfi/43#vector-copy!))
                        (_send1763_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _send1758_
                          std/srfi/43#vector-copy!)))
                    (if (and (<= '0
                                 _sstart1762_
                                 _send1763_
                                 _source-length1759_)
                             (<= (+ _tstart1761_ (- _send1763_ _sstart1762_))
                                 (vector-length _target1748_)))
                        (std/srfi/43#%vector-copy!
                         _target1748_
                         _tstart1761_
                         _source1750_
                         _sstart1762_
                         _send1763_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/43#vector-copy!
                                                 '())))
                               (cons 'target
                                     (cons 'was (cons _target1748_ '())))
                               (cons 'target-length
                                     (cons 'was
                                           (cons (vector-length _target1748_)
                                                 '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart1761_ '())))
                               (cons 'source
                                     (cons 'was (cons _source1750_ '())))
                               (cons 'source-length
                                     (cons 'was
                                           (cons _source-length1759_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart1762_ '())))
                               (cons 'send
                                     (cons 'was (cons _send1763_ '())))))))))
        (let ((_n1755_ (vector-length _source1750_)))
          (if (null? _maybe-sstart+send1751_)
              (_doit!1753_ '0 _n1755_ _n1755_)
              (if (null? (cdr _maybe-sstart+send1751_))
                  (_doit!1753_ (car _maybe-sstart+send1751_) _n1755_ _n1755_)
                  (if (null? (cddr _maybe-sstart+send1751_))
                      (_doit!1753_
                       (car _maybe-sstart+send1751_)
                       (cadr _maybe-sstart+send1751_)
                       _n1755_)
                      (error '"too many arguments"
                             std/srfi/43#vector-copy!
                             (cddr _maybe-sstart+send1751_)))))))))
  (define std/srfi/43#vector-reverse-copy!
    (lambda (_target1728_ _tstart1729_ _source1730_ . _maybe-sstart+send1731_)
      (letrec ((_doit!1733_
                (lambda (_sstart1737_ _send1738_ _source-length1739_)
                  (let ((_tstart1741_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _tstart1729_
                          std/srfi/43#vector-reverse-copy!))
                        (_sstart1742_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _sstart1737_
                          std/srfi/43#vector-reverse-copy!))
                        (_send1743_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _send1738_
                          std/srfi/43#vector-reverse-copy!)))
                    (if (and (eq? _target1728_ _source1730_)
                             (or (std/srfi/43#between?
                                  _sstart1742_
                                  _tstart1741_
                                  _send1743_)
                                 (std/srfi/43#between?
                                  _tstart1741_
                                  _sstart1742_
                                  (+ _tstart1741_
                                     (- _send1743_ _sstart1742_)))))
                        (error '"vector range for self-copying overlaps"
                               std/srfi/43#vector-reverse-copy!
                               (cons 'vector
                                     (cons 'was (cons _target1728_ '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart1741_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart1742_ '())))
                               (cons 'send (cons 'was (cons _send1743_ '()))))
                        (if (and (<= '0
                                     _sstart1742_
                                     _send1743_
                                     _source-length1739_)
                                 (<= (+ _tstart1741_
                                        (- _send1743_ _sstart1742_))
                                     (vector-length _target1728_)))
                            (std/srfi/43#%vector-reverse-copy!
                             _target1728_
                             _tstart1741_
                             _source1730_
                             _sstart1742_
                             _send1743_)
                            (error '"illegal arguments"
                                   (cons 'while
                                         (cons 'calling
                                               (cons std/srfi/43#vector-reverse-copy!
                                                     '())))
                                   (cons 'target
                                         (cons 'was (cons _target1728_ '())))
                                   (cons 'target-length
                                         (cons 'was
                                               (cons (vector-length
                                                      _target1728_)
                                                     '())))
                                   (cons 'tstart
                                         (cons 'was (cons _tstart1741_ '())))
                                   (cons 'source
                                         (cons 'was (cons _source1730_ '())))
                                   (cons 'source-length
                                         (cons 'was
                                               (cons _source-length1739_ '())))
                                   (cons 'sstart
                                         (cons 'was (cons _sstart1742_ '())))
                                   (cons 'send
                                         (cons 'was
                                               (cons _send1743_ '()))))))))))
        (let ((_n1735_ (vector-length _source1730_)))
          (if (null? _maybe-sstart+send1731_)
              (_doit!1733_ '0 _n1735_ _n1735_)
              (if (null? (cdr _maybe-sstart+send1731_))
                  (_doit!1733_ (car _maybe-sstart+send1731_) _n1735_ _n1735_)
                  (if (null? (cddr _maybe-sstart+send1731_))
                      (_doit!1733_
                       (car _maybe-sstart+send1731_)
                       (cadr _maybe-sstart+send1731_)
                       _n1735_)
                      (error '"too many arguments"
                             std/srfi/43#vector-reverse-copy!
                             (cddr _maybe-sstart+send1731_)))))))))
  (define std/srfi/43#vector-reverse!
    (lambda (_vec1720_ . _start+end1721_)
      (let* ((_vec1723_
              (std/srfi/43#check-type
               vector?
               _vec1720_
               std/srfi/43#vector-reverse!))
             (_g6149_ (std/srfi/43#vector-parse-start+end
                       _vec1723_
                       _start+end1721_
                       'start
                       'end
                       std/srfi/43#vector-reverse!)))
        (begin
          (let ((_g6150_ (let ()
                           (declare (not safe))
                           (if (##values? _g6149_)
                               (##vector-length _g6149_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6150_ 2)))
                (error "Context expects 2 values" _g6150_)))
          (let ((_start1725_
                 (let () (declare (not safe)) (##vector-ref _g6149_ 0)))
                (_end1726_
                 (let () (declare (not safe)) (##vector-ref _g6149_ 1))))
            (std/srfi/43#%vector-reverse! _vec1723_ _start1725_ _end1726_))))))
  (define std/srfi/43#%%vector->list
    (let ((_%vector->list1704_ vector->list))
      (lambda (_vec1706_ . _maybe-start+end1707_)
        (if (null? _maybe-start+end1707_)
            (_%vector->list1704_ _vec1706_)
            (let* ((_vec1709_
                    (std/srfi/43#check-type vector? _vec1706_ vector->list))
                   (_g6151_ (std/srfi/43#vector-parse-start+end
                             _vec1709_
                             _maybe-start+end1707_
                             'start
                             'end
                             vector->list)))
              (begin
                (let ((_g6152_ (let ()
                                 (declare (not safe))
                                 (if (##values? _g6151_)
                                     (##vector-length _g6151_)
                                     1))))
                  (if (not (let () (declare (not safe)) (##fx= _g6152_ 2)))
                      (error "Context expects 2 values" _g6152_)))
                (let ((_start1711_
                       (let () (declare (not safe)) (##vector-ref _g6151_ 0)))
                      (_end1712_
                       (let () (declare (not safe)) (##vector-ref _g6151_ 1))))
                  (let _$loop1714_ ((_i1717_ (- _end1712_ '1))
                                    (_result1718_ '()))
                    (if (< _i1717_ _start1711_)
                        _result1718_
                        (_$loop1714_
                         (- _i1717_ '1)
                         (cons (vector-ref _vec1709_ _i1717_)
                               _result1718_)))))))))))
  (define std/srfi/43#reverse-vector->list
    (lambda (_vec1690_ . _maybe-start+end1691_)
      (let* ((_vec1693_
              (std/srfi/43#check-type
               vector?
               _vec1690_
               std/srfi/43#reverse-vector->list))
             (_g6153_ (std/srfi/43#vector-parse-start+end
                       _vec1693_
                       _maybe-start+end1691_
                       'start
                       'end
                       std/srfi/43#reverse-vector->list)))
        (begin
          (let ((_g6154_ (let ()
                           (declare (not safe))
                           (if (##values? _g6153_)
                               (##vector-length _g6153_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g6154_ 2)))
                (error "Context expects 2 values" _g6154_)))
          (let ((_start1695_
                 (let () (declare (not safe)) (##vector-ref _g6153_ 0)))
                (_end1696_
                 (let () (declare (not safe)) (##vector-ref _g6153_ 1))))
            (let _$loop1698_ ((_i1701_ _start1695_) (_result1702_ '()))
              (if (= _i1701_ _end1696_)
                  _result1702_
                  (_$loop1698_
                   (+ _i1701_ '1)
                   (cons (vector-ref _vec1693_ _i1701_) _result1702_)))))))))
  (define std/srfi/43#%%list->vector
    (let ((_%list->vector1644_ list->vector))
      (lambda (_lst1646_ . _maybe-start+end1647_)
        (if (null? _maybe-start+end1647_)
            (_%list->vector1644_ _lst1646_)
            (if (null? _maybe-start+end1647_)
                (let* ((_start1649_ '0) (_end1651_ (length _lst1646_)))
                  (let ((_start1654_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start1649_
                          list->vector))
                        (_end1655_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end1651_
                          list->vector)))
                    ((lambda (_f1657_)
                       (std/srfi/43#vector-unfold
                        _f1657_
                        (- _end1655_ _start1654_)
                        (list-tail _lst1646_ _start1654_)))
                     (lambda (_index1659_ _l1660_)
                       (if (null? _l1660_)
                           (error '"list was too short"
                                  (cons 'list (cons 'was (cons _lst1646_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end1655_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/43#%%list->vector
                                                    '()))))
                           (if (pair? _l1660_)
                               (values (car _l1660_) (cdr _l1660_))
                               (error '"erroneous value"
                                      (list list? _lst1646_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/43#%%list->vector
                                                        '()))))))))))
                (let ((_start1662_ (car _maybe-start+end1647_))
                      (_new-args1663_ (cdr _maybe-start+end1647_)))
                  (if (null? _new-args1663_)
                      (let ((_end1666_ (length _lst1646_)))
                        (let ((_start1669_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _start1662_
                                list->vector))
                              (_end1670_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _end1666_
                                list->vector)))
                          ((lambda (_f1672_)
                             (std/srfi/43#vector-unfold
                              _f1672_
                              (- _end1670_ _start1669_)
                              (list-tail _lst1646_ _start1669_)))
                           (lambda (_index1674_ _l1675_)
                             (if (null? _l1675_)
                                 (error '"list was too short"
                                        (cons 'list
                                              (cons 'was (cons _lst1646_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end1670_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/43#%%list->vector
                                                          '()))))
                                 (if (pair? _l1675_)
                                     (values (car _l1675_) (cdr _l1675_))
                                     (error '"erroneous value"
                                            (list list? _lst1646_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/43#%%list->vector
                                                              '()))))))))))
                      (let ((_end1677_ (car _new-args1663_))
                            (_new-args1678_ (cdr _new-args1663_)))
                        (if (null? _new-args1678_)
                            (let ()
                              (let ((_start1682_
                                     (std/srfi/43#check-type
                                      std/srfi/43#nonneg-int?
                                      _start1662_
                                      list->vector))
                                    (_end1683_
                                     (std/srfi/43#check-type
                                      std/srfi/43#nonneg-int?
                                      _end1677_
                                      list->vector)))
                                ((lambda (_f1685_)
                                   (std/srfi/43#vector-unfold
                                    _f1685_
                                    (- _end1683_ _start1682_)
                                    (list-tail _lst1646_ _start1682_)))
                                 (lambda (_index1687_ _l1688_)
                                   (if (null? _l1688_)
                                       (error '"list was too short"
                                              (cons 'list
                                                    (cons 'was
                                                          (cons _lst1646_
                                                                '())))
                                              (cons 'attempted
                                                    (cons 'end
                                                          (cons 'was
                                                                (cons _end1683_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              '()))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (cons 'while
                                                    (cons 'calling
                                                          (cons std/srfi/43#%%list->vector
                                                                '()))))
                                       (if (pair? _l1688_)
                                           (values (car _l1688_) (cdr _l1688_))
                                           (error '"erroneous value"
                                                  (list list? _lst1646_)
                                                  (cons 'while
                                                        (cons 'calling
                                                              (cons std/srfi/43#%%list->vector
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            '()))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                            (error '"too many arguments"
                                   (length _maybe-start+end1647_)
                                   _maybe-start+end1647_))))))))))
  (define std/srfi/43#reverse-list->vector
    (lambda (_lst1600_ . _maybe-start+end1601_)
      (if (null? _maybe-start+end1601_)
          (let* ((_start1603_ '0) (_end1605_ (length _lst1600_)))
            (let ((_start1608_
                   (std/srfi/43#check-type
                    std/srfi/43#nonneg-int?
                    _start1603_
                    std/srfi/43#reverse-list->vector))
                  (_end1609_
                   (std/srfi/43#check-type
                    std/srfi/43#nonneg-int?
                    _end1605_
                    std/srfi/43#reverse-list->vector)))
              ((lambda (_f1611_)
                 (std/srfi/43#vector-unfold-right
                  _f1611_
                  (- _end1609_ _start1608_)
                  (list-tail _lst1600_ _start1608_)))
               (lambda (_index1613_ _l1614_)
                 (if (null? _l1614_)
                     (error '"list too short"
                            (cons 'list (cons 'was (cons _lst1600_ '())))
                            (cons 'attempted
                                  (cons 'end (cons 'was (cons _end1609_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/43#reverse-list->vector
                                              '()))))
                     (if (pair? _l1614_)
                         (values (car _l1614_) (cdr _l1614_))
                         (error '"erroneous value"
                                (list list? _lst1600_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/43#reverse-list->vector
                                                  '()))))))))))
          (let ((_start1616_ (car _maybe-start+end1601_))
                (_new-args1617_ (cdr _maybe-start+end1601_)))
            (if (null? _new-args1617_)
                (let ((_end1620_ (length _lst1600_)))
                  (let ((_start1623_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _start1616_
                          std/srfi/43#reverse-list->vector))
                        (_end1624_
                         (std/srfi/43#check-type
                          std/srfi/43#nonneg-int?
                          _end1620_
                          std/srfi/43#reverse-list->vector)))
                    ((lambda (_f1626_)
                       (std/srfi/43#vector-unfold-right
                        _f1626_
                        (- _end1624_ _start1623_)
                        (list-tail _lst1600_ _start1623_)))
                     (lambda (_index1628_ _l1629_)
                       (if (null? _l1629_)
                           (error '"list too short"
                                  (cons 'list (cons 'was (cons _lst1600_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end1624_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/43#reverse-list->vector
                                                    '()))))
                           (if (pair? _l1629_)
                               (values (car _l1629_) (cdr _l1629_))
                               (error '"erroneous value"
                                      (list list? _lst1600_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/43#reverse-list->vector
                                                        '()))))))))))
                (let ((_end1631_ (car _new-args1617_))
                      (_new-args1632_ (cdr _new-args1617_)))
                  (if (null? _new-args1632_)
                      (let ()
                        (let ((_start1636_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _start1616_
                                std/srfi/43#reverse-list->vector))
                              (_end1637_
                               (std/srfi/43#check-type
                                std/srfi/43#nonneg-int?
                                _end1631_
                                std/srfi/43#reverse-list->vector)))
                          ((lambda (_f1639_)
                             (std/srfi/43#vector-unfold-right
                              _f1639_
                              (- _end1637_ _start1636_)
                              (list-tail _lst1600_ _start1636_)))
                           (lambda (_index1641_ _l1642_)
                             (if (null? _l1642_)
                                 (error '"list too short"
                                        (cons 'list
                                              (cons 'was (cons _lst1600_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end1637_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/43#reverse-list->vector
                                                          '()))))
                                 (if (pair? _l1642_)
                                     (values (car _l1642_) (cdr _l1642_))
                                     (error '"erroneous value"
                                            (list list? _lst1600_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/43#reverse-list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end1601_)
                             _maybe-start+end1601_)))))))))
