(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define gerbil/tools/gxtags#main
    (lambda _args1322_
      (letrec* ((_gopt1324_
                 (std/getopt#getopt
                  (std/getopt#flag__%__0
                   '#f
                   '"append to existing tag file"
                   'append
                   '"-a")
                  (std/getopt#option__%__0
                   '#f
                   '"explicit name of file for tag table"
                   absent-value
                   '"TAGS"
                   'output
                   '"-o")
                  (std/getopt#flag__%__%
                   '#f
                   '"display help"
                   'help
                   '"-h"
                   '"--help")
                  (std/getopt#rest-arguments__%
                   '#f
                   '"source file or directory"
                   absent-value
                   'input)))
                (_help1325_
                 (lambda (_what1341_)
                   (std/getopt#getopt-display-help__0 _what1341_ '"gxtags"))))
        (with-exception-catcher
         (lambda (_g13261328_)
           (if ((lambda (_$obj1331_)
                  (let ()
                    (declare (not safe))
                    (##structure-instance-of?
                     _$obj1331_
                     'std/getopt#getopt-error::t)))
                _g13261328_)
               (let ((_exn1334_ _g13261328_)) (_help1325_ _exn1334_) (exit '1))
               (raise _g13261328_)))
         (lambda ()
           (let ((_opt1337_ (std/getopt#getopt-parse _gopt1324_ _args1322_)))
             (if (table-ref _opt1337_ 'help '#f)
                 (_help1325_ _gopt1324_)
                 (let ((_inputs1339_ (table-ref _opt1337_ 'input '#f)))
                   (if (null? _inputs1339_)
                       (begin (_help1325_ _gopt1324_) (exit '1))
                       (gerbil/tools/gxtags#run
                        (table-ref _opt1337_ 'input '#f)
                        (table-ref _opt1337_ 'output '#f)
                        (table-ref _opt1337_ 'append '#f)))))))))))
  (define gerbil/tools/gxtags#run
    (lambda (_inputs1318_ _tagfile1319_ _append?1320_)
      (_gx#load-expander!)
      (gerbil/tools/gxtags#make-tags__%
       _inputs1318_
       _tagfile1319_
       _append?1320_)))
  (define gerbil/tools/gxtags#current-tags-path (make-parameter '#f))
  (define gerbil/tools/gxtags#make-tags__%
    (lambda (_inputs1295_ _tagfile1296_ _append?1297_)
      (call-with-output-file
       (cons 'path:
             (cons _tagfile1296_ (cons 'append: (cons _append?1297_ '()))))
       (lambda (_output1299_)
         (call-with-parameters
          (lambda ()
            (for-each
             (lambda (_g13011303_)
               (gerbil/tools/gxtags#tag-input _g13011303_ _output1299_))
             _inputs1295_))
          gerbil/tools/gxtags#current-tags-path
          (path-normalize _tagfile1296_))))))
  (define gerbil/tools/gxtags#make-tags__0
    (lambda (_inputs1309_ _tagfile1310_)
      (let ((_append?1312_ '#f))
        (gerbil/tools/gxtags#make-tags__%
         _inputs1309_
         _tagfile1310_
         _append?1312_))))
  (define gerbil/tools/gxtags#make-tags
    (lambda _g5893_
      (let ((_g5892_ (let () (declare (not safe)) (##length _g5893_))))
        (cond ((let () (declare (not safe)) (##fx= _g5892_ 2))
               (apply gerbil/tools/gxtags#make-tags__0 _g5893_))
              ((let () (declare (not safe)) (##fx= _g5892_ 3))
               (apply gerbil/tools/gxtags#make-tags__% _g5893_))
              (else
               (##raise-wrong-number-of-arguments-exception
                gerbil/tools/gxtags#make-tags
                _g5893_))))))
  (define gerbil/tools/gxtags#file-directory?
    (lambda (_path1292_) (eq? (file-type _path1292_) 'directory)))
  (define gerbil/tools/gxtags#tag-input
    (lambda (_input1289_ _output1290_)
      (if (file-exists? _input1289_)
          (if (gerbil/tools/gxtags#file-directory? _input1289_)
              (gerbil/tools/gxtags#tag-directory _input1289_ _output1290_)
              (gerbil/tools/gxtags#tag-source-file _input1289_ _output1290_))
          (error '"No such file or directory" _input1289_))))
  (define gerbil/tools/gxtags#tag-directory
    (lambda (_dirname1277_ _output1278_)
      (let ((_files1280_
             (std/sort#sort (directory-files _dirname1277_) string<?)))
        (for-each
         (lambda (_file1282_)
           (let ((_path1284_ (path-expand _file1282_ _dirname1277_)))
             (if (or (gerbil/tools/gxtags#file-directory? _path1284_)
                     (member (path-extension _path1284_) '(".ss" ".ssi")))
                 (gerbil/tools/gxtags#tag-input _path1284_ _output1278_)
                 '#!void)))
         _files1280_))))
  (define gerbil/tools/gxtags#tag-source-file
    (lambda (_filename1259_ _output1260_)
      (let ((_$e1262_ (gerbil/tools/gxtags#try-import-module _filename1259_)))
        (if _$e1262_
            ((lambda (_ctx1265_)
               (displayln '"TAG " _filename1259_)
               (let ((_xtab1267_ (make-table 'test: eq?)))
                 (for-each
                  (lambda (_xport1269_)
                    (let ((_bind1271_
                           (gx#core-resolve-module-export _xport1269_)))
                      (hash-update!
                       _xtab1267_
                       (##structure-ref _bind1271_ '1 gx#binding::t '#f)
                       (lambda (_g12721274_)
                         (cons (##direct-structure-ref
                                _xport1269_
                                '4
                                gx#module-export::t
                                '#f)
                               _g12721274_))
                       '())))
                  (##structure-ref _ctx1265_ '9 gx#module-context::t '#f))
                 (gerbil/tools/gxtags#write-tags
                  (gerbil/tools/gxtags#module-tags _ctx1265_ _xtab1267_)
                  _filename1259_
                  _output1260_)))
             _$e1262_)
            (displayln '"SKIP " _filename1259_)))))
  (define gerbil/tools/gxtags#module-tags
    (lambda (_ctx511_ _xtab512_)
      (letrec* ((_tags514_ '())
                (_loc515_ '#f)
                (_tag!660_
                 (lambda (_eid1256_ _name1257_)
                   (set! _tags514_
                         (cons (cons _eid1256_
                                     (cons _name1257_ (cons _loc515_ '())))
                               _tags514_))))
                (_tag-e661_
                 (lambda (_stx770_)
                   (let* ((_K1247_ (lambda ()
                                     (let* ((___stx57395740_ _stx770_)
                                            (_g779870_
                                             (lambda ()
                                               (gx#raise-syntax-error
                                                '#f
                                                '"Bad syntax"
                                                ___stx57395740_))))
                                       (let ((___kont57415742_
                                              (lambda (_L1224_)
                                                (for-each
                                                 _tag-e661_
                                                 (foldr1 (lambda (_g12361239_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g12371241_)
                   (cons _g12361239_ _g12371241_))
                 '()
                 _L1224_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont57455746_
                                              (lambda (_L1166_)
                                                (call-with-parameters
                                                 (lambda ()
                                                   (for-each
                                                    _tag-e661_
                                                    (foldr1 (lambda (_g11791182_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             _g11801184_)
                      (cons _g11791182_ _g11801184_))
                    '()
                    _L1166_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 gx#current-expander-phi
                                                 (fx+ (gx#current-expander-phi)
                                                      '1))))
                                             (___kont57495750_
                                              (lambda (_L1105_)
                                                (for-each
                                                 _tag-def662_
                                                 (filter values
                                                         (foldr1 (lambda (_g11211124_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                  _g11221126_)
                           (cons _g11211124_ _g11221126_))
                         '()
                         _L1105_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont57535754_
                                              (lambda (_L1039_)
                                                (_tag-def662_ _L1039_)))
                                             (___kont57555756_
                                              (lambda (_L990_)
                                                (for-each
                                                 _tag-decl663_
                                                 (foldr1 (lambda (_g10021005_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g10031007_)
                   (cons _g10021005_ _g10031007_))
                 '()
                 _L990_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (___kont57595760_
                                              (lambda (_L922_ _L923_)
                                                (let ((_eid942_
                                                       (##structure-ref
                                                        (gx#resolve-identifier__0
                                                         _L923_)
                                                        '1
                                                        gx#binding::t
                                                        '#f))
                                                      (_ctx943_
                                                       (gx#syntax-local-e__0
                                                        _L923_)))
                                                  (call-with-parameters
                                                   (lambda ()
                                                     (_tag-name!664_ _eid942_)
                                                     (for-each
                                                      _tag-e661_
                                                      (foldr1 (lambda (_g945948_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               _g946950_)
                        (cons _g945948_ _g946950_))
                      '()
                      _L922_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   gx#current-expander-context
                                                   _ctx943_))))
                                             (___kont57635764_
                                              (lambda () '#!void)))
                                         (let* ((___match58905891_
                                                 (lambda (_e851882_
                                                          _hd852885_
                                                          _tl853887_
                                                          _e854890_
                                                          _hd855893_
                                                          _tl856895_
                                                          ___splice57615762_
                                                          _target857898_
                                                          _tl859900_)
                                                   (letrec ((_loop860903_
                                                             (lambda (_hd858906_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr864908_)
                       (if (gx#stx-pair? _hd858906_)
                           (let ((_e861911_ (gx#stx-e _hd858906_)))
                             (let ((_lp-tl863916_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _e861911_)))
                                   (_lp-hd862914_
                                    (let ()
                                      (declare (not safe))
                                      (##car _e861911_))))
                               (_loop860903_
                                _lp-tl863916_
                                (cons _lp-hd862914_ _expr864908_))))
                           (let ((_expr865919_ (reverse _expr864908_)))
                             (___kont57595760_ _expr865919_ _hd855893_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop860903_
                                                      _target857898_
                                                      '()))))
                                                (___match58665867_
                                                 (lambda (_e837958_
                                                          _hd838961_
                                                          _tl839963_
                                                          ___splice57575758_
                                                          _target840966_
                                                          _tl842968_)
                                                   (letrec ((_loop843971_
                                                             (lambda (_hd841974_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _decl847976_)
                       (if (gx#stx-pair? _hd841974_)
                           (let ((_e844979_ (gx#stx-e _hd841974_)))
                             (let ((_lp-tl846984_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _e844979_)))
                                   (_lp-hd845982_
                                    (let ()
                                      (declare (not safe))
                                      (##car _e844979_))))
                               (_loop843971_
                                _lp-tl846984_
                                (cons _lp-hd845982_ _decl847976_))))
                           (let ((_decl848987_ (reverse _decl847976_)))
                             (___kont57555756_ _decl848987_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop843971_
                                                      _target840966_
                                                      '()))))
                                                (___match58245825_
                                                 (lambda (_e8081057_
                                                          _hd8091060_
                                                          _tl8101062_
                                                          _e8111065_
                                                          _hd8121068_
                                                          _tl8131070_
                                                          ___splice57515752_
                                                          _target8141073_
                                                          _tl8161075_)
                                                   (letrec ((_loop8171078_
                                                             (lambda (_hd8151081_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _id8211083_)
                       (if (gx#stx-pair? _hd8151081_)
                           (let ((_e8181086_ (gx#stx-e _hd8151081_)))
                             (let ((_lp-tl8201091_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _e8181086_)))
                                   (_lp-hd8191089_
                                    (let ()
                                      (declare (not safe))
                                      (##car _e8181086_))))
                               (_loop8171078_
                                _lp-tl8201091_
                                (cons _lp-hd8191089_ _id8211083_))))
                           (let ((_id8221094_ (reverse _id8211083_)))
                             (if (gx#stx-pair? _tl8131070_)
                                 (let ((_e8231097_ (gx#stx-e _tl8131070_)))
                                   (let ((_tl8251102_
                                          (let ()
                                            (declare (not safe))
                                            (##cdr _e8231097_)))
                                         (_hd8241100_
                                          (let ()
                                            (declare (not safe))
                                            (##car _e8231097_))))
                                     (if (gx#stx-null? _tl8251102_)
                                         (___kont57495750_ _id8221094_)
                                         (___kont57635764_))))
                                 (___kont57635764_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop8171078_
                                                      _target8141073_
                                                      '()))))
                                                (___match58005801_
                                                 (lambda (_e7951134_
                                                          _hd7961137_
                                                          _tl7971139_
                                                          ___splice57475748_
                                                          _target7981142_
                                                          _tl8001144_)
                                                   (letrec ((_loop8011147_
                                                             (lambda (_hd7991150_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr8051152_)
                       (if (gx#stx-pair? _hd7991150_)
                           (let ((_e8021155_ (gx#stx-e _hd7991150_)))
                             (let ((_lp-tl8041160_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _e8021155_)))
                                   (_lp-hd8031158_
                                    (let ()
                                      (declare (not safe))
                                      (##car _e8021155_))))
                               (_loop8011147_
                                _lp-tl8041160_
                                (cons _lp-hd8031158_ _expr8051152_))))
                           (let ((_expr8061163_ (reverse _expr8051152_)))
                             (___kont57455746_ _expr8061163_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop8011147_
                                                      _target7981142_
                                                      '()))))
                                                (___match57825783_
                                                 (lambda (_e7821192_
                                                          _hd7831195_
                                                          _tl7841197_
                                                          ___splice57435744_
                                                          _target7851200_
                                                          _tl7871202_)
                                                   (letrec ((_loop7881205_
                                                             (lambda (_hd7861208_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              _expr7921210_)
                       (if (gx#stx-pair? _hd7861208_)
                           (let ((_e7891213_ (gx#stx-e _hd7861208_)))
                             (let ((_lp-tl7911218_
                                    (let ()
                                      (declare (not safe))
                                      (##cdr _e7891213_)))
                                   (_lp-hd7901216_
                                    (let ()
                                      (declare (not safe))
                                      (##car _e7891213_))))
                               (_loop7881205_
                                _lp-tl7911218_
                                (cons _lp-hd7901216_ _expr7921210_))))
                           (let ((_expr7931221_ (reverse _expr7921210_)))
                             (___kont57415742_ _expr7931221_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop7881205_
                                                      _target7851200_
                                                      '())))))
                                           (if (gx#stx-pair? ___stx57395740_)
                                               (let ((_e7821192_
                                                      (gx#stx-e
                                                       ___stx57395740_)))
                                                 (let ((_tl7841197_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##cdr _e7821192_)))
                                                       (_hd7831195_
                                                        (let ()
                                                          (declare (not safe))
                                                          (##car _e7821192_))))
                                                   (if (gx#identifier?
                                                        _hd7831195_)
                                                       (if (gx#stx-eq?
                                                            '%#begin
                                                            _hd7831195_)
                                                           (if (gx#stx-pair/null?
                                                                _tl7841197_)
                                                               (let ((___splice57435744_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              (gx#syntax-split-splice _tl7841197_ '0)))
                         (let ((_tl7871202_
                                (let ()
                                  (declare (not safe))
                                  (##vector-ref ___splice57435744_ '1)))
                               (_target7851200_
                                (let ()
                                  (declare (not safe))
                                  (##vector-ref ___splice57435744_ '0))))
                           (if (gx#stx-null? _tl7871202_)
                               (___match57825783_
                                _e7821192_
                                _hd7831195_
                                _tl7841197_
                                ___splice57435744_
                                _target7851200_
                                _tl7871202_)
                               (___kont57635764_))))
                       (___kont57635764_))
                   (if (gx#stx-eq? '%#begin-syntax _hd7831195_)
                       (if (gx#stx-pair/null? _tl7841197_)
                           (let ((___splice57475748_
                                  (gx#syntax-split-splice _tl7841197_ '0)))
                             (let ((_tl8001144_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref ___splice57475748_ '1)))
                                   (_target7981142_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref ___splice57475748_ '0))))
                               (if (gx#stx-null? _tl8001144_)
                                   (___match58005801_
                                    _e7821192_
                                    _hd7831195_
                                    _tl7841197_
                                    ___splice57475748_
                                    _target7981142_
                                    _tl8001144_)
                                   (___kont57635764_))))
                           (___kont57635764_))
                       (if (gx#stx-eq? '%#define-values _hd7831195_)
                           (if (gx#stx-pair? _tl7841197_)
                               (let ((_e8111065_ (gx#stx-e _tl7841197_)))
                                 (let ((_tl8131070_
                                        (let ()
                                          (declare (not safe))
                                          (##cdr _e8111065_)))
                                       (_hd8121068_
                                        (let ()
                                          (declare (not safe))
                                          (##car _e8111065_))))
                                   (if (gx#stx-pair/null? _hd8121068_)
                                       (let ((___splice57515752_
                                              (gx#syntax-split-splice
                                               _hd8121068_
                                               '0)))
                                         (let ((_tl8161075_
                                                (let ()
                                                  (declare (not safe))
                                                  (##vector-ref
                                                   ___splice57515752_
                                                   '1)))
                                               (_target8141073_
                                                (let ()
                                                  (declare (not safe))
                                                  (##vector-ref
                                                   ___splice57515752_
                                                   '0))))
                                           (if (gx#stx-null? _tl8161075_)
                                               (___match58245825_
                                                _e7821192_
                                                _hd7831195_
                                                _tl7841197_
                                                _e8111065_
                                                _hd8121068_
                                                _tl8131070_
                                                ___splice57515752_
                                                _target8141073_
                                                _tl8161075_)
                                               (___kont57635764_))))
                                       (___kont57635764_))))
                               (___kont57635764_))
                           (if (gx#stx-eq? '%#define-syntax _hd7831195_)
                               (if (gx#stx-pair? _tl7841197_)
                                   (let ((_e8301023_ (gx#stx-e _tl7841197_)))
                                     (let ((_tl8321028_
                                            (let ()
                                              (declare (not safe))
                                              (##cdr _e8301023_)))
                                           (_hd8311026_
                                            (let ()
                                              (declare (not safe))
                                              (##car _e8301023_))))
                                       (if (gx#stx-pair? _tl8321028_)
                                           (let ((_e8331031_
                                                  (gx#stx-e _tl8321028_)))
                                             (let ((_tl8351036_
                                                    (let ()
                                                      (declare (not safe))
                                                      (##cdr _e8331031_)))
                                                   (_hd8341034_
                                                    (let ()
                                                      (declare (not safe))
                                                      (##car _e8331031_))))
                                               (if (gx#stx-null? _tl8351036_)
                                                   (___kont57535754_
                                                    _hd8311026_)
                                                   (___kont57635764_))))
                                           (___kont57635764_))))
                                   (___kont57635764_))
                               (if (gx#stx-eq? '%#extern _hd7831195_)
                                   (if (gx#stx-pair/null? _tl7841197_)
                                       (let ((___splice57575758_
                                              (gx#syntax-split-splice
                                               _tl7841197_
                                               '0)))
                                         (let ((_tl842968_
                                                (let ()
                                                  (declare (not safe))
                                                  (##vector-ref
                                                   ___splice57575758_
                                                   '1)))
                                               (_target840966_
                                                (let ()
                                                  (declare (not safe))
                                                  (##vector-ref
                                                   ___splice57575758_
                                                   '0))))
                                           (if (gx#stx-null? _tl842968_)
                                               (___match58665867_
                                                _e7821192_
                                                _hd7831195_
                                                _tl7841197_
                                                ___splice57575758_
                                                _target840966_
                                                _tl842968_)
                                               (___kont57635764_))))
                                       (___kont57635764_))
                                   (if (gx#stx-eq? '%#module _hd7831195_)
                                       (if (gx#stx-pair? _tl7841197_)
                                           (let ((_e854890_
                                                  (gx#stx-e _tl7841197_)))
                                             (let ((_tl856895_
                                                    (let ()
                                                      (declare (not safe))
                                                      (##cdr _e854890_)))
                                                   (_hd855893_
                                                    (let ()
                                                      (declare (not safe))
                                                      (##car _e854890_))))
                                               (if (gx#stx-pair/null?
                                                    _tl856895_)
                                                   (let ((___splice57615762_
                                                          (gx#syntax-split-splice
                                                           _tl856895_
                                                           '0)))
                                                     (let ((_tl859900_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               ___splice57615762_
                                                               '1)))
                                                           (_target857898_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               ___splice57615762_
                                                               '0))))
                                                       (if (gx#stx-null?
                                                            _tl859900_)
                                                           (___match58905891_
                                                            _e7821192_
                                                            _hd7831195_
                                                            _tl7841197_
                                                            _e854890_
                                                            _hd855893_
                                                            _tl856895_
                                                            ___splice57615762_
                                                            _target857898_
                                                            _tl859900_)
                                                           (___kont57635764_))))
                                                   (___kont57635764_))))
                                           (___kont57635764_))
                                       (___kont57635764_)))))))
               (___kont57635764_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                               (___kont57635764_)))))))
                          (_new-loc1250_ (gx#stx-source _stx770_)))
                     (if _new-loc1250_
                         (let ((_save-loc1253_ _loc515_))
                           (set! _loc515_ _new-loc1250_)
                           (_K1247_)
                           (set! _loc515_ _save-loc1253_))
                         (_K1247_)))))
                (_tag-def662_
                 (lambda (_id758_)
                   (let* ((_K761_ (lambda ()
                                    (_tag-name!664_
                                     (##structure-ref
                                      (gx#resolve-identifier__0 _id758_)
                                      '1
                                      gx#binding::t
                                      '#f))))
                          (_new-loc764_ (gx#stx-source _id758_)))
                     (if _new-loc764_
                         (let ((_save-loc767_ _loc515_))
                           (set! _loc515_ _new-loc764_)
                           (_K761_)
                           (set! _loc515_ _save-loc767_))
                         (_K761_)))))
                (_tag-decl663_
                 (lambda (_decl694_)
                   (let* ((_g696710_
                           (lambda (_g697707_)
                             (gx#raise-syntax-error
                              '#f
                              '"Bad syntax"
                              _g697707_)))
                          (_g695755_
                           (lambda (_g697713_)
                             (if (gx#stx-pair? _g697713_)
                                 (let ((_e700715_ (gx#stx-e _g697713_)))
                                   (let ((_hd701718_
                                          (let ()
                                            (declare (not safe))
                                            (##car _e700715_)))
                                         (_tl702720_
                                          (let ()
                                            (declare (not safe))
                                            (##cdr _e700715_))))
                                     (if (gx#stx-pair? _tl702720_)
                                         (let ((_e703723_
                                                (gx#stx-e _tl702720_)))
                                           (let ((_hd704726_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##car _e703723_)))
                                                 (_tl705728_
                                                  (let ()
                                                    (declare (not safe))
                                                    (##cdr _e703723_))))
                                             (if (gx#stx-null? _tl705728_)
                                                 ((lambda (_L731_ _L732_)
                                                    (let* ((_K746_ (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             (_tag-name!664_ (gx#stx-e _L731_))))
                   (_new-loc749_ (gx#stx-source _L732_)))
              (if _new-loc749_
                  (let ((_save-loc752_ _loc515_))
                    (set! _loc515_ _new-loc749_)
                    (_K746_)
                    (set! _loc515_ _save-loc752_))
                  (_K746_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  _hd704726_
                                                  _hd701718_)
                                                 (_g696710_ _g697713_))))
                                         (_g696710_ _g697713_))))
                                 (_g696710_ _g697713_)))))
                     (_g695755_ _decl694_))))
                (_tag-name!664_
                 (lambda (_eid684_)
                   (let ((_names685687_ (table-ref _xtab512_ _eid684_ '#f)))
                     (if _names685687_
                         (let ((_names690_ _names685687_))
                           (for-each
                            (lambda (_name692_) (_tag!660_ _eid684_ _name692_))
                            (std/srfi/1#delete-duplicates _names690_ eq?)))
                         '#f)))))
        (let ((_stx666_
               (##structure-ref _ctx511_ '11 gx#module-context::t '#f)))
          (let* ((_id668_ (##structure-ref
                           _ctx511_
                           '1
                           gx#expander-context::t
                           '#f))
                 (_gid670_ (make-symbol '":" _id668_)))
            (let* ((_K674_ (lambda () (_tag!660_ 'module _gid670_)))
                   (_new-loc677_ (gx#stx-source _stx666_)))
              (if _new-loc677_
                  (let ((_save-loc680_ _loc515_))
                    (set! _loc515_ _new-loc677_)
                    (_K674_)
                    (set! _loc515_ _save-loc680_))
                  (_K674_))))
          (call-with-parameters
           (lambda () (_tag-e661_ _stx666_))
           gx#current-expander-context
           _ctx511_
           gx#current-expander-phi
           '0)
          (std/srfi/1#reverse! _tags514_)))))
  (define gerbil/tools/gxtags#write-tags
    (lambda (_tags426_ _filename427_ _output428_)
      (let* ((_lines430_
              (std/misc/ports#read-file-lines__%
               '#f
               absent-value
               _filename427_))
             (_lines432_
              (if (null? _lines430_) '#("") (list->vector _lines430_)))
             (_offsets434_
              (gerbil/tools/gxtags#file-line-offsets _filename427_))
             (_tmp436_ (open-output-string))
             (_filepath438_ (path-normalize _filename427_))
             (_rfilepath440_
              (path-normalize
               _filepath438_
               '#t
               (gerbil/tools/gxtags#current-tags-path)))
             (_out-of-file-tags442_ '()))
        (for-each
         (lambda (_tag445_)
           (let* ((_tag446457_ _tag445_)
                  (_E448461_
                   (lambda () (error '"No clause matching" _tag446457_)))
                  (_K449479_
                   (lambda (_loc464_ _name465_)
                     (let ((_path467_ (source-location-path _loc464_)))
                       (if (or (equal? _path467_ _filepath438_)
                               (not _path467_))
                           (let* ((_line472_
                                   (gerbil/tools/gxtags#source-location-line
                                    _loc464_))
                                  (_anchor474_
                                   (vector-ref _lines432_ (fx- _line472_ '1)))
                                  (_offset476_
                                   (vector-ref
                                    _offsets434_
                                    (fx- _line472_ '1))))
                             (gerbil/gambit/ports#write-string__%
                              _anchor474_
                              _tmp436_)
                             (write-char '#\delete _tmp436_)
                             (display _name465_ _tmp436_)
                             (write-char '#\x1 _tmp436_)
                             (display _line472_ _tmp436_)
                             (write-char '#\, _tmp436_)
                             (display _offset476_ _tmp436_)
                             (newline _tmp436_))
                           (set! _out-of-file-tags442_
                                 (cons _tag445_ _out-of-file-tags442_)))))))
             (if (let () (declare (not safe)) (##pair? _tag446457_))
                 (let ((_tl451482_
                        (let () (declare (not safe)) (##cdr _tag446457_))))
                   (if (let () (declare (not safe)) (##pair? _tl451482_))
                       (let ((_hd452485_
                              (let () (declare (not safe)) (##car _tl451482_)))
                             (_tl453487_
                              (let ()
                                (declare (not safe))
                                (##cdr _tl451482_))))
                         (let ((_name490_ _hd452485_))
                           (if (let ()
                                 (declare (not safe))
                                 (##pair? _tl453487_))
                               (let ((_hd454492_
                                      (let ()
                                        (declare (not safe))
                                        (##car _tl453487_)))
                                     (_tl455494_
                                      (let ()
                                        (declare (not safe))
                                        (##cdr _tl453487_))))
                                 (let ((_loc497_ _hd454492_))
                                   (if (let ()
                                         (declare (not safe))
                                         (##null? _tl455494_))
                                       (_K449479_ _loc497_ _name490_)
                                       (_E448461_))))
                               (_E448461_))))
                       (_E448461_)))
                 (_E448461_))))
         _tags426_)
        (let* ((_str499_ (get-output-string _tmp436_))
               (_len501_ (std/text/utf8#string-utf8-length__0 _str499_)))
          (write-char '#\page _output428_)
          (newline _output428_)
          (gerbil/gambit/ports#write-string__% _rfilepath440_ _output428_)
          (write-char '#\, _output428_)
          (display _len501_ _output428_)
          (newline _output428_)
          (gerbil/gambit/ports#write-string__% _str499_ _output428_)
          (if (null? _out-of-file-tags442_)
              '#!void
              (let* ((_tags504_ (std/srfi/1#reverse! _out-of-file-tags442_))
                     (_path506_ (source-location-path (caddar _tags504_)))
                     (_filename508_ (path-normalize _path506_ '#t)))
                (gerbil/tools/gxtags#write-tags
                 _tags504_
                 _filename508_
                 _output428_)))))))
  (define gerbil/tools/gxtags#+nl+ (char->integer '#\newline))
  (define gerbil/tools/gxtags#file-line-offsets
    (lambda (_filename413_)
      (call-with-input-file
       _filename413_
       (lambda (_inp415_)
         (let _lp417_ ((_i419_ '0) (_offs420_ (cons '0 '())))
           (let ((_next422_ (read-u8 _inp415_)))
             (if (eof-object? _next422_)
                 (list->vector (std/srfi/1#reverse! _offs420_))
                 (if (eq? _next422_ gerbil/tools/gxtags#+nl+)
                     (let ((_i+1424_ (fx+ _i419_ '1)))
                       (_lp417_ _i+1424_ (cons _i+1424_ _offs420_)))
                     (_lp417_ (fx+ _i419_ '1) _offs420_)))))))))
  (define gerbil/tools/gxtags#source-location-line
    (lambda (_locat409_)
      (if (let () (declare (not safe)) (##locat? _locat409_))
          (let ((_filepos411_
                 (let ((__tmp5894
                        (let ()
                          (declare (not safe))
                          (##locat-position _locat409_))))
                   (declare (not safe))
                   (##position->filepos __tmp5894))))
            (fx+ (let () (declare (not safe)) (##filepos-line _filepos411_))
                 '1))
          '1)))
  (define gerbil/tools/gxtags#try-import-module
    (lambda (_filename400_)
      (with-exception-catcher
       (lambda (_g401403_)
         (if '#t (let ((_e406_ _g401403_)) '#f) (raise _g401403_)))
       (lambda () (gx#import-module__0 _filename400_))))))
