(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/address#ip4-address
    (lambda (_obj1115_)
      (if (std/net/address#ip4-address? _obj1115_)
          _obj1115_
          (if (std/net/address#ip4-address-string? _obj1115_)
              (std/net/address#string->ip4-address _obj1115_)
              (error '"Malformed ip4 address" _obj1115_)))))
  (define std/net/address#ip4-address?
    (lambda (_obj1113_)
      (if (let () (declare (not safe)) (##u8vector? _obj1113_))
          (let ((__tmp4753
                 (let () (declare (not safe)) (##u8vector-length _obj1113_))))
            (declare (not safe))
            (##fx= __tmp4753 '4))
          '#f)))
  (define std/net/address#ip4-address-string?
    (lambda (_obj1111_)
      (if (string? _obj1111_)
          (if (std/pregexp#pregexp-match
               std/net/address#ip4-address-rx
               _obj1111_)
              '#t
              '#f)
          '#f)))
  (define std/net/address#ip4-address-rx
    (std/pregexp#pregexp
     '"^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$"))
  (define std/net/address#string->ip4-address
    (lambda (_str1086_)
      (let* ((_g10871094_
              (std/pregexp#pregexp-match
               std/net/address#ip4-address-rx
               _str1086_))
             (_E10891098_
              (lambda () (error '"No clause matching" _g10871094_)))
             (_K10901103_
              (lambda (_octets1101_)
                (apply ##u8vector (map string->number _octets1101_)))))
        (if (let () (declare (not safe)) (##pair? _g10871094_))
            (let* ((_tl10921106_
                    (let () (declare (not safe)) (##cdr _g10871094_)))
                   (_octets1109_ _tl10921106_))
              (_K10901103_ _octets1109_))
            (_E10891098_)))))
  (define std/net/address#ip4-address->string
    (lambda (_ip41084_)
      (if (std/net/address#ip4-address? _ip41084_)
          (apply std/format#format
                 '"~a.~a.~a.~a"
                 (let () (declare (not safe)) (##u8vector->list _ip41084_)))
          (if (std/net/address#ip4-address-string? _ip41084_)
              _ip41084_
              (error '"Malformed ip4 address" _ip41084_)))))
  (define std/net/address#ip6-address
    (lambda (_obj1082_)
      (if (std/net/address#ip6-address? _obj1082_)
          _obj1082_
          (if (std/net/address#ip6-address-string? _obj1082_)
              (std/net/address#string->ip6-address _obj1082_)
              (error '"Malformed ip6 address" _obj1082_)))))
  (define std/net/address#ip6-address?
    (lambda (_obj1080_)
      (if (let () (declare (not safe)) (##u8vector? _obj1080_))
          (let ((__tmp4754
                 (let () (declare (not safe)) (##u8vector-length _obj1080_))))
            (declare (not safe))
            (##fx= __tmp4754 '16))
          '#f)))
  (define std/net/address#ip6-address-rx
    (std/pregexp#pregexp '"^[0-9a-fA-F:]+$"))
  (define std/net/address#ip6-address-string?
    (lambda (_obj1078_)
      (if (string? _obj1078_)
          (if (std/pregexp#pregexp-match
               std/net/address#ip6-address-rx
               _obj1078_)
              '#t
              '#f)
          '#f)))
  (define std/net/address#string->ip6-address
    (lambda (_str965_)
      (letrec ((_hex-e967_
                (lambda (_str1070_ _k1071_)
                  (let* ((_char1073_ (string-ref _str1070_ _k1071_))
                         (_$e1075_ (std/text/hex#unhex* _char1073_)))
                    (if _$e1075_
                        (values _$e1075_)
                        (error '"Malformed address; not a hex digit"
                               _str1070_
                               _char1073_)))))
               (_loop968_
                (lambda (_rest1020_ _bytes1021_ _have-zeros1022_)
                  (let* ((_rest10231031_ _rest1020_)
                         (_else10251039_
                          (lambda ()
                            (_check969_
                             (list->u8vector (reverse _bytes1021_)))))
                         (_K10271058_
                          (lambda (_rest1042_ _hex1043_)
                            (let ((_$e1045_ (string-length _hex1043_)))
                              (if (eq? '0 _$e1045_)
                                  (if _have-zeros1022_
                                      (error '"Malformed address" _str965_)
                                      (let* ((_count1048_ (length _rest1042_))
                                             (_count1050_
                                              (let ((__tmp4755
                                                     (let ()
                                                       (declare (not safe))
                                                       (##fx- '8
                                                              _count1048_))))
                                                (declare (not safe))
                                                (##fx* __tmp4755 '2)))
                                             (_count1052_
                                              (let ((__tmp4756
                                                     (length _bytes1021_)))
                                                (declare (not safe))
                                                (##fx- _count1050_ __tmp4756)))
                                             (_g4757_ (if (let ()
                                                            (declare
                                                              (not safe))
                                                            (##fxnegative?
                                                             _count1052_))
                                                          (error '"Malformed address; too many bits"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _str965_)
                  '#!void))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                             (_block1055_
                                              (make-list _count1052_ '0)))
                                        (_loop968_
                                         _rest1042_
                                         (foldl1 cons _bytes1021_ _block1055_)
                                         '#t)))
                                  (if (eq? '1 _$e1045_)
                                      (_loop968_
                                       _rest1042_
                                       (cons (_hex-e967_ _hex1043_ '0)
                                             (cons '0 _bytes1021_))
                                       _have-zeros1022_)
                                      (if (eq? '2 _$e1045_)
                                          (_loop968_
                                           _rest1042_
                                           (cons (let ((__tmp4759
                                                        (let ((__tmp4760
                                                               (_hex-e967_
                                                                _hex1043_
                                                                '0)))
                                                          (declare (not safe))
                                                          (##fxarithmetic-shift
                                                           __tmp4760
                                                           '4)))
                                                       (__tmp4758
                                                        (_hex-e967_
                                                         _hex1043_
                                                         '1)))
                                                   (declare (not safe))
                                                   (##fxior __tmp4759
                                                            __tmp4758))
                                                 (cons '0 _bytes1021_))
                                           _have-zeros1022_)
                                          (if (eq? '3 _$e1045_)
                                              (_loop968_
                                               _rest1042_
                                               (cons (let ((__tmp4762
                                                            (let ((__tmp4763
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (_hex-e967_ _hex1043_ '1)))
                      (declare (not safe))
                      (##fxarithmetic-shift __tmp4763 '4)))
                   (__tmp4761 (_hex-e967_ _hex1043_ '2)))
               (declare (not safe))
               (##fxior __tmp4762 __tmp4761))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (cons (_hex-e967_
                                                            _hex1043_
                                                            '0)
                                                           _bytes1021_))
                                               _have-zeros1022_)
                                              (if (eq? '4 _$e1045_)
                                                  (_loop968_
                                                   _rest1042_
                                                   (cons (let ((__tmp4765
                                                                (let ((__tmp4766
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                               (_hex-e967_ _hex1043_ '2)))
                          (declare (not safe))
                          (##fxarithmetic-shift __tmp4766 '4)))
                       (__tmp4764 (_hex-e967_ _hex1043_ '3)))
                   (declare (not safe))
                   (##fxior __tmp4765 __tmp4764))
                 (cons (let ((__tmp4768
                              (let ((__tmp4769 (_hex-e967_ _hex1043_ '0)))
                                (declare (not safe))
                                (##fxarithmetic-shift __tmp4769 '4)))
                             (__tmp4767 (_hex-e967_ _hex1043_ '1)))
                         (declare (not safe))
                         (##fxior __tmp4768 __tmp4767))
                       _bytes1021_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   _have-zeros1022_)
                                                  _hex1043_)))))))))
                    (if (let () (declare (not safe)) (##pair? _rest10231031_))
                        (let ((_hd10281061_
                               (let ()
                                 (declare (not safe))
                                 (##car _rest10231031_)))
                              (_tl10291063_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _rest10231031_))))
                          (let* ((_hex1066_ _hd10281061_)
                                 (_rest1068_ _tl10291063_))
                            (_K10271058_ _rest1068_ _hex1066_)))
                        (_else10251039_)))))
               (_check969_
                (lambda (_bytes1018_)
                  (if (let ((__tmp4770 (u8vector-length _bytes1018_)))
                        (declare (not safe))
                        (##fx= __tmp4770 '16))
                      _bytes1018_
                      (if (let ((__tmp4771 (u8vector-length _bytes1018_)))
                            (declare (not safe))
                            (##fx< __tmp4771 '16))
                          (error '"Malformed address; not enough bits"
                                 _str965_
                                 _bytes1018_)
                          (error '"malformed address; too many bits"
                                 _str965_
                                 _bytes1018_))))))
        (let* ((_hexes971_ (string-split _str965_ '#\:))
               (_hexes972982_ _hexes971_)
               (_else974990_ (lambda () (_loop968_ _hexes971_ '() '#f)))
               (_K9761003_
                (lambda (_rest993_)
                  (let* ((_count995_ (length _rest993_))
                         (_count997_
                          (let ((__tmp4772
                                 (let ()
                                   (declare (not safe))
                                   (##fx- '8 _count995_))))
                            (declare (not safe))
                            (##fx* __tmp4772 '2)))
                         (_g4773_ (if (let ()
                                        (declare (not safe))
                                        (##fxnegative? _count997_))
                                      (error '"Malformed address; too many bits"
                                             _str965_)
                                      '#!void))
                         (_bytes1000_ (make-list _count997_ '0)))
                    (_loop968_ _rest993_ _bytes1000_ '#t)))))
          (if (let () (declare (not safe)) (##pair? _hexes972982_))
              (let ((_hd9771006_
                     (let () (declare (not safe)) (##car _hexes972982_)))
                    (_tl9781008_
                     (let () (declare (not safe)) (##cdr _hexes972982_))))
                (if (equal? _hd9771006_ '"")
                    (if (let () (declare (not safe)) (##pair? _tl9781008_))
                        (let ((_hd9791011_
                               (let ()
                                 (declare (not safe))
                                 (##car _tl9781008_)))
                              (_tl9801013_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _tl9781008_))))
                          (if (equal? _hd9791011_ '"")
                              (let ((_rest1016_ _tl9801013_))
                                (_K9761003_ _rest1016_))
                              (_else974990_)))
                        (_else974990_))
                    (_else974990_)))
              (_else974990_))))))
  (define std/net/address#ip6-address->string
    (lambda (_ip6730_)
      (letrec ((_compress-zeros732_
                (lambda (_hexes963_)
                  (_compress-leading-trailing733_ (_compress734_ _hexes963_))))
               (_compress-leading-trailing733_
                (lambda (_hexes961_)
                  (if (equal? (car _hexes961_) '"")
                      (cons '"" _hexes961_)
                      (if (equal? (last _hexes961_) '"")
                          (begin
                            (set-cdr! (last-pair _hexes961_) '(""))
                            _hexes961_)
                          _hexes961_))))
               (_compress734_
                (lambda (_hexes899_)
                  (let* ((_hexes900914_ _hexes899_)
                         (_else903922_ (lambda () '())))
                    (let ((_K908946_
                           (lambda (_rest944_)
                             (cons '"" (_compress*735_ _rest944_))))
                          (_K905929_
                           (lambda (_rest926_ _hd927_)
                             (cons _hd927_ (_compress734_ _rest926_)))))
                      (if (let () (declare (not safe)) (##pair? _hexes900914_))
                          (let ((_tl910951_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _hexes900914_)))
                                (_hd909949_
                                 (let ()
                                   (declare (not safe))
                                   (##car _hexes900914_))))
                            (if (equal? _hd909949_ '"0")
                                (if (let ()
                                      (declare (not safe))
                                      (##pair? _tl910951_))
                                    (let ((_tl912956_
                                           (let ()
                                             (declare (not safe))
                                             (##cdr _tl910951_)))
                                          (_hd911954_
                                           (let ()
                                             (declare (not safe))
                                             (##car _tl910951_))))
                                      (if (equal? _hd911954_ '"0")
                                          (let ((_rest959_ _tl912956_))
                                            (_K908946_ _rest959_))
                                          (let ((_hd937_ _hd909949_)
                                                (_rest939_ _tl910951_))
                                            (_K905929_ _rest939_ _hd937_))))
                                    (let ((_hd937_ _hd909949_)
                                          (_rest939_ _tl910951_))
                                      (_K905929_ _rest939_ _hd937_)))
                                (let ((_hd937_ _hd909949_)
                                      (_rest939_ _tl910951_))
                                  (_K905929_ _rest939_ _hd937_))))
                          (_else903922_))))))
               (_compress*735_
                (lambda (_hexes867_)
                  (let* ((_hexes868876_ _hexes867_)
                         (_else870884_ (lambda () _hexes867_))
                         (_K872889_
                          (lambda (_rest887_) (_compress*735_ _rest887_))))
                    (if (let () (declare (not safe)) (##pair? _hexes868876_))
                        (let ((_hd873892_
                               (let ()
                                 (declare (not safe))
                                 (##car _hexes868876_)))
                              (_tl874894_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _hexes868876_))))
                          (if (equal? _hd873892_ '"0")
                              (let ((_rest897_ _tl874894_))
                                (_compress*735_ _rest897_))
                              (_else870884_)))
                        (_else870884_))))))
        (let _lp737_ ((_rest739_ (u8vector->list _ip6730_)) (_hexes740_ '()))
          (let* ((_rest741751_ _rest739_)
                 (_else743759_
                  (lambda ()
                    (string-join
                     (_compress-zeros732_ (reverse _hexes740_))
                     '#\:)))
                 (_K745848_
                  (lambda (_rest762_ _b1763_ _b0764_)
                    (let ((_b0h766_
                           (let ((__tmp4774
                                  (let ()
                                    (declare (not safe))
                                    (##fxarithmetic-shift _b0764_ '-4))))
                             (declare (not safe))
                             (##fxand __tmp4774 '15)))
                          (_b0l767_
                           (let () (declare (not safe)) (##fxand _b0764_ '15)))
                          (_b1h768_
                           (let ((__tmp4775
                                  (let ()
                                    (declare (not safe))
                                    (##fxarithmetic-shift _b1763_ '-4))))
                             (declare (not safe))
                             (##fxand __tmp4775 '15)))
                          (_b1l769_
                           (let ()
                             (declare (not safe))
                             (##fxand _b1763_ '15))))
                      (let ((_b0h770785_ _b0h766_)
                            (_b0l771787_ _b0l767_)
                            (_b1h772789_ _b1h768_)
                            (_b1l773791_ _b1l769_))
                        (let ((_else778799_
                               (lambda ()
                                 (_lp737_ _rest762_
                                          (cons (string (std/text/hex#hex
                                                         _b0h766_)
                                                        (std/text/hex#hex
                                                         _b0l767_)
                                                        (std/text/hex#hex
                                                         _b1h768_)
                                                        (std/text/hex#hex
                                                         _b1l769_))
                                                _hexes740_)))))
                          (let ((_K783845_
                                 (lambda ()
                                   (_lp737_ _rest762_ (cons '"0" _hexes740_))))
                                (_K782836_
                                 (lambda (_b1l834_)
                                   (_lp737_ _rest762_
                                            (cons (string (std/text/hex#hex
                                                           _b1l834_))
                                                  _hexes740_))))
                                (_K781823_
                                 (lambda (_b1h820_ _b1l821_)
                                   (_lp737_ _rest762_
                                            (cons (string (std/text/hex#hex
                                                           _b1h820_)
                                                          (std/text/hex#hex
                                                           _b1l821_))
                                                  _hexes740_))))
                                (_K780807_
                                 (lambda (_b0l803_ _b1h804_ _b1l805_)
                                   (_lp737_ _rest762_
                                            (cons (string (std/text/hex#hex
                                                           _b0l803_)
                                                          (std/text/hex#hex
                                                           _b1h804_)
                                                          (std/text/hex#hex
                                                           _b1l805_))
                                                  _hexes740_)))))
                            (if (let ()
                                  (declare (not safe))
                                  (##eq? _b0h770785_ '0))
                                (if (let ()
                                      (declare (not safe))
                                      (##eq? _b0l771787_ '0))
                                    (if (let ()
                                          (declare (not safe))
                                          (##eq? _b1h772789_ '0))
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _b1l773791_ '0))
                                            (_K783845_)
                                            (let ((_b1l839_ _b1l773791_))
                                              (_K782836_ _b1l839_)))
                                        (let ((_b1h826_ _b1h772789_)
                                              (_b1l828_ _b1l773791_))
                                          (_K781823_ _b1h826_ _b1l828_)))
                                    (let ((_b0l810_ _b0l771787_)
                                          (_b1h812_ _b1h772789_)
                                          (_b1l814_ _b1l773791_))
                                      (_K780807_ _b0l810_ _b1h812_ _b1l814_)))
                                (_else778799_)))))))))
            (if (let () (declare (not safe)) (##pair? _rest741751_))
                (let ((_hd746851_
                       (let () (declare (not safe)) (##car _rest741751_)))
                      (_tl747853_
                       (let () (declare (not safe)) (##cdr _rest741751_))))
                  (let ((_b0856_ _hd746851_))
                    (if (let () (declare (not safe)) (##pair? _tl747853_))
                        (let ((_hd748858_
                               (let ()
                                 (declare (not safe))
                                 (##car _tl747853_)))
                              (_tl749860_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _tl747853_))))
                          (let* ((_b1863_ _hd748858_) (_rest865_ _tl749860_))
                            (_K745848_ _rest865_ _b1863_ _b0856_)))
                        (_else743759_))))
                (_else743759_)))))))
  (define std/net/address#inet-address
    (lambda (_obj728_)
      (if (std/net/address#inet-address? _obj728_)
          (std/net/address#inet-address-normalize _obj728_)
          (if (std/net/address#inet-address-string? _obj728_)
              (std/net/address#string->inet-address _obj728_)
              (error '"Malformed inet address" _obj728_)))))
  (define std/net/address#inet-address-normalize
    (lambda (_addr695_)
      (let* ((_addr696703_ _addr695_)
             (_E698707_ (lambda () (error '"No clause matching" _addr696703_)))
             (_K699716_
              (lambda (_port710_ _host711_)
                (if (or (std/net/address#ip4-address? _host711_)
                        (std/net/address#ip6-address? _host711_))
                    _addr695_
                    (if (std/net/address#ip4-address-string? _host711_)
                        (cons (std/net/address#string->ip4-address _host711_)
                              _port710_)
                        (if (std/net/address#ip6-address-string? _host711_)
                            (cons (std/net/address#string->ip6-address
                                   _host711_)
                                  _port710_)
                            _addr695_))))))
        (if (let () (declare (not safe)) (##pair? _addr696703_))
            (let ((_hd700719_
                   (let () (declare (not safe)) (##car _addr696703_)))
                  (_tl701721_
                   (let () (declare (not safe)) (##cdr _addr696703_))))
              (let* ((_host724_ _hd700719_) (_port726_ _tl701721_))
                (_K699716_ _port726_ _host724_)))
            (_E698707_)))))
  (define std/net/address#inet-address?
    (lambda (_obj660_)
      (let* ((_obj661669_ _obj660_)
             (_else663677_ (lambda () '#f))
             (_K665683_
              (lambda (_port680_ _host681_)
                (if (std/net/address#inet-host-address? _host681_)
                    (fixnum? _port680_)
                    '#f))))
        (if (let () (declare (not safe)) (##pair? _obj661669_))
            (let ((_hd666686_
                   (let () (declare (not safe)) (##car _obj661669_)))
                  (_tl667688_
                   (let () (declare (not safe)) (##cdr _obj661669_))))
              (let* ((_host691_ _hd666686_) (_port693_ _tl667688_))
                (_K665683_ _port693_ _host691_)))
            (_else663677_)))))
  (define std/net/address#inet-address-string?
    (lambda (_obj614_)
      (let ((_$e616_ (if (string? _obj614_)
                         (std/net/address#inet-address-split__% _obj614_ false)
                         '#f)))
        (if _$e616_
            ((lambda (_e618620_)
               (let* ((_g622630_ _e618620_)
                      (_else624638_ (lambda () '#f))
                      (_K626647_
                       (lambda (_port641_ _host642_)
                         (let ((_$e644_ (string-empty? _host642_)))
                           (if _$e644_
                               _$e644_
                               (std/net/address#inet-host-address-string?
                                _host642_))))))
                 (if (let ((__tmp4776
                            (if (let ()
                                  (declare (not safe))
                                  (##values? _g622630_))
                                (let ()
                                  (declare (not safe))
                                  (##vector-length _g622630_))
                                '1)))
                       (declare (not safe))
                       (##fx= __tmp4776 '2))
                     (let* ((_e627650_
                             (let ()
                               (declare (not safe))
                               (##vector-ref _g622630_ '0)))
                            (_host653_ _e627650_)
                            (_e628655_
                             (let ()
                               (declare (not safe))
                               (##vector-ref _g622630_ '1)))
                            (_port658_ _e628655_))
                       (_K626647_ _port658_ _host653_))
                     (_else624638_))))
             _$e616_)
            '#f))))
  (define std/net/address#inet-address-split__%
    (lambda (_str596_ _E597_)
      (let ((_$e599_ (string-rindex _str596_ '#\:)))
        (if _$e599_
            ((lambda (_ix602_)
               (values (substring _str596_ '0 _ix602_)
                       (substring
                        _str596_
                        (let () (declare (not safe)) (##fx+ _ix602_ '1))
                        (string-length _str596_))))
             _$e599_)
            (_E597_ '"Malformed address; no port separator" _str596_)))))
  (define std/net/address#inet-address-split__0
    (lambda (_str607_)
      (let ((_E609_ error))
        (std/net/address#inet-address-split__% _str607_ _E609_))))
  (define std/net/address#inet-address-split
    (lambda _g4778_
      (let ((_g4777_ (let () (declare (not safe)) (##length _g4778_))))
        (cond ((let () (declare (not safe)) (##fx= _g4777_ 1))
               (apply std/net/address#inet-address-split__0 _g4778_))
              ((let () (declare (not safe)) (##fx= _g4777_ 2))
               (apply std/net/address#inet-address-split__% _g4778_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/address#inet-address-split
                _g4778_))))))
  (define std/net/address#inet-host-address?
    (lambda (_obj587_)
      (let ((_$e589_ (std/net/address#ip4-address? _obj587_)))
        (if _$e589_
            _$e589_
            (let ((_$e592_ (std/net/address#ip6-address? _obj587_)))
              (if _$e592_
                  _$e592_
                  (std/net/address#inet-host-address-string? _obj587_)))))))
  (define std/net/address#inet-host-address-string?
    (lambda (_obj579_)
      (let ((_$e581_ (std/net/address#ip4-address-string? _obj579_)))
        (if _$e581_
            _$e581_
            (let ((_$e584_ (std/net/address#ip6-address-string? _obj579_)))
              (if _$e584_
                  _$e584_
                  (std/net/address#inet-host-name? _obj579_)))))))
  (define std/net/address#inet-host-name?
    (lambda (_obj577_)
      (if (string? _obj577_)
          (std/pregexp#pregexp-match
           std/net/address#inet-host-name-rx
           _obj577_)
          '#f)))
  (define std/net/address#inet-host-name-rx
    (std/pregexp#pregexp
     '"^[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?)*$"))
  (define std/net/address#string->inet-address
    (lambda (_str537_)
      (letrec ((_string->host539_
                (lambda (_host575_)
                  (if (std/net/address#ip4-address-string? _host575_)
                      (std/net/address#string->ip4-address _host575_)
                      (if (std/net/address#ip6-address-string? _host575_)
                          (std/net/address#string->ip6-address _host575_)
                          (if (std/net/address#inet-host-name? _host575_)
                              _host575_
                              (if (string-empty? _host575_)
                                  '#u8(0 0 0 0)
                                  (error '"Malformed address; bad host"
                                         _str537_
                                         _host575_)))))))
               (_string->port540_
                (lambda (_port571_)
                  (let ((_port573_ (string->number _port571_)))
                    (if (and (fixnum? _port573_)
                             (let ()
                               (declare (not safe))
                               (##fx<= '0 _port573_ '65535)))
                        _port573_
                        (error '"Malformed address; bad port"
                               _str537_
                               _port573_))))))
        (let* ((_g541548_ (std/net/address#inet-address-split__0 _str537_))
               (_E543552_ (lambda () (error '"No clause matching" _g541548_)))
               (_K544558_
                (lambda (_port555_ _host556_)
                  (cons (_string->host539_ _host556_)
                        (_string->port540_ _port555_)))))
          (if (let ((__tmp4779
                     (if (let () (declare (not safe)) (##values? _g541548_))
                         (let ()
                           (declare (not safe))
                           (##vector-length _g541548_))
                         '1)))
                (declare (not safe))
                (##fx= __tmp4779 '2))
              (let* ((_e545561_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _g541548_ '0)))
                     (_host564_ _e545561_)
                     (_e546566_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _g541548_ '1)))
                     (_port569_ _e546566_))
                (_K544558_ _port569_ _host564_))
              (_E543552_))))))
  (define std/net/address#inet-address->string
    (lambda (_obj507_)
      (if (std/net/address#inet-address? _obj507_)
          (let* ((_obj508515_ _obj507_)
                 (_E510519_
                  (lambda () (error '"No clause matching" _obj508515_)))
                 (_K511525_
                  (lambda (_port522_ _host523_)
                    (std/format#format
                     '"~a:~a"
                     (std/net/address#inet-host-address->string _host523_)
                     _port522_))))
            (if (let () (declare (not safe)) (##pair? _obj508515_))
                (let ((_hd512528_
                       (let () (declare (not safe)) (##car _obj508515_)))
                      (_tl513530_
                       (let () (declare (not safe)) (##cdr _obj508515_))))
                  (let* ((_host533_ _hd512528_) (_port535_ _tl513530_))
                    (_K511525_ _port535_ _host533_)))
                (_E510519_)))
          (if (std/net/address#inet-address-string? _obj507_)
              _obj507_
              (error '"Malformed inet address")))))
  (define std/net/address#inet-host-address->string
    (lambda (_host505_)
      (if (string? _host505_)
          _host505_
          (if (std/net/address#ip4-address? _host505_)
              (std/net/address#ip4-address->string _host505_)
              (if (std/net/address#ip6-address? _host505_)
                  (std/net/address#ip6-address->string _host505_)
                  (error '"Malformed inet host address" _host505_))))))
  (define std/net/address#resolve-address
    (lambda (_addr435_)
      (let* ((_addr437_ (std/net/address#inet-address _addr435_))
             (_addr438445_ _addr437_)
             (_E440449_ (lambda () (error '"No clause matching" _addr438445_)))
             (_K441493_
              (lambda (_port452_ _host453_)
                (if (or (std/net/address#ip4-address? _host453_)
                        (std/net/address#ip6-address? _host453_))
                    _addr437_
                    (let* ((_info458_ (host-info _host453_))
                           (_g459467_ (host-info-addresses _info458_))
                           (_else461475_
                            (lambda ()
                              (error '"Failed to resolve address" _addr437_)))
                           (_K463481_
                            (lambda (_rest478_ _ip479_)
                              (cons _ip479_ _port452_))))
                      (if (let () (declare (not safe)) (##pair? _g459467_))
                          (let ((_hd464484_
                                 (let ()
                                   (declare (not safe))
                                   (##car _g459467_)))
                                (_tl465486_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _g459467_))))
                            (let* ((_ip489_ _hd464484_) (_rest491_ _tl465486_))
                              (_K463481_ _rest491_ _ip489_)))
                          (_else461475_)))))))
        (if (let () (declare (not safe)) (##pair? _addr438445_))
            (let ((_hd442496_
                   (let () (declare (not safe)) (##car _addr438445_)))
                  (_tl443498_
                   (let () (declare (not safe)) (##cdr _addr438445_))))
              (let* ((_host501_ _hd442496_) (_port503_ _tl443498_))
                (_K441493_ _port503_ _host501_)))
            (_E440449_)))))
  (define std/net/address#resolved-address?
    (lambda (_obj397_)
      (let* ((_obj398406_ _obj397_)
             (_else400414_ (lambda () '#f))
             (_K402423_
              (lambda (_port417_ _host418_)
                (if (or (std/net/address#ip4-address? _host418_)
                        (std/net/address#ip6-address? _host418_))
                    (fixnum? _port417_)
                    '#f))))
        (if (let () (declare (not safe)) (##pair? _obj398406_))
            (let ((_hd403426_
                   (let () (declare (not safe)) (##car _obj398406_)))
                  (_tl404428_
                   (let () (declare (not safe)) (##cdr _obj398406_))))
              (let* ((_host431_ _hd403426_) (_port433_ _tl404428_))
                (_K402423_ _port433_ _host431_)))
            (_else400414_))))))
