/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.DefaultSearchEngine;
import com.sun.java.help.search.QueryEngine;
import java.util.Locale;
import javax.help.search.SearchEngine;
import javax.help.search.SearchQuery;

public class DefaultSearchQuery
extends SearchQuery
implements Runnable {
    private Thread thread = null;
    private DefaultSearchEngine dhs;
    private static final boolean debugFlag = false;

    public DefaultSearchQuery(SearchEngine searchEngine) {
        super(searchEngine);
        if (searchEngine instanceof DefaultSearchEngine) {
            this.dhs = (DefaultSearchEngine)searchEngine;
        }
    }

    public void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
        DefaultSearchQuery.debug("Starting Search");
        if (this.isActive()) {
            throw new IllegalStateException();
        }
        super.start(string, locale);
        this.thread = new Thread((Runnable)this, "QueryThread");
        this.thread.start();
    }

    public void stop() throws IllegalArgumentException, IllegalStateException {
        DefaultSearchQuery.debug("Stop Search");
    }

    public boolean isActive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public void run() throws IllegalArgumentException {
        QueryEngine queryEngine = this.dhs.getQueryEngine();
        try {
            queryEngine.processQuery(this.searchparams, this.l, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException();
        }
        this.fireSearchFinished();
        this.thread = null;
    }

    private static void debug(String string) {
    }
}

