/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconAware;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnDependencyChecker;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.CheckForUpdateCallback;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;
import org.zaproxy.zap.extension.autoupdate.InstalledAddOnsTableModel;
import org.zaproxy.zap.extension.autoupdate.UninstalledAddOnsTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.panels.TableFilterPanel;

public class ManageAddOnsDialog
extends AbstractFrame
implements CheckForUpdateCallback {
    static final Icon ICON_ADD_ON_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/16/050.png"));
    static final Icon ICON_ADD_ON_EXTENSION_ISSUES = new ImageIcon(InstalledAddOnsTableModel.class.getResource("/resource/icon/fugue/information-white.png"));
    private static final String RETRIEVE_PANEL = "RetrievePanel";
    private static final String MARKETPLACE_PANEL = "MarketplacePanel";
    private static final double ADD_ON_DETAILS_RESIZE_WEIGHT = 0.7;
    private static final Logger logger = Logger.getLogger(ManageAddOnsDialog.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbed = null;
    private JPanel topPanel = null;
    private JPanel installedPanel = null;
    private JPanel browsePanel = null;
    private JPanel corePanel = null;
    private JPanel installedAddOnsPanel = null;
    private JPanel installedAddOnsFilterPanel = null;
    private JPanel uninstalledAddOnsPanel = null;
    private JPanel marketplacePanel;
    private CardLayout marketplaceCardLayout;
    private JPanel retrievePanel = null;
    private JButton addOnInfoButton = null;
    private JButton coreNotesButton = null;
    private JButton downloadZapButton = null;
    private JButton checkForUpdatesButton = null;
    private JButton updateButton = null;
    private JButton updateAllButton = null;
    private JButton uninstallButton = null;
    private JButton installAllButton;
    private JButton installButton = null;
    private JButton close1Button = null;
    private JButton close2Button = null;
    private JLabel downloadProgress = null;
    private JLabel updatesMessage = null;
    private ZapTable installedAddOnsTable = null;
    private ZapTable uninstalledAddOnsTable = null;
    private String currentVersion = null;
    private AddOnCollection latestInfo = null;
    private AddOnCollection prevInfo = null;
    private ExtensionAutoUpdate extension = null;
    private AddOnCollection installedAddOns;
    private final InstalledAddOnsTableModel installedAddOnsModel;
    private final UninstalledAddOnsTableModel uninstalledAddOnsModel;
    private State state = null;

    public ManageAddOnsDialog(ExtensionAutoUpdate ext, String currentVersion, AddOnCollection installedAddOns) throws HeadlessException {
        this.extension = ext;
        this.currentVersion = currentVersion;
        this.installedAddOns = installedAddOns;
        this.installedAddOnsModel = new InstalledAddOnsTableModel(installedAddOns);
        this.uninstalledAddOnsModel = new UninstalledAddOnsTableModel(installedAddOns);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("cfu.manage.title"));
        this.setContentPane(this.getTopPanel());
        this.pack();
        this.centerFrame();
        this.state = State.IDLE;
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 3516424501887406165L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageAddOnsDialog.this.dispatchEvent(new WindowEvent(ManageAddOnsDialog.this, 201));
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.getJTabbed(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            this.topPanel.add((Component)this.getUpdatesMessage(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        }
        return this.topPanel;
    }

    private JTabbedPane getJTabbed() {
        if (this.jTabbed == null) {
            this.jTabbed = new JTabbedPane();
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.installed"), this.getInstalledPanel());
            this.jTabbed.addTab(Constant.messages.getString("cfu.tab.browse"), this.getBrowsePanel());
        }
        return this.jTabbed;
    }

    protected void selectMarketplaceTab() {
        this.getJTabbed().setSelectedIndex(1);
    }

    private JPanel getInstalledPanel() {
        if (this.installedPanel == null) {
            this.installedPanel = new JPanel();
            this.installedPanel.setLayout(new GridBagLayout());
            this.installedPanel.add((Component)this.getCorePanel(true), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
            this.installedPanel.add((Component)this.getInstalledAddOnsPanel(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
        }
        return this.installedPanel;
    }

    private JPanel getBrowsePanel() {
        if (this.browsePanel == null) {
            this.browsePanel = new JPanel();
            this.browsePanel.setLayout(new GridBagLayout());
            this.browsePanel.add((Component)this.getUninstalledAddOnsPanel(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
        }
        return this.browsePanel;
    }

    private JPanel getCorePanel(boolean update) {
        if (this.corePanel == null) {
            this.corePanel = new JPanel();
            this.corePanel.setLayout(new GridBagLayout());
            this.corePanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.zap.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo == null || this.latestInfo.getZapRelease() == null) {
                this.corePanel.add((Component)new JLabel(this.currentVersion), LayoutHelper.getGBC(0, 0, 1, 0.0));
                this.corePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(1, 0, 1, 1.0));
                this.corePanel.add((Component)this.getCheckForUpdatesButton(), LayoutHelper.getGBC(2, 0, 1, 0.0));
            } else if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.addNewerVersionComponents(this.corePanel);
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
        } else if (update && this.latestInfo != null && this.latestInfo.getZapRelease() != null) {
            this.corePanel.removeAll();
            if (this.latestInfo.getZapRelease().isNewerThan(this.currentVersion)) {
                this.addNewerVersionComponents(this.corePanel);
            } else {
                this.corePanel.add((Component)new JLabel(this.currentVersion + " : " + Constant.messages.getString("cfu.check.zap.latest")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            }
            this.installedPanel.validate();
        }
        return this.corePanel;
    }

    private void addNewerVersionComponents(JPanel panel) {
        int x = 0;
        panel.add((Component)new JLabel(Constant.messages.getString("cfu.check.zap.newer", this.latestInfo.getZapRelease().getVersion())), LayoutHelper.getGBC(x, 0, 1, 0.0));
        panel.add((Component)new JLabel(""), LayoutHelper.getGBC(++x, 0, 1, 0.8));
        panel.add((Component)this.getDownloadProgress(), LayoutHelper.getGBC(++x, 0, 1, 0.2));
        if (!Constant.isDailyBuild()) {
            panel.add((Component)this.getCoreNotesButton(), LayoutHelper.getGBC(++x, 0, 1, 0.0));
        }
        panel.add((Component)this.getDownloadZapButton(), LayoutHelper.getGBC(++x, 0, 1, 0.0));
    }

    private JPanel getInstalledAddOnsPanel() {
        if (this.installedAddOnsPanel == null) {
            this.installedAddOnsPanel = new JPanel();
            this.installedAddOnsPanel.setLayout(new GridBagLayout());
            this.installedAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.getInstalledAddOnsTable();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setViewportView((Component)((Object)this.getInstalledAddOnsTable()));
            this.installedAddOnsFilterPanel = new TableFilterPanel<ZapTable>(this.getInstalledAddOnsTable());
            AddOnDetailsPanel addonDetailsPanel = new AddOnDetailsPanel();
            this.getInstalledAddOnsTable().getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedRow = this.getInstalledAddOnsTable().getSelectedRow();
                if (selectedRow != -1) {
                    AddOnWrapper aow = (AddOnWrapper)this.installedAddOnsModel.getValueAt(this.getInstalledAddOnsTable().convertRowIndexToModel(selectedRow), -1);
                    AddOn addOn = AddOn.InstallationStatus.UNINSTALLATION_FAILED == aow.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == aow.getInstallationStatus() ? aow.getAddOn() : (aow.getAddOnUpdate() != null ? aow.getAddOnUpdate() : aow.getAddOn());
                    addonDetailsPanel.setDetails(addOn);
                } else {
                    addonDetailsPanel.clearDetails();
                }
            });
            int row = 0;
            this.installedAddOnsPanel.add((Component)this.installedAddOnsFilterPanel, LayoutHelper.getGBC(0, row++, 5, 0.0));
            JSplitPane split = new JSplitPane(0);
            split.setTopComponent(scrollPane);
            split.setBottomComponent(addonDetailsPanel);
            split.setResizeWeight(0.7);
            this.installedAddOnsPanel.add((Component)split, LayoutHelper.getGBC(0, row++, 5, 1.0, 1.0));
            this.installedAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, row, 1, 1.0));
            this.installedAddOnsPanel.add((Component)this.getUninstallButton(), LayoutHelper.getGBC(1, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateButton(), LayoutHelper.getGBC(2, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getUpdateAllButton(), LayoutHelper.getGBC(3, row, 1, 0.0));
            this.installedAddOnsPanel.add((Component)this.getClose1Button(), LayoutHelper.getGBC(4, row, 1, 0.0));
        }
        return this.installedAddOnsPanel;
    }

    private JPanel getUninstalledAddOnsPanel() {
        if (this.uninstalledAddOnsPanel == null) {
            this.uninstalledAddOnsPanel = new JPanel();
            this.uninstalledAddOnsPanel.setLayout(new GridBagLayout());
            this.uninstalledAddOnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("cfu.label.addons.border"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            if (this.latestInfo != null) {
                this.getMarketplaceCardLayout().show(this.getMarketplacePanel(), MARKETPLACE_PANEL);
            }
            int row = 0;
            int column = 0;
            this.uninstalledAddOnsPanel.add((Component)this.getMarketplacePanel(), LayoutHelper.getGBC(column, row++, 5, 1.0, 1.0));
            if (Constant.isDevMode()) {
                this.uninstalledAddOnsPanel.add((Component)this.getInstallAllButton(), LayoutHelper.getGBC(column++, row, 1, 0.0));
            }
            this.uninstalledAddOnsPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(column++, row, 1, 1.0));
            this.uninstalledAddOnsPanel.add((Component)this.getInstallButton(), LayoutHelper.getGBC(column++, row, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getAddOnInfoButton(), LayoutHelper.getGBC(column++, row, 1, 0.0));
            this.uninstalledAddOnsPanel.add((Component)this.getClose2Button(), LayoutHelper.getGBC(column, row, 1, 0.0));
        }
        return this.uninstalledAddOnsPanel;
    }

    private JPanel getMarketplacePanel() {
        if (this.marketplacePanel == null) {
            this.marketplacePanel = new JPanel(this.getMarketplaceCardLayout());
            JSplitPane marketplaceSplitPane = new JSplitPane(0);
            JScrollPane uninstalledAddOnsScrollPane = new JScrollPane((Component)((Object)this.getUninstalledAddOnsTable()));
            uninstalledAddOnsScrollPane.setHorizontalScrollBarPolicy(31);
            marketplaceSplitPane.setTopComponent(uninstalledAddOnsScrollPane);
            AddOnDetailsPanel addonDetailsPanel = new AddOnDetailsPanel();
            this.getUninstalledAddOnsTable().getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedRow = this.getUninstalledAddOnsTable().getSelectedRow();
                if (selectedRow != -1) {
                    addonDetailsPanel.setDetails(((AddOnWrapper)this.uninstalledAddOnsModel.getValueAt(this.getUninstalledAddOnsTable().convertRowIndexToModel(selectedRow), -1)).getAddOn());
                } else {
                    addonDetailsPanel.clearDetails();
                }
            });
            marketplaceSplitPane.setBottomComponent(addonDetailsPanel);
            marketplaceSplitPane.setResizeWeight(0.7);
            JPanel addOnsPanel = new JPanel(new BorderLayout());
            addOnsPanel.add(new TableFilterPanel<ZapTable>(this.getUninstalledAddOnsTable()), "First");
            addOnsPanel.add((Component)marketplaceSplitPane, "Center");
            this.marketplacePanel.add((Component)this.getRetrievePanel(), RETRIEVE_PANEL);
            this.marketplacePanel.add((Component)addOnsPanel, MARKETPLACE_PANEL);
        }
        return this.marketplacePanel;
    }

    private CardLayout getMarketplaceCardLayout() {
        if (this.marketplaceCardLayout == null) {
            this.marketplaceCardLayout = new CardLayout();
        }
        return this.marketplaceCardLayout;
    }

    private JPanel getRetrievePanel() {
        if (this.retrievePanel == null) {
            this.retrievePanel = new JPanel();
            this.retrievePanel.setLayout(new GridBagLayout());
            JButton retrieveButton = new JButton();
            retrieveButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            retrieveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.checkForUpdates(false);
                }
            });
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.retrievePanel.add((Component)retrieveButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(2, 0, 1, 1.0));
            this.retrievePanel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, 1, 3, 1.0, 1.0));
        }
        return this.retrievePanel;
    }

    protected void setPreviousVersionInfo(AddOnCollection prevInfo) {
        this.prevInfo = prevInfo;
    }

    protected void setLatestVersionInfo(AddOnCollection latestInfo) {
        this.latestInfo = latestInfo;
        this.getCorePanel(true);
        if (latestInfo != null) {
            this.installedAddOnsModel.setAvailableAddOns(latestInfo);
            this.uninstalledAddOnsModel.setAddOnCollection(latestInfo);
            List<AddOn> addOnsNotInstalled = this.installedAddOnsModel.updateEntries();
            this.uninstalledAddOnsModel.setAddOns(addOnsNotInstalled, this.prevInfo);
        }
        this.getMarketplaceCardLayout().show(this.getMarketplacePanel(), MARKETPLACE_PANEL);
    }

    private ZapTable getInstalledAddOnsTable() {
        if (this.installedAddOnsTable == null) {
            this.installedAddOnsTable = ManageAddOnsDialog.createCustomZapTable();
            this.installedAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ManageAddOnsDialog.this.getUpdateButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUpdateSelected());
                    ManageAddOnsDialog.this.getUpdateAllButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates().size() > 0);
                    ManageAddOnsDialog.this.getUninstallButton().setEnabled(ManageAddOnsDialog.this.installedAddOnsModel.canUninstallSelected());
                }
            });
            this.installedAddOnsTable.setModel(this.installedAddOnsModel);
            this.installedAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.installedAddOnsTable.getColumnExt(0).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            this.installedAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(60);
            this.installedAddOnsTable.getColumnExt(2).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(400);
            this.installedAddOnsTable.getColumnExt(3).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.installedAddOnsTable.getColumnExt(4).setSortable(false);
            this.installedAddOnsTable.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.installedAddOnsTable.getColumnExt(5).setSortable(false);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            this.installedAddOnsTable.getRowSorter().setSortKeys(sortKeys);
            this.installedAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.installedAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(3).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningUpdateIssuesHighlighter(-1), new WarningUpdateIssuesToolTipHighlighter(-1)})});
            this.installedAddOnsTable.getColumnExt(4).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.installedAddOnsTable;
    }

    private static ZapTable createCustomZapTable() {
        ZapTable zapTable = new ZapTable(){
            private static final long serialVersionUID = 1L;

            @Override
            protected ZapTable.AutoScrollAction createAutoScrollAction() {
                return null;
            }
        };
        zapTable.setAutoScrollOnNewValues(false);
        return zapTable;
    }

    private ZapTable getUninstalledAddOnsTable() {
        if (this.uninstalledAddOnsTable == null) {
            this.uninstalledAddOnsTable = ManageAddOnsDialog.createCustomZapTable();
            this.uninstalledAddOnsModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ManageAddOnsDialog.this.getInstallButton().setEnabled(ManageAddOnsDialog.this.uninstalledAddOnsModel.canIinstallSelected());
                    ManageAddOnsDialog.this.getInstallAllButton().setEnabled(ManageAddOnsDialog.this.uninstalledAddOnsModel.hasAvailableAddOns());
                }
            });
            this.uninstalledAddOnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AddOnWrapper ao;
                    ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(false);
                    if (DesktopUtils.canOpenUrlInBrowser() && ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRowCount() == 1 && (ao = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().convertRowIndexToModel(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow()))) != null && ao.getAddOn().getInfo() != null) {
                        ManageAddOnsDialog.this.getAddOnInfoButton().setEnabled(true);
                    }
                }
            });
            this.uninstalledAddOnsTable.setModel(this.uninstalledAddOnsModel);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(0).setMaxWidth(20);
            this.uninstalledAddOnsTable.getColumnExt(0).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(3).setPreferredWidth(300);
            this.uninstalledAddOnsTable.getColumnExt(3).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(4).setPreferredWidth(60);
            this.uninstalledAddOnsTable.getColumnExt(4).setSortable(false);
            this.uninstalledAddOnsTable.getColumnModel().getColumn(5).setPreferredWidth(40);
            this.uninstalledAddOnsTable.getColumnExt(5).setSortable(false);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(2);
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
            sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            this.uninstalledAddOnsTable.getRowSorter().setSortKeys(sortKeys);
            this.uninstalledAddOnsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.uninstalledAddOnsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new CompoundHighlighter(new Highlighter[]{new WarningRunningIssuesHighlighter(-1), new WarningRunningIssuesToolTipHighlighter(-1)})});
            this.uninstalledAddOnsTable.getColumnExt(5).addHighlighter((Highlighter)new DisableSelectionHighlighter(-1));
        }
        return this.uninstalledAddOnsTable;
    }

    private JLabel getUpdatesMessage() {
        if (this.updatesMessage == null) {
            this.updatesMessage = new JLabel(" ");
        }
        return this.updatesMessage;
    }

    private JButton getCoreNotesButton() {
        if (this.coreNotesButton == null) {
            this.coreNotesButton = new JButton();
            this.coreNotesButton.setIcon(new ImageIcon(ManageAddOnsDialog.class.getResource("/resource/icon/16/022.png")));
            this.coreNotesButton.setToolTipText(Constant.messages.getString("cfu.button.zap.relnotes"));
            final ManageAddOnsDialog dialog = this;
            this.coreNotesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] strs;
                    URL url = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotesUrl();
                    if (url != null && DesktopUtils.canOpenUrlInBrowser() && DesktopUtils.openUrlInBrowser(url.toString())) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(Constant.messages.getString("cfu.title.relnotes", ManageAddOnsDialog.this.latestInfo.getZapRelease().getVersion()));
                    for (String s : strs = ManageAddOnsDialog.this.latestInfo.getZapRelease().getReleaseNotes().split("\n")) {
                        sb.append(s.replace("&lt;", "<").trim());
                    }
                    sb.append("</html>");
                    View.getSingleton().showMessageDialog(dialog, sb.toString());
                }
            });
        }
        return this.coreNotesButton;
    }

    private JButton getClose1Button() {
        if (this.close1Button == null) {
            this.close1Button = new JButton();
            this.close1Button.setText(Constant.messages.getString("all.button.close"));
            this.close1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close1Button;
    }

    private JButton getClose2Button() {
        if (this.close2Button == null) {
            this.close2Button = new JButton();
            this.close2Button.setText(Constant.messages.getString("all.button.close"));
            this.close2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.dispose();
                }
            });
        }
        return this.close2Button;
    }

    private JLabel getDownloadProgress() {
        if (this.downloadProgress == null) {
            this.downloadProgress = new JLabel("");
        }
        return this.downloadProgress;
    }

    private JButton getCheckForUpdatesButton() {
        if (this.checkForUpdatesButton == null) {
            this.checkForUpdatesButton = new JButton();
            this.checkForUpdatesButton.setText(Constant.messages.getString("cfu.button.checkForUpdates"));
            this.checkForUpdatesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.checkForUpdates(false);
                }
            });
        }
        return this.checkForUpdatesButton;
    }

    protected void checkForUpdates(boolean force) {
        this.setCursor(new Cursor(3));
        this.extension.getLatestVersionInfo(this, force);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private JButton getDownloadZapButton() {
        if (this.downloadZapButton == null) {
            this.downloadZapButton = new JButton();
            if (Constant.isKali()) {
                this.getDownloadZapButton().setText(Constant.messages.getString("cfu.button.zap.options"));
            } else {
                this.downloadZapButton.setText(Constant.messages.getString("cfu.button.zap.download"));
            }
            this.downloadZapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ManageAddOnsDialog.this.extension.downloadLatestRelease()) {
                        ManageAddOnsDialog.this.setDownloadingZap();
                    }
                }
            });
        }
        return this.downloadZapButton;
    }

    protected void setDownloadingZap() {
        this.downloadZapButton.setEnabled(false);
        this.getUpdateButton().setEnabled(false);
        this.getUpdateAllButton().setEnabled(false);
        this.state = State.DOWNLOADING_ZAP;
        this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.zap.downloading"));
    }

    protected void setDownloadingUpdates() {
        if (EventQueue.isDispatchThread()) {
            this.getDownloadZapButton().setEnabled(false);
            this.getUpdateButton().setEnabled(false);
            this.getUpdateAllButton().setEnabled(false);
            this.state = State.DOWNLOADING_UPDATES;
            this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloading"));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.setDownloadingUpdates();
                }
            });
        }
    }

    public void notifyAddOnDownloading(AddOn addOn) {
        if (this.installedAddOnsModel.notifyAddOnDownloading(addOn)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloading(addOn);
    }

    public void notifyAddOnDownloadFailed(String url) {
        if (this.installedAddOnsModel.notifyAddOnDownloadFailed(url)) {
            return;
        }
        this.uninstalledAddOnsModel.notifyAddOnDownloadFailed(url);
    }

    public void notifyAddOnInstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            if (this.latestInfo != null && this.latestInfo.getAddOn(addOn.getId()) != null) {
                this.uninstalledAddOnsModel.removeAddOn(addOn);
            }
            this.installedAddOnsModel.addOrRefreshAddOn(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnInstalled(addOn);
                }
            });
        }
    }

    public void notifyAddOnFailedUninstallation(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            this.installedAddOnsModel.notifyAddOnFailedUninstallation(addOn);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnFailedUninstallation(addOn);
                }
            });
        }
    }

    public void notifyAddOnUninstalled(final AddOn addOn) {
        if (EventQueue.isDispatchThread()) {
            AddOn availableAddOn;
            this.installedAddOnsModel.removeAddOn(addOn);
            if (this.latestInfo != null && (availableAddOn = this.latestInfo.getAddOn(addOn.getId())) != null) {
                this.uninstalledAddOnsModel.addAddOn(this.latestInfo.getAddOn(addOn.getId()));
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManageAddOnsDialog.this.notifyAddOnUninstalled(addOn);
                }
            });
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText(Constant.messages.getString("cfu.button.addons.update"));
            this.updateButton.setEnabled(false);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getSelectedUpdates());
                }
            });
        }
        return this.updateButton;
    }

    private JButton getUpdateAllButton() {
        if (this.updateAllButton == null) {
            this.updateAllButton = new JButton();
            this.updateAllButton.setText(Constant.messages.getString("cfu.button.addons.updateAll"));
            this.updateAllButton.setEnabled(false);
            this.updateAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageAddOnsDialog.this.processUpdates(ManageAddOnsDialog.this.installedAddOnsModel.getAllUpdates());
                }
            });
        }
        return this.updateAllButton;
    }

    private void processUpdates(Set<AddOn> updatedAddOns) {
        if (updatedAddOns.isEmpty()) {
            return;
        }
        AddOnDependencyChecker calc = new AddOnDependencyChecker(this.installedAddOns, this.latestInfo);
        AddOnDependencyChecker.AddOnChangesResult result = calc.calculateUpdateChanges(updatedAddOns);
        if (!calc.confirmUpdateChanges(this, result)) {
            return;
        }
        this.extension.processAddOnChanges(this, result);
    }

    private JButton getUninstallButton() {
        if (this.uninstallButton == null) {
            this.uninstallButton = new JButton();
            this.uninstallButton.setText(Constant.messages.getString("cfu.button.addons.uninstall"));
            this.uninstallButton.setEnabled(false);
            this.uninstallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Set<AddOn> selectedAddOns = ManageAddOnsDialog.this.installedAddOnsModel.getSelectedAddOns();
                    if (selectedAddOns.isEmpty()) {
                        return;
                    }
                    Set<AddOn> addOnsBeingDownloaded = ManageAddOnsDialog.this.installedAddOnsModel.getDownloadingAddOns();
                    addOnsBeingDownloaded.addAll(ManageAddOnsDialog.this.uninstalledAddOnsModel.getDownloadingAddOns());
                    AddOnDependencyChecker calc = new AddOnDependencyChecker(ManageAddOnsDialog.this.installedAddOns, ManageAddOnsDialog.this.latestInfo);
                    AddOnDependencyChecker.UninstallationResult changes = calc.calculateUninstallChanges(selectedAddOns);
                    if (!calc.confirmUninstallChanges(ManageAddOnsDialog.this, changes, addOnsBeingDownloaded)) {
                        return;
                    }
                    Set<AddOn> addOns = changes.getUninstallations();
                    Set<Extension> extensions = changes.getExtensions();
                    if (!ManageAddOnsDialog.this.extension.warnUnsavedResourcesOrActiveActions(ManageAddOnsDialog.this, addOns, extensions, false)) {
                        return;
                    }
                    ManageAddOnsDialog.this.extension.uninstallAddOnsWithView(ManageAddOnsDialog.this, addOns, false, new HashSet<AddOn>());
                }
            });
        }
        return this.uninstallButton;
    }

    private JButton getInstallAllButton() {
        if (this.installAllButton == null) {
            this.installAllButton = new JButton();
            this.installAllButton.setEnabled(false);
            this.installAllButton.setText(Constant.messages.getString("cfu.button.addons.installall"));
            this.installAllButton.addActionListener(e -> this.installAddOns(this.uninstalledAddOnsModel.getAvailableAddOns()));
        }
        return this.installAllButton;
    }

    private JButton getInstallButton() {
        if (this.installButton == null) {
            this.installButton = new JButton();
            this.installButton.setText(Constant.messages.getString("cfu.button.addons.install"));
            this.installButton.setEnabled(false);
            this.installButton.addActionListener(e -> this.installAddOns(this.uninstalledAddOnsModel.getSelectedAddOns()));
        }
        return this.installButton;
    }

    private void installAddOns(Set<AddOn> addOns) {
        if (addOns.isEmpty()) {
            return;
        }
        AddOnDependencyChecker calc = new AddOnDependencyChecker(this.installedAddOns, this.latestInfo);
        AddOnDependencyChecker.AddOnChangesResult changes = calc.calculateInstallChanges(addOns);
        if (!calc.confirmInstallChanges(this, changes)) {
            return;
        }
        this.extension.processAddOnChanges(this, changes);
    }

    private JButton getAddOnInfoButton() {
        if (this.addOnInfoButton == null) {
            this.addOnInfoButton = new JButton();
            this.addOnInfoButton.setText(Constant.messages.getString("cfu.button.addons.info"));
            this.addOnInfoButton.setEnabled(false);
            this.addOnInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddOnWrapper ao;
                    if (ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow() >= 0 && (ao = ManageAddOnsDialog.this.uninstalledAddOnsModel.getAddOnWrapper(ManageAddOnsDialog.this.getUninstalledAddOnsTable().convertRowIndexToModel(ManageAddOnsDialog.this.getUninstalledAddOnsTable().getSelectedRow()))) != null && ao.getAddOn().getInfo() != null) {
                        DesktopUtils.openUrlInBrowser(ao.getAddOn().getInfo().toString());
                    }
                }
            });
        }
        return this.addOnInfoButton;
    }

    public void showProgress() {
        if (this.state.equals((Object)State.DOWNLOADING_UPDATES)) {
            this.installedAddOnsModel.updateDownloadsProgresses(this.extension);
            this.uninstalledAddOnsModel.updateDownloadsProgresses(this.extension);
            if (this.extension.getCurrentDownloadCount() == 0) {
                this.state = State.DOWNLOADED_UPDATES;
                this.getDownloadZapButton().setEnabled(true);
                this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.upd.downloaded"));
            }
        } else if (this.state.equals((Object)State.DOWNLOADING_ZAP)) {
            try {
                int progress = this.extension.getDownloadProgressPercent(this.latestInfo.getZapRelease().getUrl());
                if (progress > 0) {
                    this.getDownloadProgress().setText(progress + "%");
                    if (progress >= 100) {
                        this.zapDownloadComplete();
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Error on " + this.latestInfo.getZapRelease().getUrl()), (Throwable)e);
                this.getDownloadProgress().setText(Constant.messages.getString("cfu.table.label.failed"));
            }
        }
    }

    private void zapDownloadComplete() {
        if (this.state.equals((Object)State.DOWNLOADED_ZAP)) {
            return;
        }
        this.state = State.DOWNLOADED_ZAP;
        File f = new File(Constant.FOLDER_LOCAL_PLUGIN, this.latestInfo.getZapRelease().getFileName());
        if (Desktop.isDesktopSupported()) {
            this.extension.promptToLaunchReleaseAndClose(this.latestInfo.getZapRelease().getVersion(), f);
        } else {
            View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.warn.nolaunch", this.latestInfo.getZapRelease().getVersion(), f.getAbsolutePath()));
        }
        this.getUpdateButton().setEnabled(true);
        this.getUpdateAllButton().setEnabled(true);
        this.getUpdatesMessage().setText(Constant.messages.getString("cfu.check.zap.downloaded", f.getAbsolutePath()));
    }

    @Override
    public void gotLatestData(AddOnCollection aoc) {
        logger.debug((Object)("gotLatestData(AddOnCollection " + aoc));
        if (aoc != null) {
            EventQueue.invokeLater(() -> this.setLatestVersionInfo(aoc));
        } else {
            View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.check.failed"));
        }
    }

    @Override
    public void insecureUrl(String url, Exception cause) {
        logger.error((Object)("Failed to get check for updates on " + url), (Throwable)cause);
        View.getSingleton().showWarningDialog(this, Constant.messages.getString("cfu.warn.badurl"));
    }

    private static ZapLabel createZapLabelField(JLabel label) {
        ZapLabel field = new ZapLabel();
        field.setLineWrap(true);
        field.setWrapStyleWord(true);
        label.setLabelFor(field);
        return field;
    }

    private static void setTextOrHide(JLabel label, JTextComponent textComponent, String text) {
        boolean visible = !text.isEmpty();
        label.setVisible(visible);
        textComponent.setVisible(visible);
        textComponent.setText(text);
    }

    private static void setUriOrHide(JLabel label, JXHyperlink hyperlink, URL url) {
        boolean visible = url != null;
        label.setVisible(visible);
        hyperlink.setVisible(visible);
        hyperlink.setURI(visible ? URI.create(url.toString()) : null);
    }

    private class WarningUpdateIssuesToolTipHighlighter
    extends AbstractAddOnToolTipHighlighter {
        public WarningUpdateIssuesToolTipHighlighter(int column) {
            super(column);
        }

        @Override
        protected String getToolTip(AddOnWrapper aow) {
            return aow.hasUpdateIssues() ? aow.getUpdateIssues() : null;
        }
    }

    private class WarningRunningIssuesToolTipHighlighter
    extends AbstractAddOnToolTipHighlighter {
        public WarningRunningIssuesToolTipHighlighter(int column) {
            super(column);
        }

        @Override
        protected String getToolTip(AddOnWrapper aow) {
            return aow.hasRunningIssues() ? aow.getRunningIssues() : null;
        }
    }

    private abstract class AbstractAddOnToolTipHighlighter
    extends AbstractHighlighter {
        private final int column;

        public AbstractAddOnToolTipHighlighter(int column) {
            this.column = column;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            ((JComponent)component).setToolTipText(this.getToolTip((AddOnWrapper)adapter.getValue(this.column)));
            return component;
        }

        protected abstract String getToolTip(AddOnWrapper var1);
    }

    private static class WarningUpdateIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningUpdateIssuesHighlighter(int columnIndex) {
            this.columnIndex = columnIndex;
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    AddOnWrapper aow = (AddOnWrapper)adapter.getValue(columnIndex);
                    if (AddOnWrapper.Status.newVersion == aow.getStatus()) {
                        return aow.hasUpdateIssues();
                    }
                    return false;
                }
            });
        }

        public Icon getIcon(ComponentAdapter adapter) {
            AddOnWrapper aow = (AddOnWrapper)adapter.getValue(this.columnIndex);
            if (aow.isAddOnUpdateIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(adapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(adapter));
            }
            return component;
        }
    }

    private static class WarningRunningIssuesHighlighter
    extends IconHighlighter {
        private final int columnIndex;

        public WarningRunningIssuesHighlighter(int columnIndex) {
            this.columnIndex = columnIndex;
            this.setHighlightPredicate((HighlightPredicate)new HighlightPredicate.EqualsHighlightPredicate((Object)Boolean.TRUE));
        }

        public Icon getIcon(ComponentAdapter adapter) {
            AddOnWrapper aow = (AddOnWrapper)adapter.getValue(this.columnIndex);
            if (aow.isAddOnRunningIssues()) {
                return ICON_ADD_ON_ISSUES;
            }
            return ICON_ADD_ON_EXTENSION_ISSUES;
        }

        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            if (component instanceof IconAware) {
                ((IconAware)component).setIcon(this.getIcon(adapter));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon(adapter));
            }
            return component;
        }
    }

    private static class DisableSelectionHighlighter
    extends AbstractHighlighter {
        public DisableSelectionHighlighter(final int columnIndex) {
            this.setHighlightPredicate(new HighlightPredicate(){

                public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                    AddOn.InstallationStatus status = ((AddOnWrapper)adapter.getValue(columnIndex)).getInstallationStatus();
                    return AddOn.InstallationStatus.UNINSTALLATION_FAILED == status || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == status || AddOn.InstallationStatus.DOWNLOADING == status;
                }
            });
        }

        protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
            renderer.setEnabled(false);
            return renderer;
        }
    }

    private class AddOnDetailsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final String DETAILS_PANEL = "DetailsPanel";
        private static final String NO_DETAILS_PANEL = "NoDetailsPanel";
        private final ZapLabel nameField;
        private final ZapLabel statusField;
        private final ZapLabel versionField;
        private final JLabel descLabel;
        private final ZapLabel descField;
        private final JLabel changesLabel;
        private final JEditorPane changesField;
        private final JLabel infoLabel;
        private final JXHyperlink infoField;
        private final JLabel repoLabel;
        private final JXHyperlink repoField;
        private final ZapLabel idField;
        private final JLabel authorLabel;
        private final ZapLabel authorField;
        private final JLabel dependenciesLabel;
        private final ZapLabel dependenciesField;
        private final JLabel notBeforeVersionLabel;
        private final ZapLabel notBeforeVersionField;
        private final JLabel notFromVersionLabel;
        private final ZapLabel notFromVersionField;
        private final JLabel fileLabel;
        private final ZapLabel fileField;
        private final CardLayout cardLayout;

        public AddOnDetailsPanel() {
            JXPanel contentPanel = new JXPanel();
            contentPanel.setScrollableHeightHint(ScrollableSizeHint.NONE);
            JScrollPane contentScrollPane = new JScrollPane((Component)contentPanel);
            contentScrollPane.setHorizontalScrollBarPolicy(31);
            GroupLayout layout = new GroupLayout((Container)contentPanel);
            contentPanel.setLayout((LayoutManager)layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            JLabel nameLabel = new JLabel(Constant.messages.getString("cfu.table.header.name"));
            this.nameField = ManageAddOnsDialog.createZapLabelField(nameLabel);
            JLabel statusLabel = new JLabel(Constant.messages.getString("cfu.table.header.status"));
            this.statusField = ManageAddOnsDialog.createZapLabelField(statusLabel);
            JLabel versionLabel = new JLabel(Constant.messages.getString("cfu.table.header.version"));
            this.versionField = ManageAddOnsDialog.createZapLabelField(versionLabel);
            this.descLabel = new JLabel(Constant.messages.getString("cfu.table.header.desc"));
            this.descField = ManageAddOnsDialog.createZapLabelField(this.descLabel);
            this.changesLabel = new JLabel(Constant.messages.getString("cfu.table.header.changes"));
            this.changesField = new JEditorPane();
            this.changesLabel.setLabelFor(this.changesField);
            this.changesField.setEditable(false);
            this.changesField.setContentType("text/html; charset=UTF-8");
            this.changesField.addHyperlinkListener(evt -> {
                if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.changesField.setToolTipText(evt.getURL().toString());
                } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    this.changesField.setToolTipText(null);
                } else if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException e) {
                        logger.warn((Object)("Failed to open the URL: " + evt.getURL()), (Throwable)e);
                    }
                }
            });
            ((DefaultCaret)this.changesField.getCaret()).setUpdatePolicy(1);
            this.infoLabel = new JLabel(Constant.messages.getString("cfu.table.header.info"));
            this.infoField = new JXHyperlink();
            this.infoLabel.setLabelFor((Component)this.infoField);
            this.repoLabel = new JLabel(Constant.messages.getString("cfu.table.header.repo"));
            this.repoField = new JXHyperlink();
            this.repoLabel.setLabelFor((Component)this.repoField);
            JLabel idLabel = new JLabel(Constant.messages.getString("cfu.table.header.id"));
            this.idField = ManageAddOnsDialog.createZapLabelField(idLabel);
            this.authorLabel = new JLabel(Constant.messages.getString("cfu.table.header.author"));
            this.authorField = ManageAddOnsDialog.createZapLabelField(this.authorLabel);
            this.dependenciesLabel = new JLabel(Constant.messages.getString("cfu.table.header.dependencies"));
            this.dependenciesField = ManageAddOnsDialog.createZapLabelField(this.dependenciesLabel);
            this.notBeforeVersionLabel = new JLabel(Constant.messages.getString("cfu.table.header.notbefore"));
            this.notBeforeVersionField = ManageAddOnsDialog.createZapLabelField(this.notBeforeVersionLabel);
            this.notFromVersionLabel = new JLabel(Constant.messages.getString("cfu.table.header.notfrom"));
            this.notFromVersionField = ManageAddOnsDialog.createZapLabelField(this.notFromVersionLabel);
            this.fileLabel = new JLabel(Constant.messages.getString("cfu.table.header.file"));
            this.fileField = ManageAddOnsDialog.createZapLabelField(this.notFromVersionLabel);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(nameLabel).addComponent(statusLabel).addComponent(versionLabel).addComponent(this.descLabel).addComponent(this.changesLabel).addComponent(this.infoLabel).addComponent(this.repoLabel).addComponent(idLabel).addComponent(this.authorLabel).addComponent(this.dependenciesLabel).addComponent(this.notBeforeVersionLabel).addComponent(this.notFromVersionLabel).addComponent(this.fileLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, 0, -1, Short.MAX_VALUE).addComponent(this.statusField, 0, -1, Short.MAX_VALUE).addComponent(this.versionField, 0, -1, Short.MAX_VALUE).addComponent(this.descField, 0, -1, Short.MAX_VALUE).addComponent(this.changesField, 0, -1, Short.MAX_VALUE).addComponent((Component)this.infoField, 0, -1, Short.MAX_VALUE).addComponent((Component)this.repoField, 0, -1, Short.MAX_VALUE).addComponent(this.idField, 0, -1, Short.MAX_VALUE).addComponent(this.authorField, 0, -1, Short.MAX_VALUE).addComponent(this.dependenciesField, 0, -1, Short.MAX_VALUE).addComponent(this.notBeforeVersionField, 0, -1, Short.MAX_VALUE).addComponent(this.notFromVersionField, 0, -1, Short.MAX_VALUE).addComponent(this.fileField, 0, -1, Short.MAX_VALUE)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.nameField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(statusLabel).addComponent(this.statusField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(versionLabel).addComponent(this.versionField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descLabel).addComponent(this.descField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.changesLabel).addComponent(this.changesField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.infoLabel).addComponent((Component)this.infoField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repoLabel).addComponent((Component)this.repoField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(idLabel).addComponent(this.idField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dependenciesLabel).addComponent(this.dependenciesField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.notBeforeVersionLabel).addComponent(this.notBeforeVersionField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.notFromVersionLabel).addComponent(this.notFromVersionField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileField)));
            this.cardLayout = new CardLayout();
            this.setLayout(this.cardLayout);
            JPanel noDetailsPanel = new JPanel(new BorderLayout());
            noDetailsPanel.add(new JLabel(Constant.messages.getString("cfu.label.selectAddOnForDetails"), 0));
            this.add((Component)noDetailsPanel, NO_DETAILS_PANEL);
            JPanel detailsPanel = new JPanel(new BorderLayout());
            detailsPanel.add(contentScrollPane);
            this.add((Component)detailsPanel, DETAILS_PANEL);
        }

        public void setDetails(AddOn addOn) {
            this.cardLayout.show(this, DETAILS_PANEL);
            this.nameField.setText(addOn.getName());
            this.statusField.setText(Constant.messages.getString("cfu.status." + addOn.getStatus().name()));
            this.versionField.setText(addOn.getVersion().toString());
            ManageAddOnsDialog.setTextOrHide(this.descLabel, this.descField, addOn.getDescription());
            ManageAddOnsDialog.setTextOrHide(this.changesLabel, this.changesField, addOn.getChanges());
            ManageAddOnsDialog.setUriOrHide(this.infoLabel, this.infoField, addOn.getInfo());
            ManageAddOnsDialog.setUriOrHide(this.repoLabel, this.repoField, addOn.getRepo());
            this.idField.setText(addOn.getId());
            ManageAddOnsDialog.setTextOrHide(this.authorLabel, this.authorField, addOn.getAuthor());
            ManageAddOnsDialog.setTextOrHide(this.dependenciesLabel, this.dependenciesField, addOn.getIdsAddOnDependencies().isEmpty() ? "" : addOn.getIdsAddOnDependencies().stream().map(addOnId -> {
                AddOn dep = ManageAddOnsDialog.this.installedAddOns.getAddOn((String)addOnId);
                if (dep == null && ManageAddOnsDialog.this.latestInfo != null) {
                    dep = ManageAddOnsDialog.this.latestInfo.getAddOn((String)addOnId);
                }
                return dep != null ? dep.getName() : addOnId;
            }).collect(Collectors.joining(",")));
            ManageAddOnsDialog.setTextOrHide(this.notBeforeVersionLabel, this.notBeforeVersionField, addOn.getNotBeforeVersion());
            ManageAddOnsDialog.setTextOrHide(this.notFromVersionLabel, this.notFromVersionField, addOn.getNotFromVersion());
            if (ManageAddOnsDialog.this.extension.getLocalAddOns().contains(addOn)) {
                this.fileLabel.setVisible(true);
                this.fileField.setText(addOn.getFile().toString());
                this.fileField.setVisible(true);
            } else {
                this.fileLabel.setVisible(false);
                this.fileField.setText("");
                this.fileField.setVisible(false);
            }
        }

        public void clearDetails() {
            this.cardLayout.show(this, NO_DETAILS_PANEL);
            this.nameField.setText("");
            this.statusField.setText("");
            this.versionField.setText("");
            this.descField.setText("");
            this.changesField.setText("");
            this.infoField.setText("");
            this.repoField.setText("");
            this.idField.setText("");
            this.authorField.setText("");
            this.dependenciesField.setText("");
            this.notBeforeVersionField.setText("");
            this.notFromVersionField.setText("");
            this.fileField.setText("");
        }
    }

    protected static enum State {
        IDLE,
        DOWNLOADING_ZAP,
        DOWNLOADED_ZAP,
        DOWNLOADING_UPDATES,
        DOWNLOADED_UPDATES;

    }
}

