/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.w3c.css.atrules.css.AtRuleImport;
import org.w3c.css.atrules.css.AtRuleMedia;
import org.w3c.css.atrules.css.AtRuleNamespace;
import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssPropertyFactory;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssValidatorListener;
import org.w3c.css.parser.Errors;
import org.w3c.css.parser.Frame;
import org.w3c.css.parser.analyzer.CssParser;
import org.w3c.css.parser.analyzer.CssParserTokenManager;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.util.Warnings;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public final class CssFouffa
extends CssParser {
    CssPropertyFactory properties = null;
    ArrayList<CssValidatorListener> listeners;
    Errors errors;
    int origin;
    ArrayList<String> visited = null;

    public CssFouffa(ApplContext ac, Reader reader, URL file, int beginLine) throws IOException {
        super(reader);
        String spec;
        String classStyle;
        if (ac.getOrigin() == -1) {
            this.setOrigin(3);
        } else {
            this.setOrigin(ac.getOrigin());
        }
        ac.setFrame(new Frame(this, file.toString(), beginLine, ac.getWarningLevel()));
        this.setApplContext(ac);
        this.setURL(file);
        if (Util.onDebug) {
            System.err.println("[DEBUG] CSS version " + ac.getCssVersionString() + " medium " + ac.getMedium() + " at-rule " + this.getAtRule() + " profile " + ac.getProfileString());
        }
        if ((classStyle = PropertiesLoader.config.getProperty(spec = ac.getPropertyKey())) == null) {
            spec = CssVersion.getDefault().toString();
            classStyle = PropertiesLoader.config.getProperty(spec);
        }
        try {
            Class<?> style = Class.forName(classStyle);
            ac.setCssSelectorsStyle(style);
        }
        catch (ClassNotFoundException e) {
            System.err.println("org.w3c.css.parser.CssFouffa: couldn't load the style");
            e.printStackTrace();
        }
        this.properties = new CssPropertyFactory(spec);
        this.listeners = new ArrayList();
    }

    public CssFouffa(ApplContext ac, InputStream input, String charset, URL file, int beginLine) throws IOException {
        this(ac, new InputStreamReader(input, charset == null ? "iso-8859-1" : charset), file, beginLine);
    }

    public CssFouffa(ApplContext ac, InputStream input, URL file) throws IOException {
        this(ac, input, ac.getCharsetForURL(file) != null ? ac.getCharsetForURL(file) : "iso-8859-1", file, 0);
    }

    public CssFouffa(ApplContext ac, URL file) throws IOException {
        this(ac, HTTPURL.getConnection(file, ac));
    }

    private CssFouffa(ApplContext ac, URLConnection uco) throws IOException {
        this(ac, HTTPURL.getInputStream(ac, uco), HTTPURL.getCharacterEncoding(ac, uco), uco.getURL(), 0);
        String httpCL = uco.getHeaderField("Content-Location");
        if (httpCL != null) {
            this.setURL(HTTPURL.getURL(this.getURL(), httpCL));
        }
    }

    private CssFouffa(ApplContext ac, InputStream in, URL url, ArrayList<CssValidatorListener> listeners, ArrayList<String> urlvisited, CssPropertyFactory cssfactory, boolean mode) throws IOException {
        this(ac, in, ac.getCharsetForURL(url), url, 0);
        this.visited = urlvisited;
        this.setURL(url);
        ac.setFrame(new Frame(this, url.toString(), ac.getWarningLevel()));
        this.setApplContext(ac);
        this.listeners = listeners;
        this.properties = cssfactory;
        this.mode = mode;
    }

    private void ReInit(ApplContext ac, InputStream input, URL file, Frame frame) {
        String spec;
        String classStyle;
        super.ReInitWithAc(input, ac, ac.getCharsetForURL(file));
        this.setURL(file);
        if (Util.onDebug) {
            System.err.println("[DEBUG] CSS version " + ac.getCssVersionString() + " medium " + ac.getMedium() + " profile " + ac.getProfileString());
        }
        if ((classStyle = PropertiesLoader.config.getProperty(spec = ac.getPropertyKey())) == null) {
            spec = CssVersion.getDefault().toString();
            classStyle = PropertiesLoader.config.getProperty(spec);
        }
        try {
            Class<?> style = Class.forName(classStyle);
            ac.setCssSelectorsStyle(style);
        }
        catch (ClassNotFoundException e) {
            System.err.println("org.w3c.css.parser.CssFouffa: couldn't load the style");
            e.printStackTrace();
        }
        this.properties = new CssPropertyFactory(spec);
    }

    public void ReInit(ApplContext ac, InputStream input, URL file, int beginLine) throws IOException {
        Frame f = new Frame(this, file.toString(), beginLine, ac.getWarningLevel());
        ac.setFrame(f);
        this.ReInit(ac, input, file, f);
    }

    public void ReInit(ApplContext ac, InputStream input, URL file) throws IOException {
        Frame f = new Frame(this, file.toString(), ac.getWarningLevel());
        ac.setFrame(f);
        this.ReInit(ac, input, file, f);
    }

    public void ReInit(ApplContext ac, URL file) throws IOException {
        URL url;
        InputStream is;
        Frame f = new Frame(this, file.toString(), ac.getWarningLevel());
        ac.setFrame(f);
        if (ac.isInputFake()) {
            is = ac.getFakeInputStream(file);
            url = file;
        } else {
            URLConnection urlC = HTTPURL.getConnection(file, ac);
            is = HTTPURL.getInputStream(ac, urlC);
            url = urlC.getURL();
        }
        this.ReInit(ac, is, url, f);
    }

    private final void setOrigin(int origin) {
        this.origin = origin;
    }

    public final int getOrigin() {
        return this.origin;
    }

    public final void addListener(CssValidatorListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(CssValidatorListener listener) {
        this.listeners.remove(listener);
    }

    public void parseStyle() {
        try {
            this.parserUnit();
        }
        catch (TokenMgrError e) {
            throw e;
        }
        catch (Throwable e) {
            if (Util.onDebug) {
                e.printStackTrace();
            }
            RuntimeException ne = new RuntimeException(e.getMessage());
            ne.fillInStackTrace();
            throw ne;
        }
        Errors errors = this.ac.getFrame().getErrors();
        Warnings warnings = this.ac.getFrame().getWarnings();
        for (CssValidatorListener listener : this.listeners) {
            listener.notifyErrors(errors);
            listener.notifyWarnings(warnings);
        }
    }

    @Override
    public void handleNamespaceDeclaration(URL url, String prefix, String nsname, boolean is_url) {
        AtRuleNamespace nsrule = new AtRuleNamespace(prefix, nsname, is_url);
        this.newAtRule(nsrule);
        this.endOfAtRule();
        this.ac.setNamespace(url, prefix, nsname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleImport(URL url, String file, boolean is_url, AtRuleMedia media) {
        block22: {
            URL importedURL;
            AtRuleImport importrule = new AtRuleImport(file, is_url, media);
            this.newAtRule(importrule);
            this.endOfAtRule();
            try {
                importedURL = HTTPURL.getURL(url, file);
            }
            catch (MalformedURLException mue) {
                if (!Util.noErrorTrace) {
                    this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), mue));
                }
                return;
            }
            if (!is_url) {
                this.ac.addLinkedURI(importedURL);
            }
            if (!this.ac.followlinks()) {
                return;
            }
            if (url.getProtocol().equals("file")) {
                this.ac.getFrame().addWarning("unsupported-import");
                return;
            }
            try {
                String surl = importedURL.toString();
                if (this.visited == null) {
                    this.visited = new ArrayList();
                } else {
                    if (this.visited.contains(surl)) {
                        CssError cerr = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new Exception("Import loop detected in " + surl));
                        this.ac.getFrame().addError(cerr);
                        return;
                    }
                    if (this.visited.size() > 42) {
                        CssError cerr = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), new Exception("Maximum number of imports reached"));
                        this.ac.getFrame().addError(cerr);
                        return;
                    }
                }
                ArrayList<String> newVisited = new ArrayList<String>(this.visited);
                newVisited.add(surl);
                if (Util.importSecurity) {
                    throw new FileNotFoundException("[SECURITY] You can't import URL sorry.");
                }
                URLConnection importURL = HTTPURL.getConnection(importedURL, this.ac);
                String charset = HTTPURL.getCharacterEncoding(this.ac, importURL);
                if (importURL instanceof HttpURLConnection) {
                    String mtype;
                    HttpURLConnection httpURL = (HttpURLConnection)importURL;
                    String httpCL = httpURL.getHeaderField("Content-Location");
                    if (httpCL != null) {
                        importedURL = HTTPURL.getURL(importedURL, httpCL);
                    }
                    if ((mtype = httpURL.getContentType()) == null) {
                        throw new FileNotFoundException(importURL.getURL() + "No Media Type defined");
                    }
                    if (mtype.toLowerCase().indexOf("text/html") != -1) {
                        throw new FileNotFoundException(importURL.getURL() + ": You can't import an HTML document");
                    }
                }
                Frame f = this.ac.getFrame();
                try {
                    CssFouffa cssFouffa = new CssFouffa(this.ac, HTTPURL.getInputStream(this.ac, importURL), importedURL, this.listeners, newVisited, this.properties, this.mode);
                    cssFouffa.setOrigin(this.getOrigin());
                    if (!media.isEmpty()) {
                        cssFouffa.setAtRule(media);
                    } else {
                        cssFouffa.setAtRule(this.getAtRule());
                    }
                    cssFouffa.parseStyle();
                }
                finally {
                    this.ac.setFrame(f);
                }
            }
            catch (Exception e) {
                if (Util.noErrorTrace) break block22;
                this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
            }
        }
    }

    @Override
    public void handleAtRule(String ident, String string) {
        if (this.mode) {
            for (CssValidatorListener listener : this.listeners) {
                listener.handleAtRule(this.ac, ident, string);
            }
        } else if (!Util.noErrorTrace) {
            ParseException error = new ParseException("at-rules are not implemented in CSS1");
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), error));
        }
    }

    private boolean allowBackslash9Hack() {
        return this.ac.getTreatCssHacksAsWarnings();
    }

    @Override
    public CssProperty handleDeclaration(String property, CssExpression expression, boolean important) throws InvalidParamException {
        CssProperty prop;
        if (Util.onDebug) {
            System.err.println("Creating " + property + ": " + expression);
        }
        CssValue lastValue = expression.getLastValue();
        if (this.allowBackslash9Hack() && lastValue != null && lastValue.hasBackslash9Hack()) {
            expression.markCssHack();
        }
        try {
            prop = this.properties.createProperty(this.ac, this.getAtRule(), property, expression);
        }
        catch (InvalidParamException e) {
            throw e;
        }
        catch (Exception e) {
            if (Util.onDebug) {
                e.printStackTrace();
            }
            throw new InvalidParamException(e.toString(), this.ac);
        }
        if (important) {
            prop.setImportant();
        }
        prop.setOrigin(this.origin);
        prop.setInfo(this.ac.getFrame().getLine(), this.ac.getFrame().getSourceFile());
        return prop;
    }

    @Override
    public MediaFeature handleMediaFeature(AtRuleMedia rule, String feature, CssExpression expression) throws InvalidParamException {
        MediaFeature mf;
        if (Util.onDebug) {
            System.err.println("Creating MediaFeature" + feature + ": " + expression);
        }
        try {
            mf = this.properties.createMediaFeature(this.ac, rule, feature, expression);
        }
        catch (WarningParamException w) {
            this.ac.getFrame().addWarning(w.getMessage(), feature);
            return null;
        }
        catch (InvalidParamException e) {
            this.ac.getFrame().addError(new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), e));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Util.onDebug) {
                e.printStackTrace();
            }
            throw new InvalidParamException(e.toString(), this.ac);
        }
        mf.setOrigin(this.origin);
        mf.setInfo(this.ac.getFrame().getLine(), this.ac.getFrame().getSourceFile());
        return mf;
    }

    public void parseDeclarations(CssSelectors context) {
        block5: {
            try {
                ArrayList<CssProperty> properties = this.attributeDeclarations();
                if (properties != null && properties.size() != 0) {
                    this.handleRule(context, properties);
                }
            }
            catch (ParseException e) {
                if (Util.noErrorTrace) break block5;
                CssParseException ex = new CssParseException(e);
                ex.skippedString = "";
                ex.property = this.currentProperty;
                ex.contexts = this.currentContext;
                CssError error = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ex);
                this.ac.getFrame().addError(error);
            }
        }
        if (!Util.noErrorTrace) {
            Errors errors = this.ac.getFrame().getErrors();
            Warnings warnings = this.ac.getFrame().getWarnings();
            for (CssValidatorListener listener : this.listeners) {
                listener.notifyErrors(errors);
                listener.notifyWarnings(warnings);
            }
        }
    }

    @Override
    public void newAtRule(AtRule atRule) {
        for (CssValidatorListener listener : this.listeners) {
            listener.newAtRule(atRule);
        }
    }

    @Override
    public void addCharSet(String charset) throws ParseException {
        for (CssValidatorListener listener : this.listeners) {
            listener.addCharSet(charset);
        }
        Charset c = null;
        try {
            c = Charset.forName(charset);
        }
        catch (Exception ex) {
            return;
        }
        boolean charsetFromBOM = this.ac.isCharsetFromBOM(this.getURL());
        if (charsetFromBOM && this.ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0) {
            throw new ParseException(this.ac.getMsg().getString("parser.charset"));
        }
        Charset originalCharset = this.ac.getCharsetObjForURL(this.getURL());
        if (originalCharset == null) {
            this.ac.setCharsetForURL(this.getURL(), c);
            try {
                this.ReInit(this.ac, this.getURL());
            }
            catch (IOException iOException) {}
        } else if (c.compareTo(originalCharset) != 0) {
            InvalidParamException ex = new InvalidParamException("conflicting-charset", new String[]{originalCharset.toString(), charset}, this.ac);
            CssError cerr = new CssError(this.getSourceFile(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), ex);
            this.ac.getFrame().addError(cerr);
        }
    }

    @Override
    public void endOfAtRule() {
        for (CssValidatorListener listener : this.listeners) {
            listener.endOfAtRule();
        }
    }

    @Override
    public void setImportant(boolean important) {
        for (CssValidatorListener listener : this.listeners) {
            listener.setImportant(important);
        }
    }

    @Override
    public void setSelectorList(ArrayList<CssSelectors> selectors) {
        for (CssValidatorListener listener : this.listeners) {
            listener.setSelectorList(selectors);
        }
    }

    @Override
    public void addProperty(ArrayList<CssProperty> properties) {
        for (CssValidatorListener listener : this.listeners) {
            listener.setProperty(properties);
        }
    }

    @Override
    public void endOfRule() {
        for (CssValidatorListener listener : this.listeners) {
            listener.endOfRule();
        }
    }

    @Override
    public void removeThisRule() {
        for (CssValidatorListener listener : this.listeners) {
            listener.removeThisRule();
        }
    }

    @Override
    public void removeThisAtRule() {
        for (CssValidatorListener listener : this.listeners) {
            listener.removeThisAtRule();
        }
    }

    @Override
    public void handleRule(CssSelectors selector, ArrayList<CssProperty> declarations) {
        for (CssValidatorListener listener : this.listeners) {
            listener.handleRule(this.ac, selector, declarations);
        }
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setStyle(Class style) {
        this.ac.setCssSelectorsStyle(style);
    }

    public CssFouffa(InputStream stream) {
        super(stream);
        this.properties = new CssPropertyFactory("css21");
    }

    public CssFouffa(Reader stream) {
        super(stream);
        this.properties = new CssPropertyFactory("css21");
    }

    public CssFouffa(CssParserTokenManager tm) {
        super(tm);
        this.properties = new CssPropertyFactory("css21");
    }

    public CssFouffa(ApplContext ac, Reader reader) {
        super(reader);
        this.ac = ac;
        this.properties = new CssPropertyFactory(ac.getPropertyKey());
    }
}

