/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import org.w3c.css.parser.CssParseException;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;

public class CssError {
    static final String parserError = "generator.unrecognize";
    String sourceFile;
    int beginLine;
    int beginColumn;
    int endLine;
    int endColumn;
    int line;
    String type = null;
    Throwable error;

    public CssError() {
    }

    public CssError(String sourceFile, int beginLine, int beginColumn, int endLine, int endColumn, Throwable error) {
        this.sourceFile = sourceFile;
        this.line = -1;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.error = error;
    }

    public CssError(String sourceFile, int line, Throwable error) {
        this.sourceFile = sourceFile;
        this.line = line;
        this.error = error;
    }

    public CssError(Throwable error) {
        this.error = error;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getSourceFileEscaped() {
        return Messages.escapeString(this.sourceFile);
    }

    public int getLine() {
        return this.line;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public Throwable getException() {
        return this.error;
    }

    public String getType() {
        if (this.type == null) {
            if (this.error == null) {
                return null;
            }
            if (this.error instanceof InvalidParamException) {
                InvalidParamException exception = (InvalidParamException)this.error;
                this.type = exception.getErrorType();
            } else {
                this.type = this.error instanceof CssParseException ? ((CssParseException)this.error).getErrorType() : this.error.getClass().getName();
            }
        }
        return this.type;
    }
}

