/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css.media;

import org.w3c.css.css.StyleSheetOrigin;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.util.ApplContext;
import org.w3c.css.values.CssValue;

public abstract class MediaFeature
implements StyleSheetOrigin {
    public CssValue value;
    public int origin;
    public int line;
    public String sourceFile;
    public String combinator = null;

    public abstract boolean equals(MediaFeature var1);

    public abstract String getFeatureName();

    public void setCombinator(String combinator) {
        this.combinator = combinator;
    }

    public String getCombinator() {
        return this.combinator;
    }

    public void reportDeprecatedMediaFeature(ApplContext ac, String modifier) {
        String feature = modifier != null ? String.format("%s-%s", modifier, this.getFeatureName()) : this.getFeatureName();
        ac.getFrame().addError(new CssError(new ParseException(String.format(ac.getMsg().getString("deprecatedmediafeature"), feature))));
    }

    public void setInfo(int line, String source) {
        this.line = line;
        this.sourceFile = source;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final int getLine() {
        return this.line;
    }

    public String toString() {
        if (this.value == null) {
            return this.getFeatureName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFeatureName());
        sb.append(':').append(' ').append(this.value.toString());
        return sb.toString();
    }
}

