/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class FutureWayProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_GPS = new PatternBuilder().text("GPS:").expression("([AV]),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").groupBegin().number("(dd)(dd.d+)([NS]),").number("(ddd)(dd.d+)([EW]),").or().number("(d+.d+)([NS]),").number("(d+.d+)([EW]),").groupEnd().number("(d+.d+),").number("(d+.d+)").compile();

    public FutureWayProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        ByteBuf header = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(sentence.substring(0, 16)));
        sentence = sentence.substring(16, sentence.length() - 4);
        header.readUnsignedByte();
        header.readUnsignedInt();
        short type = header.readUnsignedByte();
        header.readUnsignedShort();
        if (type == 32) {
            this.getDeviceSession(channel, remoteAddress, sentence.split(",")[1].substring(5));
        } else if (type == 160) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Network network = new Network();
            for (String line : sentence.split("\r\n")) {
                int lac;
                int cid;
                if (line.startsWith("GPS")) {
                    String[] parser = new Parser(PATTERN_GPS, line);
                    if (!parser.matches()) {
                        return null;
                    }
                    position.setValid(parser.next().equals("A"));
                    position.setTime(parser.nextDateTime());
                    if (parser.hasNext(6)) {
                        position.setLatitude(parser.nextCoordinate());
                        position.setLongitude(parser.nextCoordinate());
                    }
                    if (parser.hasNext(4)) {
                        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
                        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
                    }
                    position.setSpeed(parser.nextDouble());
                    position.setCourse(parser.nextDouble());
                    continue;
                }
                if (line.startsWith("WIFI")) {
                    if (!line.contains(",")) continue;
                    for (String item : line.substring(line.indexOf(44) + 1).split("&")) {
                        String[] values = item.split("\\|");
                        network.addWifiAccessPoint(WifiAccessPoint.from(values[1].replace('-', ':'), Integer.parseInt(values[2])));
                    }
                    continue;
                }
                if (!line.startsWith("LBS")) continue;
                String[] values = line.substring("LBS:".length()).split(",");
                if (Integer.parseInt(values[2]) > 65535) {
                    cid = Integer.parseInt(values[2]);
                    lac = Integer.parseInt(values[3]);
                } else {
                    lac = Integer.parseInt(values[2]);
                    cid = Integer.parseInt(values[3]);
                }
                network.addCellTower(CellTower.from(Integer.parseInt(values[0]), Integer.parseInt(values[1]), lac, cid));
            }
            if (!network.getCellTowers().isEmpty() || !network.getWifiAccessPoints().isEmpty()) {
                position.setNetwork(network);
            }
            if (position.getFixTime() == null) {
                this.getLastLocation(position, null);
            }
            return position;
        }
        return null;
    }
}

