/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.WrappedSimpleMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMConfigNode
implements ConfigNode {
    private final Node node;
    SimpleMap<String> attrs;

    public String name() {
        return this.node.getNodeName();
    }

    public String textValue() {
        return DOMUtil.getText((Node)this.node);
    }

    public DOMConfigNode(Node node) {
        this.node = node;
    }

    public SimpleMap<String> attributes() {
        if (this.attrs != null) {
            return this.attrs;
        }
        this.attrs = new WrappedSimpleMap(DOMUtil.toMap((NamedNodeMap)this.node.getAttributes()));
        return this.attrs;
    }

    public ConfigNode child(String name) {
        Node n = DOMUtil.getChild((Node)this.node, (String)name);
        return n == null ? null : new DOMConfigNode(n);
    }

    public List<ConfigNode> children(String name) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        this.forEachChild(it -> {
            if (name.equals(it.name())) {
                result.add((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
        return result;
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        Boolean toContinue;
        Node item;
        NodeList nlst = this.node.getChildNodes();
        for (int i = 0; i < nlst.getLength() && ((item = nlst.item(i)).getNodeType() != 1 || Boolean.FALSE != (toContinue = fun.apply(new DOMConfigNode(item)))); ++i) {
        }
    }
}

