/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.GroupAssert;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.ToString;

public class MapAssert
extends GroupAssert<MapAssert, Map<?, ?>> {
    private static final String ENTRY = "entry";
    private static final String ENTRIES = "entries";

    protected MapAssert(@Nullable Map<?, ?> actual) {
        super(MapAssert.class, actual);
    }

    @Nonnull
    public static Entry entry(@Nullable Object key, @Nullable Object value) {
        return new Entry(key, value);
    }

    @Nonnull
    public MapAssert includes(Entry ... entries) {
        this.isNotNull();
        Preconditions.checkNotNull((Object)entries);
        ArrayList notFound = Lists.newArrayList();
        for (Entry e : entries) {
            if (this.containsEntry((Entry)Preconditions.checkNotNull((Object)e))) continue;
            notFound.add(e);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(this.entryOrEntries(notFound), notFound);
        }
        return this;
    }

    @Nonnull
    public MapAssert excludes(Entry ... entries) {
        this.isNotNull();
        Preconditions.checkNotNull((Object)entries);
        ArrayList found = Lists.newArrayList();
        for (Entry e : entries) {
            if (!this.containsEntry((Entry)Preconditions.checkNotNull((Object)e))) continue;
            found.add(e);
        }
        if (!found.isEmpty()) {
            this.failIfFound(this.entryOrEntries(found), found);
        }
        return this;
    }

    private boolean containsEntry(@Nonnull Entry e) {
        if (!((Map)this.actual).containsKey(e.key)) {
            return false;
        }
        return ((Map)this.actual).get(e.key).equals(e.value);
    }

    @Nonnull
    private String entryOrEntries(@Nonnull List<Entry> found) {
        return found.size() == 1 ? ENTRY : ENTRIES;
    }

    private void failIfNotFound(@Nonnull String description, @Nonnull Collection<?> notFound) {
        this.failIfCustomMessageIsSet();
        String format = "the map:<%s> does not contain the %s:<%s>";
        this.fail(String.format(format, this.formattedActual(), description, ToString.toStringOf(notFound)));
    }

    private void failIfFound(@Nonnull String description, @Nonnull Collection<?> found) {
        this.failIfCustomMessageIsSet();
        this.fail(String.format("the map:<%s> contains the %s:<%s>", this.formattedActual(), description, ToString.toStringOf(found)));
    }

    @Nonnull
    private String formattedActual() {
        return (String)Preconditions.checkNotNull((Object)ToString.toStringOf((Object)this.actual));
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((Map)this.actual).size();
    }

    public static class Entry {
        final Object key;
        final Object value;

        Entry(@Nullable Object key, @Nullable Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format("%s=%s", Strings.quote((Object)this.key), Strings.quote((Object)this.value));
        }
    }
}

