/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final Logger LOG = Logger.getInstance(EventLogMetadataPersistence.class);
    @NotNull
    private final String myRecorderId;

    public EventLogMetadataPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            File file = this.getEventsSchemeFile();
            if (file.exists()) {
                return FileUtil.loadFile((File)file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private File getEventsSchemeFile() throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            return new File(settings.getCustomPath());
        }
        File file = this.getDefaultFile();
        if (!file.exists()) {
            this.initBuiltinMetadata(file);
        }
        File file2 = file;
        if (file2 == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(1);
        }
        return file2;
    }

    public void cacheEventsScheme(@NotNull String eventsSchemeJson, long lastModified) {
        if (eventsSchemeJson == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(2);
        }
        try {
            File file = this.getDefaultFile();
            FileUtil.writeToFile((File)file, (String)eventsSchemeJson);
            EventLogMetadataSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void initBuiltinMetadata(File file) throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinEventSchemePath());){
            if (stream == null) {
                return;
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create " + file.getParentFile().getAbsolutePath());
            }
            Files.copy(stream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinEventSchemePath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/events-scheme.json";
    }

    public long getLastModified() {
        return EventLogMetadataSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    @NotNull
    public File getDefaultFile() throws IOException {
        File file = EventLogMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
        if (file == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(3);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsSchemeJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSchemeFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cacheEventsScheme";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

