/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogNotificationService;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogNotificationProxy;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "writer", "recorderId", "", "(Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;Ljava/lang/String;)V", "cleanup", "", "dispose", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "logEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "rollOver", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogNotificationProxy
implements StatisticsEventLogWriter {
    private final StatisticsEventLogWriter writer;
    private final String recorderId;

    @Override
    public void log(@NotNull LogEvent logEvent) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        EventLogNotificationService.INSTANCE.notifySubscribers(logEvent, this.recorderId);
        this.writer.log(logEvent);
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        return this.writer.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.writer.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.writer.cleanup();
    }

    @Override
    public void rollOver() {
        this.writer.rollOver();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.writer);
    }

    public EventLogNotificationProxy(@NotNull StatisticsEventLogWriter writer, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.writer = writer;
        this.recorderId = recorderId;
    }
}

