/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ui.icons.IconLoadMeasurer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"safeHashValue", "", "value", "writeIcons", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeServiceStats", "intellij.platform.diagnostic"})
public final class IdeIdeaFormatWriterKt {
    /*
     * WARNING - void declaration
     */
    private static final void writeIcons(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "icons";
        boolean $i$f$array = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl4 = false;
        for (IconLoadMeasurer.Counter stat : IconLoadMeasurer.getStats()) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv2 = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl5 = false;
            writer.writeStringField("name", stat.name);
            IconLoadMeasurer.Counter counter = stat;
            Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"stat");
            writer.writeNumberField("count", counter.getCount());
            writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(stat.getTotalDuration()));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    private static final String safeHashValue(String value) {
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(new Argon2Parameters.Builder(2).build());
        byte[] result = new byte[20];
        String string = value;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        generator.generateBytes(byArray, result, 0, result.length);
        String string3 = Base64.getEncoder().withoutPadding().encodeToString(result);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().with\u2026().encodeToString(result)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeServiceStats(JsonGenerator writer) {
        void $this$obj$iv;
        Object statItem8;
        void $this$obj$iv2;
        JsonGenerator plugin2;
        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"com/intellij/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt$writeServiceStats$StatItem", "", "name", "", "(Ljava/lang/String;)V", "app", "", "getApp", "()I", "setApp", "(I)V", "module", "getModule", "setModule", "getName", "()Ljava/lang/String;", "project", "getProject", "setProject", "intellij.platform.diagnostic"})
        public final class StatItem {
            private int app;
            private int project;
            private int module;
            @NotNull
            private final String name;

            public final int getApp() {
                return this.app;
            }

            public final void setApp(int n) {
                this.app = n;
            }

            public final int getProject() {
                return this.project;
            }

            public final void setProject(int n) {
                this.project = n;
            }

            public final int getModule() {
                return this.module;
            }

            public final void setModule(int n) {
                this.module = n;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public StatItem(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.name = name;
            }
        }
        StatItem component = new StatItem("component");
        StatItem service = new StatItem("service");
        List list = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PluginManagerCore.getLoadedPlugins()");
        List plugins = list;
        for (JsonGenerator plugin2 : plugins) {
            StatItem statItem2 = service;
            int n = statItem2.getApp();
            JsonGenerator jsonGenerator = plugin2;
            if (jsonGenerator == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            }
            ContainerDescriptor containerDescriptor = ((IdeaPluginDescriptorImpl)jsonGenerator).getApp();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor, (String)"(plugin as IdeaPluginDescriptorImpl).app");
            statItem2.setApp(n + containerDescriptor.getServices().size());
            StatItem statItem3 = service;
            int n2 = statItem3.getProject();
            ContainerDescriptor containerDescriptor2 = ((IdeaPluginDescriptorImpl)plugin2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor2, (String)"plugin.project");
            statItem3.setProject(n2 + containerDescriptor2.getServices().size());
            StatItem statItem4 = service;
            int n3 = statItem4.getModule();
            ContainerDescriptor containerDescriptor3 = ((IdeaPluginDescriptorImpl)plugin2).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor3, (String)"plugin.module");
            statItem4.setModule(n3 + containerDescriptor3.getServices().size());
            StatItem statItem5 = component;
            int n4 = statItem5.getApp();
            ContainerDescriptor containerDescriptor4 = ((IdeaPluginDescriptorImpl)plugin2).getApp();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor4, (String)"plugin.app");
            List list2 = containerDescriptor4.getComponents();
            statItem5.setApp(n4 + (list2 != null ? list2.size() : 0));
            StatItem statItem6 = component;
            int n5 = statItem6.getProject();
            ContainerDescriptor containerDescriptor5 = ((IdeaPluginDescriptorImpl)plugin2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor5, (String)"plugin.project");
            List list3 = containerDescriptor5.getComponents();
            statItem6.setProject(n5 + (list3 != null ? list3.size() : 0));
            StatItem statItem7 = component;
            int n6 = statItem7.getModule();
            ContainerDescriptor containerDescriptor6 = ((IdeaPluginDescriptorImpl)plugin2).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)containerDescriptor6, (String)"plugin.module");
            List list4 = containerDescriptor6.getComponents();
            statItem7.setModule(n6 + (list4 != null ? list4.size() : 0));
        }
        plugin2 = writer;
        String fieldName$iv = "stats";
        boolean $i$f$obj = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$obj$iv2.writeFieldName(it$iv);
        $this$obj$iv2.writeStartObject();
        boolean bl4 = false;
        writer.writeNumberField("plugin", plugins.size());
        for (Object statItem8 : CollectionsKt.listOf((Object[])new StatItem[]{component, service})) {
            void $this$obj$iv3;
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = ((StatItem)statItem8).getName();
            boolean $i$f$obj2 = false;
            if (fieldName$iv2 != null) {
                String string2;
                boolean bl5 = false;
                boolean bl6 = false;
                String it$iv2 = string2;
                $i$a$-let-JacksonKt$obj$1$iv = false;
                $this$obj$iv3.writeFieldName(it$iv2);
            }
            $this$obj$iv3.writeStartObject();
            boolean bl7 = false;
            writer.writeNumberField("app", ((StatItem)statItem8).getApp());
            writer.writeNumberField("project", ((StatItem)statItem8).getProject());
            writer.writeNumberField("module", ((StatItem)statItem8).getModule());
            $this$obj$iv3.writeEndObject();
        }
        statItem8 = writer;
        String fieldName$iv3 = "loadedClasses";
        boolean $i$f$obj3 = false;
        String string3 = fieldName$iv3;
        boolean bl8 = false;
        boolean bl9 = false;
        String it$iv3 = string3;
        $i$a$-let-JacksonKt$obj$1$iv = false;
        $this$obj$iv.writeFieldName(it$iv3);
        $this$obj$iv.writeStartObject();
        boolean bl10 = false;
        Iterator iterator = plugins.iterator();
        while (iterator.hasNext()) {
            PluginAwareClassLoader classLoader;
            IdeaPluginDescriptor plugin3;
            IdeaPluginDescriptor ideaPluginDescriptor = plugin3 = (IdeaPluginDescriptor)iterator.next();
            if (ideaPluginDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            }
            ClassLoader classLoader2 = ((IdeaPluginDescriptorImpl)ideaPluginDescriptor).getPluginClassLoader();
            if (!(classLoader2 instanceof PluginAwareClassLoader)) {
                classLoader2 = null;
            }
            if ((PluginAwareClassLoader)classLoader2 == null) {
                continue;
            }
            long classCount = classLoader.getLoadedClassCount();
            if (classCount <= 0L) continue;
            PluginId pluginId = ((IdeaPluginDescriptorImpl)plugin3).getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
            writer.writeNumberField(pluginId.getIdString(), classCount);
        }
        $this$obj$iv.writeEndObject();
        $this$obj$iv2.writeEndObject();
    }

    public static final /* synthetic */ String access$safeHashValue(String value) {
        return IdeIdeaFormatWriterKt.safeHashValue(value);
    }

    public static final /* synthetic */ void access$writeServiceStats(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeServiceStats(writer);
    }

    public static final /* synthetic */ void access$writeIcons(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeIcons(writer);
    }
}

