/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.text;

import javax.annotation.Nonnull;
import javax.swing.JList;
import javax.swing.ListModel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.text.TextReader;
import org.fest.util.VisibleForTesting;

public class JListTextReader
extends TextReader<JList> {
    private final JListCellReader cellReader;

    public JListTextReader() {
        this(new BasicJListCellReader());
    }

    @VisibleForTesting
    JListTextReader(@Nonnull JListCellReader cellReader) {
        this.cellReader = cellReader;
    }

    @Override
    @Nonnull
    public Class<JList> supportedComponent() {
        return JList.class;
    }

    @Override
    @RunsInCurrentThread
    protected boolean checkContainsText(@Nonnull JList list, @Nonnull String text) {
        ListModel model = list.getModel();
        int elementCount = model.getSize();
        for (int i = 0; i < elementCount; ++i) {
            String elementText = this.cellReader.valueAt(list, i);
            if (elementText == null || !elementText.contains(text)) continue;
            return true;
        }
        return false;
    }
}

