/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatter;
import org.fest.util.Preconditions;

public abstract class ComponentFormatterTemplate
implements ComponentFormatter {
    @Override
    @Nonnull
    @RunsInCurrentThread
    public final String format(@Nonnull Component c) {
        this.checkTypeOf(c);
        return this.doFormat(c);
    }

    @Nonnull
    @RunsInCurrentThread
    protected abstract String doFormat(@Nonnull Component var1);

    private void checkTypeOf(@Nonnull Component c) {
        Preconditions.checkNotNull((Object)c);
        if (!this.targetType().isAssignableFrom(c.getClass())) {
            String msg = String.format("This formatter only supports components of type %s", this.targetType().getName());
            throw new IllegalArgumentException(msg);
        }
    }
}

