/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentShowingQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class WaitForComponentToShowCondition
extends Condition {
    private Component c;

    public static WaitForComponentToShowCondition untilIsShowing(@Nonnull Component c) {
        return new WaitForComponentToShowCondition(c);
    }

    private WaitForComponentToShowCondition(@Nonnull Component c) {
        super(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " to show on the screen"}));
        this.c = (Component)Preconditions.checkNotNull((Object)c);
    }

    @Override
    public boolean test() {
        return ComponentShowingQuery.isShowing(this.c);
    }

    @Override
    protected void done() {
        this.c = null;
    }
}

