/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.util.Arrays;

public final class JTreeLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> rowBoundsAndCoordinates(@Nonnull JTree tree, int row) {
        Rectangle rowBounds = tree.getRowBounds(this.checkRowInBounds(tree, row));
        if (rowBounds != null) {
            return Pair.of(rowBounds, this.pointAt(rowBounds));
        }
        throw new LocationUnavailableException(String.format("The tree row <%d> is not visible", row));
    }

    @Nonnull
    @RunsInCurrentThread
    public TreePath pathFor(@Nonnull JTree tree, int row) {
        TreePath path = tree.getPathForRow(this.checkRowInBounds(tree, row));
        if (path != null) {
            return path;
        }
        throw new LocationUnavailableException(String.format("Unable to find tree path for row <%d>", row));
    }

    @RunsInCurrentThread
    public int checkRowInBounds(@Nonnull JTree tree, int row) {
        int rowCount = tree.getRowCount();
        if (row >= 0 && row < rowCount) {
            return row;
        }
        String msg = String.format("The given row <%d> should be between <0> and <%d>", row, rowCount);
        throw new IndexOutOfBoundsException(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> pathBoundsAndCoordinates(@Nonnull JTree tree, @Nonnull TreePath path) {
        Rectangle pathBounds = tree.getPathBounds(path);
        if (pathBounds != null) {
            return Pair.of(pathBounds, this.pointAt(pathBounds));
        }
        throw new LocationUnavailableException(String.format("The tree path %s is not visible", Arrays.format((Object)path.getPath())));
    }

    @Nonnull
    private Point pointAt(@Nonnull Rectangle cellBounds) {
        return new Point(cellBounds.x, cellBounds.y + cellBounds.height / 2);
    }
}

