/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JToolBarIsFloatingQuery;
import org.fest.swing.driver.JToolBarLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JToolBarDriver
extends JComponentDriver {
    private final JToolBarLocation location = new JToolBarLocation();

    public JToolBarDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public boolean isFloating(final @Nonnull JToolBar toolBar) {
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JToolBarIsFloatingQuery.isJToolBarFloating(toolBar);
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    public void makeFloat(@Nonnull JToolBar toolBar) {
        Pair<Point, Pair<Window, Point>> floatInfo = JToolBarDriver.floatInfo(toolBar, this.location());
        Point p = (Point)((Pair)floatInfo.second).second;
        this.doFloat(toolBar, p.x, p.y, floatInfo);
    }

    @RunsInEDT
    public void floatTo(@Nonnull JToolBar toolBar, int x, int y) {
        this.doFloat(toolBar, x, y, JToolBarDriver.floatInfo(toolBar, this.location()));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Point, Pair<Window, Point>> floatInfo(final @Nonnull JToolBar toolBar, final @Nonnull JToolBarLocation location) {
        Pair<Point, Pair<Window, Point>> result = GuiActionRunner.execute(new GuiQuery<Pair<Point, Pair<Window, Point>>>(){

            @Override
            protected Pair<Point, Pair<Window, Point>> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                JToolBarDriver.checkFloatable(toolBar);
                Pair windowAndLocation = JToolBarDriver.ancestorAndLocation(toolBar);
                return Pair.of(location.pointToGrab(toolBar), windowAndLocation);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private static void checkFloatable(@Nonnull JToolBar toolBar) {
        if (!toolBar.isFloatable()) {
            String msg = String.format("JToolbar <%s> is not floatable", Formatting.format(toolBar));
            throw new IllegalStateException(msg);
        }
    }

    @Nonnull
    @RunsInCurrentThread
    private static Pair<Window, Point> ancestorAndLocation(@Nonnull JToolBar toolBar) {
        Window window = SwingUtilities.getWindowAncestor(toolBar);
        return Pair.of(window, window.getLocation());
    }

    @RunsInEDT
    private void doFloat(@Nonnull JToolBar toolBar, int x, int y, Pair<Point, Pair<Window, Point>> floatInfo) {
        this.drag(toolBar, (Point)Preconditions.checkNotNull(floatInfo.first));
        Pair locationAndAncestor = (Pair)floatInfo.second;
        Point ancestorLocation = (Point)locationAndAncestor.second;
        this.drop((Component)Preconditions.checkNotNull(locationAndAncestor.first), new Point(x - ancestorLocation.x, y - ancestorLocation.y));
        JToolBarDriver.checkFloated(toolBar);
    }

    @RunsInEDT
    private static void checkFloated(final @Nonnull JToolBar toolBar) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (!JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    throw ActionFailedException.actionFailure(String.format("Unable to float JToolbar <%s>", Formatting.format(toolBar)));
                }
            }
        });
    }

    @RunsInEDT
    public void unfloat(@Nonnull JToolBar toolBar, @Nonnull String constraint) {
        Pair<GenericRange<Point>, Container> unfloatInfo = JToolBarDriver.unfloatInfo(toolBar, constraint, this.location());
        GenericRange fromAndTo = (GenericRange)unfloatInfo.first;
        this.drag(toolBar, (Point)fromAndTo.from());
        this.drop((Component)Preconditions.checkNotNull(unfloatInfo.second), (Point)fromAndTo.to());
        JToolBarDriver.validateIsNotFloating(toolBar, constraint);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<GenericRange<Point>, Container> unfloatInfo(final @Nonnull JToolBar toolBar, final @Nonnull String constraint, final @Nonnull JToolBarLocation location) {
        Pair<GenericRange<Point>, Container> result = GuiActionRunner.execute(new GuiQuery<Pair<GenericRange<Point>, Container>>(){

            @Override
            protected Pair<GenericRange<Point>, Container> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                Container dock = JToolBarDriver.dockFor(toolBar);
                Point from = location.pointToGrab(toolBar);
                Point to = location.dockLocation(toolBar, dock, constraint);
                return Pair.of(new GenericRange<Point>(from, to), dock);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    private static void validateIsNotFloating(final @Nonnull JToolBar toolBar, final @Nonnull String constraint) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    String msg = String.format("Failed to dock <%s> using constraint '%s'", Formatting.format(toolBar), constraint);
                    throw ActionFailedException.actionFailure(msg);
                }
            }
        });
    }

    @Nonnull
    @RunsInCurrentThread
    private static Container dockFor(@Nonnull JToolBar toolBar) {
        try {
            return (Container)Preconditions.checkNotNull((Object)Reflection.field((String)"dockingSource").ofType(Container.class).in((Object)toolBar.getUI()).get());
        }
        catch (RuntimeException e) {
            throw ActionFailedException.actionFailure("Unabled to determine dock for JToolBar");
        }
    }

    @RunsInEDT
    public void unfloat(@Nonnull JToolBar toolBar) {
        Window w = JToolBarDriver.windowAncestorOf(toolBar);
        if (w != null) {
            this.robot.close(w);
        }
    }

    @Nullable
    @RunsInEDT
    private static Window windowAncestorOf(final @Nonnull JToolBar toolBar) {
        return GuiActionRunner.execute(new GuiQuery<Window>(){

            @Override
            protected Window executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(toolBar);
                return SwingUtilities.getWindowAncestor(toolBar);
            }
        });
    }

    @Nonnull
    private JToolBarLocation location() {
        return this.location;
    }
}

