/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectArrayAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JOptionPaneMessageQuery;
import org.fest.swing.driver.JOptionPaneMessageTypeQuery;
import org.fest.swing.driver.JOptionPaneMessageTypes;
import org.fest.swing.driver.JOptionPaneOptionsQuery;
import org.fest.swing.driver.JOptionPaneTitleQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JOptionPaneDriver
extends JComponentDriver {
    private static final String MESSAGE_PROPERTY = "message";
    private static final String MESSAGE_TYPE_PROPERTY = "messageType";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String TITLE_PROPERTY = "title";

    public JOptionPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nullable String title) {
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTitle(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public String title(@Nonnull JOptionPane optionPane) {
        return JOptionPaneTitleQuery.titleOf(optionPane);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nullable Object message) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        if (message instanceof String && actual != null) {
            this.requireMessage(optionPane, (String)message, actual.toString());
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)actual).as(this.messageProperty(optionPane))).isEqualTo(message);
    }

    @RunsInEDT
    private void requireMessage(@Nonnull JOptionPane optionPane, @Nullable String expected, @Nullable String actual) {
        TextAssert.verifyThat(actual).as(this.messageProperty(optionPane)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireMessage(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        String s = actual == null ? null : actual.toString();
        TextAssert.verifyThat(s).as(this.messageProperty(optionPane)).matches(pattern);
    }

    private Description messageProperty(@Nonnull JOptionPane optionPane) {
        return JOptionPaneDriver.propertyName(optionPane, MESSAGE_PROPERTY);
    }

    @RunsInEDT
    public void requireOptions(@Nonnull JOptionPane optionPane, @Nonnull Object[] options) {
        ((ObjectArrayAssert)Assertions.assertThat((Object[])JOptionPaneOptionsQuery.optionsOf(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, OPTIONS_PROPERTY))).isEqualTo(options);
    }

    @Nonnull
    @RunsInEDT
    public JButton okButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.okButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.cancelButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton yesButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.yesButtonText");
    }

    @Nonnull
    @RunsInEDT
    public JButton noButton(@Nonnull JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.noButtonText");
    }

    @Nonnull
    @RunsInEDT
    private JButton buttonWithTextFromUIManager(@Nonnull JOptionPane optionPane, @Nonnull String key) {
        return this.buttonWithText(optionPane, (String)Preconditions.checkNotNull((Object)UIManager.getString(key)));
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nullable String text) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(text).andShowing());
    }

    @Nonnull
    @RunsInEDT
    public JButton buttonWithText(@Nonnull JOptionPane optionPane, @Nonnull Pattern pattern) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(pattern).andShowing());
    }

    @RunsInEDT
    public void requireErrorMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 0);
    }

    @RunsInEDT
    public void requireInformationMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 1);
    }

    @RunsInEDT
    public void requireWarningMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 2);
    }

    @RunsInEDT
    public void requireQuestionMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 3);
    }

    @RunsInEDT
    public void requirePlainMessage(@Nonnull JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, -1);
    }

    @RunsInEDT
    private void assertEqualMessageType(@Nonnull JOptionPane optionPane, int expected) {
        String actualType = this.actualMessageTypeAsText(optionPane);
        ((StringAssert)Assertions.assertThat((String)actualType).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_TYPE_PROPERTY))).isEqualTo((Object)JOptionPaneMessageTypes.messageTypeAsText(expected));
    }

    @RunsInEDT
    private String actualMessageTypeAsText(@Nonnull JOptionPane optionPane) {
        return JOptionPaneMessageTypes.messageTypeAsText(JOptionPaneMessageTypeQuery.messageTypeOf(optionPane));
    }
}

