/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Lists;
import org.fest.util.Preconditions;

final class JListSelectionValuesQuery {
    @Nonnull
    @RunsInEDT
    static List<String> selectionValues(final @Nonnull JList list, final @Nonnull JListCellReader cellReader) {
        List<String> result = GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                int[] selectedIndices;
                ArrayList values = Lists.newArrayList();
                for (int index : selectedIndices = list.getSelectedIndices()) {
                    values.add(cellReader.valueAt(list, index));
                }
                return values;
            }
        });
        return (List)Preconditions.checkNotNull(result);
    }

    private JListSelectionValuesQuery() {
    }
}

