/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JListContentQuery {
    @Nonnull
    @RunsInEDT
    static String[] contents(final @Nonnull JList list, final @Nonnull JListCellReader cellReader) {
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() {
                String[] values = new String[list.getModel().getSize()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = cellReader.valueAt(list, i);
                }
                return values;
            }
        });
        return (String[])Preconditions.checkNotNull((Object)result);
    }

    private JListContentQuery() {
    }
}

