/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public class Logger {
    private static LogBackEnd backend;

    public static LogBackEnd getBackend() {
        return backend;
    }

    public static void setBackend(LogBackEnd backend) {
        Logger.backend = backend;
    }

    public static void log(Class<?> clazz, LogLevel loglevel, String msg, Object ... params) {
        if (backend != null) {
            backend.log(clazz, loglevel, msg, params);
        }
    }

    public class Slf4jLogBackEnd
    implements LogBackEnd {
        protected Map<Class<?>, org.slf4j.Logger> loggers = new ConcurrentHashMap();

        @Override
        public void log(Class<?> clazz, LogLevel loglevel, String msg, Object ... params) {
            org.slf4j.Logger log = this.getLogger(clazz);
            switch (loglevel) {
                case ERROR: {
                    if (!log.isErrorEnabled()) break;
                    log.error(msg, params);
                    break;
                }
                case WARNING: {
                    if (!log.isWarnEnabled()) break;
                    log.warn(msg, params);
                    break;
                }
                case INFO: {
                    if (!log.isInfoEnabled()) break;
                    log.info(msg, params);
                    break;
                }
                case TRACE: {
                    if (!log.isTraceEnabled()) break;
                    log.trace(msg, params);
                    break;
                }
                case DEBUG: {
                    if (!log.isDebugEnabled()) break;
                    log.debug(msg, params);
                }
            }
        }

        protected org.slf4j.Logger getLogger(Class<?> clazz) {
            org.slf4j.Logger logger = this.loggers.get(clazz);
            if (logger == null) {
                logger = LoggerFactory.getLogger(clazz);
                this.loggers.put(clazz, logger);
            }
            return logger;
        }
    }

    public static interface LogBackEnd {
        public void log(Class<?> var1, LogLevel var2, String var3, Object ... var4);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        TRACE,
        DEBUG;

    }
}

