/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.quickfix.CompatibilityPrintCallQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveUnderscoresInNumericLiteralsQuickFix;
import com.jetbrains.python.inspections.quickfix.RemovePrefixQuickFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingSuffixQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBackquoteExpressionQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBuiltinsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceExceptPartQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceListComprehensionsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceNotEqOperatorQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceOctalNumericLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceRaiseStatementQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReprExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompatibilityVisitor
extends PyAnnotator {
    @NotNull
    private static final Set<String> PYTHON2_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"});
    @NotNull
    private static final Set<String> PYTHON34_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"});
    @NotNull
    private static final Set<String> PYTHON36_PREFIXES = Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB", "F", "FR", "RF"});
    @NotNull
    protected List<LanguageLevel> myVersionsToProcess;

    public CompatibilityVisitor(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(0);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    @Override
    public void visitPyAnnotation(@NotNull PyAnnotation node) {
        PsiElement parent;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(1);
        }
        if (!((parent = node.getParent()) instanceof PyFunction) && !(parent instanceof PyNamedParameter)) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.variable.annotations", new Object[0]), (PsiElement)node);
        }
    }

    @Override
    public void visitPyExceptBlock(@NotNull PyExceptPart node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(2);
        }
        super.visitPyExceptBlock(node);
        PyExpression exceptClass = node.getExceptClass();
        if (exceptClass != null) {
            PsiElement element = exceptClass.getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null && ",".equals(element.getText())) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), node, (LocalQuickFix)new ReplaceExceptPartQuickFix());
            }
        }
    }

    @Override
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(3);
        }
        super.visitPyImportStatement(node);
        PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyIfStatement.class);
        if (ifParent != null) {
            return;
        }
        for (PyImportElement importElement : node.getImportElements()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            if (qName.matches(new String[]{"builtins"})) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.module.builtins", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
                continue;
            }
            if (!qName.matches(new String[]{"__builtin__"})) continue;
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.module.builtin", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceBuiltinsQuickFix());
        }
    }

    @Override
    public void visitPyStarExpression(@NotNull PyStarExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyStarExpression(node);
        if (node.isAssignmentTarget()) {
            this.registerForAllMatchingVersions(level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.as.assignment.targets", new Object[0]), (PsiElement)node);
        }
        if (node.isUnpacking()) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.tuples.lists.and.sets", new Object[0]), (PsiElement)node);
            PsiElement container = PsiTreeUtil.skipParentsOfType((PsiElement)node, (Class[])new Class[]{PyParenthesizedExpression.class});
            if (container instanceof PyTupleExpression) {
                PsiElement tupleParent = container.getParent();
                if (tupleParent instanceof PyReturnStatement) {
                    this.registerForAllMatchingVersions(level -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.unpacking.without.parentheses.in.return.statements", new Object[0]), (PsiElement)node);
                }
                if (tupleParent instanceof PyYieldExpression && !((PyYieldExpression)tupleParent).isDelegating()) {
                    this.registerForAllMatchingVersions(level -> level.isAtLeast(LanguageLevel.PYTHON35) && level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.unpacking.without.parentheses.in.yield.statements", new Object[0]), (PsiElement)node);
                }
            }
        }
    }

    @Override
    public void visitPyDoubleStarExpression(@NotNull PyDoubleStarExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(5);
        }
        super.visitPyDoubleStarExpression(node);
        this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.starred.expressions.in.dicts", new Object[0]), (PsiElement)node);
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(6);
        }
        super.visitPyBinaryExpression(node);
        if (node.isOperator("<>")) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.diamond.operator", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceNotEqOperatorQuickFix());
        } else if (node.isOperator("@")) {
            this.checkMatrixMultiplicationOperator(node.getPsiOperator());
        }
    }

    private void checkMatrixMultiplicationOperator(PsiElement node) {
        this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.matrix.multiplication.operators", new Object[0]), node);
    }

    @Override
    public void visitPyNumericLiteralExpression(@NotNull PyNumericLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(7);
        }
        super.visitPyNumericLiteralExpression(node);
        String text2 = node.getText();
        if (node.isIntegerLiteral()) {
            char secondChar;
            String suffix = node.getIntegerLiteralSuffix();
            if ("l".equalsIgnoreCase(suffix)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.long.integer.literal.suffix", suffix), (PsiElement)node, (LocalQuickFix)new RemoveTrailingSuffixQuickFix());
            }
            if (text2.length() > 1 && text2.charAt(0) == '0' && (secondChar = Character.toLowerCase(text2.charAt(1))) != 'o' && secondChar != 'b' && secondChar != 'x' && text2.chars().anyMatch(c -> c != 48)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.old.style.octal.literals", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceOctalNumericLiteralQuickFix());
            }
        }
        if (text2.contains("_")) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON36) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.underscores.in.numeric.literals", new Object[0]), (PsiElement)node, (LocalQuickFix)new PyRemoveUnderscoresInNumericLiteralsQuickFix());
        }
    }

    @Override
    public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(8);
        }
        super.visitPyStringLiteralExpression(node);
        boolean seenBytes = false;
        boolean seenNonBytes = false;
        for (PyStringElement element : node.getStringElements()) {
            String prefix = StringUtil.toUpperCase((String)element.getPrefix());
            if (prefix.isEmpty()) continue;
            boolean bytes = element.isBytes();
            seenBytes |= bytes;
            seenNonBytes |= !bytes;
            int elementStart = element.getTextOffset();
            this.registerForAllMatchingVersions(level -> !CompatibilityVisitor.getSupportedStringPrefixes(level).contains(prefix) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.string.literal.prefix", prefix), node, TextRange.create((int)elementStart, (int)(elementStart + element.getPrefixLength())), new RemovePrefixQuickFix(prefix), true);
        }
        if (seenBytes && seenNonBytes) {
            this.registerForAllMatchingVersions(level -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.to.mix.bytes.and.non.bytes.literals", new Object[0]), node);
        }
    }

    @NotNull
    private static Set<String> getSupportedStringPrefixes(@NotNull LanguageLevel level) {
        if (level == null) {
            CompatibilityVisitor.$$$reportNull$$$0(9);
        }
        if (level.isPython2()) {
            Set<String> set = PYTHON2_PREFIXES;
            if (set == null) {
                CompatibilityVisitor.$$$reportNull$$$0(10);
            }
            return set;
        }
        if (level.isOlderThan(LanguageLevel.PYTHON36)) {
            Set<String> set = PYTHON34_PREFIXES;
            if (set == null) {
                CompatibilityVisitor.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<String> set = PYTHON36_PREFIXES;
        if (set == null) {
            CompatibilityVisitor.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    public void visitPyListCompExpression(@NotNull PyListCompExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(13);
        }
        super.visitPyListCompExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.visitPyListCompExpression(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax.in.list.comprehensions", new Object[0]), ContainerUtil.map(node.getForComponents(), PyComprehensionForComponent::getIteratedList), (LocalQuickFix)new ReplaceListComprehensionsQuickFix());
    }

    @Override
    public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(14);
        }
        super.visitPyRaiseStatement(node);
        this.registerForAllMatchingVersions(level -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasNoArgsUnderFinally(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.raise.with.no.arguments.outside.except.block", new Object[0]), (PsiElement)node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasMoreThenOneArg(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
        this.registerForAllMatchingVersions((LanguageLevel level) -> this.registerForLanguageLevel((LanguageLevel)((Object)level)) && UnsupportedFeaturesUtil.raiseHasFromKeyword(node, level), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceRaiseStatementQuickFix());
    }

    @Override
    public void visitPyReprExpression(@NotNull PyReprExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(15);
        }
        super.visitPyReprExpression(node);
        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.backquotes", new Object[0]), (PsiElement)node, (LocalQuickFix)new ReplaceBackquoteExpressionQuickFix());
    }

    @Override
    public void visitPyWithStatement(@NotNull PyWithStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(16);
        }
        super.visitPyWithStatement(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyForStatement(@NotNull PyForStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(17);
        }
        super.visitPyForStatement(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyPrintStatement(@NotNull PyPrintStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(18);
        }
        super.visitPyPrintStatement(node);
        PsiElement[] arguments = node.getChildren();
        Predicate<PsiElement> nonParenthesesPredicate = element -> !(element instanceof PyParenthesizedExpression) && !(element instanceof PyTupleExpression);
        if (arguments.length == 0 || Arrays.stream(arguments).anyMatch(nonParenthesesPredicate)) {
            this.registerForAllMatchingVersions((LanguageLevel level) -> level.isPy3K() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.print.statement", new Object[0]), (PsiElement)node, (LocalQuickFix)new CompatibilityPrintCallQuickFix());
        }
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(19);
        }
        super.visitPyCallExpression(node);
        PsiElement firstChild = node.getFirstChild();
        if (firstChild != null && "super".equals(firstChild.getText()) && ArrayUtil.isEmpty((Object[])node.getArguments())) {
            this.registerForAllMatchingVersions(level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.super.without.arguments", new Object[0]), (PsiElement)node);
        }
        this.highlightIncorrectArguments(node);
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(20);
        }
        super.visitPyFunction(node);
        this.checkAsyncKeyword(node);
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(21);
        }
        super.visitPyPrefixExpression(node);
        if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), (PsiElement)node);
        }
    }

    @Override
    public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(22);
        }
        super.visitPyYieldExpression(node);
        Optional.ofNullable(ScopeUtil.getScopeOwner((PsiElement)node)).map(owner -> PyUtil.as(owner, PyFunction.class)).filter(function -> function.isAsync() && function.isAsyncAllowed()).ifPresent(function -> {
            if (!node.isDelegating() && this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.yield.inside.async.functions", new Object[0]));
            }
        });
        if (!node.isDelegating()) {
            return;
        }
        this.registerForAllMatchingVersions(level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.yield.from", new Object[0]), (PsiElement)node);
    }

    @Override
    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        PyFunction function;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(23);
        }
        if (ContainerUtil.exists(this.myVersionsToProcess, level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level))) && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class})) != null && node.getExpression() != null) {
            YieldVisitor visitor2 = new YieldVisitor();
            function.acceptChildren(visitor2);
            if (visitor2.haveYield()) {
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.pre35.versions.do.not.allow.return.with.argument.inside.generator", new Object[0]));
            }
        }
    }

    @Override
    public void visitPyNoneLiteralExpression(@NotNull PyNoneLiteralExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(24);
        }
        if (node.isEllipsis()) {
            PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PySubscriptionExpression.class);
            if (subscription != null && PsiTreeUtil.isAncestor((PsiElement)subscription.getIndexExpression(), (PsiElement)node, (boolean)false)) {
                return;
            }
            PySliceItem sliceItem = (PySliceItem)PsiTreeUtil.getParentOfType((PsiElement)node, PySliceItem.class);
            if (sliceItem != null) {
                return;
            }
            this.registerForAllMatchingVersions(level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.ellipsis.outside.slices", new Object[0]), (PsiElement)node);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
        IElementType operationType;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(25);
        }
        super.visitPyAugAssignmentStatement(node);
        PsiElement operation = node.getOperation();
        if (operation != null && ((Object)((Object)PyTokenTypes.ATEQ)).equals(operationType = operation.getNode().getElementType())) {
            this.checkMatrixMultiplicationOperator(operation);
        }
    }

    private void checkAsyncKeyword(@NotNull PsiElement node) {
        ASTNode asyncNode;
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(26);
        }
        if ((asyncNode = node.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)) != null) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.this.syntax", new Object[0]), node, asyncNode.getTextRange(), null, true);
        }
    }

    protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            CompatibilityVisitor.$$$reportNull$$$0(27);
        }
        return true;
    }

    protected abstract void registerProblem(@NotNull PsiElement var1, @NotNull TextRange var2, @NotNull @InspectionMessage String var3, @Nullable LocalQuickFix var4, boolean var5);

    protected void registerProblem(@NotNull PsiElement node, @NotNull @InspectionMessage String message, @Nullable LocalQuickFix localQuickFix) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(28);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(29);
        }
        this.registerProblem(node, node.getTextRange(), message, localQuickFix, true);
    }

    protected void registerProblem(@NotNull PsiElement node, @NotNull @InspectionMessage String message) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(30);
        }
        if (message == null) {
            CompatibilityVisitor.$$$reportNull$$$0(31);
        }
        this.registerProblem(node, message, null);
    }

    protected void setVersionsToProcess(@NotNull List<LanguageLevel> versionsToProcess) {
        if (versionsToProcess == null) {
            CompatibilityVisitor.$$$reportNull$$$0(32);
        }
        this.myVersionsToProcess = versionsToProcess;
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull Iterable<Pair<? extends PsiElement, TextRange>> nodesWithRanges, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        List levels;
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(33);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(34);
        }
        if (nodesWithRanges == null) {
            CompatibilityVisitor.$$$reportNull$$$0(35);
        }
        if (!(levels = this.myVersionsToProcess.stream().filter(levelPredicate).map(LanguageLevel::toString).collect(Collectors.toList())).isEmpty()) {
            @NlsSafe String versions = StringUtil.join(levels, (String)", ");
            @InspectionMessage String message = PyPsiBundle.message("INSP.compatibility.inspection.unsupported.feature.prefix", levels.size(), versions, suffix);
            for (Pair<? extends PsiElement, TextRange> nodeWithRange : nodesWithRanges) {
                this.registerProblem((PsiElement)nodeWithRange.first, (TextRange)nodeWithRange.second, message, localQuickFix, asError);
            }
        }
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull Iterable<? extends PsiElement> nodes, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(36);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(37);
        }
        if (nodes == null) {
            CompatibilityVisitor.$$$reportNull$$$0(38);
        }
        List nodesWithRanges = ContainerUtil.map(nodes, node -> Pair.createNonNull((Object)node, (Object)node.getTextRange()));
        this.registerForAllMatchingVersions(levelPredicate, suffix, nodesWithRanges, localQuickFix, true);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node, @NotNull TextRange range, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(39);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(40);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(41);
        }
        if (range == null) {
            CompatibilityVisitor.$$$reportNull$$$0(42);
        }
        List<Pair.NonNull> nodesWithRanges = Collections.singletonList(Pair.createNonNull((Object)node, (Object)range));
        this.registerForAllMatchingVersions(levelPredicate, suffix, nodesWithRanges, localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(43);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(44);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(45);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, node.getTextRange(), localQuickFix, asError);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node, @Nullable LocalQuickFix localQuickFix) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(46);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(47);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(48);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, localQuickFix, true);
    }

    protected void registerForAllMatchingVersions(@NotNull Predicate<LanguageLevel> levelPredicate, @NotNull @Nls String suffix, @NotNull PsiElement node) {
        if (levelPredicate == null) {
            CompatibilityVisitor.$$$reportNull$$$0(49);
        }
        if (suffix == null) {
            CompatibilityVisitor.$$$reportNull$$$0(50);
        }
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(51);
        }
        this.registerForAllMatchingVersions(levelPredicate, suffix, node, null, true);
    }

    @Override
    public void visitPyNonlocalStatement(@NotNull PyNonlocalStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(52);
        }
        this.registerForAllMatchingVersions(level -> level.isPython2() && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.have.nonlocal.keyword", new Object[0]), (PsiElement)node);
    }

    private void highlightIncorrectArguments(@NotNull PyCallExpression callExpression) {
        PsiElement sibling;
        if (callExpression == null) {
            CompatibilityVisitor.$$$reportNull$$$0(53);
        }
        HashSet<String> keywordArgumentNames = new HashSet<String>();
        boolean seenKeywordArgument = false;
        boolean seenKeywordContainer = false;
        boolean seenPositionalContainer = false;
        for (PyExpression argument : callExpression.getArguments()) {
            if (argument instanceof PyKeywordArgument) {
                String keyword = ((PyKeywordArgument)argument).getKeyword();
                if (keywordArgumentNames.contains(keyword)) {
                    this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.keyword.argument.repeated", new Object[0]), new PyRemoveArgumentQuickFix());
                } else if (seenKeywordContainer) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.keyword.arguments.after.kwargs", new Object[0]), (PsiElement)argument, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                }
                seenKeywordArgument = true;
                keywordArgumentNames.add(keyword);
                continue;
            }
            if (argument instanceof PyStarArgument) {
                PyStarArgument starArgument = (PyStarArgument)argument;
                if (starArgument.isKeyword()) {
                    if (seenKeywordContainer) {
                        this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.duplicate.kwargs", new Object[0]), (PsiElement)argument, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                    }
                    seenKeywordContainer = true;
                    continue;
                }
                if (seenPositionalContainer) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.duplicate.positional.varargs", new Object[0]), (PsiElement)argument, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                }
                seenPositionalContainer = true;
                continue;
            }
            if (seenKeywordArgument) {
                this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.positional.argument.after.keyword.argument", new Object[0]), new PyRemoveArgumentQuickFix());
                continue;
            }
            if (seenPositionalContainer) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.allow.positional.arguments.after.expression", new Object[0]), (PsiElement)argument, (LocalQuickFix)new PyRemoveArgumentQuickFix());
                continue;
            }
            if (!seenKeywordContainer) continue;
            this.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.compatibility.positional.argument.after.kwargs", new Object[0]), new PyRemoveArgumentQuickFix());
        }
        PyExpression lastArg = (PyExpression)ContainerUtil.getLastItem(Arrays.asList(callExpression.getArguments()));
        if (lastArg instanceof PyStarArgument && (sibling = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)lastArg)) != null && sibling.getNode().getElementType() == PyTokenTypes.COMMA) {
            boolean isKeyword = ((PyStarArgument)lastArg).isKeyword();
            String message = isKeyword ? PyPsiBundle.message("INSP.compatibility.feature.allow.trailing.comma.after.kwargs", new Object[0]) : PyPsiBundle.message("INSP.compatibility.feature.allow.trailing.comma.after.positional.vararg", new Object[0]);
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON35) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), message, sibling);
        }
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(54);
        }
        super.visitPyComprehensionElement(node);
        if (this.registerForLanguageLevel(LanguageLevel.PYTHON35) && this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON35)) {
            Arrays.stream(node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.ASYNC_KEYWORD}))).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.async.inside.comprehensions.and.generator.expressions", new Object[0])));
            Stream resultPrefixExpressions = PsiTreeUtil.collectElementsOfType((PsiElement)node.getResultExpression(), (Class[])new Class[]{PyPrefixExpression.class}).stream();
            Stream ifComponentsPrefixExpressions = node.getIfComponents().stream().map(ifComponent -> PsiTreeUtil.collectElementsOfType((PsiElement)ifComponent.getTest(), (Class[])new Class[]{PyPrefixExpression.class})).flatMap(Collection::stream);
            Stream.concat(resultPrefixExpressions, ifComponentsPrefixExpressions).filter(expression -> expression.getOperator() == PyTokenTypes.AWAIT_KEYWORD && expression.getOperand() != null).map(expression -> expression.getNode().findChildByType((IElementType)PyTokenTypes.AWAIT_KEYWORD)).filter(Objects::nonNull).map(ASTNode::getPsi).forEach(element -> this.registerProblem((PsiElement)element, PyPsiBundle.message("INSP.compatibility.py35.does.not.support.await.inside.comprehensions", new Object[0])));
        }
    }

    @Override
    public void visitPySlashParameter(@NotNull PySlashParameter node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(55);
        }
        super.visitPySlashParameter(node);
        this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.positional.only.parameters", new Object[0]), (PsiElement)node);
    }

    @Override
    public void visitPyFStringFragment(@NotNull PyFStringFragment node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(56);
        }
        super.visitPyFStringFragment(node);
        ASTNode equalitySignInFStringFragment = node.getNode().findChildByType((IElementType)PyTokenTypes.EQ);
        if (equalitySignInFStringFragment != null) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.support.equality.signs.in.fstrings", new Object[0]), equalitySignInFStringFragment.getPsi());
        }
    }

    @Override
    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(57);
        }
        super.visitPyAssignmentExpression(node);
        this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.assignment.expressions", new Object[0]), (PsiElement)node);
    }

    @Override
    public void visitPyContinueStatement(@NotNull PyContinueStatement node) {
        if (node == null) {
            CompatibilityVisitor.$$$reportNull$$$0(58);
        }
        super.visitPyContinueStatement(node);
        if (PsiTreeUtil.getParentOfType((PsiElement)node, PyFinallyPart.class, (boolean)false, (Class[])new Class[]{PyLoopStatement.class}) != null) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON38) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.continue.inside.finally.clause", new Object[0]), (PsiElement)node);
        }
    }

    @Override
    public void visitPyDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            CompatibilityVisitor.$$$reportNull$$$0(59);
        }
        super.visitPyDecorator(decorator);
        if (PsiTreeUtil.getChildOfType((PsiElement)decorator, PsiErrorElement.class) == null && decorator.getQualifiedName() == null) {
            this.registerForAllMatchingVersions(level -> level.isOlderThan(LanguageLevel.PYTHON39) && this.registerForLanguageLevel((LanguageLevel)((Object)level)), PyPsiBundle.message("INSP.compatibility.feature.support.arbitrary.expressions.as.decorator", new Object[0]), (PsiElement)decorator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsToProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 41: 
            case 45: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "levelPredicate";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesWithRanges";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedStringPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyExceptBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyImportStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStarExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDoubleStarExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNumericLiteralExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStringLiteralExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedStringPrefixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPyListCompExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPyRaiseStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReprExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWithStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitPyForStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPrintStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFunction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPrefixExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitPyYieldExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReturnStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNoneLiteralExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAugAssignmentStatement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkAsyncKeyword";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerForLanguageLevel";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setVersionsToProcess";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "registerForAllMatchingVersions";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNonlocalStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "highlightIncorrectArguments";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitPyComprehensionElement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitPySlashParameter";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFStringFragment";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitPyContinueStatement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDecorator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class YieldVisitor
    extends PyElementVisitor {
        private boolean _haveYield = false;

        private YieldVisitor() {
        }

        public boolean haveYield() {
            return this._haveYield;
        }

        @Override
        public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(0);
            }
            this._haveYield = true;
        }

        @Override
        public void visitPyElement(@NotNull PyElement node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(1);
            }
            if (!this._haveYield) {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                YieldVisitor.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/validation/CompatibilityVisitor$YieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyYieldExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

