/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyClassRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)PyClassRefactoringUtil.class.getName());
    private static final Key<PsiNamedElement> ENCODED_IMPORT = Key.create((String)"PyEncodedImport");
    private static final Key<Boolean> ENCODED_USE_FROM_IMPORT = Key.create((String)"PyEncodedUseFromImport");
    private static final Key<String> ENCODED_IMPORT_AS = Key.create((String)"PyEncodedImportAs");

    private PyClassRefactoringUtil() {
    }

    @NotNull
    public static List<PyAssignmentStatement> copyFieldDeclarationToStatement(@NotNull Collection<? extends PyAssignmentStatement> assignmentStatements, @NotNull PyStatementList superClassStatement, @Nullable PyClass dequalifyIfDeclaredInClass) {
        if (assignmentStatements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (superClassStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(1);
        }
        ArrayList<PyAssignmentStatement> declarations = new ArrayList<PyAssignmentStatement>(assignmentStatements.size());
        for (PyAssignmentStatement pyAssignmentStatement : assignmentStatements) {
            PyExpression value = pyAssignmentStatement.getAssignedValue();
            PyAssignmentStatement newDeclaration = (PyAssignmentStatement)pyAssignmentStatement.copy();
            if (value instanceof PyReferenceExpression && dequalifyIfDeclaredInClass != null) {
                String newValue = PyClassRefactoringUtil.getNewValueToAssign((PyReferenceExpression)value, dequalifyIfDeclaredInClass);
                PyClassRefactoringUtil.setNewAssigneeValue(newDeclaration, newValue);
            }
            declarations.add(PyPsiRefactoringUtil.addElementToStatementList(newDeclaration, superClassStatement));
            PyPsiUtils.removeRedundantPass(superClassStatement);
        }
        ArrayList<PyAssignmentStatement> arrayList = declarations;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void setNewAssigneeValue(@NotNull PyAssignmentStatement assignmentStatement, @NotNull String newValue) {
        if (assignmentStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(4);
        }
        PyExpression oldValue = assignmentStatement.getAssignedValue();
        PyExpression newExpression = PyElementGenerator.getInstance(assignmentStatement.getProject()).createExpressionFromText(LanguageLevel.forElement(assignmentStatement), newValue);
        if (oldValue != null) {
            oldValue.replace((PsiElement)newExpression);
        } else {
            assignmentStatement.add((PsiElement)newExpression);
        }
    }

    @NotNull
    private static String getNewValueToAssign(@NotNull PyReferenceExpression currentValue, @NotNull PyClass dequalifyIfDeclaredInClass) {
        PyExpression qualifier;
        if (currentValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (dequalifyIfDeclaredInClass == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(6);
        }
        if ((qualifier = currentValue.getQualifier()) instanceof PyReferenceExpression && ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)dequalifyIfDeclaredInClass)) {
            String name = currentValue.getName();
            String string = name != null ? name : currentValue.getText();
            if (string == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = currentValue.getText();
        if (string == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static List<PyFunction> copyMethods(Collection<? extends PyFunction> methods, PyClass superClass, boolean skipIfExist) {
        if (methods.isEmpty()) {
            List<PyFunction> list = Collections.emptyList();
            if (list == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        for (PsiElement psiElement : methods) {
            PyClassRefactoringUtil.rememberNamedReferences(psiElement, new String[0]);
        }
        PyFunction[] elements = methods.toArray(PyFunction.EMPTY_ARRAY);
        return PyClassRefactoringUtil.addMethods(superClass, skipIfExist, elements);
    }

    @NotNull
    public static List<PyFunction> addMethods(@NotNull PyClass destination, boolean skipIfExist, PyFunction ... methods) {
        if (destination == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (methods == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(11);
        }
        PyStatementList destStatementList = destination.getStatementList();
        ArrayList<PyFunction> result = new ArrayList<PyFunction>(methods.length);
        for (PyFunction method : methods) {
            PyFunction existingMethod = destination.findMethodByName(method.getName(), false, null);
            if (existingMethod != null && skipIfExist) {
                result.add(existingMethod);
                continue;
            }
            PyFunction newMethod = PyClassRefactoringUtil.insertMethodInProperPlace(destStatementList, method);
            result.add(newMethod);
            PyClassRefactoringUtil.restoreNamedReferences(newMethod);
        }
        PyPsiUtils.removeRedundantPass(destStatementList);
        ArrayList<PyFunction> arrayList = result;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static PyFunction insertMethodInProperPlace(@NotNull PyStatementList destStatementList, @NotNull PyFunction method) {
        boolean methodIsInit;
        if (destStatementList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (method == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (!(methodIsInit = "__init__".equals(method.getName()))) {
            PyFunction pyFunction = (PyFunction)destStatementList.add(method);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(15);
            }
            return pyFunction;
        }
        for (PsiElement element : destStatementList.getChildren()) {
            boolean elementComment = element instanceof PyExpressionStatement;
            boolean elementClassField = element instanceof PyAssignmentStatement;
            if (elementComment || elementClassField) continue;
            PyFunction pyFunction = (PyFunction)destStatementList.addBefore(method, element);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(16);
            }
            return pyFunction;
        }
        PyFunction pyFunction = (PyFunction)destStatementList.add(method);
        if (pyFunction == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(17);
        }
        return pyFunction;
    }

    public static void restoreNamedReferences(@NotNull PsiElement element) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(18);
        }
        PyClassRefactoringUtil.restoreNamedReferences(element, null);
    }

    public static void restoreNamedReferences(@NotNull PsiElement newElement, @Nullable PsiElement oldElement) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(19);
        }
        PyClassRefactoringUtil.restoreNamedReferences(newElement, oldElement, PsiElement.EMPTY_ARRAY);
    }

    public static void restoreNamedReferences(final @NotNull PsiElement newElement, final @Nullable PsiElement oldElement, final PsiElement @NotNull [] otherMovedElements) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(21);
        }
        newElement.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(node);
                PyClassRefactoringUtil.restoreReference(node, node, otherMovedElements);
            }

            @Override
            public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitPyStringLiteralExpression(node);
                if (oldElement != null) {
                    for (PsiReference ref : node.getReferences()) {
                        if (!ref.isReferenceTo(oldElement)) continue;
                        ref.bindToElement(newElement);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStringLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreReference(@NotNull PyReferenceExpression sourceNode, @NotNull PyReferenceExpression targetNode, PsiElement @NotNull [] otherMovedElements) {
        if (sourceNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (targetNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(24);
        }
        try {
            PyFunction f;
            PyClass c;
            Object target = (PsiNamedElement)sourceNode.getCopyableUserData(ENCODED_IMPORT);
            String asName = (String)sourceNode.getCopyableUserData(ENCODED_IMPORT_AS);
            Boolean useFromImport = (Boolean)sourceNode.getCopyableUserData(ENCODED_USE_FROM_IMPORT);
            if (target instanceof PsiDirectory) {
                target = (PsiNamedElement)PyUtil.getPackageElement((PsiDirectory)target, (PsiElement)sourceNode);
            }
            if (target instanceof PyFunction && (c = (f = (PyFunction)target).getContainingClass()) != null && c.multiFindInitOrNew(false, null).contains(f)) {
                target = c;
            }
            if (target == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)targetNode.getContainingFile(), (PsiElement)target, (boolean)false)) {
                return;
            }
            if (ArrayUtil.contains((Object)target, (Object[])otherMovedElements)) {
                return;
            }
            if (target instanceof PyFile || target instanceof PsiDirectory) {
                PyPsiRefactoringUtil.insertImport((PsiElement)targetNode, target, asName, useFromImport != null ? useFromImport : true);
            } else {
                PyPsiRefactoringUtil.insertImport((PsiElement)targetNode, target, asName, true);
            }
        }
        finally {
            sourceNode.putCopyableUserData(ENCODED_IMPORT, null);
            sourceNode.putCopyableUserData(ENCODED_IMPORT_AS, null);
            sourceNode.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
        }
    }

    public static void rememberNamedReferences(final @NotNull PsiElement element, final String ... namesToSkip) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (namesToSkip == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(26);
        }
        element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                    return;
                }
                PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
                if (importElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)importElement, (boolean)false)) {
                    return;
                }
                if (!ArrayUtil.contains((String)node.getText(), (String[])namesToSkip)) {
                    PyClassRefactoringUtil.rememberReference(node, element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$2", "visitPyReferenceExpression"));
            }
        });
    }

    private static void rememberReference(@NotNull PyReferenceExpression node, @NotNull PsiElement element) {
        PyExpression qualifier;
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(28);
        }
        if ((qualifier = node.getQualifier()) != null && !(PyClassRefactoringUtil.resolveExpression(qualifier) instanceof PyImportedModule)) {
            return;
        }
        List<PsiElement> allResolveResults = PyClassRefactoringUtil.multiResolveExpression(node);
        Object target = (PsiElement)ContainerUtil.getFirstItem(allResolveResults);
        if (target instanceof PsiNamedElement && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)target, (boolean)false)) {
            PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
            if (!PyUtil.inSameFile(element, target) && importElement == null && !(target instanceof PsiFileSystemItem)) {
                return;
            }
            if (target instanceof PyTargetExpression && "__all__".equals(((PyTargetExpression)target).getName())) {
                for (PsiElement result : allResolveResults) {
                    QualifiedName importedQName;
                    if (!(result instanceof PyImportElement) || (importedQName = ((PyImportElement)result).getImportedQName()) == null) continue;
                    target = new DynamicNamedElement(target.getContainingFile(), importedQName.toString());
                    break;
                }
            }
            node.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)target);
            if (importElement instanceof PyImportElement) {
                node.putCopyableUserData(ENCODED_IMPORT_AS, ((PyImportElement)importElement).getAsName());
            }
            node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, qualifier == null);
        }
    }

    @Nullable
    private static PyImportedNameDefiner getImportElement(PyReferenceExpression expr) {
        for (ResolveResult result : expr.getReference().multiResolve(false)) {
            PsiElement e = result.getElement();
            if (e instanceof PyImportElement) {
                return (PyImportElement)e;
            }
            if (!(e instanceof PyStarImportElement)) continue;
            return (PyStarImportElement)e;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PyExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (expr instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)expr).getReference().resolve();
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> multiResolveExpression(@NotNull PyReferenceExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.mapNotNull((Object[])expr.getReference().multiResolve(false), result -> result.getElement());
        if (list == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    public static void forceAsName(@NotNull PyReferenceExpression node, @NotNull String asName) {
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (asName == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(33);
        }
        if (node.getCopyableUserData(ENCODED_IMPORT) == null) {
            LOG.warn("As name is forced on the referenceExpression, that has no encoded import. Forcing it will likely be ignored.");
        }
        node.putCopyableUserData(ENCODED_IMPORT_AS, asName);
    }

    public static void transferEncodedImports(@NotNull PyReferenceExpression source, @NotNull PyReferenceExpression target) {
        if (source == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(34);
        }
        if (target == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(35);
        }
        target.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)source.getCopyableUserData(ENCODED_IMPORT));
        target.putCopyableUserData(ENCODED_IMPORT_AS, (String)source.getCopyableUserData(ENCODED_IMPORT_AS));
        target.putCopyableUserData(ENCODED_USE_FROM_IMPORT, (Boolean)source.getCopyableUserData(ENCODED_USE_FROM_IMPORT));
        source.putCopyableUserData(ENCODED_IMPORT, null);
        source.putCopyableUserData(ENCODED_IMPORT_AS, null);
        source.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
    }

    public static boolean hasEncodedTarget(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(36);
        }
        return node.getCopyableUserData(ENCODED_IMPORT) != null;
    }

    public static boolean updateUnqualifiedImportOfElement(@NotNull PyImportStatementBase importStatement, @NotNull PsiNamedElement element) {
        String name;
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(37);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(38);
        }
        if ((name = PyPsiRefactoringUtil.getOriginalName(element)) != null) {
            PyImportElement importElement = null;
            for (PyImportElement e : importStatement.getImportElements()) {
                if (!name.equals(PyPsiRefactoringUtil.getOriginalName(e))) continue;
                importElement = e;
            }
            if (importElement != null) {
                PsiFile file = importStatement.getContainingFile();
                PsiFile newFile = element.getContainingFile();
                if (newFile == file || PyPsiRefactoringUtil.insertImport((PsiElement)importStatement, element, importElement.getAsName(), true)) {
                    if (importStatement.getImportElements().length == 1) {
                        boolean isInjected = InjectedLanguageManager.getInstance((Project)importElement.getProject()).isInjectedFragment(importElement.getContainingFile());
                        if (!isInjected) {
                            importStatement.delete();
                        } else {
                            PyClassRefactoringUtil.deleteImportStatementFromInjected(importStatement);
                        }
                    } else {
                        importElement.delete();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void deleteImportStatementFromInjected(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(39);
        }
        PsiElement sibling = importStatement.getPrevSibling();
        importStatement.delete();
        if (sibling instanceof PsiWhiteSpace) {
            sibling.delete();
        }
    }

    public static void optimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(40);
        }
        PyImportOptimizer.onlyRemoveUnused().processFile(file).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dequalifyIfDeclaredInClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destStatementList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: 
            case 25: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMovedElements";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 27: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldDeclarationToStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewValueToAssign";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyMethods";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethods";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMethodInProperPlace";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldDeclarationToStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 31: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNewAssigneeValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewValueToAssign";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMethods";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertMethodInProperPlace";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "restoreNamedReferences";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "restoreReference";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rememberNamedReferences";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rememberReference";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "forceAsName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "transferEncodedImports";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasEncodedTarget";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateUnqualifiedImportOfElement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "deleteImportStatementFromInjected";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DynamicNamedElement
    extends LightElement
    implements PsiNamedElement {
        private final PsiFile myFile;
        private final String myName;

        private DynamicNamedElement(@NotNull PsiFile file, @NotNull String name) {
            if (file == null) {
                DynamicNamedElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                DynamicNamedElement.$$$reportNull$$$0(1);
            }
            super(file.getManager(), file.getLanguage());
            this.myName = name;
            this.myFile = file;
        }

        public String toString() {
            return "DynamicNamedElement(file='" + this.getContainingFile().getName() + "', name='" + this.getName() + "')";
        }

        public PsiFile getContainingFile() {
            return this.myFile;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                DynamicNamedElement.$$$reportNull$$$0(2);
            }
            return null;
        }

        public String getName() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$DynamicNamedElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

