/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.breadcrumbs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.breadcrumbs.PyBreadcrumbsInfoProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u00132\u00020\u0001:\f\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\n\u001a\f\u0012\u0006\b\u0000\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "()V", "acceptElement", "", "e", "Lcom/intellij/psi/PsiElement;", "getElementInfo", "", "getElementTooltip", "getHelper", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyElement;", "getLanguages", "", "Lcom/jetbrains/python/PythonLanguage;", "()[Lcom/jetbrains/python/PythonLanguage;", "getParent", "ClassHelper", "Companion", "ExceptHelper", "ForHelper", "FunctionHelper", "Helper", "IfHelper", "KeyValueHelper", "LambdaHelper", "SimpleHelper", "WhileHelper", "WithHelper", "intellij.python.community.impl"})
public final class PyBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    private static final PythonLanguage[] LANGUAGES;
    private static final List<Helper<?>> HELPERS;
    public static final Companion Companion;

    @NotNull
    public PythonLanguage[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.getHelper(e) != null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getParent();
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Helper<? super PyElement> helper = this.getHelper(e);
        Intrinsics.checkNotNull(helper);
        return helper.elementInfo((PyElement)e);
    }

    @NotNull
    public String getElementTooltip(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Helper<? super PyElement> helper = this.getHelper(e);
        Intrinsics.checkNotNull(helper);
        return helper.elementTooltip((PyElement)e);
    }

    private final Helper<? super PyElement> getHelper(PsiElement e) {
        Object v0;
        block2: {
            if (!(e instanceof PyElement)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = HELPERS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Helper it = (Helper)element$iv;
                boolean bl = false;
                if (!it.getType().isInstance(e)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Companion = new Companion(null);
        LANGUAGES = new PythonLanguage[]{PythonLanguage.getInstance()};
        HELPERS = CollectionsKt.listOf((Object[])new Helper[]{LambdaHelper.INSTANCE, new SimpleHelper<PyTryPart>(PyTryPart.class, "try"), ExceptHelper.INSTANCE, new SimpleHelper<PyFinallyPart>(PyFinallyPart.class, "finally"), new SimpleHelper<PyElsePart>(PyElsePart.class, "else"), IfHelper.INSTANCE, ForHelper.INSTANCE, WhileHelper.INSTANCE, WithHelper.INSTANCE, ClassHelper.INSTANCE, FunctionHelper.INSTANCE, KeyValueHelper.INSTANCE});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\"\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "T", "Lcom/jetbrains/python/psi/PyElement;", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "getType", "()Ljava/lang/Class;", "elementInfo", "", "e", "(Lcom/jetbrains/python/psi/PyElement;)Ljava/lang/String;", "elementTooltip", "getPresentation", "getTruncatedPresentation", "Lorg/jetbrains/annotations/NotNull;", "maxLength", "", "(Lcom/jetbrains/python/psi/PyElement;I)Ljava/lang/String;", "intellij.python.community.impl"})
    private static abstract class Helper<T extends PyElement> {
        @NotNull
        private final Class<T> type;

        @NotNull
        public final String elementInfo(@NotNull T e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return this.getTruncatedPresentation(e, 32);
        }

        @NotNull
        public final String elementTooltip(@NotNull T e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return this.getTruncatedPresentation(e, 96);
        }

        @NotNull
        public abstract String getPresentation(@NotNull T var1);

        private final String getTruncatedPresentation(T e, int maxLength) {
            String string = StringUtil.shortenTextWithEllipsis((String)this.getPresentation(e), (int)maxLength, (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026n(e), maxLength, 0, true)");
            return string;
        }

        @NotNull
        public final Class<T> getType() {
            return this.type;
        }

        public Helper(@NotNull Class<T> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$SimpleHelper;", "T", "Lcom/jetbrains/python/psi/PyElement;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "type", "Ljava/lang/Class;", "representation", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "getRepresentation", "()Ljava/lang/String;", "getPresentation", "e", "(Lcom/jetbrains/python/psi/PyElement;)Ljava/lang/String;", "intellij.python.community.impl"})
    private static final class SimpleHelper<T extends PyElement>
    extends Helper<T> {
        @NotNull
        private final String representation;

        @Override
        @NotNull
        public String getPresentation(@NotNull T e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return this.representation;
        }

        @NotNull
        public final String getRepresentation() {
            return this.representation;
        }

        public SimpleHelper(@NotNull Class<T> type, @NotNull String representation) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)representation, (String)"representation");
            super(type);
            this.representation = representation;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$LambdaHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyLambdaExpression;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class LambdaHelper
    extends Helper<PyLambdaExpression> {
        public static final LambdaHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyLambdaExpression e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return "lambda " + e.getParameterList().getPresentableText(false);
        }

        private LambdaHelper() {
            super(PyLambdaExpression.class);
        }

        static {
            LambdaHelper lambdaHelper;
            INSTANCE = lambdaHelper = new LambdaHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$ExceptHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyExceptPart;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class ExceptHelper
    extends Helper<PyExceptPart> {
        public static final ExceptHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyExceptPart e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PyExpression pyExpression = e.getExceptClass();
            if (pyExpression == null) {
                return "except";
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"e.exceptClass ?: return \"except\"");
            PyExpression exceptClass = pyExpression;
            PyExpression pyExpression2 = e.getTarget();
            if (pyExpression2 == null) {
                return "except " + exceptClass.getText();
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression2, (String)"e.target ?: return \"except ${exceptClass.text}\"");
            PyExpression target = pyExpression2;
            return "except " + exceptClass.getText() + " as " + target.getText();
        }

        private ExceptHelper() {
            super(PyExceptPart.class);
        }

        static {
            ExceptHelper exceptHelper;
            INSTANCE = exceptHelper = new ExceptHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$IfHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyIfPart;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class IfHelper
    extends Helper<PyIfPart> {
        public static final IfHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyIfPart e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String prefix = e.isElif() ? "elif" : "if";
            PyExpression pyExpression = e.getCondition();
            if (pyExpression == null) {
                return prefix;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"e.condition ?: return prefix");
            PyExpression condition = pyExpression;
            return prefix + ' ' + condition.getText();
        }

        private IfHelper() {
            super(PyIfPart.class);
        }

        static {
            IfHelper ifHelper;
            INSTANCE = ifHelper = new IfHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$ForHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyForPart;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class ForHelper
    extends Helper<PyForPart> {
        public static final ForHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyForPart e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiElement parent = e.getParent();
            String prefix = parent instanceof PyForStatement && ((PyForStatement)parent).isAsync() ? "async for" : "for";
            PyExpression pyExpression = e.getTarget();
            if (pyExpression == null) {
                return prefix;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"e.target ?: return prefix");
            PyExpression target = pyExpression;
            PyExpression pyExpression2 = e.getSource();
            if (pyExpression2 == null) {
                return prefix;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression2, (String)"e.source ?: return prefix");
            PyExpression source = pyExpression2;
            return prefix + ' ' + target.getText() + " in " + source.getText();
        }

        private ForHelper() {
            super(PyForPart.class);
        }

        static {
            ForHelper forHelper;
            INSTANCE = forHelper = new ForHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$WhileHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyWhilePart;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class WhileHelper
    extends Helper<PyWhilePart> {
        public static final WhileHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyWhilePart e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PyExpression pyExpression = e.getCondition();
            if (pyExpression == null) {
                return "while";
            }
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"e.condition ?: return \"while\"");
            PyExpression condition = pyExpression;
            return "while " + condition.getText();
        }

        private WhileHelper() {
            super(PyWhilePart.class);
        }

        static {
            WhileHelper whileHelper;
            INSTANCE = whileHelper = new WhileHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$WithHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyWithStatement;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class WithHelper
    extends Helper<PyWithStatement> {
        public static final WithHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyWithStatement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Function1 getItemPresentation2 = getPresentation.getItemPresentation.1.INSTANCE;
            String prefix = e.isAsync() ? "async with " : "with ";
            Object[] $this$orEmpty$iv = e.getWithItems();
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                objectArray = new PyWithItem[]{};
            }
            return SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)getItemPresentation2)), null, (CharSequence)prefix, null, (int)0, null, null, (int)61, null);
        }

        private WithHelper() {
            super(PyWithStatement.class);
        }

        static {
            WithHelper withHelper;
            INSTANCE = withHelper = new WithHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$ClassHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyClass;", "()V", "getPresentation", "", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "e", "intellij.python.community.impl"})
    private static final class ClassHelper
    extends Helper<PyClass> {
        public static final ClassHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyClass e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = e.getName();
            if (string == null) {
                string = "class";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.name ?: \"class\"");
            return string;
        }

        private ClassHelper() {
            super(PyClass.class);
        }

        static {
            ClassHelper classHelper;
            INSTANCE = classHelper = new ClassHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$FunctionHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyFunction;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class FunctionHelper
    extends Helper<PyFunction> {
        public static final FunctionHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyFunction e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String prefix = e.isAsync() ? "async " : "";
            String string = e.getName();
            if (string == null) {
                return "function";
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.name ?: return \"function\"");
            String name = string;
            return prefix + name + "()";
        }

        private FunctionHelper() {
            super(PyFunction.class);
        }

        static {
            FunctionHelper functionHelper;
            INSTANCE = functionHelper = new FunctionHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$KeyValueHelper;", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "Lcom/jetbrains/python/psi/PyKeyValueExpression;", "()V", "getPresentation", "", "e", "intellij.python.community.impl"})
    private static final class KeyValueHelper
    extends Helper<PyKeyValueExpression> {
        public static final KeyValueHelper INSTANCE;

        @Override
        @NotNull
        public String getPresentation(@NotNull PyKeyValueExpression e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PyExpression pyExpression = e.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"e.key");
            String string = pyExpression.getText();
            if (string == null) {
                string = "key";
            }
            return string;
        }

        private KeyValueHelper() {
            super(PyKeyValueExpression.class);
        }

        static {
            KeyValueHelper keyValueHelper;
            INSTANCE = keyValueHelper = new KeyValueHelper();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Companion;", "", "()V", "HELPERS", "", "Lcom/jetbrains/python/breadcrumbs/PyBreadcrumbsInfoProvider$Helper;", "LANGUAGES", "", "Lcom/jetbrains/python/PythonLanguage;", "kotlin.jvm.PlatformType", "[Lcom/jetbrains/python/PythonLanguage;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

