/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.packaging.PyPackage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiPackageUtil {
    private static final Logger LOG = Logger.getInstance(PyPsiPackageUtil.class);
    public static final ImmutableMap<String, List<String>> PACKAGES_TOPLEVEL = PyPsiPackageUtil.loadPackageAliases();

    @Nullable
    public static PyPackage findPackage(@NotNull List<? extends PyPackage> packages, @NotNull String name) {
        if (packages == null) {
            PyPsiPackageUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PyPsiPackageUtil.$$$reportNull$$$0(1);
        }
        for (PyPackage pyPackage : packages) {
            if (!name.equalsIgnoreCase(pyPackage.getName())) continue;
            return pyPackage;
        }
        return null;
    }

    @NotNull
    private static ImmutableMap<String, List<String>> loadPackageAliases() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            Arrays.stream(StringUtil.splitByLines((String)ResourceUtil.loadText((URL)PyPsiPackageUtil.class.getResource("/tools/packages")))).forEach(line2 -> {
                List split = StringUtil.split((String)line2, (String)" ");
                builder.put((Object)((String)split.get(0)), (Object)new SmartList((Collection)ContainerUtil.subList((List)split, (int)1)));
            });
        }
        catch (IOException e) {
            LOG.error("Cannot find \"packages\". " + e.getMessage());
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            PyPsiPackageUtil.$$$reportNull$$$0(2);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyPsiPackageUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyPsiPackageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPackageAliases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

