/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static int copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int read;
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            StreamUtil.$$$reportNull$$$0(1);
        }
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((read = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
            total += read;
        }
        return total;
    }

    public static byte @NotNull [] readBytes(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(2);
        }
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.copy(inputStream, outputStream);
        byte[] byArray = outputStream.toByteArray();
        if (byArray == null) {
            StreamUtil.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    @NotNull
    public static String readText(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(4);
        }
        char[] chars = StreamUtil.readChars(reader);
        String string = StringFactory.createShared(chars);
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String convertSeparators(@NotNull String s) {
        if (s == null) {
            StreamUtil.$$$reportNull$$$0(6);
        }
        String string = StringFactory.createShared(StreamUtil.convertSeparators(s.toCharArray()));
        if (string == null) {
            StreamUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static char @NotNull [] readTextAndConvertSeparators(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(8);
        }
        char[] chars = StreamUtil.readChars(reader);
        char[] cArray = StreamUtil.convertSeparators(chars);
        if (cArray == null) {
            StreamUtil.$$$reportNull$$$0(9);
        }
        return cArray;
    }

    private static char[] convertSeparators(char[] buffer) {
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        if (dst == buffer.length) {
            return buffer;
        }
        char[] result = new char[dst];
        System.arraycopy(buffer, 0, result, 0, result.length);
        return result;
    }

    private static char[] readChars(Reader reader) throws IOException {
        int read;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, read);
        }
        return writer.toCharArray();
    }

    @Deprecated
    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(10);
        }
        if (outputStream == null) {
            StreamUtil.$$$reportNull$$$0(11);
        }
        return StreamUtil.copy(inputStream, outputStream);
    }

    @Deprecated
    public static byte @NotNull [] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(12);
        }
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copy(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = outputStream.toByteArray();
        if (byArray == null) {
            StreamUtil.$$$reportNull$$$0(13);
        }
        return byArray;
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(14);
        }
        return StreamUtil.readText(inputStream, StandardCharsets.UTF_8);
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(15);
        }
        if (encoding == null) {
            StreamUtil.$$$reportNull$$$0(16);
        }
        return StreamUtil.readText(inputStream, Charset.forName(encoding));
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull Charset encoding) throws IOException {
        if (inputStream == null) {
            StreamUtil.$$$reportNull$$$0(17);
        }
        if (encoding == null) {
            StreamUtil.$$$reportNull$$$0(18);
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    @Deprecated
    @NotNull
    public static String readTextFrom(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            StreamUtil.$$$reportNull$$$0(19);
        }
        return StreamUtil.readText(reader);
    }

    @Deprecated
    public static void closeStream(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.getInstance(StreamUtil.class).error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/StreamUtil";
                break;
            }
            case 4: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/StreamUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readBytes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeparators";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readTextAndConvertSeparators";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readBytes";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertSeparators";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTextAndConvertSeparators";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readTextFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

