/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.html.embedding.HtmlCustomEmbeddedContentTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.html.HTMLParser;
import com.intellij.lang.xml.XMLParserDefinition;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.xml.stub.XmlStubBasedElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class HTMLParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new HtmlLexer();
    }

    public IFileElementType getFileNodeType() {
        return XmlElementType.HTML_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = XmlTokenType.WHITESPACES;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = XmlTokenType.COMMENTS;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            HTMLParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new HTMLParser();
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() instanceof XmlStubBasedElementType) {
            Object PsiT = ((XmlStubBasedElementType)node.getElementType()).createPsi(node);
            if (PsiT == null) {
                HTMLParserDefinition.$$$reportNull$$$0(3);
            }
            return PsiT;
        }
        if (node.getElementType() instanceof HtmlCustomEmbeddedContentTokenType) {
            PsiElement psiElement = ((HtmlCustomEmbeddedContentTokenType)node.getElementType()).createPsi(node);
            if (psiElement == null) {
                HTMLParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        if (node.getElementType() == XmlElementType.HTML_EMBEDDED_CONTENT) {
            return new HtmlEmbeddedContentImpl(node);
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            HTMLParserDefinition.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new HtmlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return XMLParserDefinition.canStickTokensTogether(left, right);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/html/HTMLParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

