/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryDataListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryProjectData {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/TestDiscoveryProjectData";
    public static final String TEST_DISCOVERY_DATA_LISTENER_PROP = "test.discovery.data.listener";
    public static final String INSTRUMENT_SHUTDOWN_HOOKS = "test.discovery.use.very.late.shutdown.hook";
    protected static final TestDiscoveryProjectData ourProjectData = new TestDiscoveryProjectData();
    private final NameEnumerator myNameEnumerator;
    private final ConcurrentMap<Integer, boolean[]> myClassToVisitedMethods = new ConcurrentHashMap<Integer, boolean[]>();
    private final ConcurrentMap<Integer, int[]> myClassToMethodNames = new ConcurrentHashMap<Integer, int[]>();
    final ConcurrentMap<Integer, ClassMetadata> classesToMetadata = new ConcurrentHashMap<Integer, ClassMetadata>();
    private final TestDiscoveryDataListener myDataListener;
    private static Long ourTraceTime = 0L;
    private static Long ourCleanupTime = 0L;
    private volatile boolean myFinished;
    private static final Map<Object, File> myOpenFilesMap = new WeakHashMap<Object, File>();
    private static final Collection<String> myOpenFilesPerTest = new LinkedHashSet<String>();
    public static final String AFFECTED_ROOTS = "test.discovery.affected.roots";
    public static final String EXCLUDED_ROOTS = "test.discovery.excluded.roots";
    private static final String[] myAffectedRoots = TestDiscoveryProjectData.split("test.discovery.affected.roots");
    private static final String[] myExcludedRoots = TestDiscoveryProjectData.split("test.discovery.excluded.roots");

    private TestDiscoveryProjectData() {
        try {
            String testDiscoveryDataListener = System.getProperty(TEST_DISCOVERY_DATA_LISTENER_PROP);
            if (testDiscoveryDataListener == null) {
                throw new RuntimeException("Property \"test.discovery.data.listener\" should be specified");
            }
            this.myDataListener = (TestDiscoveryDataListener)Class.forName(testDiscoveryDataListener).newInstance();
            this.myNameEnumerator = this.myDataListener.getNameEnumerator();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        boolean useVeryLateShutDownHook = Boolean.TRUE.toString().equals(System.getProperty(INSTRUMENT_SHUTDOWN_HOOKS));
        if (useVeryLateShutDownHook && !TestDiscoveryProjectData.tryRegisterHook()) {
            useVeryLateShutDownHook = false;
        }
        final boolean finalUseVeryLateShutDownHook = useVeryLateShutDownHook;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                TestDiscoveryProjectData.this.testDiscoveryFinished();
                if (!finalUseVeryLateShutDownHook) {
                    TestDiscoveryProjectData.logTestInfo();
                }
            }
        }));
    }

    public static TestDiscoveryProjectData getProjectData() {
        return ourProjectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] trace(String className, boolean[] methodFlags, String[] methodNames) {
        long s = System.nanoTime();
        try {
            boolean[] blArray = ourProjectData.traceLines(className, methodFlags, methodNames);
            return blArray;
        }
        finally {
            ourTraceTime = ourTraceTime + (System.nanoTime() - s);
        }
    }

    private synchronized boolean[] traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        int classId = this.myNameEnumerator.enumerate(className);
        boolean[] previousMethodFlags = this.myClassToVisitedMethods.putIfAbsent(classId, methodFlags);
        if (previousMethodFlags != null) {
            if (previousMethodFlags.length == methodFlags.length) {
                return previousMethodFlags;
            }
            this.myClassToVisitedMethods.put(classId, methodFlags);
        }
        this.myClassToMethodNames.put(classId, NameEnumerator.enumerate(methodNames, this.myNameEnumerator));
        return methodFlags;
    }

    public synchronized void testDiscoveryEnded(String className, String methodName) {
        try {
            this.myDataListener.testFinished(className, methodName, this.myClassToVisitedMethods, this.myClassToMethodNames, this.enumerateFiles(myOpenFilesPerTest));
            block2: for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
                for (boolean isUsed : (boolean[])e.getValue()) {
                    if (!isUsed) continue;
                    ClassMetadata cm = (ClassMetadata)this.classesToMetadata.remove(e.getKey());
                    if (cm == null) continue block2;
                    this.myDataListener.addClassMetadata(Collections.singletonList(cm));
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<int[]> enumerateFiles(Collection<String> openedFiles) {
        ArrayList<int[]> files = new ArrayList<int[]>(openedFiles.size());
        for (String file : openedFiles) {
            files.add(this.fileToInts(file));
        }
        return files;
    }

    private int[] fileToInts(String file) {
        String[] split = file.split("/");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = this.myNameEnumerator.enumerate(split[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testDiscoveryStarted(String className, String methodName) {
        long s = System.nanoTime();
        try {
            this.cleanup();
        }
        finally {
            ourCleanupTime = ourCleanupTime + (System.nanoTime() - s);
        }
    }

    private void cleanup() {
        for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
            boolean[] used = (boolean[])e.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
        myOpenFilesPerTest.clear();
    }

    private synchronized void testDiscoveryFinished() {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        try {
            this.myDataListener.testsFinished();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addClassMetadata(List<ClassMetadata> classMetadata) {
        for (ClassMetadata cm : classMetadata) {
            this.classesToMetadata.put(this.myNameEnumerator.enumerate(cm.getFqn()), cm);
        }
    }

    NameEnumerator getMyNameEnumerator() {
        return this.myNameEnumerator;
    }

    ConcurrentMap<Integer, int[]> getClassToMethodNames() {
        return this.myClassToMethodNames;
    }

    ConcurrentMap<Integer, boolean[]> getClassToVisitedMethods() {
        return this.myClassToVisitedMethods;
    }

    private static String[] split(String key) {
        String affected = System.getProperty(key);
        return affected == null ? new String[]{} : affected.split(";");
    }

    private static String stripRoot(String path) {
        for (String prefix : myAffectedRoots) {
            if (!path.startsWith(prefix)) continue;
            return path.substring(prefix.length());
        }
        return null;
    }

    private static boolean excluded(String path) {
        for (String prefix : myExcludedRoots) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static String toSystemIndependentName(String fileName) {
        return fileName.replace('\\', '/');
    }

    public static synchronized void openPath(Object path) {
        try {
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            File file = (File)pathClass.getDeclaredMethod("toFile", new Class[0]).invoke(path, new Object[0]);
            TestDiscoveryProjectData.openFile(path, file);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static synchronized void openFile(Object o, File file) {
        if (file == null) {
            return;
        }
        String absolutePath = TestDiscoveryProjectData.getPath(file);
        String trimmedPath = TestDiscoveryProjectData.stripRoot(absolutePath);
        if (trimmedPath == null) {
            return;
        }
        if (TestDiscoveryProjectData.excluded(absolutePath)) {
            return;
        }
        myOpenFilesMap.put(o, file);
        myOpenFilesPerTest.add(TestDiscoveryProjectData.toSystemIndependentName(trimmedPath));
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static synchronized void closeFile(Object o) {
        myOpenFilesMap.remove(o);
    }

    private static synchronized void logTestInfo() {
        System.out.println("Trace time: " + 1.0 * (double)ourTraceTime.longValue() / 1.0E9);
        System.out.println("Cleanup time: " + 1.0 * (double)ourCleanupTime.longValue() / 1.0E9);
        System.out.println("Leaked files: " + myOpenFilesMap.size());
        for (File value : new ArrayList<File>(myOpenFilesMap.values())) {
            System.out.println(value.getPath());
        }
    }

    private static boolean tryRegisterHook() {
        try {
            Object javaLangAccess = TestDiscoveryProjectData.getJavaLangAccess();
            if (javaLangAccess == null) {
                return false;
            }
            Method registerShutdownHook = null;
            for (Method method : javaLangAccess.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("registerShutdownHook")) continue;
                registerShutdownHook = method;
            }
            if (registerShutdownHook == null) {
                return false;
            }
            registerShutdownHook.setAccessible(true);
            registerShutdownHook.invoke(javaLangAccess, 9, true, new Runnable(){

                public void run() {
                    TestDiscoveryProjectData.logTestInfo();
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Object getJavaLangAccess() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> sharedSecrets;
        try {
            sharedSecrets = Class.forName("sun.misc.SharedSecrets");
        }
        catch (ClassNotFoundException e) {
            try {
                sharedSecrets = Class.forName("jdk.internal.misc.SharedSecrets");
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
        Method getJavaLangAccessMethod = sharedSecrets.getDeclaredMethod("getJavaLangAccess", new Class[0]);
        return getJavaLangAccessMethod.invoke(null, new Object[0]);
    }
}

