/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import org.jetbrains.annotations.NotNull;

public final class PropertiesResourceBundleUtil {
    private static final char ESCAPE_SYMBOL = '\\';

    @NotNull
    public static String fromPropertyValueToValueEditor(@NotNull String text) {
        if (text == null) {
            PropertiesResourceBundleUtil.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped && (i == text.length() - 1 || text.charAt(i + 1) != 'u' && text.charAt(i + 1) != 'U')) {
                escaped = true;
                continue;
            }
            if (escaped && (c == 'n' || c == 'r')) {
                buffer.append('\\');
            }
            buffer.append(c);
            escaped = false;
        }
        String string = buffer.toString();
        if (string == null) {
            PropertiesResourceBundleUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String convertValueToFileFormat(@NotNull String value, char delimiter, @NotNull PropertyKeyValueFormat valueFormat) {
        if (value == null) {
            PropertiesResourceBundleUtil.$$$reportNull$$$0(2);
        }
        if (valueFormat == null) {
            PropertiesResourceBundleUtil.$$$reportNull$$$0(3);
        }
        if (valueFormat == PropertyKeyValueFormat.FILE) {
            String string = value;
            if (string == null) {
                PropertiesResourceBundleUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\n' || c == '\r') {
                buffer.append('\\');
                if (valueFormat == PropertyKeyValueFormat.MEMORY) {
                    buffer.append(c == '\n' ? (char)'n' : 'r');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (i == 0 && (c == ' ' || c == '\t') || delimiter == ' ' && (c == '=' || c == ':')) {
                buffer.append('\\');
                buffer.append(c);
                continue;
            }
            if (c == '\\') {
                if (i + 1 >= value.length() || !PropertiesResourceBundleUtil.isEscapedChar(value.charAt(i + 1)) || valueFormat == PropertyKeyValueFormat.MEMORY) {
                    buffer.append('\\');
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            PropertiesResourceBundleUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isEscapedChar(char nextChar) {
        return nextChar == 'n' || nextChar == 'r' || nextChar == 'u' || nextChar == 'U';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/psi/PropertiesResourceBundleUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPropertyValueToValueEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertValueToFileFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromPropertyValueToValueEditor";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertValueToFileFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

