/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UsageNodeTreeBuilder {
    private final GroupNode myRoot;
    private final Project myProject;
    private final UsageTarget[] myTargets;
    private UsageGroupingRule[] myGroupingRules;
    private UsageFilteringRule[] myFilteringRules;

    UsageNodeTreeBuilder(UsageTarget @NotNull [] targets, UsageGroupingRule @NotNull [] groupingRules, UsageFilteringRule @NotNull [] filteringRules, @NotNull GroupNode root, @NotNull Project project) {
        if (root == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(2);
        }
        if (groupingRules == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(3);
        }
        if (filteringRules == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(4);
        }
        this.myTargets = targets;
        this.myGroupingRules = groupingRules;
        this.myFilteringRules = filteringRules;
        this.myRoot = root;
        this.myProject = project;
    }

    public void setGroupingRules(UsageGroupingRule @NotNull [] rules) {
        if (rules == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(5);
        }
        this.myGroupingRules = rules;
    }

    void setFilteringRules(UsageFilteringRule @NotNull [] rules) {
        if (rules == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(6);
        }
        this.myFilteringRules = rules;
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(7);
        }
        return ContainerUtil.and((Object[])this.myFilteringRules, rule -> rule.isVisible(usage, this.myTargets));
    }

    UsageNode appendOrGet(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue, @NotNull Consumer<? super Usage> invalidatedUsagesConsumer) {
        if (usage == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(8);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(9);
        }
        if (invalidatedUsagesConsumer == null) {
            UsageNodeTreeBuilder.$$$reportNull$$$0(10);
        }
        if (!this.isVisible(usage)) {
            return null;
        }
        boolean dumb = DumbService.isDumb(this.myProject);
        GroupNode groupNode = this.myRoot;
        for (int i = 0; i < this.myGroupingRules.length; ++i) {
            UsageGroupingRule rule = this.myGroupingRules[i];
            if (dumb && !DumbService.isDumbAware(rule)) continue;
            List<UsageGroup> groups = rule.getParentGroupsFor(usage, this.myTargets);
            for (UsageGroup group : groups) {
                groupNode = groupNode.addOrGetGroup(group, i, edtModelToSwingNodeChangesQueue, invalidatedUsagesConsumer);
            }
        }
        return groupNode.addOrGetUsage(usage, filterDuplicateLines, edtModelToSwingNodeChangesQueue, invalidatedUsagesConsumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingRules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filteringRules";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtModelToSwingNodeChangesQueue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidatedUsagesConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/UsageNodeTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setGroupingRules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilteringRules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendOrGet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

