/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EditableTreeModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.tree.TreeUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeToolbarDecorator
extends ToolbarDecorator {
    private final JComponent myComponent;
    private final JTree myTree;
    @Nullable
    private final ElementProducer<?> myProducer;

    TreeToolbarDecorator(JTree tree, @Nullable ElementProducer<?> producer) {
        this(tree, tree, producer);
    }

    TreeToolbarDecorator(@NotNull JComponent component, @NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        if (component == null) {
            TreeToolbarDecorator.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            TreeToolbarDecorator.$$$reportNull$$$0(1);
        }
        this.myComponent = component;
        this.myTree = tree;
        this.myProducer = producer;
        this.myUpActionEnabled = this.myDownActionEnabled = this.myTree.getModel() instanceof EditableTreeModel;
        this.myRemoveActionEnabled = this.myDownActionEnabled;
        this.myAddActionEnabled = this.myDownActionEnabled;
        if (this.myTree.getModel() instanceof EditableTreeModel) {
            this.createDefaultTreeActions();
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
        this.myTree.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeToolbarDecorator.this.updateButtons();
            }
        });
    }

    private void createDefaultTreeActions() {
        final EditableTreeModel model = (EditableTreeModel)this.myTree.getModel();
        this.myAddAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object element;
                TreePath path2 = TreeToolbarDecorator.this.myTree.getSelectionPath();
                DefaultMutableTreeNode selected = path2 == null ? (DefaultMutableTreeNode)TreeToolbarDecorator.this.myTree.getModel().getRoot() : (DefaultMutableTreeNode)path2.getLastPathComponent();
                Object selectedNode = selected.getUserObject();
                TreeToolbarDecorator.this.myTree.stopEditing();
                if (model instanceof DefaultTreeModel && TreeToolbarDecorator.this.myProducer != null) {
                    element = TreeToolbarDecorator.this.myProducer.createElement();
                    if (element == null) {
                        return;
                    }
                } else {
                    element = null;
                }
                DefaultMutableTreeNode parent = selected;
                if (selectedNode instanceof SimpleNode && ((SimpleNode)selectedNode).isAlwaysLeaf() || !selected.getAllowsChildren()) {
                    parent = (DefaultMutableTreeNode)selected.getParent();
                }
                if (parent != null) {
                    parent.insert(new DefaultMutableTreeNode(element), parent.getChildCount());
                }
                TreePath createdPath = model.addNode(new TreePath(parent.getPath()));
                if (path2 != null) {
                    TreeUtil.selectPath(TreeToolbarDecorator.this.myTree, createdPath);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(TreeToolbarDecorator.this.myTree, true));
                }
            }
        };
        this.myRemoveAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TreeToolbarDecorator.this.myTree.stopEditing();
                if (TreeToolbarDecorator.this.myTree.getSelectionModel().getSelectionMode() == 1) {
                    TreePath path2 = TreeToolbarDecorator.this.myTree.getSelectionPath();
                    if (path2 != null) {
                        model.removeNode(path2);
                    }
                } else {
                    TreePath[] paths = TreeToolbarDecorator.this.myTree.getSelectionPaths();
                    if (paths != null && paths.length > 0) {
                        model.removeNodes(Arrays.asList(paths));
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    public ToolbarDecorator initPosition() {
        ToolbarDecorator toolbarDecorator = this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.TOP);
        if (toolbarDecorator == null) {
            TreeToolbarDecorator.$$$reportNull$$$0(2);
        }
        return toolbarDecorator;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            TreeToolbarDecorator.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    protected void updateButtons() {
        this.getActionsPanel().setEnabled(CommonActionsPanel.Buttons.REMOVE, this.myTree.getSelectionPath() != null);
    }

    @Override
    @NotNull
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        this.myTree.setVisibleRowCount(rowCount);
        TreeToolbarDecorator treeToolbarDecorator = this;
        if (treeToolbarDecorator == null) {
            TreeToolbarDecorator.$$$reportNull$$$0(4);
        }
        return treeToolbarDecorator;
    }

    @Override
    protected boolean isModelEditable() {
        return this.myTree.getModel() instanceof EditableModel;
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myTree, (EditableModel)this.myTree.getModel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TreeToolbarDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TreeToolbarDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initPosition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setVisibleRowCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

