/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.GHCompletableFutureLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandlerImpl;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingPanelFactory;
import org.jetbrains.plugins.github.pullrequest.ui.GHSimpleLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRListComponent;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowTabComponentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRViewComponentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRViewComponentFactory;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "remote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;Lcom/intellij/openapi/Disposable;)V", "dataContextRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContextRepository;", "createComponent", "Ljavax/swing/JComponent;", "AuthorizationController", "ComponentController", "intellij.vcs.github"})
public final class GHPRToolWindowTabComponentFactory {
    private final GHPRDataContextRepository dataContextRepository;
    private final Project project;
    private final GHRepositoryCoordinates repository;
    private final GitRemoteUrlCoordinates remote;
    private final Disposable parentDisposable;

    @RequiresEdt
    @NotNull
    public final JComponent createComponent() {
        Object object = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = object;
        boolean bl3 = false;
        $this$apply.setBackground(UIUtil.getListBackground());
        JPanel panel2 = object;
        object = new AuthorizationController(panel2);
        bl = false;
        bl2 = false;
        Object it = object;
        boolean bl4 = false;
        UIUtil.putClientProperty((JComponent)panel2, GHPRToolWindowTabComponentController.Companion.getKEY(), (Object)it);
        return panel2;
    }

    public GHPRToolWindowTabComponentFactory(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GitRemoteUrlCoordinates remote, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.repository = repository;
        this.remote = remote;
        this.parentDisposable = parentDisposable;
        this.dataContextRepository = GHPRDataContextRepository.Companion.getInstance(this.project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\b\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0016\u0010&\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010(\u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\b\u0010+\u001a\u00020\u0013H\u0016J(\u0010,\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010/\u0012\u0004\u0012\u00020\u0013\u0018\u00010.H\u0016R/\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentFactory$AuthorizationController;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentController;", "panel", "Ljavax/swing/JPanel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentFactory;Ljavax/swing/JPanel;)V", "<set-?>", "Lcom/intellij/openapi/Disposable;", "contentDisposable", "getContentDisposable", "()Lcom/intellij/openapi/Disposable;", "setContentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "contentDisposable$delegate", "Lkotlin/properties/ReadWriteProperty;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "selectedAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "chooseAccount", "", "accounts", "", "createDataContextLoadingPanel", "Ljavax/swing/JComponent;", "account", "disposable", "createRequestExecutorWithUserInput", "getActualController", "openPullRequestDiff", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "requestFocus", "", "openPullRequestTimeline", "refreshList", "requestNewAccount", "setCenteredContent", "component", "showChooseAccountPanel", "showCreateRequestExecutorPanel", "showLoginPanel", "showPullRequestsComponent", "update", "viewList", "viewPullRequest", "onShown", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRViewComponentController;", "intellij.vcs.github"})
    private final class AuthorizationController
    implements GHPRToolWindowTabComponentController {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private GithubAccount selectedAccount;
        private GithubApiRequestExecutor requestExecutor;
        private final ReadWriteProperty contentDisposable$delegate;
        private final JPanel panel;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(AuthorizationController.class, "contentDisposable", "getContentDisposable()Lcom/intellij/openapi/Disposable;", 0))};
        }

        private final Disposable getContentDisposable() {
            return (Disposable)this.contentDisposable$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void setContentDisposable(Disposable disposable) {
            this.contentDisposable$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)disposable);
        }

        /*
         * WARNING - void declaration
         */
        private final void update() {
            GithubAuthenticationManager authManager = GithubAuthenticationManager.Companion.getInstance();
            if (this.selectedAccount == null) {
                Object v0;
                boolean bl;
                Iterable iterable;
                List accounts;
                block15: {
                    GithubAccount it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = authManager.getAccounts();
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (GithubAccount)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getServer(), (Object)GHPRToolWindowTabComponentFactory.this.repository.getServerPath())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    accounts = (List)destination$iv$iv;
                    if (accounts.size() == 1) {
                        this.selectedAccount = (GithubAccount)CollectionsKt.single((List)accounts);
                    }
                    iterable = accounts;
                    bl = false;
                    Iterable iterable3 = iterable;
                    boolean bl3 = false;
                    for (Object t : iterable3) {
                        it = (GithubAccount)t;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)authManager.getDefaultAccount(GHPRToolWindowTabComponentFactory.this.project))) continue;
                        v0 = t;
                        break block15;
                    }
                    v0 = null;
                }
                GithubAccount defaultAccount = v0;
                if (defaultAccount != null) {
                    this.selectedAccount = defaultAccount;
                }
                iterable = accounts;
                bl = false;
                if (!iterable.isEmpty()) {
                    this.showChooseAccountPanel(accounts);
                } else {
                    this.showLoginPanel();
                }
            }
            GithubAccount githubAccount = this.selectedAccount;
            if (githubAccount == null) {
                return;
            }
            GithubAccount account = githubAccount;
            if (this.requestExecutor == null) {
                try {
                    this.requestExecutor = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account);
                }
                catch (Exception e) {
                    this.showCreateRequestExecutorPanel(account);
                }
            }
            GithubApiRequestExecutor githubApiRequestExecutor = this.requestExecutor;
            if (githubApiRequestExecutor == null) {
                return;
            }
            GithubApiRequestExecutor executor = githubApiRequestExecutor;
            if (this.getContentDisposable() == null) {
                this.showPullRequestsComponent(account, executor);
            } else if (!authManager.getAccounts().contains(account)) {
                this.selectedAccount = null;
                this.requestExecutor = null;
                this.update();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void showLoginPanel() {
            void $this$apply;
            SimpleColoredComponent simpleColoredComponent = GithubUIUtil.INSTANCE.createNoteWithAction((Function0<Unit>)((Function0)new Function0<Unit>(this){

                public final void invoke() {
                    AuthorizationController.access$requestNewAccount((AuthorizationController)this.receiver);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
            AuthorizationController authorizationController = this;
            boolean bl3 = false;
            $this$apply.append(GithubBundle.message("login.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (Object)new Runnable(this){
                final /* synthetic */ AuthorizationController this$0;
                {
                    this.this$0 = authorizationController;
                }

                public final void run() {
                    AuthorizationController.access$requestNewAccount(this.this$0);
                }
            });
            $this$apply.append(" ");
            $this$apply.append(GithubBundle.message("pull.request.account.to.view.prs.suffix", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            Unit unit = Unit.INSTANCE;
            authorizationController.setCenteredContent((JComponent)simpleColoredComponent);
        }

        private final void requestNewAccount() {
            GithubAuthenticationManager.requestNewAccountForServer$default(GithubAuthenticationManager.Companion.getInstance(), GHPRToolWindowTabComponentFactory.this.repository.getServerPath(), GHPRToolWindowTabComponentFactory.this.project, null, 4, null);
            this.update();
            GithubUIUtil.INSTANCE.focusPanel(this.panel);
        }

        /*
         * WARNING - void declaration
         */
        private final void showChooseAccountPanel(List<? extends GithubAccount> accounts) {
            void $this$apply;
            SimpleColoredComponent simpleColoredComponent = GithubUIUtil.INSTANCE.createNoteWithAction((Function0<Unit>)((Function0)new Function0<Unit>(this, accounts){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ List $accounts;

                public final void invoke() {
                    AuthorizationController.access$chooseAccount(this.this$0, this.$accounts);
                }
                {
                    this.this$0 = authorizationController;
                    this.$accounts = list2;
                    super(0);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
            AuthorizationController authorizationController = this;
            boolean bl3 = false;
            $this$apply.append(GithubBundle.message("account.choose.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (Object)new Runnable(this, accounts){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ List $accounts$inlined;
                {
                    this.this$0 = authorizationController;
                    this.$accounts$inlined = list2;
                }

                public final void run() {
                    AuthorizationController.access$chooseAccount(this.this$0, this.$accounts$inlined);
                }
            });
            $this$apply.append(" ");
            $this$apply.append(GithubBundle.message("pull.request.account.to.view.prs.suffix", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            Unit unit = Unit.INSTANCE;
            authorizationController.setCenteredContent((JComponent)simpleColoredComponent);
        }

        private final void chooseAccount(List<? extends GithubAccount> accounts) {
            GithubChooseAccountDialog dialog2 = new GithubChooseAccountDialog(GHPRToolWindowTabComponentFactory.this.project, null, accounts, null, true, true, null, null, 192, null);
            if (dialog2.showAndGet()) {
                this.selectedAccount = dialog2.getAccount();
                if (dialog2.getSetDefault()) {
                    Project $this$service$iv = GHPRToolWindowTabComponentFactory.this.project;
                    boolean $i$f$service = false;
                    Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((GithubProjectDefaultAccountHolder)object).setAccount(dialog2.getAccount());
                }
                this.update();
                GithubUIUtil.INSTANCE.focusPanel(this.panel);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void showCreateRequestExecutorPanel(GithubAccount account) {
            void $this$apply;
            SimpleColoredComponent simpleColoredComponent = GithubUIUtil.INSTANCE.createNoteWithAction((Function0<Unit>)((Function0)new Function0<Unit>(this, account){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ GithubAccount $account;

                public final void invoke() {
                    AuthorizationController.access$createRequestExecutorWithUserInput(this.this$0, this.$account);
                }
                {
                    this.this$0 = authorizationController;
                    this.$account = githubAccount;
                    super(0);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
            AuthorizationController authorizationController = this;
            boolean bl3 = false;
            $this$apply.append(GithubBundle.message("login.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (Object)new Runnable(this, account){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ GithubAccount $account$inlined;
                {
                    this.this$0 = authorizationController;
                    this.$account$inlined = githubAccount;
                }

                public final void run() {
                    AuthorizationController.access$createRequestExecutorWithUserInput(this.this$0, this.$account$inlined);
                }
            });
            $this$apply.append(" ");
            $this$apply.append(GithubBundle.message("pull.request.account.to.view.prs.suffix", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            Unit unit = Unit.INSTANCE;
            authorizationController.setCenteredContent((JComponent)simpleColoredComponent);
        }

        private final void createRequestExecutorWithUserInput(GithubAccount account) {
            this.requestExecutor = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account, GHPRToolWindowTabComponentFactory.this.project);
            this.update();
            GithubUIUtil.INSTANCE.focusPanel(this.panel);
        }

        private final void setCenteredContent(JComponent component) {
            this.setContentDisposable(null);
            JPanel jPanel = this.panel;
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$with = jPanel;
            boolean bl3 = false;
            $this$with.removeAll();
            $this$with.setLayout((LayoutManager)new SingleComponentCenteringLayout());
            $this$with.add(component);
            $this$with.validate();
            $this$with.repaint();
        }

        private final void showPullRequestsComponent(GithubAccount account, GithubApiRequestExecutor requestExecutor) {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
            Disposable newDisposable = disposable;
            this.setContentDisposable(newDisposable);
            JComponent component = this.createDataContextLoadingPanel(account, requestExecutor, newDisposable);
            JPanel jPanel = this.panel;
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$with = jPanel;
            boolean bl3 = false;
            $this$with.removeAll();
            $this$with.setLayout(new BorderLayout());
            $this$with.add((Component)component, "Center");
            $this$with.validate();
            $this$with.repaint();
        }

        private final JComponent createDataContextLoadingPanel(GithubAccount account, GithubApiRequestExecutor requestExecutor, Disposable disposable) {
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
            Disposable uiDisposable = disposable2;
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(this, uiDisposable){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ Disposable $uiDisposable;

                public final void dispose() {
                    Disposer.dispose((Disposable)this.$uiDisposable);
                    GHPRToolWindowTabComponentFactory.access$getDataContextRepository$p(this.this$0.GHPRToolWindowTabComponentFactory.this).clearContext(GHPRToolWindowTabComponentFactory.access$getRepository$p(this.this$0.GHPRToolWindowTabComponentFactory.this));
                }
                {
                    this.this$0 = authorizationController;
                    this.$uiDisposable = disposable;
                }
            });
            GHCompletableFutureLoadingModel<GHPRDataContext> gHCompletableFutureLoadingModel = new GHCompletableFutureLoadingModel<GHPRDataContext>(uiDisposable);
            boolean bl = false;
            boolean bl2 = false;
            GHCompletableFutureLoadingModel<GHPRDataContext> $this$apply = gHCompletableFutureLoadingModel;
            boolean bl3 = false;
            $this$apply.setFuture(GHPRToolWindowTabComponentFactory.this.dataContextRepository.acquireContext(GHPRToolWindowTabComponentFactory.this.repository, GHPRToolWindowTabComponentFactory.this.remote, account, requestExecutor));
            GHCompletableFutureLoadingModel<GHPRDataContext> loadingModel = gHCompletableFutureLoadingModel;
            GHSimpleLoadingModel gHSimpleLoadingModel = loadingModel;
            String string = GithubBundle.message("cannot.load.data.from.github", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"ca\u2026t.load.data.from.github\")");
            return new GHLoadingPanelFactory(gHSimpleLoadingModel, null, string, new GHLoadingErrorHandlerImpl(GHPRToolWindowTabComponentFactory.this.project, account, (Function0<Unit>)((Function0)new Function0<Unit>(this, loadingModel, account, requestExecutor){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ GHCompletableFutureLoadingModel $loadingModel;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ GithubApiRequestExecutor $requestExecutor;

                public final void invoke() {
                    GHPRDataContextRepository contextRepository = GHPRToolWindowTabComponentFactory.access$getDataContextRepository$p(this.this$0.GHPRToolWindowTabComponentFactory.this);
                    contextRepository.clearContext(GHPRToolWindowTabComponentFactory.access$getRepository$p(this.this$0.GHPRToolWindowTabComponentFactory.this));
                    this.$loadingModel.setFuture(contextRepository.acquireContext(GHPRToolWindowTabComponentFactory.access$getRepository$p(this.this$0.GHPRToolWindowTabComponentFactory.this), GHPRToolWindowTabComponentFactory.access$getRemote$p(this.this$0.GHPRToolWindowTabComponentFactory.this), this.$account, this.$requestExecutor));
                }
                {
                    this.this$0 = authorizationController;
                    this.$loadingModel = gHCompletableFutureLoadingModel;
                    this.$account = githubAccount;
                    this.$requestExecutor = githubApiRequestExecutor;
                    super(0);
                }
            }))).create((Function2)new Function2<JPanel, GHPRDataContext, JComponent>(this, disposable){
                final /* synthetic */ AuthorizationController this$0;
                final /* synthetic */ Disposable $disposable;

                @NotNull
                public final JComponent invoke(@NotNull JPanel parent, @NotNull GHPRDataContext result) {
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    Wrapper wrapper = new Wrapper();
                    ComponentController componentController = new ComponentController(result, wrapper, this.$disposable);
                    boolean bl = false;
                    boolean bl2 = false;
                    ComponentController it = componentController;
                    boolean bl3 = false;
                    UIUtil.putClientProperty((JComponent)parent, GHPRToolWindowTabComponentController.Companion.getKEY(), (Object)it);
                    return (JComponent)wrapper;
                }
                {
                    this.this$0 = authorizationController;
                    this.$disposable = disposable;
                    super(2);
                }
            });
        }

        @Override
        public void viewList() {
            block0: {
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this.getActualController();
                if (gHPRToolWindowTabComponentController == null) break block0;
                gHPRToolWindowTabComponentController.viewList();
            }
        }

        @Override
        public void viewPullRequest(@NotNull GHPRIdentifier id, @Nullable Function1<? super GHPRViewComponentController, Unit> onShown) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this.getActualController();
                if (gHPRToolWindowTabComponentController == null) break block0;
                gHPRToolWindowTabComponentController.viewPullRequest(id, onShown);
            }
        }

        @Override
        public void refreshList() {
            block0: {
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this.getActualController();
                if (gHPRToolWindowTabComponentController == null) break block0;
                gHPRToolWindowTabComponentController.refreshList();
            }
        }

        @Override
        public void openPullRequestTimeline(@NotNull GHPRIdentifier id, boolean requestFocus) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this.getActualController();
                if (gHPRToolWindowTabComponentController == null) break block0;
                gHPRToolWindowTabComponentController.openPullRequestTimeline(id, requestFocus);
            }
        }

        @Override
        public void openPullRequestDiff(@NotNull GHPRIdentifier id, boolean requestFocus) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this.getActualController();
                if (gHPRToolWindowTabComponentController == null) break block0;
                gHPRToolWindowTabComponentController.openPullRequestDiff(id, requestFocus);
            }
        }

        private final GHPRToolWindowTabComponentController getActualController() {
            GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController;
            Object[] objectArray = this.panel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"panel.components");
            Component component = (Component)ArraysKt.firstOrNull((Object[])objectArray);
            if (component != null) {
                Component component2 = component;
                boolean bl = false;
                boolean bl2 = false;
                Component it = component2;
                boolean bl3 = false;
                gHPRToolWindowTabComponentController = (GHPRToolWindowTabComponentController)UIUtil.getClientProperty((Object)it, GHPRToolWindowTabComponentController.Companion.getKEY());
            } else {
                gHPRToolWindowTabComponentController = null;
            }
            return gHPRToolWindowTabComponentController;
        }

        public AuthorizationController(JPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            this.panel = panel2;
            Delegates delegates = Delegates.INSTANCE;
            Object initialValue$iv = null;
            boolean $i$f$observable = false;
            this.contentDisposable$delegate = (ReadWriteProperty)new ObservableProperty<Disposable>(initialValue$iv, initialValue$iv, this){
                final /* synthetic */ Object $initialValue;
                final /* synthetic */ AuthorizationController this$0;
                {
                    this.$initialValue = $captured_local_variable$1;
                    this.this$0 = authorizationController;
                    super($super_call_param$2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                    void newValue2;
                    void oldValue2;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    Disposable disposable = (Disposable)newValue;
                    Disposable disposable2 = (Disposable)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    if (oldValue2 != null) {
                        Disposer.dispose((Disposable)oldValue2);
                    }
                    if (newValue2 != null) {
                        Disposer.register((Disposable)GHPRToolWindowTabComponentFactory.access$getParentDisposable$p(this.this$0.GHPRToolWindowTabComponentFactory.this), (Disposable)newValue2);
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            application.getMessageBus().connect(GHPRToolWindowTabComponentFactory.this.parentDisposable).subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)new AccountTokenChangedListener(){

                @Override
                public void tokenChanged(@NotNull GithubAccount account) {
                    Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$0;

                        public final void run() {
                            AuthorizationController.access$update(this.this$0.this);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, GHPRToolWindowTabComponentFactory.this.project.getDisposed());
                }
            });
            this.update();
        }

        public static final /* synthetic */ void access$requestNewAccount(AuthorizationController $this) {
            $this.requestNewAccount();
        }

        public static final /* synthetic */ void access$chooseAccount(AuthorizationController $this, List accounts) {
            $this.chooseAccount(accounts);
        }

        public static final /* synthetic */ void access$createRequestExecutorWithUserInput(AuthorizationController $this, GithubAccount account) {
            $this.createRequestExecutorWithUserInput(account);
        }

        public static final /* synthetic */ void access$update(AuthorizationController $this) {
            $this.update();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0016\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0018H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentFactory$ComponentController;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentController;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowTabComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lcom/intellij/ui/components/panels/Wrapper;Lcom/intellij/openapi/Disposable;)V", "currentDisposable", "currentPullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "listComponent", "Ljavax/swing/JComponent;", "openPullRequestDiff", "", "id", "requestFocus", "", "openPullRequestTimeline", "refreshList", "viewList", "viewPullRequest", "onShown", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRViewComponentController;", "intellij.vcs.github"})
    private final class ComponentController
    implements GHPRToolWindowTabComponentController {
        private final JComponent listComponent;
        private Disposable currentDisposable;
        private GHPRIdentifier currentPullRequest;
        private final GHPRDataContext dataContext;
        private final Wrapper wrapper;
        private final Disposable parentDisposable;

        @Override
        public void viewList() {
            Disposable disposable = this.currentDisposable;
            if (disposable != null) {
                Disposable disposable2 = disposable;
                boolean bl = false;
                boolean bl2 = false;
                Disposable it = disposable2;
                boolean bl3 = false;
                Disposer.dispose((Disposable)it);
            }
            this.currentPullRequest = null;
            this.wrapper.setContent(this.listComponent);
            this.wrapper.repaint();
        }

        @Override
        public void refreshList() {
            this.dataContext.getListLoader().reset();
            this.dataContext.getRepositoryDataService().resetData();
        }

        @Override
        public void viewPullRequest(@NotNull GHPRIdentifier id, @Nullable Function1<? super GHPRViewComponentController, Unit> onShown) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (Intrinsics.areEqual((Object)this.currentPullRequest, (Object)id) ^ true) {
                Disposable it;
                boolean bl;
                boolean bl2;
                Disposable disposable;
                Disposable disposable2 = this.currentDisposable;
                if (disposable2 != null) {
                    disposable = disposable2;
                    bl2 = false;
                    bl = false;
                    it = disposable;
                    boolean bl3 = false;
                    Disposer.dispose((Disposable)it);
                }
                disposable = Disposer.newDisposable((String)"Pull request component disposable");
                bl2 = false;
                bl = false;
                it = disposable;
                ComponentController componentController = this;
                boolean bl4 = false;
                Disposer.register((Disposable)this.parentDisposable, (Disposable)it);
                Unit unit = Unit.INSTANCE;
                componentController.currentDisposable = disposable;
                this.currentPullRequest = id;
                ActionManager actionManager = ActionManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"ActionManager.getInstance()");
                Project project = GHPRToolWindowTabComponentFactory.this.project;
                GHPRToolWindowTabComponentController gHPRToolWindowTabComponentController = this;
                Disposable disposable3 = this.currentDisposable;
                Intrinsics.checkNotNull((Object)disposable3);
                JComponent pullRequestComponent = new GHPRViewComponentFactory(actionManager, project, this.dataContext, gHPRToolWindowTabComponentController, id, disposable3).create();
                this.wrapper.setContent(pullRequestComponent);
                this.wrapper.repaint();
            }
            if (onShown == null) {
                JComponent jComponent = this.wrapper.getTargetComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"wrapper.targetComponent");
                GithubUIUtil.INSTANCE.focusPanel(jComponent);
            } else {
                onShown.invoke(UIUtil.getClientProperty((Object)this.wrapper.getTargetComponent(), GHPRViewComponentController.Companion.getKEY()));
            }
        }

        @Override
        public void openPullRequestTimeline(@NotNull GHPRIdentifier id, boolean requestFocus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.dataContext.getFilesManager().createAndOpenTimelineFile(id, requestFocus);
        }

        @Override
        public void openPullRequestDiff(@NotNull GHPRIdentifier id, boolean requestFocus) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.dataContext.getFilesManager().createAndOpenDiffFile(id, requestFocus);
        }

        public ComponentController(@NotNull GHPRDataContext dataContext, @NotNull Wrapper wrapper, Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.dataContext = dataContext;
            this.wrapper = wrapper;
            this.parentDisposable = parentDisposable;
            this.listComponent = GHPRListComponent.INSTANCE.create(GHPRToolWindowTabComponentFactory.this.project, this.dataContext, this.parentDisposable);
            this.viewList();
            DataManager.registerDataProvider((JComponent)((JComponent)this.wrapper), (DataProvider)new DataProvider(){

                @Nullable
                public final Object getData(@NotNull String dataId) {
                    Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                    return GHPRActionKeys.getPULL_REQUESTS_TAB_CONTROLLER().is(dataId) ? this : null;
                }
            });
        }
    }
}

