/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.google.common.collect.HashMultiset;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.intellij.BundleBase;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItem;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.internal.statistic.actions.CollectFUStatisticsAction;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.LogEventsKt;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/actions/CollectFUStatisticsAction;", "Lcom/intellij/ide/actions/GotoActionBase;", "()V", "gotoActionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showCollectorUsages", "project", "Lcom/intellij/openapi/project/Project;", "item", "Lcom/intellij/internal/statistic/actions/CollectFUStatisticsAction$Item;", "useExtendedPresentation", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Item", "MyChooseByNameModel", "intellij.platform.statistics.devkit"})
public final class CollectFUStatisticsAction
extends GotoActionBase {
    /*
     * WARNING - void declaration
     */
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.statistics.projectUsagesCollector");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026.projectUsagesCollector\")");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ExtensionPointName.creat\u2026Collector\").extensionList");
        List projectCollectors = list;
        ExtensionPointName extensionPointName2 = ExtensionPointName.create((String)"com.intellij.statistics.applicationUsagesCollector");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName2, (String)"ExtensionPointName.creat\u2026licationUsagesCollector\")");
        List list2 = extensionPointName2.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ExtensionPointName.creat\u2026Collector\").extensionList");
        List applicationCollectors = list2;
        List collectors = CollectionsKt.filterIsInstance((Iterable)CollectionsKt.plus((Collection)projectCollectors, (Iterable)applicationCollectors), FeatureUsagesCollector.class);
        Iterable iterable = collectors;
        Collection destination$iv = (Collection)HashMultiset.create();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FeatureUsagesCollector featureUsagesCollector = (FeatureUsagesCollector)item$iv;
            collection = destination$iv;
            boolean bl = false;
            object = it.getGroupId();
            collection.add(object);
        }
        HashMultiset ids = (HashMultiset)destination$iv;
        Iterable $this$map$iv = collectors;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String groupId;
            void collector;
            FeatureUsagesCollector featureUsagesCollector = (FeatureUsagesCollector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)collector.getGroupId(), (String)"collector.groupId");
            String className = StringUtil.nullize((String)collector.getClass().getSimpleName(), (boolean)true);
            object = new Item((FeatureUsagesCollector)collector, groupId, className, ids.count((Object)groupId) > 1);
            collection.add(object);
        }
        List items = (List)destination$iv$iv;
        ContainerUtil.sort((List)items, Comparator.comparing(gotoActionPerformed.1.INSTANCE));
        MyChooseByNameModel model = new MyChooseByNameModel(project2, items);
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup((Project)project2, (ChooseByNameModel)((ChooseByNameModel)model), (PsiElement)GotoActionBase.getPsiContext((AnActionEvent)e));
        popup.setShowListForEmptyPattern(true);
        popup.invoke(new ChooseByNamePopupComponent.Callback(this, project2, model){
            final /* synthetic */ CollectFUStatisticsAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MyChooseByNameModel $model;

            public void onClose() {
                if (Intrinsics.areEqual(((Object)((Object)this.this$0)).getClass(), (Object)CollectFUStatisticsAction.access$getMyInAction$p$s2488330())) {
                    CollectFUStatisticsAction.access$setMyInAction$p$s2488330(null);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void elementChosen(@NotNull Object element) {
                void title$iv;
                void project$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = "Collecting statistics";
                Project project = this.$project;
                boolean cancellable$iv = true;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, (Project)project$iv, (String)title$iv, cancellable$iv, this, element){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ gotoActionPerformed.2 this$0;
                    final /* synthetic */ Object $element$inlined;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.this$0 = var7_7;
                        this.$element$inlined = object;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator indicator2 = indicator;
                        boolean bl = false;
                        indicator2.setIndeterminate(true);
                        Object object = this.$element$inlined;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.internal.statistic.actions.CollectFUStatisticsAction.Item");
                        }
                        indicator2.setText2(((Item)object).getUsagesCollector().getClass().getSimpleName());
                        CollectFUStatisticsAction.access$showCollectorUsages(this.this$0.this$0, this.this$0.$project, (Item)this.$element$inlined, this.this$0.$model.getUseExtendedPresentation(), indicator2);
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$model = $captured_local_variable$2;
            }
        }, ModalityState.current(), false);
    }

    private final void showCollectorUsages(Project project, Item item, boolean useExtendedPresentation, ProgressIndicator indicator) {
        FeatureUsageData featureUsageData;
        Promise promise;
        if (project.isDisposed()) {
            return;
        }
        FeatureUsagesCollector collector = item.getUsagesCollector();
        FeatureUsagesCollector featureUsagesCollector = collector;
        if (featureUsagesCollector instanceof ApplicationUsagesCollector) {
            promise = Promises.resolvedPromise((Object)((ApplicationUsagesCollector)collector).getMetrics());
        } else if (featureUsagesCollector instanceof ProjectUsagesCollector) {
            CancellablePromise cancellablePromise = ((ProjectUsagesCollector)collector).getMetrics(project, indicator);
            Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"collector.getMetrics(project, indicator)");
            promise = (Promise)cancellablePromise;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported collector: " + collector);
        }
        Promise metricsPromise = promise;
        FeatureUsagesCollector featureUsagesCollector2 = collector;
        if (featureUsagesCollector2 instanceof ApplicationUsagesCollector) {
            featureUsageData = ((ApplicationUsagesCollector)collector).getData();
        } else if (featureUsagesCollector2 instanceof ProjectUsagesCollector) {
            featureUsageData = ((ProjectUsagesCollector)collector).getData(project);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported collector: " + collector);
        }
        FeatureUsageData groupData = featureUsageData;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        StringBuilder result = new StringBuilder();
        metricsPromise.onSuccess((Consumer)new Consumer<Set<MetricEvent>>(useExtendedPresentation, result, groupData, collector, gson, item, project){
            final /* synthetic */ boolean $useExtendedPresentation;
            final /* synthetic */ StringBuilder $result;
            final /* synthetic */ FeatureUsageData $groupData;
            final /* synthetic */ FeatureUsagesCollector $collector;
            final /* synthetic */ Gson $gson;
            final /* synthetic */ Item $item;
            final /* synthetic */ Project $project;

            public final void accept(@NotNull Set<MetricEvent> metrics) {
                if (this.$useExtendedPresentation) {
                    this.$result.append("[\n");
                    for (MetricEvent metric : metrics) {
                        FeatureUsageData featureUsageData = FUStateUsagesLogger.mergeWithEventData((FeatureUsageData)this.$groupData, (FeatureUsageData)metric.getData());
                        Intrinsics.checkNotNull((Object)featureUsageData);
                        Map metricData = featureUsageData.build();
                        long l = System.currentTimeMillis();
                        String string = this.$collector.getGroupId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collector.groupId");
                        LogEvent event = LogEventsKt.newLogEvent((String)"test.session", (String)"build", (String)"bucket", (long)l, (String)string, (String)String.valueOf(this.$collector.getVersion()), (String)"recorder.version", (String)"event.id", (boolean)true);
                        Map map2 = metricData;
                        boolean bl = false;
                        for (Map.Entry<K, V> datum : map2.entrySet()) {
                            event.getEvent().addData((String)datum.getKey(), datum.getValue());
                        }
                        String presentation = LogEventSerializer.INSTANCE.toString(event);
                        this.$result.append(presentation);
                        this.$result.append(",\n");
                    }
                    this.$result.append("]");
                } else {
                    this.$result.append("{");
                    for (MetricEvent metric : metrics) {
                        this.$result.append("\"");
                        this.$result.append(metric.getEventId());
                        this.$result.append("\" : ");
                        JsonElement presentation = this.$gson.toJsonTree((Object)metric.getData().build());
                        this.$result.append(presentation);
                        this.$result.append(",\n");
                    }
                    this.$result.append("}");
                }
                FileType fileType = FileTypeManager.getInstance().getStdFileType("JSON");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"FileTypeManager.getInsta\u2026().getStdFileType(\"JSON\")");
                FileType fileType2 = fileType;
                LightVirtualFile file = new LightVirtualFile(this.$item.getGroupId(), fileType2, (CharSequence)this.$result.toString());
                ApplicationManager.getApplication().invokeLater(new Runnable(this, file){
                    final /* synthetic */ showCollectorUsages.1 this$0;
                    final /* synthetic */ LightVirtualFile $file;

                    public final void run() {
                        FileEditorManager.getInstance((Project)this.this$0.$project).openFile((VirtualFile)this.$file, true);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$file = lightVirtualFile;
                    }
                });
            }
            {
                this.$useExtendedPresentation = bl;
                this.$result = stringBuilder;
                this.$groupData = featureUsageData;
                this.$collector = featureUsagesCollector;
                this.$gson = gson;
                this.$item = item;
                this.$project = project;
            }
        });
    }

    public static final /* synthetic */ Class access$getMyInAction$p$s2488330() {
        return GotoActionBase.myInAction;
    }

    public static final /* synthetic */ void access$setMyInAction$p$s2488330(Class clazz) {
        GotoActionBase.myInAction = clazz;
    }

    public static final /* synthetic */ void access$showCollectorUsages(CollectFUStatisticsAction $this, Project project, Item item, boolean useExtendedPresentation, ProgressIndicator indicator) {
        $this.showCollectorUsages(project, item, useExtendedPresentation, indicator);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/actions/CollectFUStatisticsAction$Item;", "Lcom/intellij/ide/util/gotoByName/ChooseByNameItem;", "usagesCollector", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "groupId", "", "className", "nonUniqueId", "", "(Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;Ljava/lang/String;Ljava/lang/String;Z)V", "getClassName", "()Ljava/lang/String;", "getGroupId", "getNonUniqueId", "()Z", "getUsagesCollector", "()Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "getDescription", "getName", "intellij.platform.statistics.devkit"})
    private static final class Item
    implements ChooseByNameItem {
        @NotNull
        private final FeatureUsagesCollector usagesCollector;
        @NotNull
        private final String groupId;
        @Nullable
        private final String className;
        private final boolean nonUniqueId;

        @NotNull
        public String getName() {
            return this.groupId + (this.nonUniqueId ? " (" + this.className + ')' : "");
        }

        @Nullable
        public String getDescription() {
            return this.className;
        }

        @NotNull
        public final FeatureUsagesCollector getUsagesCollector() {
            return this.usagesCollector;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @Nullable
        public final String getClassName() {
            return this.className;
        }

        public final boolean getNonUniqueId() {
            return this.nonUniqueId;
        }

        public Item(@NotNull FeatureUsagesCollector usagesCollector, @NotNull String groupId, @Nullable String className, boolean nonUniqueId) {
            Intrinsics.checkNotNullParameter((Object)usagesCollector, (String)"usagesCollector");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            this.usagesCollector = usagesCollector;
            this.groupId = groupId;
            this.className = className;
            this.nonUniqueId = nonUniqueId;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/actions/CollectFUStatisticsAction$MyChooseByNameModel;", "Lcom/intellij/ide/util/gotoByName/ListChooseByNameModel;", "Lcom/intellij/internal/statistic/actions/CollectFUStatisticsAction$Item;", "project", "Lcom/intellij/openapi/project/Project;", "items", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "useExtendedPresentation", "", "getUseExtendedPresentation", "()Z", "setUseExtendedPresentation", "(Z)V", "getCheckBoxName", "", "loadInitialCheckBoxState", "saveInitialCheckBoxState", "", "state", "useMiddleMatching", "intellij.platform.statistics.devkit"})
    private static final class MyChooseByNameModel
    extends ListChooseByNameModel<Item> {
        private boolean useExtendedPresentation;

        public final boolean getUseExtendedPresentation() {
            return this.useExtendedPresentation;
        }

        public final void setUseExtendedPresentation(boolean bl) {
            this.useExtendedPresentation = bl;
        }

        @Nullable
        public String getCheckBoxName() {
            return BundleBase.replaceMnemonicAmpersand((String)"&Extended presentation");
        }

        public boolean loadInitialCheckBoxState() {
            return false;
        }

        public void saveInitialCheckBoxState(boolean state) {
            this.useExtendedPresentation = state;
        }

        public boolean useMiddleMatching() {
            return true;
        }

        public MyChooseByNameModel(@NotNull Project project, @NotNull List<Item> items) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            super(project, "Enter usage collector group id", "No collectors found", items);
        }
    }
}

