/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateCopyrightAction
extends BaseAnalysisAction {
    public static final String UPDATE_EXISTING_COPYRIGHTS = "update.existing.copyrights";
    private JCheckBox myUpdateExistingCopyrightsCb;

    protected UpdateCopyrightAction() {
        super(UpdateCopyrightProcessor.TITLE, UpdateCopyrightProcessor.TITLE);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            UpdateCopyrightAction.$$$reportNull$$$0(0);
        }
        boolean enabled = UpdateCopyrightAction.isEnabled(event);
        event.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        PsiElement[] elems;
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        if (!CopyrightManager.getInstance(project).hasAnyCopyrights()) {
            return false;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            return FileTypeUtil.isSupportedFile(file);
        }
        if (files != null && UpdateCopyrightAction.areFiles(files)) {
            boolean copyrightEnabled = false;
            for (VirtualFile vfile : files) {
                if (vfile == null || !FileTypeUtil.isSupportedFile(vfile)) continue;
                copyrightEnabled = true;
                break;
            }
            return copyrightEnabled;
        }
        if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(context) == null && LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(context) == null && (elems = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context)) != null) {
            boolean copyrightEnabled = false;
            for (PsiElement elem : elems) {
                PsiFile file;
                if (elem instanceof PsiDirectory || (file = elem.getContainingFile()) != null && FileTypeUtil.isSupportedFile(file.getVirtualFile())) continue;
                copyrightEnabled = true;
                break;
            }
            return copyrightEnabled;
        }
        return true;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myUpdateExistingCopyrightsCb = new JCheckBox(CopyrightBundle.message("checkbox.text.update.existing.copyrights", new Object[0]), PropertiesComponent.getInstance().getBoolean(UPDATE_EXISTING_COPYRIGHTS, true));
        panel.add(this.myUpdateExistingCopyrightsCb);
        return panel;
    }

    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            UpdateCopyrightAction.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            UpdateCopyrightAction.$$$reportNull$$$0(2);
        }
        PropertiesComponent.getInstance().setValue(UPDATE_EXISTING_COPYRIGHTS, String.valueOf(this.myUpdateExistingCopyrightsCb.isSelected()), "true");
        final LinkedHashMap preparations = new LinkedHashMap();
        Task.Backgroundable task = new Task.Backgroundable(project, CopyrightBundle.message("task.title.prepare.copyright", new Object[0]), true){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                scope.accept(new PsiElementVisitor(){

                    public void visitFile(@NotNull PsiFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (indicator.isCanceled()) {
                            return;
                        }
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                        UpdateCopyrightProcessor processor = new UpdateCopyrightProcessor(project, module, file);
                        Runnable runnable = processor.preprocessFile(file, UpdateCopyrightAction.this.myUpdateExistingCopyrightsCb.isSelected());
                        if (runnable != EmptyRunnable.getInstance()) {
                            preparations.put(file, runnable);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction$1$1", "visitFile"));
                    }
                });
            }

            public void onSuccess() {
                if (!preparations.isEmpty()) {
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite(preparations.keySet())) {
                        return;
                    }
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, UpdateCopyrightProcessor.TITLE.get(), true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask((SequentialTask)new UpdateCopyrightSequentialTask(preparations, progressTask));
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                        ProgressManager.getInstance().run((Task)progressTask);
                    }, UpdateCopyrightAction.this.getTemplatePresentation().getText(), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static boolean areFiles(VirtualFile @NotNull [] files) {
        if (files == null) {
            UpdateCopyrightAction.$$$reportNull$$$0(3);
        }
        if (files.length < 2) {
            return false;
        }
        for (VirtualFile file : files) {
            if (!file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UpdateCopyrightSequentialTask
    implements SequentialTask {
        private final int mySize;
        private final Iterator<Runnable> myRunnables;
        private final SequentialModalProgressTask myProgressTask;
        private int myIdx;

        private UpdateCopyrightSequentialTask(Map<PsiFile, Runnable> runnables, SequentialModalProgressTask progressTask) {
            this.myRunnables = runnables.values().iterator();
            this.myProgressTask = progressTask;
            this.mySize = runnables.size();
        }

        public boolean isDone() {
            return this.myIdx > this.mySize - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myProgressTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myIdx / (double)this.mySize);
            }
            this.myRunnables.next().run();
            ++this.myIdx;
            return true;
        }

        public void stop() {
            this.myIdx = this.mySize;
        }
    }
}

