/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FileBasedStorageConfiguration;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"defaultFileBasedStorageConfiguration", "Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "getDefaultFileBasedStorageConfiguration", "()Lcom/intellij/configurationStore/FileBasedStorageConfiguration;", "doResolveVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "reasonOperation", "Lcom/intellij/openapi/components/StateStorageOperation;", "intellij.platform.configurationStore.impl"})
public final class FileBasedStorageConfigurationKt {
    @NotNull
    private static final FileBasedStorageConfiguration defaultFileBasedStorageConfiguration = new FileBasedStorageConfiguration(){

        public boolean isUseVfsForRead() {
            return false;
        }

        public boolean isUseVfsForWrite() {
            return true;
        }

        @Nullable
        public VirtualFile resolveVirtualFile(@NotNull String path, @NotNull StateStorageOperation reasonOperation) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)reasonOperation, (String)"reasonOperation");
            return FileBasedStorageConfiguration.DefaultImpls.resolveVirtualFile(this, path, reasonOperation);
        }
    };

    @NotNull
    public static final FileBasedStorageConfiguration getDefaultFileBasedStorageConfiguration() {
        return defaultFileBasedStorageConfiguration;
    }

    @Nullable
    public static final VirtualFile doResolveVirtualFile(@NotNull String path, @NotNull StateStorageOperation reasonOperation) {
        VirtualFile result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)reasonOperation, (String)"reasonOperation");
        LocalFileSystem fs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = result = reasonOperation == StateStorageOperation.READ ? fs.findFileByPath(path) : fs.refreshAndFindFileByPath(path);
        if (result == null || !result.isValid()) {
            return null;
        }
        result.setCharset(Charsets.UTF_8, null, false);
        return result;
    }
}

