/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Variable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/debugger/MemberFilter;", "", "additionalVariables", "", "Lorg/jetbrains/debugger/Variable;", "getAdditionalVariables", "()Ljava/util/Collection;", "hasNameMappings", "", "isMemberVisible", "variable", "rawNameToSource", "", "sourceNameToRaw", "name", "intellij.platform.scriptDebugger.ui"})
public interface MemberFilter {
    public boolean isMemberVisible(@NotNull Variable var1);

    @NotNull
    public Collection<Variable> getAdditionalVariables();

    @NotNull
    public String rawNameToSource(@NotNull Variable var1);

    @Nullable
    public String sourceNameToRaw(@NotNull String var1);

    public boolean hasNameMappings();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static boolean isMemberVisible(@NotNull MemberFilter $this, @NotNull Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            return variable.isReadable();
        }

        @NotNull
        public static Collection<Variable> getAdditionalVariables(@NotNull MemberFilter $this) {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public static String rawNameToSource(@NotNull MemberFilter $this, @NotNull Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            String string = variable.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variable.name");
            return string;
        }

        @Nullable
        public static String sourceNameToRaw(@NotNull MemberFilter $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return null;
        }

        public static boolean hasNameMappings(@NotNull MemberFilter $this) {
            return false;
        }
    }
}

