/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpBackrefImpl
extends RegExpElementImpl
implements RegExpBackref {
    public RegExpBackrefImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public int getIndex() {
        return Integer.parseInt(this.getIndexNumberText());
    }

    @NotNull
    private String getIndexNumberText() {
        String s = this.getUnescapedText();
        assert (s.charAt(0) == '\\');
        boolean pcreBackReference = s.charAt(1) == 'g';
        String string = pcreBackReference ? RegExpBackrefImpl.getPcreBackrefIndexNumberText(s.substring(2)) : s.substring(1);
        if (string == null) {
            RegExpBackrefImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getPcreBackrefIndexNumberText(String s) {
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)s, (String)"{"), (String)"}");
        if (string == null) {
            RegExpBackrefImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpBackref(this);
    }

    @Override
    public RegExpGroup resolve() {
        int index = this.getIndex();
        if (index < 0) {
            return this.resolveRelativeGroup(Math.abs(index));
        }
        return (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)this.getContainingFile()).traverse().takeWhile(e -> e != this).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).skip(index - 1).first();
    }

    @Nullable
    private RegExpGroup resolveRelativeGroup(int index) {
        List groups2 = SyntaxTraverser.psiTraverser((PsiElement)this.getContainingFile()).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).toList();
        return index <= groups2.size() ? (RegExpGroup)groups2.get(groups2.size() - index) : null;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @NotNull
            public PsiElement getElement() {
                RegExpBackrefImpl regExpBackrefImpl = RegExpBackrefImpl.this;
                if (regExpBackrefImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return regExpBackrefImpl;
            }

            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = TextRange.from((int)0, (int)this.getElement().getTextLength());
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getElement().getText();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new IncorrectOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                if (element2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new IncorrectOperationException();
            }

            public boolean isReferenceTo(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return Comparing.equal((Object)element2, (Object)this.resolve());
            }

            public boolean isSoft() {
                return false;
            }

            public PsiElement resolve() {
                return RegExpBackrefImpl.this.resolve();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isReferenceTo";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexNumberText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPcreBackrefIndexNumberText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

