/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.fs.LazyAttachVirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyAttachVirtualFS
extends VirtualFileSystem {
    private static final Logger LOG = Logger.getInstance(LazyAttachVirtualFS.class);
    @NonNls
    private static final String PROTOCOL = "lazyAttachVfs";
    private final Map<String, LazyAttachVirtualFile> myFileCache = new HashMap<String, LazyAttachVirtualFile>();

    public static LazyAttachVirtualFS getInstance() {
        return (LazyAttachVirtualFS)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path, @NotNull EnvironmentAwareHost hostInfo) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(0);
        }
        if (hostInfo == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(1);
        }
        String fullFilePath = hostInfo.getFileSystemHostId() + path;
        return (VirtualFile)this.myFileCache.computeIfAbsent(fullFilePath, s -> {
            String content2;
            try {
                content2 = LazyAttachVirtualFS.getFileContent(hostInfo, path);
            }
            catch (IOException e) {
                LOG.warn("can't read file", (Throwable)e);
                return null;
            }
            if (content2 == null) {
                return null;
            }
            return new LazyAttachVirtualFile(fullFilePath, content2);
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(2);
        }
        return (VirtualFile)this.myFileCache.get(path);
    }

    public void refresh(boolean asynchronous) {
        throw new IncorrectOperationException();
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(3);
        }
        return null;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(4);
        }
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(5);
        }
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(6);
        }
        throw new IncorrectOperationException();
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(7);
        }
        if (newParent == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException();
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName2) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(9);
        }
        if (newName2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) {
        if (vDir == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        if (vDir == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(13);
        }
        if (dirName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(14);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (virtualFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(15);
        }
        if (newParent == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(16);
        }
        if (copyName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(17);
        }
        throw new IncorrectOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    private static String getFileContent(@NotNull EnvironmentAwareHost host, @NotNull String path) throws IOException {
        InputStream stream;
        if (host == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(18);
        }
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(19);
        }
        if ((stream = host.getFileContent(path)) == null) {
            return null;
        }
        return new String(FileUtil.loadBytes((InputStream)stream), StandardCharsets.UTF_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/attach/fs/LazyAttachVirtualFS";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAndFindFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addVirtualFileListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVirtualFileListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moveFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "renameFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createChildFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createChildDirectory";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

