/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.IndexableFilesFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J4\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/roots/IndexableFilesIterationMethods;", "", "()V", "followSymlinks", "", "getFollowSymlinks", "()Z", "iterateNonExcludedRoots", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "contentIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "visitedFileSet", "Lcom/intellij/util/containers/ConcurrentBitSet;", "shouldIndexFile", "file", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "filters", "", "Lcom/intellij/util/indexing/IndexableFilesFilter;", "rootsSet", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class IndexableFilesIterationMethods {
    public static final IndexableFilesIterationMethods INSTANCE;

    private final boolean getFollowSymlinks() {
        return Registry.is((String)"indexer.follows.symlinks");
    }

    public final boolean iterateNonExcludedRoots(@NotNull Project project, @NotNull Iterable<? extends VirtualFile> roots, @NotNull ContentIterator contentIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)contentIterator, (String)"contentIterator");
            Intrinsics.checkNotNullParameter((Object)visitedFileSet, (String)"visitedFileSet");
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            ExtensionPointName<IndexableFilesFilter> extensionPointName = IndexableFilesFilter.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableFilesFilter.EP_NAME");
            List list2 = extensionPointName.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"IndexableFilesFilter.EP_NAME.extensionList");
            List filters = list2;
            Set rootsSet = CollectionsKt.toSet(roots);
            VirtualFileFilter virtualFileFilter = ((VirtualFileFilter)new VirtualFileFilter(visitedFileSet){
                final /* synthetic */ ConcurrentBitSet $visitedFileSet;

                public final boolean accept(@NotNull VirtualFile file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    return file2 instanceof VirtualFileWithId && ((VirtualFileWithId)file2).getId() > 0 && !this.$visitedFileSet.set(((VirtualFileWithId)file2).getId());
                }
                {
                    this.$visitedFileSet = concurrentBitSet;
                }
            }).and(new VirtualFileFilter(projectFileIndex2, filters, rootsSet){
                final /* synthetic */ ProjectFileIndex $projectFileIndex;
                final /* synthetic */ List $filters;
                final /* synthetic */ Set $rootsSet;

                public final boolean accept(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IndexableFilesIterationMethods.access$shouldIndexFile(IndexableFilesIterationMethods.INSTANCE, it, this.$projectFileIndex, this.$filters, this.$rootsSet);
                }
                {
                    this.$projectFileIndex = projectFileIndex;
                    this.$filters = list2;
                    this.$rootsSet = set2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileFilter, (String)"VirtualFileFilter { file\u2026dex, filters, rootsSet) }");
            VirtualFileFilter fileFilter2 = virtualFileFilter;
            Iterable<? extends VirtualFile> $this$all$iv = roots;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<? extends VirtualFile> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile element$iv;
                    VirtualFile root = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, (VirtualFileFilter)fileFilter2, (ContentIterator)contentIterator)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean shouldIndexFile(VirtualFile file2, ProjectFileIndex projectFileIndex, List<? extends IndexableFilesFilter> filters, Set<? extends VirtualFile> rootsSet) {
        if (file2.is(VFileProperty.SYMLINK)) {
            if (!this.getFollowSymlinks()) {
                return false;
            }
            VirtualFile targetFile = file2.getCanonicalFile();
            if (targetFile == null || targetFile.is(VFileProperty.SYMLINK)) {
                return false;
            }
            if (rootsSet.contains(file2)) {
                return true;
            }
            return this.shouldIndexFile(targetFile, projectFileIndex, filters, rootsSet);
        }
        if (!(file2 instanceof VirtualFileWithId) || ((VirtualFileWithId)file2).getId() <= 0) {
            return false;
        }
        boolean $i$f$runReadAction22 = false;
        if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(projectFileIndex, file2){
            final /* synthetic */ ProjectFileIndex $projectFileIndex$inlined;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.$projectFileIndex$inlined = projectFileIndex;
                this.$file$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(this.$projectFileIndex$inlined.isExcluded(this.$file$inlined));
            }
        })).booleanValue()) {
            return false;
        }
        Collection $i$f$runReadAction22 = filters;
        boolean bl = false;
        if (!$i$f$runReadAction22.isEmpty()) {
            boolean bl2;
            block11: {
                Iterable $this$none$iv = filters;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IndexableFilesFilter it = (IndexableFilesFilter)element$iv;
                        boolean bl3 = false;
                        if (!it.shouldIndex(file2)) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
        }
        return true;
    }

    private IndexableFilesIterationMethods() {
    }

    static {
        IndexableFilesIterationMethods indexableFilesIterationMethods;
        INSTANCE = indexableFilesIterationMethods = new IndexableFilesIterationMethods();
    }

    public static final /* synthetic */ boolean access$shouldIndexFile(IndexableFilesIterationMethods $this, VirtualFile file2, ProjectFileIndex projectFileIndex, List filters, Set rootsSet) {
        return $this.shouldIndexFile(file2, projectFileIndex, filters, rootsSet);
    }
}

