/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.util.indexing.UnindexedFileStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u00060\u0014j\u0002`\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001e\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00060\u0014j\u0002`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001e\u0010\u001d\u001a\u00060\u0014j\u0002`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001e\u0010 \u001a\u00060\u0014j\u0002`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "", "fileSetName", "", "(Ljava/lang/String;)V", "getFileSetName", "()Ljava/lang/String;", "numberOfFilesForIndexing", "", "getNumberOfFilesForIndexing", "()I", "setNumberOfFilesForIndexing", "(I)V", "numberOfFilesFullyIndexedByInfrastructureExtension", "getNumberOfFilesFullyIndexedByInfrastructureExtension", "setNumberOfFilesFullyIndexedByInfrastructureExtension", "numberOfScannedFiles", "getNumberOfScannedFiles", "setNumberOfScannedFiles", "scanningTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "getScanningTime", "()J", "setScanningTime", "(J)V", "timeIndexingWithoutContent", "getTimeIndexingWithoutContent", "setTimeIndexingWithoutContent", "timeProcessingUpToDateFiles", "getTimeProcessingUpToDateFiles", "setTimeProcessingUpToDateFiles", "timeUpdatingContentLessIndexes", "getTimeUpdatingContentLessIndexes", "setTimeUpdatingContentLessIndexes", "addStatus", "", "unindexedFileStatus", "Lcom/intellij/util/indexing/UnindexedFileStatus;", "statusTime", "intellij.platform.lang.impl"})
public final class ScanningStatistics {
    private int numberOfScannedFiles;
    private int numberOfFilesForIndexing;
    private int numberOfFilesFullyIndexedByInfrastructureExtension;
    private long scanningTime;
    private long timeProcessingUpToDateFiles;
    private long timeUpdatingContentLessIndexes;
    private long timeIndexingWithoutContent;
    @NotNull
    private final String fileSetName;

    public final int getNumberOfScannedFiles() {
        return this.numberOfScannedFiles;
    }

    public final void setNumberOfScannedFiles(int n) {
        this.numberOfScannedFiles = n;
    }

    public final int getNumberOfFilesForIndexing() {
        return this.numberOfFilesForIndexing;
    }

    public final void setNumberOfFilesForIndexing(int n) {
        this.numberOfFilesForIndexing = n;
    }

    public final int getNumberOfFilesFullyIndexedByInfrastructureExtension() {
        return this.numberOfFilesFullyIndexedByInfrastructureExtension;
    }

    public final void setNumberOfFilesFullyIndexedByInfrastructureExtension(int n) {
        this.numberOfFilesFullyIndexedByInfrastructureExtension = n;
    }

    public final long getScanningTime() {
        return this.scanningTime;
    }

    public final void setScanningTime(long l) {
        this.scanningTime = l;
    }

    public final long getTimeProcessingUpToDateFiles() {
        return this.timeProcessingUpToDateFiles;
    }

    public final void setTimeProcessingUpToDateFiles(long l) {
        this.timeProcessingUpToDateFiles = l;
    }

    public final long getTimeUpdatingContentLessIndexes() {
        return this.timeUpdatingContentLessIndexes;
    }

    public final void setTimeUpdatingContentLessIndexes(long l) {
        this.timeUpdatingContentLessIndexes = l;
    }

    public final long getTimeIndexingWithoutContent() {
        return this.timeIndexingWithoutContent;
    }

    public final void setTimeIndexingWithoutContent(long l) {
        this.timeIndexingWithoutContent = l;
    }

    public final void addStatus(@NotNull UnindexedFileStatus unindexedFileStatus, long statusTime) {
        Intrinsics.checkNotNullParameter((Object)unindexedFileStatus, (String)"unindexedFileStatus");
        int n = this.numberOfScannedFiles;
        this.numberOfScannedFiles = n + 1;
        if (unindexedFileStatus.getShouldIndex()) {
            n = this.numberOfFilesForIndexing;
            this.numberOfFilesForIndexing = n + 1;
        }
        this.scanningTime += statusTime;
        this.timeProcessingUpToDateFiles += unindexedFileStatus.getTimeProcessingUpToDateFiles();
        this.timeUpdatingContentLessIndexes += unindexedFileStatus.getTimeUpdatingContentLessIndexes();
        this.timeIndexingWithoutContent += unindexedFileStatus.getTimeIndexingWithoutContent();
        if (unindexedFileStatus.getWasFullyIndexedByInfrastructureExtension()) {
            n = this.numberOfFilesFullyIndexedByInfrastructureExtension;
            this.numberOfFilesFullyIndexedByInfrastructureExtension = n + 1;
        }
    }

    @NotNull
    public final String getFileSetName() {
        return this.fileSetName;
    }

    public ScanningStatistics(@NotNull String fileSetName) {
        Intrinsics.checkNotNullParameter((Object)fileSetName, (String)"fileSetName");
        this.fileSetName = fileSetName;
    }
}

