/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UpdatableIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnindexedFilesFinder {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesFinder.class);
    private final Project myProject;
    private final boolean myDoTraceForFilesToBeIndexed;
    private final FileBasedIndexImpl myFileBasedIndex;
    private final UpdatableIndex<FileType, Void, FileContent> myFileTypeIndex;
    private final Collection<FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor> myStateProcessors;
    private final boolean myRunExtensionsForFilesMarkedAsIndexed;
    private final boolean myShouldProcessUpToDateFiles;

    UnindexedFilesFinder(@NotNull Project project, @NotNull FileBasedIndexImpl fileBasedIndex, boolean runExtensionsForFilesMarkedAsIndexed) {
        if (project == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(0);
        }
        if (fileBasedIndex == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(1);
        }
        this.myDoTraceForFilesToBeIndexed = FileBasedIndexImpl.LOG.isTraceEnabled();
        this.myProject = project;
        this.myFileBasedIndex = fileBasedIndex;
        this.myFileTypeIndex = fileBasedIndex.getIndex(FileTypeIndex.NAME);
        this.myRunExtensionsForFilesMarkedAsIndexed = runExtensionsForFilesMarkedAsIndexed;
        this.myStateProcessors = FileBasedIndexInfrastructureExtension.EP_NAME.extensions().map(ex -> ex.createFileIndexingStatusProcessor(project)).filter(Objects::nonNull).collect(Collectors.toList());
        this.myShouldProcessUpToDateFiles = ContainerUtil.find(this.myStateProcessors, p -> p.shouldProcessUpToDateFiles()) != null;
    }

    private boolean tryIndexWithoutContentViaInfrastructureExtension(IndexedFile fileContent, int inputId, ID<?, ?> indexId) {
        for (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor processor2 : this.myStateProcessors) {
            if (!processor2.tryIndexFileWithoutContent(fileContent, inputId, indexId)) continue;
            FileBasedIndexImpl.setIndexedState(this.myFileBasedIndex.getIndex(indexId), fileContent, inputId, true);
            return true;
        }
        return false;
    }

    @Nullable(value="null if the file is not subject for indexing (a directory, invalid, etc.)")
    public @Nullable(value="null if the file is not subject for indexing (a directory, invalid, etc.)") UnindexedFileStatus getFileStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(2);
        }
        return (UnindexedFileStatus)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || !file2.isValid() || !(file2 instanceof VirtualFileWithId)) {
                return null;
            }
            SmartList applicableIndexes = new SmartList();
            HashSet indexesProvidedByInfrastructureExtension = new HashSet();
            AtomicLong timeProcessingUpToDateFiles = new AtomicLong();
            AtomicLong timeUpdatingContentLessIndexes = new AtomicLong();
            AtomicLong timeIndexingWithoutContent = new AtomicLong();
            IndexedFileImpl indexedFile = new IndexedFileImpl(file2, this.myProject);
            if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                boolean wasInvalidated = false;
                if (this.myRunExtensionsForFilesMarkedAsIndexed && this.myShouldProcessUpToDateFiles) {
                    List<ID<?, ?>> ids = IndexingStamp.getNontrivialFileIndexedStates(inputId);
                    applicableIndexes.addAll(ids);
                    for (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor processor2 : this.myStateProcessors) {
                        for (ID<?, ?> id2 : ids) {
                            if (!this.myFileBasedIndex.needsFileContentLoading(id2)) continue;
                            long nowTime = System.nanoTime();
                            try {
                                if (processor2.processUpToDateFile(indexedFile, inputId, id2)) continue;
                                wasInvalidated = true;
                            }
                            finally {
                                timeProcessingUpToDateFiles.addAndGet(System.nanoTime() - nowTime);
                            }
                        }
                    }
                }
                if (!wasInvalidated) {
                    IndexingStamp.flushCache(inputId);
                    return new UnindexedFileStatus(false, (List<? extends ID<?, ?>>)applicableIndexes, indexesProvidedByInfrastructureExtension, timeProcessingUpToDateFiles.get(), timeUpdatingContentLessIndexes.get(), timeIndexingWithoutContent.get());
                }
            }
            AtomicBoolean shouldIndex = new AtomicBoolean();
            FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(file2, () -> this.lambda$getFileStatus$2(file2, indexedFile, shouldIndex, (List)applicableIndexes, timeProcessingUpToDateFiles, timeIndexingWithoutContent, indexesProvidedByInfrastructureExtension, timeUpdatingContentLessIndexes));
            return new UnindexedFileStatus(shouldIndex.get(), (List<? extends ID<?, ?>>)applicableIndexes, indexesProvidedByInfrastructureExtension, timeProcessingUpToDateFiles.get(), timeUpdatingContentLessIndexes.get(), timeIndexingWithoutContent.get());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$getFileStatus$2(VirtualFile file2, IndexedFileImpl indexedFile, AtomicBoolean shouldIndex, List applicableIndexes, AtomicLong timeProcessingUpToDateFiles, AtomicLong timeIndexingWithoutContent, Set indexesProvidedByInfrastructureExtension, AtomicLong timeUpdatingContentLessIndexes) {
        boolean isDirectory = file2.isDirectory();
        int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        FileIndexingState fileTypeIndexState = null;
        if (!isDirectory && !this.myFileBasedIndex.isTooLarge(file2)) {
            fileTypeIndexState = this.myFileTypeIndex.getIndexingStateForFile(inputId, indexedFile);
            if (fileTypeIndexState == FileIndexingState.OUT_DATED) {
                this.myFileBasedIndex.dropNontrivialIndexedStates(inputId);
                shouldIndex.set(true);
            } else {
                List<ID<?, ?>> affectedIndexCandidates = this.myFileBasedIndex.getAffectedIndexCandidates(file2);
                applicableIndexes.addAll(affectedIndexCandidates);
                int size = affectedIndexCandidates.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ID<?, ?> indexId = affectedIndexCandidates.get(i2);
                    try {
                        boolean wasIndexedByInfrastructure;
                        if (!this.myFileBasedIndex.needsFileContentLoading(indexId)) continue;
                        FileIndexingState fileIndexingState = this.myFileBasedIndex.shouldIndexFile(indexedFile, indexId);
                        boolean indexInfrastructureExtensionInvalidated = false;
                        if (fileIndexingState == FileIndexingState.UP_TO_DATE && this.myShouldProcessUpToDateFiles) {
                            for (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor p : this.myStateProcessors) {
                                long nowTime = System.nanoTime();
                                try {
                                    if (p.processUpToDateFile(indexedFile, inputId, indexId)) continue;
                                    indexInfrastructureExtensionInvalidated = true;
                                }
                                finally {
                                    timeProcessingUpToDateFiles.addAndGet(System.nanoTime() - nowTime);
                                }
                            }
                        }
                        if (indexInfrastructureExtensionInvalidated) {
                            fileIndexingState = this.myFileBasedIndex.shouldIndexFile(indexedFile, indexId);
                        }
                        if (!fileIndexingState.updateRequired()) continue;
                        if (this.myDoTraceForFilesToBeIndexed) {
                            LOG.trace("Scheduling indexing of " + file2 + " by request of index " + indexId);
                        }
                        long nowTime = System.nanoTime();
                        try {
                            wasIndexedByInfrastructure = this.tryIndexWithoutContentViaInfrastructureExtension(indexedFile, inputId, indexId);
                        }
                        finally {
                            timeIndexingWithoutContent.addAndGet(System.nanoTime() - nowTime);
                        }
                        if (wasIndexedByInfrastructure) {
                            indexesProvidedByInfrastructureExtension.add(indexId);
                            continue;
                        }
                        shouldIndex.set(true);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException || cause instanceof StorageException) {
                            LOG.info((Throwable)e);
                            this.myFileBasedIndex.requestRebuild(indexId);
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
        long nowTime = System.nanoTime();
        try {
            for (ID<?, ?> indexId : this.myFileBasedIndex.getContentLessIndexes(isDirectory)) {
                if (FileTypeIndex.NAME.equals(indexId) && fileTypeIndexState != null && !fileTypeIndexState.updateRequired() || !this.myFileBasedIndex.shouldIndexFile(indexedFile, indexId).updateRequired()) continue;
                this.myFileBasedIndex.updateSingleIndex(indexId, file2, inputId, new IndexedFileWrapper(indexedFile));
            }
        }
        finally {
            timeUpdatingContentLessIndexes.addAndGet(System.nanoTime() - nowTime);
        }
        IndexingStamp.flushCache(inputId);
        if (!shouldIndex.get() && file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileStatus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

