/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.wizard;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.wizard.WizardModel;
import com.intellij.ui.wizard.WizardNavigationState;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class WizardStep<T extends WizardModel> {
    public static final WizardStep FORCED_GOAL_DROPPED = new Empty();
    public static final WizardStep FORCED_GOAL_ACHIEVED = new Empty();
    @NlsContexts.DialogTitle
    private String myTitle = "";
    private @NlsContexts.DetailedDescription String myExplanation = "";
    private Icon myIcon = null;
    private String myHelpId;

    protected WizardStep() {
    }

    public WizardStep(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
    }

    public WizardStep(@NlsContexts.DialogTitle String title, @NlsContexts.DetailedDescription String explanation) {
        this.myTitle = title;
        this.myExplanation = explanation;
    }

    public WizardStep(@NlsContexts.DialogTitle String title, @NlsContexts.DetailedDescription String explanation, Icon icon2) {
        this.myTitle = title;
        this.myExplanation = explanation;
        this.myIcon = icon2;
    }

    public WizardStep(@NlsContexts.DialogTitle String title, @NlsContexts.DetailedDescription String explanation, Icon icon2, @NonNls String helpId) {
        this.myTitle = title;
        this.myExplanation = explanation;
        this.myIcon = icon2;
        this.myHelpId = helpId;
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return this.myTitle;
    }

    @NlsContexts.DetailedDescription
    public String getExplanation() {
        return this.myExplanation;
    }

    public abstract JComponent prepare(WizardNavigationState var1);

    public WizardStep onNext(T model2) {
        return ((WizardModel)model2).getNextFor(this);
    }

    public WizardStep onPrevious(T model2) {
        return ((WizardModel)model2).getPreviousFor(this);
    }

    public boolean onCancel() {
        return true;
    }

    public boolean onFinish() {
        return true;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NonNls
    public String getHelpId() {
        return this.myHelpId;
    }

    public static class Empty
    extends WizardStep {
        @Override
        public JComponent prepare(WizardNavigationState state) {
            return null;
        }
    }
}

